// Generated by gtkmmproc -- DO NOT MODIFY!


#include <cluttermm/behaviour.h>
#include <cluttermm/private/behaviour_p.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <clutter/clutter.h>

static void SignalProxy_behaviours_foreach_callback(ClutterBehaviour* behaviour, ClutterActor *actor, gpointer user_data)
{
  Clutter::Behaviour::SlotForEach* the_slot = static_cast<Clutter::Behaviour::SlotForEach*>(user_data);

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  try
  {
  #endif //GLIBMM_EXCEPTIONS_ENABLED
    Glib::RefPtr<Clutter::Behaviour> cpp_behaviour = Glib::wrap(behaviour, true /* take reference */);
    Glib::RefPtr<Clutter::Actor> cpp_actor = Glib::wrap(actor, true /* take reference */);
    (*the_slot)(cpp_behaviour, cpp_actor);
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
  #endif //GLIBMM_EXCEPTIONS_ENABLED
}
namespace Clutter
{

void Behaviour::actors_foreach(const SlotForEach& slot)
{
  clutter_behaviour_actors_foreach(
      gobj(),
      &SignalProxy_behaviours_foreach_callback, const_cast<SlotForEach*>(&slot));
}

std::vector<Glib::RefPtr<Actor> > Behaviour::get_actors()
{
  GSList* actorList = clutter_behaviour_get_actors(gobj());

  const guint actorCount = g_slist_length(actorList);
  std::vector<Glib::RefPtr<Actor> > actorVec;
  actorVec.reserve(actorCount);

  for(GSList* actorNode = actorList; actorNode->next; actorNode = actorList->next)
  {
    actorVec.push_back(Glib::wrap(static_cast<ClutterActor*>(actorNode->data), true));
  }

  return actorVec;
}

std::vector<Glib::RefPtr<const Actor> > Behaviour::get_actors() const
{
  GSList* actorList = clutter_behaviour_get_actors(const_cast<ClutterBehaviour*>(gobj()));

  const guint actorCount = g_slist_length(actorList);
  std::vector<Glib::RefPtr<const Actor> > actorVec;
  actorVec.reserve(actorCount);

  for(GSList* actorNode = actorList; actorNode->next; actorNode = actorList->next)
  {
    actorVec.push_back(Glib::wrap(static_cast<ClutterActor*>(actorNode->data), true));
  }

  return actorVec;
}

} //namespace Clutter


namespace
{


static void Behaviour_signal_applied_callback(ClutterBehaviour* self, ClutterActor* p0,void* data)
{
  using namespace Clutter;
  typedef sigc::slot< void,const Glib::RefPtr<Actor>& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Behaviour_signal_applied_info =
{
  "applied",
  (GCallback) &Behaviour_signal_applied_callback,
  (GCallback) &Behaviour_signal_applied_callback
};


static void Behaviour_signal_removed_callback(ClutterBehaviour* self, ClutterActor* p0,void* data)
{
  using namespace Clutter;
  typedef sigc::slot< void,const Glib::RefPtr<Actor>& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Behaviour_signal_removed_info =
{
  "removed",
  (GCallback) &Behaviour_signal_removed_callback,
  (GCallback) &Behaviour_signal_removed_callback
};


} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Clutter::Behaviour> wrap(ClutterBehaviour* object, bool take_copy)
{
  return Glib::RefPtr<Clutter::Behaviour>( dynamic_cast<Clutter::Behaviour*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Clutter
{


/* The *_Class implementation: */

const Glib::Class& Behaviour_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Behaviour_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(clutter_behaviour_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Behaviour_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

  klass->alpha_notify = &alpha_notify_vfunc_callback;

  klass->applied = &applied_callback;
  klass->removed = &removed_callback;
}

void Behaviour_Class::alpha_notify_vfunc_callback(ClutterBehaviour* self, double alpha_value)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->alpha_notify_vfunc(alpha_value);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->alpha_notify)
    (*base->alpha_notify)(self, alpha_value);

}

void Behaviour_Class::applied_callback(ClutterBehaviour* self, ClutterActor* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_applied(Glib::wrap(p0)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->applied)
    (*base->applied)(self, p0);
}
void Behaviour_Class::removed_callback(ClutterBehaviour* self, ClutterActor* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_removed(Glib::wrap(p0)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->removed)
    (*base->removed)(self, p0);
}


Glib::ObjectBase* Behaviour_Class::wrap_new(GObject* object)
{
  return new Behaviour((ClutterBehaviour*)object);
}


/* The implementation: */

ClutterBehaviour* Behaviour::gobj_copy()
{
  reference();
  return gobj();
}

Behaviour::Behaviour(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

Behaviour::Behaviour(ClutterBehaviour* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


Behaviour::~Behaviour()
{}


Behaviour::CppClassType Behaviour::behaviour_class_; // initialize static member

GType Behaviour::get_type()
{
  return behaviour_class_.init().get_type();
}


GType Behaviour::get_base_type()
{
  return clutter_behaviour_get_type();
}


Behaviour::Behaviour()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(behaviour_class_.init()))
{
  

}

void Behaviour::apply(const Glib::RefPtr<Actor>& actor)
{
clutter_behaviour_apply(gobj(), Glib::unwrap(actor)); 
}

void Behaviour::remove(const Glib::RefPtr<Actor>& actor)
{
clutter_behaviour_remove(gobj(), Glib::unwrap(actor)); 
}

void Behaviour::remove_all()
{
clutter_behaviour_remove_all(gobj()); 
}

bool Behaviour::is_applied(const Glib::RefPtr<Actor>& actor)
{
  return clutter_behaviour_is_applied(gobj(), Glib::unwrap(actor));
}

int Behaviour::get_n_actors() const
{
  return clutter_behaviour_get_n_actors(const_cast<ClutterBehaviour*>(gobj()));
}

Glib::RefPtr<Actor> Behaviour::get_nth_actor(int index)
{
  return Glib::wrap(clutter_behaviour_get_nth_actor(gobj(), index));
}

Glib::RefPtr<const Actor> Behaviour::get_nth_actor(int index) const
{
  return const_cast<Behaviour*>(this)->get_nth_actor(index);
}

Glib::RefPtr<Alpha> Behaviour::get_alpha()
{
  return Glib::wrap(clutter_behaviour_get_alpha(gobj()));
}

Glib::RefPtr<const Alpha> Behaviour::get_alpha() const
{
  return const_cast<Behaviour*>(this)->get_alpha();
}

void Behaviour::set_alpha(const Glib::RefPtr<Alpha>& alpha)
{
clutter_behaviour_set_alpha(gobj(), Glib::unwrap(alpha)); 
}


Glib::SignalProxy1< void,const Glib::RefPtr<Actor>& > Behaviour::signal_applied()
{
  return Glib::SignalProxy1< void,const Glib::RefPtr<Actor>& >(this, &Behaviour_signal_applied_info);
}


Glib::SignalProxy1< void,const Glib::RefPtr<Actor>& > Behaviour::signal_removed()
{
  return Glib::SignalProxy1< void,const Glib::RefPtr<Actor>& >(this, &Behaviour_signal_removed_info);
}


void Clutter::Behaviour::on_applied(const Glib::RefPtr<Actor>& actor)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->applied)
    (*base->applied)(gobj(),Glib::unwrap(actor));
}
void Clutter::Behaviour::on_removed(const Glib::RefPtr<Actor>& actor)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->removed)
    (*base->removed)(gobj(),Glib::unwrap(actor));
}

void Clutter::Behaviour::alpha_notify_vfunc(double alpha_value) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->alpha_notify)
    (*base->alpha_notify)(gobj(),alpha_value);
}


} // namespace Clutter


