


#include <e-data-cal.h>
#include "e-data-cal-enumtypes.h"

/* enumerations from "e-data-cal-types.h" */
GType
e_data_cal_call_status_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { 0, "Success", "success" },
      { 1, "Busy", "busy" },
      { 2, "RepositoryOffline", "repositoryoffline" },
      { 3, "PermissionDenied", "permissiondenied" },
      { 4, "InvalidRange", "invalidrange" },
      { 5, "ObjectNotFound", "objectnotfound" },
      { 6, "InvalidObject", "invalidobject" },
      { 7, "ObjectIdAlreadyExists", "objectidalreadyexists" },
      { 8, "AuthenticationFailed", "authenticationfailed" },
      { 9, "AuthenticationRequired", "authenticationrequired" },
      { 10, "UnsupportedField", "unsupportedfield" },
      { 11, "UnsupportedMethod", "unsupportedmethod" },
      { 12, "UnsupportedAuthenticationMethod", "unsupportedauthenticationmethod" },
      { 13, "TLSNotAvailable", "tlsnotavailable" },
      { 14, "NoSuchCal", "nosuchcal" },
      { 15, "UnknownUser", "unknownuser" },
      { 16, "OfflineUnavailable", "offlineunavailable" },
      { 17, "SearchSizeLimitExceeded", "searchsizelimitexceeded" },
      { 18, "SearchTimeLimitExceeded", "searchtimelimitexceeded" },
      { 19, "InvalidQuery", "invalidquery" },
      { 20, "QueryRefused", "queryrefused" },
      { 21, "CouldNotCancel", "couldnotcancel" },
      { 22, "OtherError", "othererror" },
      { 23, "InvalidServerVersion", "invalidserverversion" },
      { 24, "InvalidArg", "invalidarg" },
      { 25, "NotSupported", "notsupported" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("EDataCalCallStatus", values);
  }
  return etype;
}
GType
e_data_cal_obj_type_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GFlagsValue values[] = {
      { 1, "Event", "event" },
      { 2, "Todo", "todo" },
      { 4, "Journal", "journal" },
      { 7, "AnyType", "anytype" },
      { 0, NULL, NULL }
    };
    etype = g_flags_register_static ("EDataCalObjType", values);
  }
  return etype;
}
GType
e_data_cal_obj_mod_type_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GFlagsValue values[] = {
      { 1, "This", "this" },
      { 2, "ThisAndPrior", "thisandprior" },
      { 4, "ThisAndFuture", "thisandfuture" },
      { 7, "All", "all" },
      { 0, NULL, NULL }
    };
    etype = g_flags_register_static ("EDataCalObjModType", values);
  }
  return etype;
}



