// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GLIBMM_REGEX_H
#define _GLIBMM_REGEX_H


/* Copyright (C) 2007 The glibmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <glibmm/refptr.h>
#include <glibmm/ustring.h>
#include <glibmm/error.h>
#include <glibmm/arrayhandle.h>
//#include <glibmm/value.h>

#include <glib/gregex.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GRegex GRegex;
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Glib
{

/** @addtogroup glibmmEnums Enums and Flags */

/**
 * @ingroup glibmmEnums
 * @par Bitwise operators:
 * <tt>%RegexCompileFlags operator|(RegexCompileFlags, RegexCompileFlags)</tt><br>
 * <tt>%RegexCompileFlags operator&(RegexCompileFlags, RegexCompileFlags)</tt><br>
 * <tt>%RegexCompileFlags operator^(RegexCompileFlags, RegexCompileFlags)</tt><br>
 * <tt>%RegexCompileFlags operator~(RegexCompileFlags)</tt><br>
 * <tt>%RegexCompileFlags& operator|=(RegexCompileFlags&, RegexCompileFlags)</tt><br>
 * <tt>%RegexCompileFlags& operator&=(RegexCompileFlags&, RegexCompileFlags)</tt><br>
 * <tt>%RegexCompileFlags& operator^=(RegexCompileFlags&, RegexCompileFlags)</tt><br>
 */
enum RegexCompileFlags
{
  REGEX_CASELESS = 1 << 0,
  REGEX_MULTILINE = 1 << 1,
  REGEX_DOTALL = 1 << 2,
  REGEX_EXTENDED = 1 << 3,
  REGEX_ANCHORED = 1 << 4,
  REGEX_DOLLAR_ENDONLY = 1 << 5,
  REGEX_UNGREEDY = 1 << 9,
  REGEX_RAW = 1 << 11,
  REGEX_NO_AUTO_CAPTURE = 1 << 12,
  REGEX_OPTIMIZE = 1 << 13,
  REGEX_DUPNAMES = 1 << 19,
  REGEX_NEWLINE_CR = 1 << 20,
  REGEX_NEWLINE_LF = 1 << 21,
  REGEX_NEWLINE_CRLF = 0x100000
};

/** @ingroup glibmmEnums */
inline RegexCompileFlags operator|(RegexCompileFlags lhs, RegexCompileFlags rhs)
  { return static_cast<RegexCompileFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup glibmmEnums */
inline RegexCompileFlags operator&(RegexCompileFlags lhs, RegexCompileFlags rhs)
  { return static_cast<RegexCompileFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup glibmmEnums */
inline RegexCompileFlags operator^(RegexCompileFlags lhs, RegexCompileFlags rhs)
  { return static_cast<RegexCompileFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup glibmmEnums */
inline RegexCompileFlags operator~(RegexCompileFlags flags)
  { return static_cast<RegexCompileFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup glibmmEnums */
inline RegexCompileFlags& operator|=(RegexCompileFlags& lhs, RegexCompileFlags rhs)
  { return (lhs = static_cast<RegexCompileFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup glibmmEnums */
inline RegexCompileFlags& operator&=(RegexCompileFlags& lhs, RegexCompileFlags rhs)
  { return (lhs = static_cast<RegexCompileFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup glibmmEnums */
inline RegexCompileFlags& operator^=(RegexCompileFlags& lhs, RegexCompileFlags rhs)
  { return (lhs = static_cast<RegexCompileFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/**
 * @ingroup glibmmEnums
 * @par Bitwise operators:
 * <tt>%RegexMatchFlags operator|(RegexMatchFlags, RegexMatchFlags)</tt><br>
 * <tt>%RegexMatchFlags operator&(RegexMatchFlags, RegexMatchFlags)</tt><br>
 * <tt>%RegexMatchFlags operator^(RegexMatchFlags, RegexMatchFlags)</tt><br>
 * <tt>%RegexMatchFlags operator~(RegexMatchFlags)</tt><br>
 * <tt>%RegexMatchFlags& operator|=(RegexMatchFlags&, RegexMatchFlags)</tt><br>
 * <tt>%RegexMatchFlags& operator&=(RegexMatchFlags&, RegexMatchFlags)</tt><br>
 * <tt>%RegexMatchFlags& operator^=(RegexMatchFlags&, RegexMatchFlags)</tt><br>
 */
enum RegexMatchFlags
{
  REGEX_MATCH_ANCHORED = 1 << 4,
  REGEX_MATCH_NOTBOL = 1 << 7,
  REGEX_MATCH_NOTEOL = 1 << 8,
  REGEX_MATCH_NOTEMPTY = 1 << 10,
  REGEX_MATCH_PARTIAL = 1 << 15,
  REGEX_MATCH_NEWLINE_CR = 1 << 20,
  REGEX_MATCH_NEWLINE_LF = 1 << 21,
  REGEX_MATCH_NEWLINE_CRLF = 0x100000,
  REGEX_MATCH_NEWLINE_ANY = 1 << 22
};

/** @ingroup glibmmEnums */
inline RegexMatchFlags operator|(RegexMatchFlags lhs, RegexMatchFlags rhs)
  { return static_cast<RegexMatchFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup glibmmEnums */
inline RegexMatchFlags operator&(RegexMatchFlags lhs, RegexMatchFlags rhs)
  { return static_cast<RegexMatchFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup glibmmEnums */
inline RegexMatchFlags operator^(RegexMatchFlags lhs, RegexMatchFlags rhs)
  { return static_cast<RegexMatchFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup glibmmEnums */
inline RegexMatchFlags operator~(RegexMatchFlags flags)
  { return static_cast<RegexMatchFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup glibmmEnums */
inline RegexMatchFlags& operator|=(RegexMatchFlags& lhs, RegexMatchFlags rhs)
  { return (lhs = static_cast<RegexMatchFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup glibmmEnums */
inline RegexMatchFlags& operator&=(RegexMatchFlags& lhs, RegexMatchFlags rhs)
  { return (lhs = static_cast<RegexMatchFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup glibmmEnums */
inline RegexMatchFlags& operator^=(RegexMatchFlags& lhs, RegexMatchFlags rhs)
  { return (lhs = static_cast<RegexMatchFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/** Exception class for Regex
 */
class RegexError : public Glib::Error
{
public:
  enum Code
  {
    COMPILE,
    OPTIMIZE,
    REPLACE,
    MATCH
  };

  RegexError(Code error_code, const Glib::ustring& error_message);
  explicit RegexError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static void throw_func(GError* gobject);
#else
  //When not using exceptions, we just pass the Exception object around without throwing it:
  static std::auto_ptr<Glib::Error> throw_func(GError* gobject);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  friend void wrap_init(); // uses throw_func()
#endif
};


/** TODO
 *
 * @newin2p12
 */
class Regex
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Regex CppObjectType;
  typedef GRegex BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  // For use with Glib::RefPtr<> only.
  void reference()   const;
  void unreference() const;

  ///Provides access to the underlying C instance.
  GRegex*       gobj();

  ///Provides access to the underlying C instance.
  const GRegex* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GRegex* gobj_copy() const;

protected:
  // Do not derive this.  Glib::Regex can neither be constructed nor deleted.
  Regex();
  void operator delete(void*, size_t);

private:
  // noncopyable
  Regex(const Regex&);
  Regex& operator=(const Regex&);


public:

#ifdef GLIBMM_EXCEPTIONS_ENABLED
   static Glib::RefPtr<Glib::Regex> create(const Glib::ustring& pattern, RegexCompileFlags compile_options = (RegexCompileFlags)0, RegexMatchFlags match_options = (RegexMatchFlags)0);
#else
   static Glib::RefPtr<Glib::Regex> create(const Glib::ustring& pattern, RegexCompileFlags compile_options = (RegexCompileFlags)0, RegexMatchFlags match_options = (RegexMatchFlags)0, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
  

  Glib::ustring get_pattern() const;
  
  int get_max_backref() const;
  
  int get_capture_count() const;
  
  int get_string_number(const Glib::ustring& name) const;

  //TODO: _WRAP_METHOD(static Glib::ustring escape_string(const Glib::ustring& string, gint length) const, g_regex_escape_string)

/* Matching. */
  
  static bool match_simple(const Glib::ustring& pattern, const Glib::ustring& string, RegexCompileFlags compile_options = (RegexCompileFlags)0, RegexMatchFlags match_options = (RegexMatchFlags)0);

  //TODO: _WRAP_METHOD(bool match(const Glib::ustring& string, RegexMatchFlags match_options = (RegexMatchFlags)0, GMatchInfo **match_info = 0), g_regex_match)
  bool match(const Glib::ustring& string, RegexMatchFlags match_options = (RegexMatchFlags)0);

  //TODO: Wrap GMatchInfo as an iterator:
  //_WRAP_METHOD(bool match_full(const gchar* string, gssize string_len, int start_position, RegexMatchFlags match_options = (RegexMatchFlags)0, GMatchInfo** match_info = 0), g_regex_match_full, errthrow)

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool match_full(const Glib::ustring& string, int start_position, RegexMatchFlags match_options);
  #else
  bool match_full(const Glib::ustring& string, int start_position, RegexMatchFlags match_options, std::auto_ptr<Glib::Error>& error);
  #endif //GLIBMM_EXCEPTIONS_ENABLED

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool match_full(const Glib::ustring& string, gssize string_len, int start_position, RegexMatchFlags match_options);
  #else
  bool match_full(const Glib::ustring& string, gssize string_len, int start_position, RegexMatchFlags match_options, std::auto_ptr<Glib::Error>& error);
  #endif //GLIBMM_EXCEPTIONS_ENABLED

  //TODO: _WRAP_METHOD(bool match_all(const Glib::ustring& string, RegexMatchFlags match_options = (RegexMatchFlags)0, GMatchInfo ** match_info = 0), g_regex_match_all)
  bool match_all(const Glib::ustring& string, RegexMatchFlags match_options = (RegexMatchFlags)0);

  //TODO: _WRAP_METHOD(bool match_all_full(const gchar* string, gssize string_len, int start_position, RegexMatchFlags match_options = (RegexMatchFlags)0, GMatchInfo** match_info = 0), g_regex_match_all_full, errthrow)

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool match_all_full(const Glib::ustring& string, int start_position, RegexMatchFlags match_options);
  #else
  bool match_all_full(const Glib::ustring& string, int start_position, RegexMatchFlags match_options, std::auto_ptr<Glib::Error>& error);
  #endif //GLIBMM_EXCEPTIONS_ENABLED

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool match_all_full(const Glib::ustring& string, gssize string_len, int start_position, RegexMatchFlags match_options);
  #else
  bool match_all_full(const Glib::ustring& string, gssize string_len, int start_position, RegexMatchFlags match_options, std::auto_ptr<Glib::Error>& error);
  #endif //GLIBMM_EXCEPTIONS_ENABLED


  static Glib::StringArrayHandle split_simple(const Glib::ustring& pattern, const Glib::ustring& string, RegexCompileFlags compile_options = (RegexCompileFlags)0, RegexMatchFlags match_options = (RegexMatchFlags)0);
  
  Glib::StringArrayHandle split(const Glib::ustring& string, RegexMatchFlags match_options = (RegexMatchFlags)0);

  
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::StringArrayHandle split_full(const gchar* string, gssize string_len, int start_position, RegexMatchFlags match_options = (RegexMatchFlags)0, int max_tokens = 0) const;
#else
  Glib::StringArrayHandle split_full(const gchar* string, gssize string_len, int start_position, RegexMatchFlags match_options, int max_tokens, std::auto_ptr<Glib::Error>& error) const;
#endif //GLIBMM_EXCEPTIONS_ENABLED


  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::StringArrayHandle split_full(const Glib::ustring& string, int start_position, RegexMatchFlags match_options, int max_tokens) const;
  #else
  Glib::StringArrayHandle split_full(const Glib::ustring& string, int start_position, RegexMatchFlags match_options, int max_tokens, std::auto_ptr<Glib::Error>& error) const;
  #endif //GLIBMM_EXCEPTIONS_ENABLED

/* String replacement. */
  
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::ustring replace(const gchar* string, gssize string_len, int start_position, const Glib::ustring& replacement, RegexMatchFlags match_options = (RegexMatchFlags)0);
#else
  Glib::ustring replace(const gchar* string, gssize string_len, int start_position, const Glib::ustring& replacement, RegexMatchFlags match_options, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::ustring replace(const Glib::ustring& string, int start_position, const Glib::ustring& replacement, RegexMatchFlags match_options);
  #else
  Glib::ustring replace(const Glib::ustring& string, int start_position, const Glib::ustring& replacement, RegexMatchFlags match_options, std::auto_ptr<Glib::Error>& error);
  #endif //GLIBMM_EXCEPTIONS_ENABLED

  
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::ustring replace_literal(const gchar *string, gssize string_len, int start_position, const Glib::ustring& replacement, RegexMatchFlags match_options = (RegexMatchFlags)0);
#else
  Glib::ustring replace_literal(const gchar * string, gssize string_len, int start_position, const Glib::ustring& replacement, RegexMatchFlags match_options, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::ustring replace_literal(const Glib::ustring& string, int start_position, const Glib::ustring& replacement, RegexMatchFlags match_options);
  #else
  Glib::ustring replace_literal(const Glib::ustring& string, int start_position, const Glib::ustring& replacement, RegexMatchFlags match_options, std::auto_ptr<Glib::Error>& error);
  #endif //GLIBMM_EXCEPTIONS_ENABLED

  
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::ustring replace_eval(const Glib::ustring& string, gssize string_len, int start_position, RegexMatchFlags match_options, GRegexEvalCallback   eval,  gpointer user_data);
#else
  Glib::ustring replace_eval(const Glib::ustring& string, gssize string_len, int start_position, RegexMatchFlags match_options, GRegexEvalCallback eval, gpointer user_data, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static bool check_replacement(const Glib::ustring& replacement, gboolean* has_references);
#else
  static bool check_replacement(const Glib::ustring& replacement, gboolean* has_references, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


/* Match info */
/*
GRegex		 *g_match_info_get_regex	(const GMatchInfo    *match_info);
const gchar      *g_match_info_get_string       (const GMatchInfo    *match_info);

void		  g_match_info_free		(GMatchInfo          *match_info);
  _WRAP_METHOD(bool g_match_info_next		(GMatchInfo          *match_info,
						 GError             **error);
  _WRAP_METHOD(bool g_match_info_matches		(const GMatchInfo    *match_info);
  _WRAP_METHOD(int g_match_info_get_match_count	(const GMatchInfo    *match_info);
  _WRAP_METHOD(bool g_match_info_is_partial_match	(const GMatchInfo    *match_info);
Glib::ustring g_match_info_expand_references(const GMatchInfo    *match_info,
						 Glib::ustring& string_to_expand,
						 GError             **error);
Glib::ustring g_match_info_fetch		(const GMatchInfo    *match_info,
						 int match_num);
  _WRAP_METHOD(bool g_match_info_fetch_pos	(const GMatchInfo    *match_info,
						 int match_num,
						 int                 *start_pos,
						 int                 *end_pos);
Glib::ustring g_match_info_fetch_named	(const GMatchInfo    *match_info,
						 Glib::ustring& name);
  _WRAP_METHOD(bool g_match_info_fetch_named_pos	(const GMatchInfo    *match_info,
						 Glib::ustring& name,
						 int                 *start_pos,
						 int                 *end_pos);
gchar		**g_match_info_fetch_all	(const GMatchInfo    *match_info);
*/


};


} // namespace Glib


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Glib::Regex
   */
  Glib::RefPtr<Glib::Regex> wrap(GRegex* object, bool take_copy = false);

} // namespace Glib


#endif /* _GLIBMM_REGEX_H */

