// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_MEMORYOUTPUTSTREAM_H
#define _GIOMM_MEMORYOUTPUTSTREAM_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2008 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <giomm/outputstream.h>
#include <giomm/seekable.h>
#include <glibmm/object.h>
// TODO: remove this if possible -- it's here for the GReallocFunc definition
#include <gio/gio.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GMemoryOutputStream GMemoryOutputStream;
typedef struct _GMemoryOutputStreamClass GMemoryOutputStreamClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class MemoryOutputStream_Class; } // namespace Gio
namespace Gio
{

//TODO: Proper documentation:

/** Streaming output operations on memory chunks
 *
 * @ingroup Streams
 *
 * @newin2p20
 */

class MemoryOutputStream :
    public OutputStream,
    public Seekable
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef MemoryOutputStream CppObjectType;
  typedef MemoryOutputStream_Class CppClassType;
  typedef GMemoryOutputStream BaseObjectType;
  typedef GMemoryOutputStreamClass BaseClassType;

private:  friend class MemoryOutputStream_Class;
  static CppClassType memoryoutputstream_class_;

private:
  // noncopyable
  MemoryOutputStream(const MemoryOutputStream&);
  MemoryOutputStream& operator=(const MemoryOutputStream&);

protected:
  explicit MemoryOutputStream(const Glib::ConstructParams& construct_params);
  explicit MemoryOutputStream(GMemoryOutputStream* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~MemoryOutputStream();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GMemoryOutputStream*       gobj()       { return reinterpret_cast<GMemoryOutputStream*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GMemoryOutputStream* gobj() const { return reinterpret_cast<GMemoryOutputStream*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GMemoryOutputStream* gobj_copy();

private:

  
protected:
  // TODO: more C++-like interface using sigc++
  explicit MemoryOutputStream(gpointer data, gsize len, GReallocFunc realloc_fn, GDestroyNotify destroy);

public:
  // TODO: more C++-like interface using sigc++
  
  static Glib::RefPtr<MemoryOutputStream> create(gpointer data, gsize len, GReallocFunc realloc_fn, GDestroyNotify destroy);

  
  /** Gets any loaded data from the @a ostream. 
   * 
   * Note that the returned pointer may become invalid on the next 
   * write or truncate operation on the stream.
   * @return Pointer to the stream's data.
   */
  gpointer get_data();
  
  /** Gets the size of the currently allocated data area (availible from
   * g_memory_output_stream_get_data()). If the stream isn't
   * growable (no realloc was passed to g_memory_output_stream_new()) then
   * this is the maximum size of the stream and further writes
   * will return IO_ERROR_NO_SPACE.
   * 
   * Note that for growable streams the returned size may become invalid on
   * the next write or truncate operation on the stream.
   * 
   * If you want the number of bytes currently written to the stream, use
   * g_memory_output_stream_get_data_size().
   * @return The number of bytes allocated for the data buffer.
   */
  gsize get_size() const;
  
  /** Returns: the number of bytes written to the stream
   * @return The number of bytes written to the stream
   * 
   * @newin2p18.
   */
  gsize get_data_size() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::MemoryOutputStream
   */
  Glib::RefPtr<Gio::MemoryOutputStream> wrap(GMemoryOutputStream* object, bool take_copy = false);
}


#endif /* _GIOMM_MEMORYOUTPUTSTREAM_H */

