// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_UNIXCONNECTION_H
#define _GIOMM_UNIXCONNECTION_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2010 Jonathon Jongsma
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <giomm/socketconnection.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GUnixConnection GUnixConnection;
typedef struct _GUnixConnectionClass GUnixConnectionClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class UnixConnection_Class; } // namespace Gio
namespace Gio
{

/**
 * A Unix domain SocketConnection
 *
 * This is the subclass of SocketConnection that is created
 * for UNIX domain sockets.
 *
 * It contains functions to do some of the unix socket specific
 * functionallity like passing file descriptors.
 *
 * @newin{2,24}
 * @ingroup NetworkIO
 */

class UnixConnection : public Gio::SocketConnection
{
    
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef UnixConnection CppObjectType;
  typedef UnixConnection_Class CppClassType;
  typedef GUnixConnection BaseObjectType;
  typedef GUnixConnectionClass BaseClassType;

private:  friend class UnixConnection_Class;
  static CppClassType unixconnection_class_;

private:
  // noncopyable
  UnixConnection(const UnixConnection&);
  UnixConnection& operator=(const UnixConnection&);

protected:
  explicit UnixConnection(const Glib::ConstructParams& construct_params);
  explicit UnixConnection(GUnixConnection* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~UnixConnection();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GUnixConnection*       gobj()       { return reinterpret_cast<GUnixConnection*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GUnixConnection* gobj() const { return reinterpret_cast<GUnixConnection*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GUnixConnection* gobj_copy();

private:

    //This is not available in on Win32.
//This source file will not be compiled,
//and the class will not be registered in wrap_init.h or wrap_init.cc


public:
    
  /** Passes a file descriptor to the recieving side of the
   * connection. The recieving end has to call g_unix_connection_receive_fd()
   * to accept the file descriptor.
   * 
   * As well as sending the fd this also writes a single byte to the
   * stream, as this is required for fd passing to work on some
   * implementations.
   * @param fd A file descriptor.
   * @param cancellable Optional Cancellable object, <tt>0</tt> to ignore.
   * @return A <tt>true</tt> on success, <tt>0</tt> on error.
   * 
   * @newin{2,22}.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool send_fd(int fd, const Glib::RefPtr<Cancellable>& cancellable);
#else
  bool send_fd(int fd, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

    
  /** Receives a file descriptor from the sending end of the connection.
   * The sending end has to call g_unix_connection_send_fd() for this
   * to work.
   * 
   * As well as reading the fd this also reads a single byte from the
   * stream, as this is required for fd passing to work on some
   * implementations.
   * @param cancellable Optional Cancellable object, <tt>0</tt> to ignore.
   * @return A file descriptor on success, -1 on error.
   * 
   * @newin{2,22}.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  int receive_fd(const Glib::RefPtr<Cancellable>& cancellable);
#else
  int receive_fd(const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::UnixConnection
   */
  Glib::RefPtr<Gio::UnixConnection> wrap(GUnixConnection* object, bool take_copy = false);
}


#endif /* _GIOMM_UNIXCONNECTION_H */

