/* ChannelFactory.c generated by valac, the Vala compiler
 * generated from ChannelFactory.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_TYPE_PLAYER_THREAD (dvb_player_thread_get_type ())
#define DVB_PLAYER_THREAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_PLAYER_THREAD, DVBPlayerThread))
#define DVB_PLAYER_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_PLAYER_THREAD, DVBPlayerThreadClass))
#define DVB_IS_PLAYER_THREAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_PLAYER_THREAD))
#define DVB_IS_PLAYER_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_PLAYER_THREAD))
#define DVB_PLAYER_THREAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_PLAYER_THREAD, DVBPlayerThreadClass))

typedef struct _DVBPlayerThread DVBPlayerThread;
typedef struct _DVBPlayerThreadClass DVBPlayerThreadClass;
typedef struct _DVBPlayerThreadPrivate DVBPlayerThreadPrivate;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;

#define DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS (dvb_player_thread_channel_elements_get_type ())
#define DVB_PLAYER_THREAD_CHANNEL_ELEMENTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS, DVBPlayerThreadChannelElements))
#define DVB_PLAYER_THREAD_CHANNEL_ELEMENTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS, DVBPlayerThreadChannelElementsClass))
#define DVB_PLAYER_THREAD_IS_CHANNEL_ELEMENTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS))
#define DVB_PLAYER_THREAD_IS_CHANNEL_ELEMENTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS))
#define DVB_PLAYER_THREAD_CHANNEL_ELEMENTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS, DVBPlayerThreadChannelElementsClass))

typedef struct _DVBPlayerThreadChannelElements DVBPlayerThreadChannelElements;
typedef struct _DVBPlayerThreadChannelElementsClass DVBPlayerThreadChannelElementsClass;

#define DVB_TYPE_EPG_SCANNER (dvb_epg_scanner_get_type ())
#define DVB_EPG_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EPG_SCANNER, DVBEPGScanner))
#define DVB_EPG_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EPG_SCANNER, DVBEPGScannerClass))
#define DVB_IS_EPG_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EPG_SCANNER))
#define DVB_IS_EPG_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EPG_SCANNER))
#define DVB_EPG_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EPG_SCANNER, DVBEPGScannerClass))

typedef struct _DVBEPGScanner DVBEPGScanner;
typedef struct _DVBEPGScannerClass DVBEPGScannerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _dvb_player_thread_channel_elements_unref0(var) ((var == NULL) ? NULL : (var = (dvb_player_thread_channel_elements_unref (var), NULL)))
typedef struct _DVBPlayerThreadChannelElementsPrivate DVBPlayerThreadChannelElementsPrivate;
#define _gst_iterator_free0(var) ((var == NULL) ? NULL : (var = (gst_iterator_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))
typedef struct _DVBPlayerThreadParamSpecChannelElements DVBPlayerThreadParamSpecChannelElements;

#define DVB_TYPE_CHANNEL_FACTORY (dvb_channel_factory_get_type ())
#define DVB_CHANNEL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactory))
#define DVB_CHANNEL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactoryClass))
#define DVB_IS_CHANNEL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_FACTORY))
#define DVB_IS_CHANNEL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_FACTORY))
#define DVB_CHANNEL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactoryClass))

typedef struct _DVBChannelFactory DVBChannelFactory;
typedef struct _DVBChannelFactoryClass DVBChannelFactoryClass;
typedef struct _DVBChannelFactoryPrivate DVBChannelFactoryPrivate;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;

typedef void (*DVBForcedStopNotify) (DVBChannel* channel, void* user_data);
struct _DVBPlayerThread {
	GObject parent_instance;
	DVBPlayerThreadPrivate * priv;
};

struct _DVBPlayerThreadClass {
	GObjectClass parent_class;
	void (*destroy) (DVBPlayerThread* self, gboolean forced);
};

struct _DVBPlayerThreadPrivate {
	GeeHashSet* _active_channels;
	DVBDevice* _device;
	GstElement* pipeline;
	GStaticRecMutex __lock_pipeline;
	GeeHashMap* elements_map;
	GStaticRecMutex __lock_elements_map;
	DVBEPGScanner* epgscanner;
	GstElement* dvbbasebin;
	gboolean destroyed;
	GStaticRecMutex __lock_destroyed;
};

struct _DVBPlayerThreadChannelElements {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBPlayerThreadChannelElementsPrivate * priv;
	guint sid;
	GeeArrayList* sinks;
	GstElement* tee;
	gboolean forced;
	DVBForcedStopNotify notify_func;
	gpointer notify_func_target;
	GDestroyNotify notify_func_target_destroy_notify;
};

struct _DVBPlayerThreadChannelElementsClass {
	GTypeClass parent_class;
	void (*finalize) (DVBPlayerThreadChannelElements *self);
};

struct _DVBPlayerThreadParamSpecChannelElements {
	GParamSpec parent_instance;
};

struct _DVBChannelFactory {
	GObject parent_instance;
	DVBChannelFactoryPrivate * priv;
};

struct _DVBChannelFactoryClass {
	GObjectClass parent_class;
	DVBPlayerThread* (*create_player) (DVBChannelFactory* self, DVBDevice* device);
};

struct _DVBChannelFactoryPrivate {
	DVBDeviceGroup* _device_group;
	GeeHashSet* active_players;
	GStaticRecMutex __lock_active_players;
};


static gpointer dvb_player_thread_channel_elements_parent_class = NULL;
static gpointer dvb_player_thread_parent_class = NULL;
static gpointer dvb_channel_factory_parent_class = NULL;

GType dvb_channel_get_type (void);
GType dvb_player_thread_get_type (void);
GType dvb_device_get_type (void);
static gpointer dvb_player_thread_channel_elements_ref (gpointer instance);
static void dvb_player_thread_channel_elements_unref (gpointer instance);
static GParamSpec* dvb_player_thread_param_spec_channel_elements (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void dvb_player_thread_value_set_channel_elements (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void dvb_player_thread_value_take_channel_elements (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer dvb_player_thread_value_get_channel_elements (const GValue* value) G_GNUC_UNUSED;
static GType dvb_player_thread_channel_elements_get_type (void) G_GNUC_UNUSED;
GType dvb_epg_scanner_get_type (void);
#define DVB_PLAYER_THREAD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_PLAYER_THREAD, DVBPlayerThreadPrivate))
enum  {
	DVB_PLAYER_THREAD_DUMMY_PROPERTY,
	DVB_PLAYER_THREAD_ACTIVE_CHANNELS,
	DVB_PLAYER_THREAD_DEVICE,
	DVB_PLAYER_THREAD_FORCED
};
DVBPlayerThread* dvb_player_thread_new (DVBDevice* device, DVBEPGScanner* epgscanner);
DVBPlayerThread* dvb_player_thread_construct (GType object_type, DVBDevice* device, DVBEPGScanner* epgscanner);
GstElement* dvb_player_thread_get_pipeline (DVBPlayerThread* self);
GstElement* dvb_player_thread_get_dvbbasebin (DVBPlayerThread* self);
guint dvb_channel_get_Sid (DVBChannel* self);
static void dvb_player_thread_bus_watch_func (DVBPlayerThread* self, GstBus* bus, GstMessage* message);
static void _dvb_player_thread_bus_watch_func_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self);
static void dvb_player_thread_on_dvbbasebin_pad_added (DVBPlayerThread* self, GstElement* elem, GstPad* pad);
static void _dvb_player_thread_on_dvbbasebin_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self);
void dvb_channel_setup_dvb_source (DVBChannel* self, GstElement* source);
DVBDevice* dvb_player_thread_get_device (DVBPlayerThread* self);
guint dvb_device_get_Adapter (DVBDevice* self);
guint dvb_device_get_Frontend (DVBDevice* self);
static gboolean dvb_player_thread_add_element (DVBPlayerThread* self, GstElement* elem);
static GstElement* dvb_player_thread_add_sink_bin (DVBPlayerThread* self, GstElement* sink_element);
GeeHashSet* dvb_player_thread_get_active_channels (DVBPlayerThread* self);
static DVBPlayerThreadChannelElements* dvb_player_thread_channel_elements_new (void);
static DVBPlayerThreadChannelElements* dvb_player_thread_channel_elements_construct (GType object_type);
GstElement* dvb_player_thread_get_element (DVBPlayerThread* self, DVBChannel* channel, GstElement* sink_element, gboolean forced, DVBForcedStopNotify notify_func, void* notify_func_target);
static gint dvb_player_thread_find_element (void* av, void* bv);
static gint _dvb_player_thread_find_element_gcompare_func (void* a, void* b);
GstElement* dvb_player_thread_get_sink_bin (DVBPlayerThread* self, guint sid, GstElement* sink);
static gboolean dvb_player_thread_set_playing_or_destroy (DVBPlayerThread* self);
static void dvb_player_thread_remove_sink_bin (DVBPlayerThread* self, guint channel_sid, GstElement* sink);
void dvb_player_thread_destroy (DVBPlayerThread* self, gboolean forced);
gboolean dvb_player_thread_remove_channel (DVBPlayerThread* self, DVBChannel* channel, GstElement* sink);
GType dvb_channel_list_get_type (void);
DVBChannelList* dvb_device_get_Channels (DVBDevice* self);
DVBChannel* dvb_channel_list_get_channel (DVBChannelList* self, guint sid);
static void dvb_player_thread_real_destroy (DVBPlayerThread* self, gboolean forced);
void dvb_epg_scanner_on_eit_structure (DVBEPGScanner* self, const GstStructure* structure);
static void dvb_player_thread_set_active_channels (DVBPlayerThread* self, GeeHashSet* value);
static void dvb_player_thread_set_device (DVBPlayerThread* self, DVBDevice* value);
gboolean dvb_player_thread_get_forced (DVBPlayerThread* self);
static GObject * dvb_player_thread_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
enum  {
	DVB_PLAYER_THREAD_CHANNEL_ELEMENTS_DUMMY_PROPERTY
};
static void dvb_player_thread_channel_elements_finalize (DVBPlayerThreadChannelElements* obj);
static void dvb_player_thread_finalize (GObject* obj);
static void dvb_player_thread_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dvb_player_thread_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType dvb_channel_factory_get_type (void);
GType dvb_device_group_get_type (void);
#define DVB_CHANNEL_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactoryPrivate))
enum  {
	DVB_CHANNEL_FACTORY_DUMMY_PROPERTY,
	DVB_CHANNEL_FACTORY_DEVICE_GROUP
};
DVBChannelFactory* dvb_channel_factory_new (DVBDeviceGroup* devgroup);
DVBChannelFactory* dvb_channel_factory_construct (GType object_type, DVBDeviceGroup* devgroup);
void dvb_channel_factory_destroy (DVBChannelFactory* self);
const char* dvb_channel_get_Name (DVBChannel* self);
gboolean dvb_channel_on_same_transport_stream (DVBChannel* self, DVBChannel* channel);
DVBDeviceGroup* dvb_channel_factory_get_device_group (DVBChannelFactory* self);
void dvb_device_group_stop_epg_scanner (DVBDeviceGroup* self);
DVBDevice* dvb_device_group_get_next_free_device (DVBDeviceGroup* self);
DVBPlayerThread* dvb_channel_factory_create_player (DVBChannelFactory* self, DVBDevice* device);
DVBPlayerThread* dvb_channel_factory_watch_channel (DVBChannelFactory* self, DVBChannel* channel, GstElement* sink_element, gboolean force, DVBForcedStopNotify notify_func, void* notify_func_target);
void dvb_device_group_start_epg_scanner (DVBDeviceGroup* self);
gboolean dvb_channel_factory_stop_channel (DVBChannelFactory* self, DVBChannel* channel, GstElement* sink);
DVBEPGScanner* dvb_device_group_get_epgscanner (DVBDeviceGroup* self);
static DVBPlayerThread* dvb_channel_factory_real_create_player (DVBChannelFactory* self, DVBDevice* device);
static void dvb_channel_factory_set_device_group (DVBChannelFactory* self, DVBDeviceGroup* value);
static void dvb_channel_factory_finalize (GObject* obj);
static void dvb_channel_factory_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dvb_channel_factory_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);


static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


DVBPlayerThread* dvb_player_thread_construct (GType object_type, DVBDevice* device, DVBEPGScanner* epgscanner) {
	DVBPlayerThread * self;
	DVBEPGScanner* _tmp0_;
	g_return_val_if_fail (device != NULL, NULL);
	self = (DVBPlayerThread*) g_object_new (object_type, "device", device, NULL);
	self->priv->epgscanner = (_tmp0_ = _g_object_ref0 (epgscanner), _g_object_unref0 (self->priv->epgscanner), _tmp0_);
	return self;
}


DVBPlayerThread* dvb_player_thread_new (DVBDevice* device, DVBEPGScanner* epgscanner) {
	return dvb_player_thread_construct (DVB_TYPE_PLAYER_THREAD, device, epgscanner);
}


static gpointer _gst_object_ref0 (gpointer self) {
	return self ? gst_object_ref (self) : NULL;
}


GstElement* dvb_player_thread_get_pipeline (DVBPlayerThread* self) {
	GstElement* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _gst_object_ref0 (self->priv->pipeline);
	return result;
}


GstElement* dvb_player_thread_get_dvbbasebin (DVBPlayerThread* self) {
	GstElement* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _gst_object_ref0 (self->priv->dvbbasebin);
	return result;
}


static void _dvb_player_thread_bus_watch_func_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self) {
	dvb_player_thread_bus_watch_func (self, _sender, message);
}


static void _dvb_player_thread_on_dvbbasebin_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self) {
	dvb_player_thread_on_dvbbasebin_pad_added (self, _sender, pad);
}


GstElement* dvb_player_thread_get_element (DVBPlayerThread* self, DVBChannel* channel, GstElement* sink_element, gboolean forced, DVBForcedStopNotify notify_func, void* notify_func_target) {
	GstElement* result = NULL;
	GError * _inner_error_;
	guint channel_sid;
	char* channel_sid_str;
	gboolean create_channel = FALSE;
	GstElement* bin;
	GstElement* tee;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (channel != NULL, NULL);
	g_return_val_if_fail (sink_element != NULL, NULL);
	_inner_error_ = NULL;
	channel_sid = dvb_channel_get_Sid (channel);
	channel_sid_str = g_strdup_printf ("%u", channel_sid);
	bin = NULL;
	tee = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_pipeline);
		{
			if (self->priv->pipeline == NULL) {
				GstElement* _tmp0_;
				GstBus* bus;
				GstElement* _tmp1_;
				GstElement* _tmp2_;
				GstElement* _tmp3_;
				g_debug ("ChannelFactory.vala:115: Creating new pipeline");
				self->priv->pipeline = (_tmp0_ = (GstElement*) ((GstPipeline*) gst_pipeline_new ("recording")), _gst_object_unref0 (self->priv->pipeline), _tmp0_);
				bus = gst_element_get_bus (self->priv->pipeline);
				gst_bus_add_signal_watch (bus);
				g_signal_connect_object (bus, "message", (GCallback) _dvb_player_thread_bus_watch_func_gst_bus_message, self, 0);
				self->priv->dvbbasebin = (_tmp1_ = gst_element_factory_make ("dvbbasebin", NULL), _gst_object_unref0 (self->priv->dvbbasebin), _tmp1_);
				if (self->priv->dvbbasebin == NULL) {
					g_critical ("ChannelFactory.vala:126: Could not create dvbbasebin element");
					result = NULL;
					_gst_object_unref0 (bus);
					{
						g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
					}
					_g_free0 (channel_sid_str);
					_gst_object_unref0 (bin);
					_gst_object_unref0 (tee);
					_gst_object_unref0 (sink_element);
					return result;
				}
				g_signal_connect_object (self->priv->dvbbasebin, "pad-added", (GCallback) _dvb_player_thread_on_dvbbasebin_pad_added_gst_element_pad_added, self, 0);
				dvb_channel_setup_dvb_source (channel, self->priv->dvbbasebin);
				g_object_set ((GObject*) self->priv->dvbbasebin, "program-numbers", channel_sid_str, NULL);
				g_object_set ((GObject*) self->priv->dvbbasebin, "adapter", dvb_device_get_Adapter (self->priv->_device), NULL);
				g_object_set ((GObject*) self->priv->dvbbasebin, "frontend", dvb_device_get_Frontend (self->priv->_device), NULL);
				gst_bin_add (GST_BIN (self->priv->pipeline), _gst_object_ref0 (self->priv->dvbbasebin));
				tee = (_tmp2_ = gst_element_factory_make ("tee", NULL), _gst_object_unref0 (tee), _tmp2_);
				dvb_player_thread_add_element (self, _gst_object_ref0 (tee));
				bin = (_tmp3_ = dvb_player_thread_add_sink_bin (self, sink_element), _gst_object_unref0 (bin), _tmp3_);
				if (!gst_element_link (tee, bin)) {
					g_critical ("ChannelFactory.vala:145: Could not link tee and bin");
					result = NULL;
					_gst_object_unref0 (bus);
					{
						g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
					}
					_g_free0 (channel_sid_str);
					_gst_object_unref0 (bin);
					_gst_object_unref0 (tee);
					_gst_object_unref0 (sink_element);
					return result;
				}
				create_channel = TRUE;
				_gst_object_unref0 (bus);
			} else {
				g_debug ("ChannelFactory.vala:153: Reusing existing pipeline");
				if (self->priv->dvbbasebin == NULL) {
					g_critical ("ChannelFactory.vala:155: No dvbbasebin element");
					result = NULL;
					{
						g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
					}
					_g_free0 (channel_sid_str);
					_gst_object_unref0 (bin);
					_gst_object_unref0 (tee);
					_gst_object_unref0 (sink_element);
					return result;
				}
				gst_element_set_state (self->priv->pipeline, GST_STATE_PAUSED);
				if (!gee_abstract_collection_contains ((GeeAbstractCollection*) self->priv->_active_channels, channel)) {
					GstElement* _tmp4_;
					GstElement* _tmp5_;
					char* programs;
					char* new_programs;
					tee = (_tmp4_ = gst_element_factory_make ("tee", NULL), _gst_object_unref0 (tee), _tmp4_);
					dvb_player_thread_add_element (self, _gst_object_ref0 (tee));
					bin = (_tmp5_ = dvb_player_thread_add_sink_bin (self, sink_element), _gst_object_unref0 (bin), _tmp5_);
					if (!gst_element_link (tee, bin)) {
						g_critical ("ChannelFactory.vala:169: Could not link tee and bin");
						result = NULL;
						{
							g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
						}
						_g_free0 (channel_sid_str);
						_gst_object_unref0 (bin);
						_gst_object_unref0 (tee);
						_gst_object_unref0 (sink_element);
						return result;
					}
					programs = NULL;
					g_object_get ((GObject*) self->priv->dvbbasebin, "program-numbers", &programs, NULL);
					new_programs = g_strdup_printf ("%s:%s", programs, channel_sid_str);
					g_debug ("ChannelFactory.vala:178: Changing program-numbers from %s to %s", programs, new_programs);
					g_object_set ((GObject*) self->priv->dvbbasebin, "program-numbers", new_programs, NULL);
					create_channel = TRUE;
					_g_free0 (programs);
					_g_free0 (new_programs);
				} else {
					DVBPlayerThreadChannelElements* c_element;
					c_element = NULL;
					{
						g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
						{
							DVBPlayerThreadChannelElements* _tmp6_;
							GstElement* _tmp7_;
							GstElement* _tmp8_;
							char* _tmp10_;
							char* _tmp9_;
							c_element = (_tmp6_ = (DVBPlayerThreadChannelElements*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->elements_map, GUINT_TO_POINTER (channel_sid)), _dvb_player_thread_channel_elements_unref0 (c_element), _tmp6_);
							tee = (_tmp7_ = _gst_object_ref0 (c_element->tee), _gst_object_unref0 (tee), _tmp7_);
							bin = (_tmp8_ = dvb_player_thread_add_sink_bin (self, sink_element), _gst_object_unref0 (bin), _tmp8_);
							g_debug ("ChannelFactory.vala:193: Linking %s with %s", _tmp9_ = gst_object_get_name ((GstObject*) tee), _tmp10_ = gst_object_get_name ((GstObject*) bin));
							_g_free0 (_tmp10_);
							_g_free0 (_tmp9_);
							if (!gst_element_link (tee, bin)) {
								g_critical ("ChannelFactory.vala:195: Could not link tee and bin");
								result = NULL;
								{
									g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
								}
								_dvb_player_thread_channel_elements_unref0 (c_element);
								{
									g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
								}
								_g_free0 (channel_sid_str);
								_gst_object_unref0 (bin);
								_gst_object_unref0 (tee);
								_gst_object_unref0 (sink_element);
								return result;
							}
							gee_abstract_collection_add ((GeeAbstractCollection*) c_element->sinks, bin);
						}
						__finally15:
						{
							g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
						}
						if (_inner_error_ != NULL) {
							_dvb_player_thread_channel_elements_unref0 (c_element);
							_dvb_player_thread_channel_elements_unref0 (c_element);
							{
								g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
							}
							_g_free0 (channel_sid_str);
							_gst_object_unref0 (bin);
							_gst_object_unref0 (tee);
							_gst_object_unref0 (sink_element);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					create_channel = FALSE;
					_dvb_player_thread_channel_elements_unref0 (c_element);
				}
			}
			if (create_channel) {
				DVBPlayerThreadChannelElements* celems;
				GeeArrayList* _tmp11_;
				GstElement* _tmp12_;
				DVBForcedStopNotify _tmp13_;
				celems = dvb_player_thread_channel_elements_new ();
				celems->sid = channel_sid;
				celems->sinks = (_tmp11_ = gee_array_list_new (GST_TYPE_ELEMENT, (GBoxedCopyFunc) gst_object_ref, gst_object_unref, NULL), _g_object_unref0 (celems->sinks), _tmp11_);
				gee_abstract_collection_add ((GeeAbstractCollection*) celems->sinks, bin);
				celems->tee = (_tmp12_ = _gst_object_ref0 (tee), _gst_object_unref0 (celems->tee), _tmp12_);
				celems->forced = forced;
				celems->notify_func = (_tmp13_ = notify_func, ((celems->notify_func_target_destroy_notify == NULL) ? NULL : (celems->notify_func_target_destroy_notify (celems->notify_func_target), NULL), celems->notify_func = NULL, celems->notify_func_target = NULL, celems->notify_func_target_destroy_notify = NULL), celems->notify_func_target = notify_func_target, celems->notify_func_target_destroy_notify = NULL, _tmp13_);
				{
					g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
					{
						gee_abstract_map_set ((GeeAbstractMap*) self->priv->elements_map, GUINT_TO_POINTER (channel_sid), celems);
					}
					__finally16:
					{
						g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
					}
					if (_inner_error_ != NULL) {
						_dvb_player_thread_channel_elements_unref0 (celems);
						_dvb_player_thread_channel_elements_unref0 (celems);
						{
							g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
						}
						_g_free0 (channel_sid_str);
						_gst_object_unref0 (bin);
						_gst_object_unref0 (tee);
						_gst_object_unref0 (sink_element);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->_active_channels, channel);
				_dvb_player_thread_channel_elements_unref0 (celems);
			}
			result = _gst_object_ref0 (bin);
			{
				g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
			}
			_g_free0 (channel_sid_str);
			_gst_object_unref0 (bin);
			_gst_object_unref0 (tee);
			_gst_object_unref0 (sink_element);
			return result;
		}
		__finally14:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
		}
		{
			_g_free0 (channel_sid_str);
			_gst_object_unref0 (bin);
			_gst_object_unref0 (tee);
			_gst_object_unref0 (sink_element);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_free0 (channel_sid_str);
	_gst_object_unref0 (bin);
	_gst_object_unref0 (tee);
	_gst_object_unref0 (sink_element);
}


static GstElement* dvb_player_thread_add_sink_bin (DVBPlayerThread* self, GstElement* sink_element) {
	GstElement* result = NULL;
	GstElement* queue;
	GstElement* bin;
	GstPad* pad;
	GstGhostPad* ghost;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sink_element != NULL, NULL);
	queue = gst_element_factory_make ("queue", NULL);
	g_object_set ((GObject*) queue, "max-size-buffers", 0, NULL);
	bin = (GstElement*) ((GstBin*) gst_bin_new (NULL));
	gst_bin_add_many (GST_BIN (bin), _gst_object_ref0 (queue), _gst_object_ref0 (sink_element), NULL);
	if (!gst_element_link (queue, sink_element)) {
		char* _tmp1_;
		char* _tmp0_;
		g_critical ("ChannelFactory.vala:231: Could not link elements %s and %s", _tmp0_ = gst_object_get_name ((GstObject*) queue), _tmp1_ = gst_object_get_name ((GstObject*) sink_element));
		_g_free0 (_tmp1_);
		_g_free0 (_tmp0_);
	}
	pad = gst_element_get_static_pad (queue, "sink");
	ghost = (GstGhostPad*) gst_ghost_pad_new ("sink", pad);
	gst_pad_set_active ((GstPad*) ghost, TRUE);
	gst_element_add_pad (bin, _gst_object_ref0 ((GstPad*) ghost));
	dvb_player_thread_add_element (self, _gst_object_ref0 (bin));
	result = bin;
	_gst_object_unref0 (queue);
	_gst_object_unref0 (pad);
	_gst_object_unref0 (ghost);
	return result;
}


static gint dvb_player_thread_find_element (void* av, void* bv) {
	gint result = 0;
	GstElement* a;
	GstElement* b;
	a = _gst_object_ref0 (GST_ELEMENT (av));
	b = _gst_object_ref0 (GST_ELEMENT (bv));
	if (a == b) {
		result = 0;
		_gst_object_unref0 (a);
		_gst_object_unref0 (b);
		return result;
	} else {
		result = 1;
		_gst_object_unref0 (a);
		_gst_object_unref0 (b);
		return result;
	}
	_gst_object_unref0 (a);
	_gst_object_unref0 (b);
}


static gint _dvb_player_thread_find_element_gcompare_func (void* a, void* b) {
	gint result;
	result = dvb_player_thread_find_element (a, b);
	return result;
}


GstElement* dvb_player_thread_get_sink_bin (DVBPlayerThread* self, guint sid, GstElement* sink) {
	GstElement* result = NULL;
	GError * _inner_error_;
	GstElement* _result_;
	char* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sink != NULL, NULL);
	_inner_error_ = NULL;
	_result_ = NULL;
	g_debug ("ChannelFactory.vala:261: Searching for sink %s (%p) of channel %u", _tmp0_ = gst_object_get_name ((GstObject*) sink), sink, sid);
	_g_free0 (_tmp0_);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
		{
			DVBPlayerThreadChannelElements* celems;
			celems = (DVBPlayerThreadChannelElements*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->elements_map, GUINT_TO_POINTER (sid));
			if (celems != NULL) {
				{
					GeeIterator* _sink_bin_it;
					_sink_bin_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) celems->sinks);
					while (TRUE) {
						GstElement* sink_bin;
						GstIterator* it;
						GstElement* element;
						if (!gee_iterator_next (_sink_bin_it)) {
							break;
						}
						sink_bin = (GstElement*) gee_iterator_get (_sink_bin_it);
						it = gst_bin_iterate_elements (GST_BIN (sink_bin));
						element = (GstElement*) gst_iterator_find_custom (it, _dvb_player_thread_find_element_gcompare_func, sink);
						if (element != NULL) {
							GstElement* _tmp1_;
							_result_ = (_tmp1_ = _gst_object_ref0 (sink_bin), _gst_object_unref0 (_result_), _tmp1_);
							_gst_object_unref0 (sink_bin);
							_gst_iterator_free0 (it);
							_gst_object_unref0 (element);
							break;
						}
						_gst_object_unref0 (sink_bin);
						_gst_iterator_free0 (it);
						_gst_object_unref0 (element);
					}
					_g_object_unref0 (_sink_bin_it);
				}
			} else {
				g_warning ("ChannelFactory.vala:274: Could not find any sinks of channel %u", sid);
			}
			_dvb_player_thread_channel_elements_unref0 (celems);
		}
		__finally17:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
		}
		if (_inner_error_ != NULL) {
			_gst_object_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (_result_ == NULL) {
		g_debug ("ChannelFactory.vala:278: Found NO sink");
	} else {
		g_debug ("ChannelFactory.vala:280: Found sink");
	}
	result = _result_;
	return result;
}


gboolean dvb_player_thread_remove_channel (DVBPlayerThread* self, DVBChannel* channel, GstElement* sink) {
	gboolean result = FALSE;
	GError * _inner_error_;
	guint channel_sid;
	DVBPlayerThreadChannelElements* celements;
	gboolean stop_channel = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (channel != NULL, FALSE);
	g_return_val_if_fail (sink != NULL, FALSE);
	_inner_error_ = NULL;
	channel_sid = dvb_channel_get_Sid (channel);
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) self->priv->_active_channels, channel)) {
		g_critical ("ChannelFactory.vala:291: Could not find channel with SID %u", channel_sid);
		result = FALSE;
		return result;
	}
	celements = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
		{
			DVBPlayerThreadChannelElements* _tmp0_;
			celements = (_tmp0_ = (DVBPlayerThreadChannelElements*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->elements_map, GUINT_TO_POINTER (channel_sid)), _dvb_player_thread_channel_elements_unref0 (celements), _tmp0_);
			stop_channel = gee_collection_get_size ((GeeCollection*) celements->sinks) == 1;
		}
		__finally18:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
		}
		if (_inner_error_ != NULL) {
			_dvb_player_thread_channel_elements_unref0 (celements);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	{
		g_static_rec_mutex_lock (&self->priv->__lock_pipeline);
		{
			if (gee_collection_get_size ((GeeCollection*) self->priv->_active_channels) > 1) {
				if (stop_channel) {
					char* channel_sid_string;
					char* programs;
					char** _tmp2_;
					gint _programs_arr_size_;
					gint programs_arr_length1;
					char** _tmp1_;
					char** programs_arr;
					GeeArrayList* new_programs_list;
					char* _tmp4_;
					GString* _tmp5_;
					GString* new_programs;
					channel_sid_string = g_strdup_printf ("%u", channel_sid);
					programs = NULL;
					g_object_get ((GObject*) self->priv->dvbbasebin, "program-numbers", &programs, NULL);
					programs_arr = (_tmp2_ = _tmp1_ = g_strsplit (programs, ":", 0), programs_arr_length1 = _vala_array_length (_tmp1_), _programs_arr_size_ = programs_arr_length1, _tmp2_);
					new_programs_list = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
					{
						gint i;
						i = 0;
						{
							gboolean _tmp3_;
							_tmp3_ = TRUE;
							while (TRUE) {
								if (!_tmp3_) {
									i++;
								}
								_tmp3_ = FALSE;
								if (!(i < programs_arr_length1)) {
									break;
								}
								if (_vala_strcmp0 (programs_arr[i], channel_sid_string) != 0) {
									gee_abstract_collection_add ((GeeAbstractCollection*) new_programs_list, programs_arr[i]);
								}
							}
						}
					}
					new_programs = (_tmp5_ = g_string_new (_tmp4_ = (char*) gee_abstract_list_get ((GeeAbstractList*) new_programs_list, 0)), _g_free0 (_tmp4_), _tmp5_);
					{
						gint i;
						i = 1;
						{
							gboolean _tmp6_;
							_tmp6_ = TRUE;
							while (TRUE) {
								char* _tmp8_;
								char* _tmp7_;
								if (!_tmp6_) {
									i++;
								}
								_tmp6_ = FALSE;
								if (!(i < gee_collection_get_size ((GeeCollection*) new_programs_list))) {
									break;
								}
								g_string_append (new_programs, _tmp8_ = g_strconcat (":", _tmp7_ = (char*) gee_abstract_list_get ((GeeAbstractList*) new_programs_list, i), NULL));
								_g_free0 (_tmp8_);
								_g_free0 (_tmp7_);
							}
						}
					}
					g_debug ("ChannelFactory.vala:330: Changing program-numbers from %s to %s", programs, new_programs->str);
					gst_element_set_state (self->priv->pipeline, GST_STATE_PAUSED);
					g_object_set ((GObject*) self->priv->dvbbasebin, "program-numbers", new_programs->str, NULL);
					if (!dvb_player_thread_set_playing_or_destroy (self)) {
						result = FALSE;
						_g_free0 (channel_sid_string);
						_g_free0 (programs);
						programs_arr = (_vala_array_free (programs_arr, programs_arr_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (new_programs_list);
						_g_string_free0 (new_programs);
						{
							g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
						}
						_dvb_player_thread_channel_elements_unref0 (celements);
						return result;
					}
					gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->_active_channels, channel);
					_g_free0 (channel_sid_string);
					_g_free0 (programs);
					programs_arr = (_vala_array_free (programs_arr, programs_arr_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (new_programs_list);
					_g_string_free0 (new_programs);
				}
				dvb_player_thread_remove_sink_bin (self, channel_sid, sink);
				if (stop_channel) {
					char* _tmp9_;
					g_debug ("ChannelFactory.vala:345: Removing tee %s from pipeline", _tmp9_ = gst_object_get_name ((GstObject*) celements->tee));
					_g_free0 (_tmp9_);
					gst_element_set_state (celements->tee, GST_STATE_NULL);
					gst_bin_remove (GST_BIN (self->priv->pipeline), celements->tee);
					{
						g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
						{
							gee_map_remove ((GeeMap*) self->priv->elements_map, GUINT_TO_POINTER (channel_sid), NULL);
						}
						__finally20:
						{
							g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
						}
						if (_inner_error_ != NULL) {
							{
								g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
							}
							_dvb_player_thread_channel_elements_unref0 (celements);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
					}
				}
			} else {
				if (stop_channel) {
					dvb_player_thread_destroy (self, FALSE);
				} else {
					dvb_player_thread_remove_sink_bin (self, channel_sid, sink);
					if (!dvb_player_thread_set_playing_or_destroy (self)) {
						result = FALSE;
						{
							g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
						}
						_dvb_player_thread_channel_elements_unref0 (celements);
						return result;
					}
				}
			}
		}
		__finally19:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
		}
		if (_inner_error_ != NULL) {
			_dvb_player_thread_channel_elements_unref0 (celements);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	_dvb_player_thread_channel_elements_unref0 (celements);
	return result;
}


static gboolean dvb_player_thread_set_playing_or_destroy (DVBPlayerThread* self) {
	gboolean result = FALSE;
	GstStateChangeReturn ret;
	g_return_val_if_fail (self != NULL, FALSE);
	ret = gst_element_set_state (self->priv->pipeline, GST_STATE_PLAYING);
	if (ret == GST_STATE_CHANGE_FAILURE) {
		g_critical ("ChannelFactory.vala:376: Failed setting pipeline to playing");
		dvb_player_thread_destroy (self, FALSE);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static void dvb_player_thread_remove_sink_bin (DVBPlayerThread* self, guint channel_sid, GstElement* sink) {
	GError * _inner_error_;
	char* _tmp0_;
	GstElement* sink_bin;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sink != NULL);
	_inner_error_ = NULL;
	g_debug ("ChannelFactory.vala:384: Removing sink bin of sink %s (%p) of channel " \
"%u", _tmp0_ = gst_object_get_name ((GstObject*) sink), sink, channel_sid);
	_g_free0 (_tmp0_);
	sink_bin = dvb_player_thread_get_sink_bin (self, channel_sid, sink);
	if (sink_bin == NULL) {
		char* _tmp1_;
		g_critical ("ChannelFactory.vala:390: Could not find sink bin for channel %u and si" \
"nk %s (%p)", channel_sid, _tmp1_ = gst_object_get_name ((GstObject*) sink), sink);
		_g_free0 (_tmp1_);
		_gst_object_unref0 (sink_bin);
		return;
	}
	{
		g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
		{
			DVBPlayerThreadChannelElements* celems;
			char* _tmp2_;
			celems = (DVBPlayerThreadChannelElements*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->elements_map, GUINT_TO_POINTER (channel_sid));
			g_debug ("ChannelFactory.vala:398: Setting state of queue and sink %s (%p) to NU" \
"LL", _tmp2_ = gst_object_get_name ((GstObject*) sink), sink);
			_g_free0 (_tmp2_);
			gst_element_unlink (celems->tee, sink_bin);
			gst_element_set_state (sink_bin, GST_STATE_NULL);
			if (!gee_abstract_collection_remove ((GeeAbstractCollection*) celems->sinks, sink_bin)) {
				char* _tmp3_;
				g_critical ("ChannelFactory.vala:404: Could not find sink bin %s (%p)", _tmp3_ = gst_object_get_name ((GstObject*) sink_bin), sink_bin);
				_g_free0 (_tmp3_);
			}
			_dvb_player_thread_channel_elements_unref0 (celems);
		}
		__finally21:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
		}
		if (_inner_error_ != NULL) {
			_gst_object_unref0 (sink_bin);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_debug ("ChannelFactory.vala:409: Removing queue and sink from pipeline");
	gst_bin_remove (GST_BIN (self->priv->pipeline), sink_bin);
	_gst_object_unref0 (sink_bin);
}


static void dvb_player_thread_real_destroy (DVBPlayerThread* self, gboolean forced) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	if (self->priv->destroyed) {
		return;
	}
	{
		g_static_rec_mutex_lock (&self->priv->__lock_destroyed);
		{
			self->priv->destroyed = TRUE;
			if (forced) {
				{
					g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
					{
						{
							GeeCollection* _tmp0_;
							GeeIterator* _tmp1_;
							GeeIterator* _celems_it;
							_celems_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = gee_map_get_values ((GeeMap*) self->priv->elements_map))), _g_object_unref0 (_tmp0_), _tmp1_);
							while (TRUE) {
								DVBPlayerThreadChannelElements* celems;
								if (!gee_iterator_next (_celems_it)) {
									break;
								}
								celems = (DVBPlayerThreadChannelElements*) gee_iterator_get (_celems_it);
								if (celems->notify_func != NULL) {
									DVBChannel* channel;
									channel = dvb_channel_list_get_channel (dvb_device_get_Channels (self->priv->_device), celems->sid);
									celems->notify_func (channel, celems->notify_func_target);
									_g_object_unref0 (channel);
								}
								_dvb_player_thread_channel_elements_unref0 (celems);
							}
							_g_object_unref0 (_celems_it);
						}
					}
					__finally23:
					{
						g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
					}
					if (_inner_error_ != NULL) {
						{
							g_static_rec_mutex_unlock (&self->priv->__lock_destroyed);
						}
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
			{
				g_static_rec_mutex_lock (&self->priv->__lock_pipeline);
				{
					GstElement* _tmp2_;
					if (self->priv->pipeline != NULL) {
						GstBus* bus;
						g_debug ("ChannelFactory.vala:434: Stopping pipeline");
						bus = gst_element_get_bus (self->priv->pipeline);
						gst_bus_remove_signal_watch (bus);
						gst_element_set_state (self->priv->pipeline, GST_STATE_NULL);
						_gst_object_unref0 (bus);
					}
					self->priv->pipeline = (_tmp2_ = NULL, _gst_object_unref0 (self->priv->pipeline), _tmp2_);
				}
				__finally24:
				{
					g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
				}
				if (_inner_error_ != NULL) {
					{
						g_static_rec_mutex_unlock (&self->priv->__lock_destroyed);
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			{
				g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
				{
					gee_abstract_map_clear ((GeeAbstractMap*) self->priv->elements_map);
				}
				__finally25:
				{
					g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
				}
				if (_inner_error_ != NULL) {
					{
						g_static_rec_mutex_unlock (&self->priv->__lock_destroyed);
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			gee_abstract_collection_clear ((GeeAbstractCollection*) self->priv->_active_channels);
		}
		__finally22:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_destroyed);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void dvb_player_thread_destroy (DVBPlayerThread* self, gboolean forced) {
	DVB_PLAYER_THREAD_GET_CLASS (self)->destroy (self, forced);
}


static gboolean dvb_player_thread_add_element (DVBPlayerThread* self, GstElement* elem) {
	gboolean result = FALSE;
	char* elem_name;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (elem != NULL, FALSE);
	elem_name = gst_object_get_name ((GstObject*) elem);
	if (!gst_bin_add (GST_BIN (self->priv->pipeline), _gst_object_ref0 (elem))) {
		g_critical ("ChannelFactory.vala:451: Could not add element %s", elem_name);
		result = FALSE;
		_g_free0 (elem_name);
		_gst_object_unref0 (elem);
		return result;
	}
	g_debug ("ChannelFactory.vala:454: Element %s (%p) added to pipeline", elem_name, elem);
	result = TRUE;
	_g_free0 (elem_name);
	_gst_object_unref0 (elem);
	return result;
}


static void dvb_player_thread_on_dvbbasebin_pad_added (DVBPlayerThread* self, GstElement* elem, GstPad* pad) {
	GError * _inner_error_;
	char* pad_name;
	guint sid = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (elem != NULL);
	g_return_if_fail (pad != NULL);
	_inner_error_ = NULL;
	pad_name = gst_object_get_name ((GstObject*) pad);
	g_debug ("ChannelFactory.vala:463: Pad %s added", pad_name);
	if (!g_str_has_prefix (pad_name, "program_")) {
		_g_free0 (pad_name);
		return;
	}
	sscanf (pad_name, "program_%u", &sid);
	g_debug ("ChannelFactory.vala:471: SID is '%u'", sid);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
		{
			if (gee_map_contains ((GeeMap*) self->priv->elements_map, GUINT_TO_POINTER (sid))) {
				DVBPlayerThreadChannelElements* _tmp0_;
				GstElement* _tmp1_;
				GstElement* sink;
				char* _tmp3_;
				char* _tmp2_;
				GstPad* sinkpad;
				GstPadLinkReturn rc;
				sink = (_tmp1_ = _gst_object_ref0 ((_tmp0_ = (DVBPlayerThreadChannelElements*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->elements_map, GUINT_TO_POINTER (sid)))->tee), _dvb_player_thread_channel_elements_unref0 (_tmp0_), _tmp1_);
				if (sink == NULL) {
					g_critical ("ChannelFactory.vala:477: Could not find sink for SID %u", sid);
					_gst_object_unref0 (sink);
					{
						g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
					}
					_g_free0 (pad_name);
					return;
				}
				g_debug ("ChannelFactory.vala:481: Linking elements %s and %s", _tmp2_ = gst_object_get_name ((GstObject*) elem), _tmp3_ = gst_object_get_name ((GstObject*) sink));
				_g_free0 (_tmp3_);
				_g_free0 (_tmp2_);
				sinkpad = gst_element_get_static_pad (sink, "sink");
				rc = gst_pad_link (pad, sinkpad);
				if (rc != GST_PAD_LINK_OK) {
					char* _tmp5_;
					char* _tmp4_;
					g_critical ("ChannelFactory.vala:486: Could not link pads %s and %s", _tmp4_ = gst_object_get_name ((GstObject*) pad), _tmp5_ = gst_object_get_name ((GstObject*) sinkpad));
					_g_free0 (_tmp5_);
					_g_free0 (_tmp4_);
				} else {
					char* _tmp7_;
					char* _tmp6_;
					g_debug ("ChannelFactory.vala:489: Src pad %s linked with sink pad %s", _tmp6_ = gst_object_get_name ((GstObject*) pad), _tmp7_ = gst_object_get_name ((GstObject*) sinkpad));
					_g_free0 (_tmp7_);
					_g_free0 (_tmp6_);
				}
				_gst_object_unref0 (sink);
				_gst_object_unref0 (sinkpad);
			}
		}
		__finally26:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
		}
		if (_inner_error_ != NULL) {
			_g_free0 (pad_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (pad_name);
}


static gpointer _gst_structure_copy0 (gpointer self) {
	return self ? gst_structure_copy (self) : NULL;
}


static void dvb_player_thread_bus_watch_func (DVBPlayerThread* self, GstBus* bus, GstMessage* message) {
	GstStructure* structure;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bus != NULL);
	g_return_if_fail (message != NULL);
	structure = _gst_structure_copy0 (gst_message_get_structure (message));
	switch (GST_MESSAGE_TYPE (message)) {
		case GST_MESSAGE_ELEMENT:
		{
			char* structure_name;
			structure_name = g_strdup (gst_structure_get_name (structure));
			if (_vala_strcmp0 (structure_name, "eit") == 0) {
				if (self->priv->epgscanner != NULL) {
					dvb_epg_scanner_on_eit_structure (self->priv->epgscanner, structure);
				}
				g_signal_emit_by_name (self, "eit-structure", structure);
			}
			_g_free0 (structure_name);
			break;
		}
		case GST_MESSAGE_WARNING:
		{
			char* _tmp0_;
			g_warning ("ChannelFactory.vala:511: %s", _tmp0_ = gst_structure_to_string (structure));
			_g_free0 (_tmp0_);
			break;
		}
		case GST_MESSAGE_ERROR:
		{
			char* _tmp1_;
			g_critical ("ChannelFactory.vala:514: %s", _tmp1_ = gst_structure_to_string (structure));
			_g_free0 (_tmp1_);
			break;
		}
		default:
		{
			break;
		}
	}
	_gst_structure_free0 (structure);
}


GeeHashSet* dvb_player_thread_get_active_channels (DVBPlayerThread* self) {
	GeeHashSet* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_active_channels;
	return result;
}


static void dvb_player_thread_set_active_channels (DVBPlayerThread* self, GeeHashSet* value) {
	GeeHashSet* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_active_channels = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_active_channels), _tmp0_);
	g_object_notify ((GObject *) self, "active-channels");
}


DVBDevice* dvb_player_thread_get_device (DVBPlayerThread* self) {
	DVBDevice* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_device;
	return result;
}


static void dvb_player_thread_set_device (DVBPlayerThread* self, DVBDevice* value) {
	DVBDevice* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_device = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_device), _tmp0_);
	g_object_notify ((GObject *) self, "device");
}


gboolean dvb_player_thread_get_forced (DVBPlayerThread* self) {
	GError * _inner_error_;
	gboolean result;
	gboolean val;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	val = FALSE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
		{
			{
				GeeCollection* _tmp0_;
				GeeIterator* _tmp1_;
				GeeIterator* _celem_it;
				_celem_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = gee_map_get_values ((GeeMap*) self->priv->elements_map))), _g_object_unref0 (_tmp0_), _tmp1_);
				while (TRUE) {
					DVBPlayerThreadChannelElements* celem;
					if (!gee_iterator_next (_celem_it)) {
						break;
					}
					celem = (DVBPlayerThreadChannelElements*) gee_iterator_get (_celem_it);
					if (celem->forced) {
						val = TRUE;
						_dvb_player_thread_channel_elements_unref0 (celem);
						break;
					}
					_dvb_player_thread_channel_elements_unref0 (celem);
				}
				_g_object_unref0 (_celem_it);
			}
		}
		__finally27:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = val;
	return result;
}


static GObject * dvb_player_thread_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBPlayerThread * self;
	parent_class = G_OBJECT_CLASS (dvb_player_thread_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_PLAYER_THREAD (obj);
	{
		GeeHashMap* _tmp0_;
		GeeHashSet* _tmp1_;
		self->priv->elements_map = (_tmp0_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS, (GBoxedCopyFunc) dvb_player_thread_channel_elements_ref, dvb_player_thread_channel_elements_unref, NULL, NULL, NULL), _g_object_unref0 (self->priv->elements_map), _tmp0_);
		dvb_player_thread_set_active_channels (self, _tmp1_ = gee_hash_set_new (DVB_TYPE_CHANNEL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL));
		_g_object_unref0 (_tmp1_);
		self->priv->destroyed = FALSE;
	}
	return obj;
}


static DVBPlayerThreadChannelElements* dvb_player_thread_channel_elements_construct (GType object_type) {
	DVBPlayerThreadChannelElements* self;
	self = (DVBPlayerThreadChannelElements*) g_type_create_instance (object_type);
	return self;
}


static DVBPlayerThreadChannelElements* dvb_player_thread_channel_elements_new (void) {
	return dvb_player_thread_channel_elements_construct (DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS);
}


static void dvb_player_thread_value_channel_elements_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void dvb_player_thread_value_channel_elements_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		dvb_player_thread_channel_elements_unref (value->data[0].v_pointer);
	}
}


static void dvb_player_thread_value_channel_elements_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = dvb_player_thread_channel_elements_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer dvb_player_thread_value_channel_elements_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* dvb_player_thread_value_channel_elements_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		DVBPlayerThreadChannelElements* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = dvb_player_thread_channel_elements_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* dvb_player_thread_value_channel_elements_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DVBPlayerThreadChannelElements** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = dvb_player_thread_channel_elements_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* dvb_player_thread_param_spec_channel_elements (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	DVBPlayerThreadParamSpecChannelElements* spec;
	g_return_val_if_fail (g_type_is_a (object_type, DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer dvb_player_thread_value_get_channel_elements (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS), NULL);
	return value->data[0].v_pointer;
}


static void dvb_player_thread_value_set_channel_elements (GValue* value, gpointer v_object) {
	DVBPlayerThreadChannelElements* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		dvb_player_thread_channel_elements_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dvb_player_thread_channel_elements_unref (old);
	}
}


static void dvb_player_thread_value_take_channel_elements (GValue* value, gpointer v_object) {
	DVBPlayerThreadChannelElements* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dvb_player_thread_channel_elements_unref (old);
	}
}


static void dvb_player_thread_channel_elements_class_init (DVBPlayerThreadChannelElementsClass * klass) {
	dvb_player_thread_channel_elements_parent_class = g_type_class_peek_parent (klass);
	DVB_PLAYER_THREAD_CHANNEL_ELEMENTS_CLASS (klass)->finalize = dvb_player_thread_channel_elements_finalize;
}


static void dvb_player_thread_channel_elements_instance_init (DVBPlayerThreadChannelElements * self) {
	self->ref_count = 1;
}


static void dvb_player_thread_channel_elements_finalize (DVBPlayerThreadChannelElements* obj) {
	DVBPlayerThreadChannelElements * self;
	self = DVB_PLAYER_THREAD_CHANNEL_ELEMENTS (obj);
	_g_object_unref0 (self->sinks);
	_gst_object_unref0 (self->tee);
	(self->notify_func_target_destroy_notify == NULL) ? NULL : (self->notify_func_target_destroy_notify (self->notify_func_target), NULL);
	self->notify_func = NULL;
	self->notify_func_target = NULL;
	self->notify_func_target_destroy_notify = NULL;
}


static GType dvb_player_thread_channel_elements_get_type (void) {
	static volatile gsize dvb_player_thread_channel_elements_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_player_thread_channel_elements_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { dvb_player_thread_value_channel_elements_init, dvb_player_thread_value_channel_elements_free_value, dvb_player_thread_value_channel_elements_copy_value, dvb_player_thread_value_channel_elements_peek_pointer, "p", dvb_player_thread_value_channel_elements_collect_value, "p", dvb_player_thread_value_channel_elements_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DVBPlayerThreadChannelElementsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_player_thread_channel_elements_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBPlayerThreadChannelElements), 0, (GInstanceInitFunc) dvb_player_thread_channel_elements_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType dvb_player_thread_channel_elements_type_id;
		dvb_player_thread_channel_elements_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DVBPlayerThreadChannelElements", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&dvb_player_thread_channel_elements_type_id__volatile, dvb_player_thread_channel_elements_type_id);
	}
	return dvb_player_thread_channel_elements_type_id__volatile;
}


static gpointer dvb_player_thread_channel_elements_ref (gpointer instance) {
	DVBPlayerThreadChannelElements* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void dvb_player_thread_channel_elements_unref (gpointer instance) {
	DVBPlayerThreadChannelElements* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DVB_PLAYER_THREAD_CHANNEL_ELEMENTS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void dvb_player_thread_class_init (DVBPlayerThreadClass * klass) {
	dvb_player_thread_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBPlayerThreadPrivate));
	DVB_PLAYER_THREAD_CLASS (klass)->destroy = dvb_player_thread_real_destroy;
	G_OBJECT_CLASS (klass)->get_property = dvb_player_thread_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_player_thread_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_player_thread_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_player_thread_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_PLAYER_THREAD_ACTIVE_CHANNELS, g_param_spec_object ("active-channels", "active-channels", "active-channels", GEE_TYPE_HASH_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_PLAYER_THREAD_DEVICE, g_param_spec_object ("device", "device", "device", DVB_TYPE_DEVICE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_PLAYER_THREAD_FORCED, g_param_spec_boolean ("forced", "forced", "forced", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("eit_structure", DVB_TYPE_PLAYER_THREAD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, GST_TYPE_STRUCTURE);
}


static void dvb_player_thread_instance_init (DVBPlayerThread * self) {
	self->priv = DVB_PLAYER_THREAD_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_pipeline);
	g_static_rec_mutex_init (&self->priv->__lock_elements_map);
	g_static_rec_mutex_init (&self->priv->__lock_destroyed);
}


static void dvb_player_thread_finalize (GObject* obj) {
	DVBPlayerThread * self;
	self = DVB_PLAYER_THREAD (obj);
	_g_object_unref0 (self->priv->_active_channels);
	_g_object_unref0 (self->priv->_device);
	g_static_rec_mutex_free (&self->priv->__lock_pipeline);
	_gst_object_unref0 (self->priv->pipeline);
	g_static_rec_mutex_free (&self->priv->__lock_elements_map);
	_g_object_unref0 (self->priv->elements_map);
	_g_object_unref0 (self->priv->epgscanner);
	_gst_object_unref0 (self->priv->dvbbasebin);
	g_static_rec_mutex_free (&self->priv->__lock_destroyed);
	G_OBJECT_CLASS (dvb_player_thread_parent_class)->finalize (obj);
}


GType dvb_player_thread_get_type (void) {
	static volatile gsize dvb_player_thread_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_player_thread_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBPlayerThreadClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_player_thread_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBPlayerThread), 0, (GInstanceInitFunc) dvb_player_thread_instance_init, NULL };
		GType dvb_player_thread_type_id;
		dvb_player_thread_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBPlayerThread", &g_define_type_info, 0);
		g_once_init_leave (&dvb_player_thread_type_id__volatile, dvb_player_thread_type_id);
	}
	return dvb_player_thread_type_id__volatile;
}


static void dvb_player_thread_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBPlayerThread * self;
	self = DVB_PLAYER_THREAD (object);
	switch (property_id) {
		case DVB_PLAYER_THREAD_ACTIVE_CHANNELS:
		g_value_set_object (value, dvb_player_thread_get_active_channels (self));
		break;
		case DVB_PLAYER_THREAD_DEVICE:
		g_value_set_object (value, dvb_player_thread_get_device (self));
		break;
		case DVB_PLAYER_THREAD_FORCED:
		g_value_set_boolean (value, dvb_player_thread_get_forced (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_player_thread_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBPlayerThread * self;
	self = DVB_PLAYER_THREAD (object);
	switch (property_id) {
		case DVB_PLAYER_THREAD_ACTIVE_CHANNELS:
		dvb_player_thread_set_active_channels (self, g_value_get_object (value));
		break;
		case DVB_PLAYER_THREAD_DEVICE:
		dvb_player_thread_set_device (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


DVBChannelFactory* dvb_channel_factory_construct (GType object_type, DVBDeviceGroup* devgroup) {
	DVBChannelFactory * self;
	GeeHashSet* _tmp0_;
	g_return_val_if_fail (devgroup != NULL, NULL);
	self = (DVBChannelFactory*) g_object_new (object_type, "device-group", devgroup, NULL);
	self->priv->active_players = (_tmp0_ = gee_hash_set_new (DVB_TYPE_PLAYER_THREAD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL), _g_object_unref0 (self->priv->active_players), _tmp0_);
	return self;
}


DVBChannelFactory* dvb_channel_factory_new (DVBDeviceGroup* devgroup) {
	return dvb_channel_factory_construct (DVB_TYPE_CHANNEL_FACTORY, devgroup);
}


void dvb_channel_factory_destroy (DVBChannelFactory* self) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_active_players);
		{
			{
				GeeIterator* _active_player_it;
				_active_player_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->active_players);
				while (TRUE) {
					DVBPlayerThread* active_player;
					if (!gee_iterator_next (_active_player_it)) {
						break;
					}
					active_player = (DVBPlayerThread*) gee_iterator_get (_active_player_it);
					dvb_player_thread_destroy (active_player, FALSE);
					_g_object_unref0 (active_player);
				}
				_g_object_unref0 (_active_player_it);
			}
			gee_abstract_collection_clear ((GeeAbstractCollection*) self->priv->active_players);
		}
		__finally28:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_active_players);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static char* bool_to_string (gboolean self) {
	char* result = NULL;
	if (self) {
		result = g_strdup ("true");
		return result;
	} else {
		result = g_strdup ("false");
		return result;
	}
}


DVBPlayerThread* dvb_channel_factory_watch_channel (DVBChannelFactory* self, DVBChannel* channel, GstElement* sink_element, gboolean force, DVBForcedStopNotify notify_func, void* notify_func_target) {
	DVBPlayerThread* result = NULL;
	GError * _inner_error_;
	gboolean create_new;
	DVBPlayerThread* player;
	DVBDevice* free_device;
	char* _tmp1_;
	GstElement* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (channel != NULL, NULL);
	g_return_val_if_fail (sink_element != NULL, NULL);
	_inner_error_ = NULL;
	g_debug ("ChannelFactory.vala:563: Watching channel %s (%u)", dvb_channel_get_Name (channel), dvb_channel_get_Sid (channel));
	create_new = TRUE;
	player = NULL;
	free_device = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_active_players);
		{
			{
				GeeIterator* _active_player_it;
				_active_player_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->active_players);
				while (TRUE) {
					DVBPlayerThread* active_player;
					if (!gee_iterator_next (_active_player_it)) {
						break;
					}
					active_player = (DVBPlayerThread*) gee_iterator_get (_active_player_it);
					{
						GeeIterator* _other_channel_it;
						_other_channel_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) dvb_player_thread_get_active_channels (active_player));
						while (TRUE) {
							DVBChannel* other_channel;
							if (!gee_iterator_next (_other_channel_it)) {
								break;
							}
							other_channel = (DVBChannel*) gee_iterator_get (_other_channel_it);
							if (dvb_channel_on_same_transport_stream (channel, other_channel)) {
								DVBPlayerThread* _tmp0_;
								create_new = FALSE;
								player = (_tmp0_ = _g_object_ref0 (active_player), _g_object_unref0 (player), _tmp0_);
								_g_object_unref0 (other_channel);
								break;
							}
							_g_object_unref0 (other_channel);
						}
						_g_object_unref0 (_other_channel_it);
					}
					_g_object_unref0 (active_player);
				}
				_g_object_unref0 (_active_player_it);
			}
		}
		__finally29:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_active_players);
		}
		if (_inner_error_ != NULL) {
			_g_object_unref0 (player);
			_g_object_unref0 (free_device);
			_gst_object_unref0 (sink_element);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	g_debug ("ChannelFactory.vala:580: Creating new PlayerThread: %s", _tmp1_ = bool_to_string (create_new));
	_g_free0 (_tmp1_);
	if (create_new) {
		DVBDevice* _tmp2_;
		gboolean _tmp3_ = FALSE;
		DVBPlayerThread* _tmp5_;
		dvb_device_group_stop_epg_scanner (self->priv->_device_group);
		free_device = (_tmp2_ = dvb_device_group_get_next_free_device (self->priv->_device_group), _g_object_unref0 (free_device), _tmp2_);
		if (free_device == NULL) {
			_tmp3_ = force;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			DVBDevice* _tmp4_;
			{
				g_static_rec_mutex_lock (&self->priv->__lock_active_players);
				{
					{
						GeeIterator* _active_player_it;
						_active_player_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->active_players);
						while (TRUE) {
							DVBPlayerThread* active_player;
							if (!gee_iterator_next (_active_player_it)) {
								break;
							}
							active_player = (DVBPlayerThread*) gee_iterator_get (_active_player_it);
							if (!dvb_player_thread_get_forced (active_player)) {
								dvb_player_thread_destroy (active_player, TRUE);
								_g_object_unref0 (active_player);
								break;
							} else {
								g_critical ("ChannelFactory.vala:594: No active players that are not forced");
							}
							_g_object_unref0 (active_player);
						}
						_g_object_unref0 (_active_player_it);
					}
				}
				__finally30:
				{
					g_static_rec_mutex_unlock (&self->priv->__lock_active_players);
				}
				if (_inner_error_ != NULL) {
					_g_object_unref0 (player);
					_g_object_unref0 (free_device);
					_gst_object_unref0 (sink_element);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			free_device = (_tmp4_ = dvb_device_group_get_next_free_device (self->priv->_device_group), _g_object_unref0 (free_device), _tmp4_);
		}
		if (free_device == NULL) {
			g_message ("ChannelFactory.vala:601: All devices are busy");
			result = NULL;
			_g_object_unref0 (player);
			_g_object_unref0 (free_device);
			_gst_object_unref0 (sink_element);
			return result;
		}
		player = (_tmp5_ = dvb_channel_factory_create_player (self, free_device), _g_object_unref0 (player), _tmp5_);
	}
	_tmp6_ = dvb_player_thread_get_element (player, channel, _gst_object_ref0 (sink_element), force, notify_func, notify_func_target);
	_gst_object_unref0 (_tmp6_);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_active_players);
		{
			gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->active_players, player);
		}
		__finally31:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_active_players);
		}
		if (_inner_error_ != NULL) {
			_g_object_unref0 (player);
			_g_object_unref0 (free_device);
			_gst_object_unref0 (sink_element);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = player;
	_g_object_unref0 (free_device);
	_gst_object_unref0 (sink_element);
	return result;
}


gboolean dvb_channel_factory_stop_channel (DVBChannelFactory* self, DVBChannel* channel, GstElement* sink) {
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean success;
	DVBPlayerThread* player;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (channel != NULL, FALSE);
	g_return_val_if_fail (sink != NULL, FALSE);
	_inner_error_ = NULL;
	g_debug ("ChannelFactory.vala:622: Stopping channel %s (%u)", dvb_channel_get_Name (channel), dvb_channel_get_Sid (channel));
	success = FALSE;
	player = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_active_players);
		{
			gboolean _tmp1_ = FALSE;
			{
				GeeIterator* _active_player_it;
				_active_player_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->active_players);
				while (TRUE) {
					DVBPlayerThread* active_player;
					if (!gee_iterator_next (_active_player_it)) {
						break;
					}
					active_player = (DVBPlayerThread*) gee_iterator_get (_active_player_it);
					if (gee_abstract_collection_contains ((GeeAbstractCollection*) dvb_player_thread_get_active_channels (active_player), channel)) {
						DVBPlayerThread* _tmp0_;
						success = dvb_player_thread_remove_channel (active_player, channel, sink);
						player = (_tmp0_ = _g_object_ref0 (active_player), _g_object_unref0 (player), _tmp0_);
						_g_object_unref0 (active_player);
						break;
					}
					_g_object_unref0 (active_player);
				}
				_g_object_unref0 (_active_player_it);
			}
			if (success) {
				_tmp1_ = gee_collection_get_size ((GeeCollection*) dvb_player_thread_get_active_channels (player)) == 0;
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->active_players, player);
			}
			if (gee_collection_get_size ((GeeCollection*) self->priv->active_players) == 0) {
				dvb_device_group_start_epg_scanner (self->priv->_device_group);
			}
		}
		__finally32:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_active_players);
		}
		if (_inner_error_ != NULL) {
			_g_object_unref0 (player);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = success;
	_g_object_unref0 (player);
	return result;
}


static DVBPlayerThread* dvb_channel_factory_real_create_player (DVBChannelFactory* self, DVBDevice* device) {
	DVBPlayerThread* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (device != NULL, NULL);
	result = dvb_player_thread_new (device, dvb_device_group_get_epgscanner (self->priv->_device_group));
	return result;
}


DVBPlayerThread* dvb_channel_factory_create_player (DVBChannelFactory* self, DVBDevice* device) {
	return DVB_CHANNEL_FACTORY_GET_CLASS (self)->create_player (self, device);
}


DVBDeviceGroup* dvb_channel_factory_get_device_group (DVBChannelFactory* self) {
	DVBDeviceGroup* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_device_group;
	return result;
}


static void dvb_channel_factory_set_device_group (DVBChannelFactory* self, DVBDeviceGroup* value) {
	g_return_if_fail (self != NULL);
	self->priv->_device_group = value;
	g_object_notify ((GObject *) self, "device-group");
}


static void dvb_channel_factory_class_init (DVBChannelFactoryClass * klass) {
	dvb_channel_factory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBChannelFactoryPrivate));
	DVB_CHANNEL_FACTORY_CLASS (klass)->create_player = dvb_channel_factory_real_create_player;
	G_OBJECT_CLASS (klass)->get_property = dvb_channel_factory_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_channel_factory_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_channel_factory_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_FACTORY_DEVICE_GROUP, g_param_spec_object ("device-group", "device-group", "device-group", DVB_TYPE_DEVICE_GROUP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void dvb_channel_factory_instance_init (DVBChannelFactory * self) {
	self->priv = DVB_CHANNEL_FACTORY_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_active_players);
}


static void dvb_channel_factory_finalize (GObject* obj) {
	DVBChannelFactory * self;
	self = DVB_CHANNEL_FACTORY (obj);
	g_static_rec_mutex_free (&self->priv->__lock_active_players);
	_g_object_unref0 (self->priv->active_players);
	G_OBJECT_CLASS (dvb_channel_factory_parent_class)->finalize (obj);
}


GType dvb_channel_factory_get_type (void) {
	static volatile gsize dvb_channel_factory_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_channel_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBChannelFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_channel_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBChannelFactory), 0, (GInstanceInitFunc) dvb_channel_factory_instance_init, NULL };
		GType dvb_channel_factory_type_id;
		dvb_channel_factory_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBChannelFactory", &g_define_type_info, 0);
		g_once_init_leave (&dvb_channel_factory_type_id__volatile, dvb_channel_factory_type_id);
	}
	return dvb_channel_factory_type_id__volatile;
}


static void dvb_channel_factory_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBChannelFactory * self;
	self = DVB_CHANNEL_FACTORY (object);
	switch (property_id) {
		case DVB_CHANNEL_FACTORY_DEVICE_GROUP:
		g_value_set_object (value, dvb_channel_factory_get_device_group (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_channel_factory_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBChannelFactory * self;
	self = DVB_CHANNEL_FACTORY (object);
	switch (property_id) {
		case DVB_CHANNEL_FACTORY_DEVICE_GROUP:
		dvb_channel_factory_set_device_group (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__BOXED callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), data2);
}



