/* ChannelFactory.c generated by valac 0.11.3, the Vala compiler
 * generated from ChannelFactory.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_TYPE_PLAYER_THREAD (dvb_player_thread_get_type ())
#define DVB_PLAYER_THREAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_PLAYER_THREAD, DVBPlayerThread))
#define DVB_PLAYER_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_PLAYER_THREAD, DVBPlayerThreadClass))
#define DVB_IS_PLAYER_THREAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_PLAYER_THREAD))
#define DVB_IS_PLAYER_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_PLAYER_THREAD))
#define DVB_PLAYER_THREAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_PLAYER_THREAD, DVBPlayerThreadClass))

typedef struct _DVBPlayerThread DVBPlayerThread;
typedef struct _DVBPlayerThreadClass DVBPlayerThreadClass;
typedef struct _DVBPlayerThreadPrivate DVBPlayerThreadPrivate;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;

#define DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS (dvb_player_thread_channel_elements_get_type ())
#define DVB_PLAYER_THREAD_CHANNEL_ELEMENTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS, DVBPlayerThreadChannelElements))
#define DVB_PLAYER_THREAD_CHANNEL_ELEMENTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS, DVBPlayerThreadChannelElementsClass))
#define DVB_PLAYER_THREAD_IS_CHANNEL_ELEMENTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS))
#define DVB_PLAYER_THREAD_IS_CHANNEL_ELEMENTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS))
#define DVB_PLAYER_THREAD_CHANNEL_ELEMENTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS, DVBPlayerThreadChannelElementsClass))

typedef struct _DVBPlayerThreadChannelElements DVBPlayerThreadChannelElements;
typedef struct _DVBPlayerThreadChannelElementsClass DVBPlayerThreadChannelElementsClass;

#define DVB_TYPE_EPG_SCANNER (dvb_epg_scanner_get_type ())
#define DVB_EPG_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EPG_SCANNER, DVBEPGScanner))
#define DVB_EPG_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EPG_SCANNER, DVBEPGScannerClass))
#define DVB_IS_EPG_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EPG_SCANNER))
#define DVB_IS_EPG_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EPG_SCANNER))
#define DVB_EPG_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EPG_SCANNER, DVBEPGScannerClass))

typedef struct _DVBEPGScanner DVBEPGScanner;
typedef struct _DVBEPGScannerClass DVBEPGScannerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _dvb_player_thread_channel_elements_unref0(var) ((var == NULL) ? NULL : (var = (dvb_player_thread_channel_elements_unref (var), NULL)))
typedef struct _DVBPlayerThreadChannelElementsPrivate DVBPlayerThreadChannelElementsPrivate;
#define _gst_iterator_free0(var) ((var == NULL) ? NULL : (var = (gst_iterator_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))
typedef struct _DVBPlayerThreadParamSpecChannelElements DVBPlayerThreadParamSpecChannelElements;

#define DVB_TYPE_CHANNEL_FACTORY (dvb_channel_factory_get_type ())
#define DVB_CHANNEL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactory))
#define DVB_CHANNEL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactoryClass))
#define DVB_IS_CHANNEL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_FACTORY))
#define DVB_IS_CHANNEL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_FACTORY))
#define DVB_CHANNEL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactoryClass))

typedef struct _DVBChannelFactory DVBChannelFactory;
typedef struct _DVBChannelFactoryClass DVBChannelFactoryClass;
typedef struct _DVBChannelFactoryPrivate DVBChannelFactoryPrivate;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;

typedef void (*DVBForcedStopNotify) (DVBChannel* channel, void* user_data);
struct _DVBPlayerThread {
	GObject parent_instance;
	DVBPlayerThreadPrivate * priv;
};

struct _DVBPlayerThreadClass {
	GObjectClass parent_class;
	void (*destroy) (DVBPlayerThread* self, gboolean forced);
};

struct _DVBPlayerThreadPrivate {
	GeeHashSet* _active_channels;
	DVBDevice* _device;
	GstElement* pipeline;
	GStaticRecMutex __lock_pipeline;
	GeeHashMap* elements_map;
	GStaticRecMutex __lock_elements_map;
	DVBEPGScanner* epgscanner;
	GstElement* dvbbasebin;
	gboolean destroyed;
	GStaticRecMutex __lock_destroyed;
};

struct _DVBPlayerThreadChannelElements {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBPlayerThreadChannelElementsPrivate * priv;
	guint sid;
	GeeArrayList* sinks;
	GstElement* tee;
	gboolean forced;
	DVBForcedStopNotify notify_func;
	gpointer notify_func_target;
	GDestroyNotify notify_func_target_destroy_notify;
};

struct _DVBPlayerThreadChannelElementsClass {
	GTypeClass parent_class;
	void (*finalize) (DVBPlayerThreadChannelElements *self);
};

struct _DVBPlayerThreadParamSpecChannelElements {
	GParamSpec parent_instance;
};

struct _DVBChannelFactory {
	GObject parent_instance;
	DVBChannelFactoryPrivate * priv;
};

struct _DVBChannelFactoryClass {
	GObjectClass parent_class;
	DVBPlayerThread* (*create_player) (DVBChannelFactory* self, DVBDevice* device);
};

struct _DVBChannelFactoryPrivate {
	DVBDeviceGroup* _device_group;
	GeeHashSet* active_players;
	GStaticRecMutex __lock_active_players;
};


static gpointer dvb_player_thread_parent_class = NULL;
static gpointer dvb_player_thread_channel_elements_parent_class = NULL;
static gpointer dvb_channel_factory_parent_class = NULL;

GType dvb_channel_get_type (void) G_GNUC_CONST;
GType dvb_player_thread_get_type (void) G_GNUC_CONST;
GType dvb_device_get_type (void) G_GNUC_CONST;
static gpointer dvb_player_thread_channel_elements_ref (gpointer instance);
static void dvb_player_thread_channel_elements_unref (gpointer instance);
static GParamSpec* dvb_player_thread_param_spec_channel_elements (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void dvb_player_thread_value_set_channel_elements (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void dvb_player_thread_value_take_channel_elements (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer dvb_player_thread_value_get_channel_elements (const GValue* value) G_GNUC_UNUSED;
static GType dvb_player_thread_channel_elements_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType dvb_epg_scanner_get_type (void) G_GNUC_CONST;
#define DVB_PLAYER_THREAD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_PLAYER_THREAD, DVBPlayerThreadPrivate))
enum  {
	DVB_PLAYER_THREAD_DUMMY_PROPERTY,
	DVB_PLAYER_THREAD_ACTIVE_CHANNELS,
	DVB_PLAYER_THREAD_DEVICE,
	DVB_PLAYER_THREAD_FORCED
};
DVBPlayerThread* dvb_player_thread_new (DVBDevice* device, DVBEPGScanner* epgscanner);
DVBPlayerThread* dvb_player_thread_construct (GType object_type, DVBDevice* device, DVBEPGScanner* epgscanner);
GstElement* dvb_player_thread_get_pipeline (DVBPlayerThread* self);
GstElement* dvb_player_thread_get_dvbbasebin (DVBPlayerThread* self);
GstElement* dvb_player_thread_get_element (DVBPlayerThread* self, DVBChannel* channel, GstElement* sink_element, gboolean forced, DVBForcedStopNotify notify_func, void* notify_func_target);
guint dvb_channel_get_Sid (DVBChannel* self);
static void dvb_player_thread_bus_watch_func (DVBPlayerThread* self, GstBus* bus, GstMessage* message);
static void _dvb_player_thread_bus_watch_func_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self);
static void dvb_player_thread_on_dvbbasebin_pad_added (DVBPlayerThread* self, GstElement* elem, GstPad* pad);
static void _dvb_player_thread_on_dvbbasebin_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self);
void dvb_channel_setup_dvb_source (DVBChannel* self, GstElement* source);
DVBDevice* dvb_player_thread_get_device (DVBPlayerThread* self);
guint dvb_device_get_Adapter (DVBDevice* self);
guint dvb_device_get_Frontend (DVBDevice* self);
static gboolean dvb_player_thread_add_element (DVBPlayerThread* self, GstElement* elem);
static GstElement* dvb_player_thread_add_sink_bin (DVBPlayerThread* self, GstElement* sink_element);
GeeHashSet* dvb_player_thread_get_active_channels (DVBPlayerThread* self);
static DVBPlayerThreadChannelElements* dvb_player_thread_channel_elements_new (void);
static DVBPlayerThreadChannelElements* dvb_player_thread_channel_elements_construct (GType object_type);
static gint dvb_player_thread_find_element (void* av, void* bv);
GstElement* dvb_player_thread_get_sink_bin (DVBPlayerThread* self, guint sid, GstElement* sink);
static gint _dvb_player_thread_find_element_gcompare_func (gconstpointer a, gconstpointer b);
gboolean dvb_player_thread_remove_channel (DVBPlayerThread* self, DVBChannel* channel, GstElement* sink);
static gboolean dvb_player_thread_set_playing_or_destroy (DVBPlayerThread* self);
static void dvb_player_thread_remove_sink_bin (DVBPlayerThread* self, guint channel_sid, GstElement* sink);
void dvb_player_thread_destroy (DVBPlayerThread* self, gboolean forced);
static void dvb_player_thread_real_destroy (DVBPlayerThread* self, gboolean forced);
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
DVBChannelList* dvb_device_get_Channels (DVBDevice* self);
DVBChannel* dvb_channel_list_get_channel (DVBChannelList* self, guint sid);
void dvb_epg_scanner_on_eit_structure (DVBEPGScanner* self, const GstStructure* structure);
static void dvb_player_thread_set_active_channels (DVBPlayerThread* self, GeeHashSet* value);
static void dvb_player_thread_set_device (DVBPlayerThread* self, DVBDevice* value);
gboolean dvb_player_thread_get_forced (DVBPlayerThread* self);
static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * dvb_player_thread_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
enum  {
	DVB_PLAYER_THREAD_CHANNEL_ELEMENTS_DUMMY_PROPERTY
};
static void dvb_player_thread_channel_elements_finalize (DVBPlayerThreadChannelElements* obj);
static void dvb_player_thread_finalize (GObject* obj);
static void _vala_dvb_player_thread_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_player_thread_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType dvb_channel_factory_get_type (void) G_GNUC_CONST;
GType dvb_device_group_get_type (void) G_GNUC_CONST;
#define DVB_CHANNEL_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactoryPrivate))
enum  {
	DVB_CHANNEL_FACTORY_DUMMY_PROPERTY,
	DVB_CHANNEL_FACTORY_DEVICE_GROUP
};
DVBChannelFactory* dvb_channel_factory_new (DVBDeviceGroup* devgroup);
DVBChannelFactory* dvb_channel_factory_construct (GType object_type, DVBDeviceGroup* devgroup);
void dvb_channel_factory_destroy (DVBChannelFactory* self);
DVBPlayerThread* dvb_channel_factory_watch_channel (DVBChannelFactory* self, DVBChannel* channel, GstElement* sink_element, gboolean force, DVBForcedStopNotify notify_func, void* notify_func_target);
const gchar* dvb_channel_get_Name (DVBChannel* self);
gboolean dvb_channel_on_same_transport_stream (DVBChannel* self, DVBChannel* channel);
DVBDeviceGroup* dvb_channel_factory_get_device_group (DVBChannelFactory* self);
void dvb_device_group_stop_epg_scanner (DVBDeviceGroup* self);
DVBDevice* dvb_device_group_get_next_free_device (DVBDeviceGroup* self);
DVBPlayerThread* dvb_channel_factory_create_player (DVBChannelFactory* self, DVBDevice* device);
gboolean dvb_channel_factory_stop_channel (DVBChannelFactory* self, DVBChannel* channel, GstElement* sink);
void dvb_device_group_start_epg_scanner (DVBDeviceGroup* self);
static DVBPlayerThread* dvb_channel_factory_real_create_player (DVBChannelFactory* self, DVBDevice* device);
DVBEPGScanner* dvb_device_group_get_epgscanner (DVBDeviceGroup* self);
static void dvb_channel_factory_set_device_group (DVBChannelFactory* self, DVBDeviceGroup* value);
static void dvb_channel_factory_finalize (GObject* obj);
static void _vala_dvb_channel_factory_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_channel_factory_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
         * @device: The device to use
         * @epgscanner: #EPGScanner to forward EIT to
         */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


DVBPlayerThread* dvb_player_thread_construct (GType object_type, DVBDevice* device, DVBEPGScanner* epgscanner) {
	DVBPlayerThread * self = NULL;
	DVBEPGScanner* _tmp0_;
	DVBEPGScanner* _tmp1_;
	g_return_val_if_fail (device != NULL, NULL);
	self = (DVBPlayerThread*) g_object_new (object_type, "device", device, NULL);
	_tmp0_ = _g_object_ref0 (epgscanner);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->epgscanner);
	self->priv->epgscanner = _tmp1_;
	return self;
}


DVBPlayerThread* dvb_player_thread_new (DVBDevice* device, DVBEPGScanner* epgscanner) {
	return dvb_player_thread_construct (DVB_TYPE_PLAYER_THREAD, device, epgscanner);
}


static gpointer _gst_object_ref0 (gpointer self) {
	return self ? gst_object_ref (self) : NULL;
}


GstElement* dvb_player_thread_get_pipeline (DVBPlayerThread* self) {
	GstElement* result = NULL;
	GstElement* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _gst_object_ref0 (self->priv->pipeline);
	result = _tmp0_;
	return result;
}


GstElement* dvb_player_thread_get_dvbbasebin (DVBPlayerThread* self) {
	GstElement* result = NULL;
	GstElement* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _gst_object_ref0 (self->priv->dvbbasebin);
	result = _tmp0_;
	return result;
}


/**
         * @returns: GstBin containing queue and @sink_element 
         *
         * Start watching @channel and link it with @sink_element
         */
static void _dvb_player_thread_bus_watch_func_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self) {
	dvb_player_thread_bus_watch_func (self, _sender, message);
}


static void _dvb_player_thread_on_dvbbasebin_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self) {
	dvb_player_thread_on_dvbbasebin_pad_added (self, _sender, pad);
}


GstElement* dvb_player_thread_get_element (DVBPlayerThread* self, DVBChannel* channel, GstElement* sink_element, gboolean forced, DVBForcedStopNotify notify_func, void* notify_func_target) {
	GstElement* result = NULL;
	guint _tmp0_;
	guint channel_sid;
	gchar* _tmp1_ = NULL;
	gchar* channel_sid_str;
	gboolean create_channel = FALSE;
	GstElement* bin;
	GstElement* tee;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (channel != NULL, NULL);
	g_return_val_if_fail (sink_element != NULL, NULL);
	_tmp0_ = dvb_channel_get_Sid (channel);
	channel_sid = _tmp0_;
	_tmp1_ = g_strdup_printf ("%u", channel_sid);
	channel_sid_str = _tmp1_;
	bin = NULL;
	tee = NULL;
	{
		GstElement* _tmp42_;
		g_static_rec_mutex_lock (&self->priv->__lock_pipeline);
		if (self->priv->pipeline == NULL) {
			GstPipeline* _tmp2_ = NULL;
			GstElement* _tmp3_;
			GstBus* _tmp4_ = NULL;
			GstBus* bus;
			GstElement* _tmp5_ = NULL;
			GstElement* _tmp6_;
			guint _tmp7_;
			guint _tmp8_;
			GstElement* _tmp9_;
			GstElement* _tmp10_ = NULL;
			GstElement* _tmp11_;
			GstElement* _tmp12_;
			GstElement* _tmp13_ = NULL;
			GstElement* _tmp14_;
			gboolean _tmp15_;
			g_debug ("ChannelFactory.vala:115: Creating new pipeline");
			_tmp2_ = (GstPipeline*) gst_pipeline_new ("recording");
			_tmp3_ = (GstElement*) _tmp2_;
			_gst_object_unref0 (self->priv->pipeline);
			self->priv->pipeline = _tmp3_;
			_tmp4_ = gst_element_get_bus (self->priv->pipeline);
			bus = _tmp4_;
			gst_bus_add_signal_watch (bus);
			g_signal_connect_object (bus, "message", (GCallback) _dvb_player_thread_bus_watch_func_gst_bus_message, self, 0);
			_tmp5_ = gst_element_factory_make ("dvbbasebin", NULL);
			_tmp6_ = _tmp5_;
			_gst_object_unref0 (self->priv->dvbbasebin);
			self->priv->dvbbasebin = _tmp6_;
			if (self->priv->dvbbasebin == NULL) {
				g_critical ("ChannelFactory.vala:126: Could not create dvbbasebin element");
				result = NULL;
				_gst_object_unref0 (bus);
				g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
				_gst_object_unref0 (tee);
				_gst_object_unref0 (bin);
				_g_free0 (channel_sid_str);
				_gst_object_unref0 (sink_element);
				return result;
			}
			g_signal_connect_object (self->priv->dvbbasebin, "pad-added", (GCallback) _dvb_player_thread_on_dvbbasebin_pad_added_gst_element_pad_added, self, 0);
			dvb_channel_setup_dvb_source (channel, self->priv->dvbbasebin);
			g_object_set ((GObject*) self->priv->dvbbasebin, "program-numbers", channel_sid_str, NULL);
			_tmp7_ = dvb_device_get_Adapter (self->priv->_device);
			g_object_set ((GObject*) self->priv->dvbbasebin, "adapter", _tmp7_, NULL);
			_tmp8_ = dvb_device_get_Frontend (self->priv->_device);
			g_object_set ((GObject*) self->priv->dvbbasebin, "frontend", _tmp8_, NULL);
			_tmp9_ = _gst_object_ref0 (self->priv->dvbbasebin);
			gst_bin_add (GST_BIN (self->priv->pipeline), _tmp9_);
			_tmp10_ = gst_element_factory_make ("tee", NULL);
			_tmp11_ = _tmp10_;
			_gst_object_unref0 (tee);
			tee = _tmp11_;
			_tmp12_ = _gst_object_ref0 (tee);
			dvb_player_thread_add_element (self, _tmp12_);
			_tmp13_ = dvb_player_thread_add_sink_bin (self, sink_element);
			_tmp14_ = _tmp13_;
			_gst_object_unref0 (bin);
			bin = _tmp14_;
			_tmp15_ = gst_element_link (tee, bin);
			if (!_tmp15_) {
				g_critical ("ChannelFactory.vala:145: Could not link tee and bin");
				result = NULL;
				_gst_object_unref0 (bus);
				g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
				_gst_object_unref0 (tee);
				_gst_object_unref0 (bin);
				_g_free0 (channel_sid_str);
				_gst_object_unref0 (sink_element);
				return result;
			}
			create_channel = TRUE;
			_gst_object_unref0 (bus);
		} else {
			gboolean _tmp16_;
			g_debug ("ChannelFactory.vala:153: Reusing existing pipeline");
			if (self->priv->dvbbasebin == NULL) {
				g_critical ("ChannelFactory.vala:155: No dvbbasebin element");
				result = NULL;
				g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
				_gst_object_unref0 (tee);
				_gst_object_unref0 (bin);
				_g_free0 (channel_sid_str);
				_gst_object_unref0 (sink_element);
				return result;
			}
			gst_element_set_state (self->priv->pipeline, GST_STATE_PAUSED);
			_tmp16_ = gee_abstract_collection_contains ((GeeAbstractCollection*) self->priv->_active_channels, channel);
			if (!_tmp16_) {
				GstElement* _tmp17_ = NULL;
				GstElement* _tmp18_;
				GstElement* _tmp19_;
				GstElement* _tmp20_ = NULL;
				GstElement* _tmp21_;
				gboolean _tmp22_;
				gchar* programs;
				gchar* _tmp23_ = NULL;
				gchar* new_programs;
				_tmp17_ = gst_element_factory_make ("tee", NULL);
				_tmp18_ = _tmp17_;
				_gst_object_unref0 (tee);
				tee = _tmp18_;
				_tmp19_ = _gst_object_ref0 (tee);
				dvb_player_thread_add_element (self, _tmp19_);
				_tmp20_ = dvb_player_thread_add_sink_bin (self, sink_element);
				_tmp21_ = _tmp20_;
				_gst_object_unref0 (bin);
				bin = _tmp21_;
				_tmp22_ = gst_element_link (tee, bin);
				if (!_tmp22_) {
					g_critical ("ChannelFactory.vala:169: Could not link tee and bin");
					result = NULL;
					g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
					_gst_object_unref0 (tee);
					_gst_object_unref0 (bin);
					_g_free0 (channel_sid_str);
					_gst_object_unref0 (sink_element);
					return result;
				}
				programs = NULL;
				g_object_get ((GObject*) self->priv->dvbbasebin, "program-numbers", &programs, NULL);
				_tmp23_ = g_strdup_printf ("%s:%s", programs, channel_sid_str);
				new_programs = _tmp23_;
				g_debug ("ChannelFactory.vala:178: Changing program-numbers from %s to %s", programs, new_programs);
				g_object_set ((GObject*) self->priv->dvbbasebin, "program-numbers", new_programs, NULL);
				create_channel = TRUE;
				_g_free0 (new_programs);
				_g_free0 (programs);
			} else {
				DVBPlayerThreadChannelElements* c_element;
				c_element = NULL;
				{
					gpointer _tmp24_ = NULL;
					DVBPlayerThreadChannelElements* _tmp25_;
					GstElement* _tmp26_;
					GstElement* _tmp27_;
					GstElement* _tmp28_ = NULL;
					GstElement* _tmp29_;
					gchar* _tmp30_ = NULL;
					gchar* _tmp31_;
					gchar* _tmp32_ = NULL;
					gchar* _tmp33_;
					gboolean _tmp34_;
					g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
					_tmp24_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->elements_map, GUINT_TO_POINTER (channel_sid));
					_tmp25_ = (DVBPlayerThreadChannelElements*) _tmp24_;
					_dvb_player_thread_channel_elements_unref0 (c_element);
					c_element = _tmp25_;
					_tmp26_ = _gst_object_ref0 (c_element->tee);
					_tmp27_ = _tmp26_;
					_gst_object_unref0 (tee);
					tee = _tmp27_;
					_tmp28_ = dvb_player_thread_add_sink_bin (self, sink_element);
					_tmp29_ = _tmp28_;
					_gst_object_unref0 (bin);
					bin = _tmp29_;
					_tmp30_ = gst_object_get_name ((GstObject*) tee);
					_tmp31_ = _tmp30_;
					_tmp32_ = gst_object_get_name ((GstObject*) bin);
					_tmp33_ = _tmp32_;
					g_debug ("ChannelFactory.vala:193: Linking %s with %s", _tmp31_, _tmp33_);
					_g_free0 (_tmp33_);
					_g_free0 (_tmp31_);
					_tmp34_ = gst_element_link (tee, bin);
					if (!_tmp34_) {
						g_critical ("ChannelFactory.vala:195: Could not link tee and bin");
						result = NULL;
						g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
						_dvb_player_thread_channel_elements_unref0 (c_element);
						g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
						_gst_object_unref0 (tee);
						_gst_object_unref0 (bin);
						_g_free0 (channel_sid_str);
						_gst_object_unref0 (sink_element);
						return result;
					}
					gee_abstract_collection_add ((GeeAbstractCollection*) c_element->sinks, bin);
					__finally15:
					g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
					if (_inner_error_ != NULL) {
						_dvb_player_thread_channel_elements_unref0 (c_element);
						_dvb_player_thread_channel_elements_unref0 (c_element);
						g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
						_gst_object_unref0 (tee);
						_gst_object_unref0 (bin);
						_g_free0 (channel_sid_str);
						_gst_object_unref0 (sink_element);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				create_channel = FALSE;
				_dvb_player_thread_channel_elements_unref0 (c_element);
			}
		}
		if (create_channel) {
			DVBPlayerThreadChannelElements* _tmp35_ = NULL;
			DVBPlayerThreadChannelElements* celems;
			GeeArrayList* _tmp36_ = NULL;
			GeeArrayList* _tmp37_;
			GstElement* _tmp38_;
			GstElement* _tmp39_;
			DVBForcedStopNotify _tmp40_;
			DVBForcedStopNotify _tmp41_;
			_tmp35_ = dvb_player_thread_channel_elements_new ();
			celems = _tmp35_;
			celems->sid = channel_sid;
			_tmp36_ = gee_array_list_new (GST_TYPE_ELEMENT, (GBoxedCopyFunc) gst_object_ref, gst_object_unref, NULL);
			_tmp37_ = _tmp36_;
			_g_object_unref0 (celems->sinks);
			celems->sinks = _tmp37_;
			gee_abstract_collection_add ((GeeAbstractCollection*) celems->sinks, bin);
			_tmp38_ = _gst_object_ref0 (tee);
			_tmp39_ = _tmp38_;
			_gst_object_unref0 (celems->tee);
			celems->tee = _tmp39_;
			celems->forced = forced;
			_tmp40_ = notify_func;
			_tmp41_ = _tmp40_;
			(celems->notify_func_target_destroy_notify == NULL) ? NULL : (celems->notify_func_target_destroy_notify (celems->notify_func_target), NULL);
			celems->notify_func = NULL;
			celems->notify_func_target = NULL;
			celems->notify_func_target_destroy_notify = NULL;
			celems->notify_func_target = notify_func_target;
			celems->notify_func_target_destroy_notify = NULL;
			celems->notify_func = _tmp41_;
			{
				g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
				gee_abstract_map_set ((GeeAbstractMap*) self->priv->elements_map, GUINT_TO_POINTER (channel_sid), celems);
				__finally16:
				g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
				if (_inner_error_ != NULL) {
					_dvb_player_thread_channel_elements_unref0 (celems);
					_dvb_player_thread_channel_elements_unref0 (celems);
					g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
					_gst_object_unref0 (tee);
					_gst_object_unref0 (bin);
					_g_free0 (channel_sid_str);
					_gst_object_unref0 (sink_element);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->_active_channels, channel);
			_dvb_player_thread_channel_elements_unref0 (celems);
		}
		_tmp42_ = _gst_object_ref0 (bin);
		result = _tmp42_;
		g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
		_gst_object_unref0 (tee);
		_gst_object_unref0 (bin);
		_g_free0 (channel_sid_str);
		_gst_object_unref0 (sink_element);
		return result;
		__finally14:
		g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
		_gst_object_unref0 (tee);
		_gst_object_unref0 (bin);
		_g_free0 (channel_sid_str);
		_gst_object_unref0 (sink_element);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_gst_object_unref0 (tee);
	_gst_object_unref0 (bin);
	_g_free0 (channel_sid_str);
	_gst_object_unref0 (sink_element);
}


static GstElement* dvb_player_thread_add_sink_bin (DVBPlayerThread* self, GstElement* sink_element) {
	GstElement* result = NULL;
	GstElement* _tmp0_ = NULL;
	GstElement* queue;
	GstBin* _tmp1_ = NULL;
	GstElement* bin;
	GstElement* _tmp2_;
	GstElement* _tmp3_;
	gboolean _tmp4_;
	GstPad* _tmp9_ = NULL;
	GstPad* pad;
	GstGhostPad* _tmp10_ = NULL;
	GstGhostPad* ghost;
	GstPad* _tmp11_;
	GstElement* _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sink_element != NULL, NULL);
	_tmp0_ = gst_element_factory_make ("queue", NULL);
	queue = _tmp0_;
	g_object_set ((GObject*) queue, "max-size-buffers", 0, NULL);
	_tmp1_ = (GstBin*) gst_bin_new (NULL);
	bin = (GstElement*) _tmp1_;
	_tmp2_ = _gst_object_ref0 (queue);
	_tmp3_ = _gst_object_ref0 (sink_element);
	gst_bin_add_many (GST_BIN (bin), _tmp2_, _tmp3_, NULL);
	_tmp4_ = gst_element_link (queue, sink_element);
	if (!_tmp4_) {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp5_ = gst_object_get_name ((GstObject*) queue);
		_tmp6_ = _tmp5_;
		_tmp7_ = gst_object_get_name ((GstObject*) sink_element);
		_tmp8_ = _tmp7_;
		g_critical ("ChannelFactory.vala:231: Could not link elements %s and %s", _tmp6_, _tmp8_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
	}
	_tmp9_ = gst_element_get_static_pad (queue, "sink");
	pad = _tmp9_;
	_tmp10_ = (GstGhostPad*) gst_ghost_pad_new ("sink", pad);
	ghost = _tmp10_;
	gst_pad_set_active ((GstPad*) ghost, TRUE);
	_tmp11_ = _gst_object_ref0 ((GstPad*) ghost);
	gst_element_add_pad (bin, _tmp11_);
	_tmp12_ = _gst_object_ref0 (bin);
	dvb_player_thread_add_element (self, _tmp12_);
	result = bin;
	_gst_object_unref0 (ghost);
	_gst_object_unref0 (pad);
	_gst_object_unref0 (queue);
	return result;
}


static gint dvb_player_thread_find_element (void* av, void* bv) {
	gint result = 0;
	GstElement* _tmp0_;
	GstElement* a;
	GstElement* _tmp1_;
	GstElement* b;
	_tmp0_ = _gst_object_ref0 (GST_ELEMENT (av));
	a = _tmp0_;
	_tmp1_ = _gst_object_ref0 (GST_ELEMENT (bv));
	b = _tmp1_;
	if (a == b) {
		result = 0;
		_gst_object_unref0 (b);
		_gst_object_unref0 (a);
		return result;
	} else {
		result = 1;
		_gst_object_unref0 (b);
		_gst_object_unref0 (a);
		return result;
	}
	_gst_object_unref0 (b);
	_gst_object_unref0 (a);
}


/**
         * @sid: Channel SID
         * @sink: The sink element that the bin should contain
         * @returns: GstBin containing queue and sink for the specified channel
         */
static gint _dvb_player_thread_find_element_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = dvb_player_thread_find_element (a, b);
	return result;
}


GstElement* dvb_player_thread_get_sink_bin (DVBPlayerThread* self, guint sid, GstElement* sink) {
	GstElement* result = NULL;
	GstElement* _result_;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sink != NULL, NULL);
	_result_ = NULL;
	_tmp0_ = gst_object_get_name ((GstObject*) sink);
	_tmp1_ = _tmp0_;
	g_debug ("ChannelFactory.vala:261: Searching for sink %s (%p) of channel %u", _tmp1_, sink, sid);
	_g_free0 (_tmp1_);
	{
		gpointer _tmp2_ = NULL;
		DVBPlayerThreadChannelElements* celems;
		g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
		_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->elements_map, GUINT_TO_POINTER (sid));
		celems = (DVBPlayerThreadChannelElements*) _tmp2_;
		if (celems != NULL) {
			{
				GeeArrayList* _tmp3_;
				GeeArrayList* _sink_bin_list;
				gint _tmp4_;
				gint _sink_bin_size;
				gint _sink_bin_index;
				_tmp3_ = _g_object_ref0 (celems->sinks);
				_sink_bin_list = _tmp3_;
				_tmp4_ = gee_collection_get_size ((GeeCollection*) _sink_bin_list);
				_sink_bin_size = _tmp4_;
				_sink_bin_index = -1;
				while (TRUE) {
					gpointer _tmp5_ = NULL;
					GstElement* sink_bin;
					GstIterator* _tmp6_ = NULL;
					GstIterator* it;
					gpointer _tmp7_ = NULL;
					GstElement* element;
					_sink_bin_index = _sink_bin_index + 1;
					if (!(_sink_bin_index < _sink_bin_size)) {
						break;
					}
					_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _sink_bin_list, _sink_bin_index);
					sink_bin = (GstElement*) _tmp5_;
					_tmp6_ = gst_bin_iterate_elements (GST_BIN (sink_bin));
					it = _tmp6_;
					_tmp7_ = gst_iterator_find_custom (it, _dvb_player_thread_find_element_gcompare_func, sink);
					element = (GstElement*) _tmp7_;
					if (element != NULL) {
						GstElement* _tmp8_;
						GstElement* _tmp9_;
						_tmp8_ = _gst_object_ref0 (sink_bin);
						_tmp9_ = _tmp8_;
						_gst_object_unref0 (_result_);
						_result_ = _tmp9_;
						_gst_object_unref0 (element);
						_gst_iterator_free0 (it);
						_gst_object_unref0 (sink_bin);
						break;
					}
					_gst_object_unref0 (element);
					_gst_iterator_free0 (it);
					_gst_object_unref0 (sink_bin);
				}
				_g_object_unref0 (_sink_bin_list);
			}
		} else {
			g_warning ("ChannelFactory.vala:274: Could not find any sinks of channel %u", sid);
		}
		_dvb_player_thread_channel_elements_unref0 (celems);
		__finally17:
		g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
		if (_inner_error_ != NULL) {
			_gst_object_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (_result_ == NULL) {
		g_debug ("ChannelFactory.vala:278: Found NO sink");
	} else {
		g_debug ("ChannelFactory.vala:280: Found sink");
	}
	result = _result_;
	return result;
}


/**
         * Stop watching @channel
         */
gboolean dvb_player_thread_remove_channel (DVBPlayerThread* self, DVBChannel* channel, GstElement* sink) {
	gboolean result = FALSE;
	guint _tmp0_;
	guint channel_sid;
	gboolean _tmp1_;
	DVBPlayerThreadChannelElements* celements;
	gboolean stop_channel = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (channel != NULL, FALSE);
	g_return_val_if_fail (sink != NULL, FALSE);
	_tmp0_ = dvb_channel_get_Sid (channel);
	channel_sid = _tmp0_;
	_tmp1_ = gee_abstract_collection_contains ((GeeAbstractCollection*) self->priv->_active_channels, channel);
	if (!_tmp1_) {
		g_critical ("ChannelFactory.vala:291: Could not find channel with SID %u", channel_sid);
		result = FALSE;
		return result;
	}
	celements = NULL;
	{
		gpointer _tmp2_ = NULL;
		DVBPlayerThreadChannelElements* _tmp3_;
		gint _tmp4_;
		g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
		_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->elements_map, GUINT_TO_POINTER (channel_sid));
		_tmp3_ = (DVBPlayerThreadChannelElements*) _tmp2_;
		_dvb_player_thread_channel_elements_unref0 (celements);
		celements = _tmp3_;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) celements->sinks);
		stop_channel = _tmp4_ == 1;
		__finally18:
		g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
		if (_inner_error_ != NULL) {
			_dvb_player_thread_channel_elements_unref0 (celements);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	{
		gint _tmp5_;
		g_static_rec_mutex_lock (&self->priv->__lock_pipeline);
		_tmp5_ = gee_collection_get_size ((GeeCollection*) self->priv->_active_channels);
		if (_tmp5_ > 1) {
			if (stop_channel) {
				gchar* _tmp6_ = NULL;
				gchar* channel_sid_string;
				gchar* programs;
				gchar** _tmp7_;
				gchar** _tmp8_ = NULL;
				gint programs_arr_length1;
				gint _programs_arr_size_;
				gchar** _tmp9_;
				gchar** programs_arr;
				GeeArrayList* _tmp10_ = NULL;
				GeeArrayList* new_programs_list;
				gpointer _tmp12_ = NULL;
				gchar* _tmp13_;
				GString* _tmp14_ = NULL;
				GString* _tmp15_;
				GString* new_programs;
				gboolean _tmp21_;
				_tmp6_ = g_strdup_printf ("%u", channel_sid);
				channel_sid_string = _tmp6_;
				programs = NULL;
				g_object_get ((GObject*) self->priv->dvbbasebin, "program-numbers", &programs, NULL);
				_tmp8_ = _tmp7_ = g_strsplit (programs, ":", 0);
				_tmp9_ = _tmp8_;
				programs_arr_length1 = _vala_array_length (_tmp7_);
				_programs_arr_size_ = programs_arr_length1;
				programs_arr = _tmp9_;
				_tmp10_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
				new_programs_list = _tmp10_;
				{
					gint i;
					i = 0;
					{
						gboolean _tmp11_;
						_tmp11_ = TRUE;
						while (TRUE) {
							if (!_tmp11_) {
								i++;
							}
							_tmp11_ = FALSE;
							if (!(i < programs_arr_length1)) {
								break;
							}
							if (g_strcmp0 (programs_arr[i], channel_sid_string) != 0) {
								gee_abstract_collection_add ((GeeAbstractCollection*) new_programs_list, programs_arr[i]);
							}
						}
					}
				}
				_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) new_programs_list, 0);
				_tmp13_ = (gchar*) _tmp12_;
				_tmp14_ = g_string_new (_tmp13_);
				new_programs = (_tmp15_ = _tmp14_, _g_free0 (_tmp13_), _tmp15_);
				{
					gint i;
					i = 1;
					{
						gboolean _tmp16_;
						_tmp16_ = TRUE;
						while (TRUE) {
							gint _tmp17_;
							gpointer _tmp18_ = NULL;
							gchar* _tmp19_;
							gchar* _tmp20_;
							if (!_tmp16_) {
								i++;
							}
							_tmp16_ = FALSE;
							_tmp17_ = gee_collection_get_size ((GeeCollection*) new_programs_list);
							if (!(i < _tmp17_)) {
								break;
							}
							_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) new_programs_list, i);
							_tmp19_ = (gchar*) _tmp18_;
							_tmp20_ = g_strconcat (":", _tmp19_, NULL);
							g_string_append (new_programs, _tmp20_);
							_g_free0 (_tmp20_);
							_g_free0 (_tmp19_);
						}
					}
				}
				g_debug ("ChannelFactory.vala:330: Changing program-numbers from %s to %s", programs, new_programs->str);
				gst_element_set_state (self->priv->pipeline, GST_STATE_PAUSED);
				g_object_set ((GObject*) self->priv->dvbbasebin, "program-numbers", new_programs->str, NULL);
				_tmp21_ = dvb_player_thread_set_playing_or_destroy (self);
				if (!_tmp21_) {
					result = FALSE;
					_g_string_free0 (new_programs);
					_g_object_unref0 (new_programs_list);
					programs_arr = (_vala_array_free (programs_arr, programs_arr_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (programs);
					_g_free0 (channel_sid_string);
					g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
					_dvb_player_thread_channel_elements_unref0 (celements);
					return result;
				}
				gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->_active_channels, channel);
				_g_string_free0 (new_programs);
				_g_object_unref0 (new_programs_list);
				programs_arr = (_vala_array_free (programs_arr, programs_arr_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (programs);
				_g_free0 (channel_sid_string);
			}
			dvb_player_thread_remove_sink_bin (self, channel_sid, sink);
			if (stop_channel) {
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_;
				_tmp22_ = gst_object_get_name ((GstObject*) celements->tee);
				_tmp23_ = _tmp22_;
				g_debug ("ChannelFactory.vala:345: Removing tee %s from pipeline", _tmp23_);
				_g_free0 (_tmp23_);
				gst_element_set_state (celements->tee, GST_STATE_NULL);
				gst_bin_remove (GST_BIN (self->priv->pipeline), celements->tee);
				{
					g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
					gee_abstract_map_unset ((GeeAbstractMap*) self->priv->elements_map, GUINT_TO_POINTER (channel_sid), NULL);
					__finally20:
					g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
					if (_inner_error_ != NULL) {
						g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
						_dvb_player_thread_channel_elements_unref0 (celements);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
				}
			}
		} else {
			if (stop_channel) {
				dvb_player_thread_destroy (self, FALSE);
			} else {
				gboolean _tmp24_;
				dvb_player_thread_remove_sink_bin (self, channel_sid, sink);
				_tmp24_ = dvb_player_thread_set_playing_or_destroy (self);
				if (!_tmp24_) {
					result = FALSE;
					g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
					_dvb_player_thread_channel_elements_unref0 (celements);
					return result;
				}
			}
		}
		__finally19:
		g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
		if (_inner_error_ != NULL) {
			_dvb_player_thread_channel_elements_unref0 (celements);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	_dvb_player_thread_channel_elements_unref0 (celements);
	return result;
}


static gboolean dvb_player_thread_set_playing_or_destroy (DVBPlayerThread* self) {
	gboolean result = FALSE;
	GstStateChangeReturn _tmp0_;
	GstStateChangeReturn ret;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gst_element_set_state (self->priv->pipeline, GST_STATE_PLAYING);
	ret = _tmp0_;
	if (ret == GST_STATE_CHANGE_FAILURE) {
		g_critical ("ChannelFactory.vala:376: Failed setting pipeline to playing");
		dvb_player_thread_destroy (self, FALSE);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static void dvb_player_thread_remove_sink_bin (DVBPlayerThread* self, guint channel_sid, GstElement* sink) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GstElement* _tmp2_ = NULL;
	GstElement* sink_bin;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sink != NULL);
	_tmp0_ = gst_object_get_name ((GstObject*) sink);
	_tmp1_ = _tmp0_;
	g_debug ("ChannelFactory.vala:384: Removing sink bin of sink %s (%p) of channel " \
"%u", _tmp1_, sink, channel_sid);
	_g_free0 (_tmp1_);
	_tmp2_ = dvb_player_thread_get_sink_bin (self, channel_sid, sink);
	sink_bin = _tmp2_;
	if (sink_bin == NULL) {
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp3_ = gst_object_get_name ((GstObject*) sink);
		_tmp4_ = _tmp3_;
		g_critical ("ChannelFactory.vala:390: Could not find sink bin for channel %u and si" \
"nk %s (%p)", channel_sid, _tmp4_, sink);
		_g_free0 (_tmp4_);
		_gst_object_unref0 (sink_bin);
		return;
	}
	{
		gpointer _tmp5_ = NULL;
		DVBPlayerThreadChannelElements* celems;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gboolean _tmp8_;
		g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
		_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->elements_map, GUINT_TO_POINTER (channel_sid));
		celems = (DVBPlayerThreadChannelElements*) _tmp5_;
		_tmp6_ = gst_object_get_name ((GstObject*) sink);
		_tmp7_ = _tmp6_;
		g_debug ("ChannelFactory.vala:398: Setting state of queue and sink %s (%p) to NU" \
"LL", _tmp7_, sink);
		_g_free0 (_tmp7_);
		gst_element_unlink (celems->tee, sink_bin);
		gst_element_set_state (sink_bin, GST_STATE_NULL);
		_tmp8_ = gee_abstract_collection_remove ((GeeAbstractCollection*) celems->sinks, sink_bin);
		if (!_tmp8_) {
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			_tmp9_ = gst_object_get_name ((GstObject*) sink_bin);
			_tmp10_ = _tmp9_;
			g_critical ("ChannelFactory.vala:404: Could not find sink bin %s (%p)", _tmp10_, sink_bin);
			_g_free0 (_tmp10_);
		}
		_dvb_player_thread_channel_elements_unref0 (celems);
		__finally21:
		g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
		if (_inner_error_ != NULL) {
			_gst_object_unref0 (sink_bin);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_debug ("ChannelFactory.vala:409: Removing queue and sink from pipeline");
	gst_bin_remove (GST_BIN (self->priv->pipeline), sink_bin);
	_gst_object_unref0 (sink_bin);
}


/**
         * Stop pipeline and clean up everything else
         */
static void dvb_player_thread_real_destroy (DVBPlayerThread* self, gboolean forced) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->destroyed) {
		return;
	}
	{
		g_static_rec_mutex_lock (&self->priv->__lock_destroyed);
		self->priv->destroyed = TRUE;
		if (forced) {
			{
				g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
				{
					GeeCollection* _tmp0_ = NULL;
					GeeCollection* _tmp1_;
					GeeIterator* _tmp2_ = NULL;
					GeeIterator* _tmp3_;
					GeeIterator* _celems_it;
					_tmp0_ = gee_map_get_values ((GeeMap*) self->priv->elements_map);
					_tmp1_ = _tmp0_;
					_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
					_celems_it = (_tmp3_ = _tmp2_, _g_object_unref0 (_tmp1_), _tmp3_);
					while (TRUE) {
						gboolean _tmp4_;
						gpointer _tmp5_ = NULL;
						DVBPlayerThreadChannelElements* celems;
						_tmp4_ = gee_iterator_next (_celems_it);
						if (!_tmp4_) {
							break;
						}
						_tmp5_ = gee_iterator_get (_celems_it);
						celems = (DVBPlayerThreadChannelElements*) _tmp5_;
						if (celems->notify_func != NULL) {
							DVBChannelList* _tmp6_ = NULL;
							DVBChannel* _tmp7_ = NULL;
							DVBChannel* channel;
							_tmp6_ = dvb_device_get_Channels (self->priv->_device);
							_tmp7_ = dvb_channel_list_get_channel (_tmp6_, celems->sid);
							channel = _tmp7_;
							celems->notify_func (channel, celems->notify_func_target);
							_g_object_unref0 (channel);
						}
						_dvb_player_thread_channel_elements_unref0 (celems);
					}
					_g_object_unref0 (_celems_it);
				}
				__finally23:
				g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
				if (_inner_error_ != NULL) {
					g_static_rec_mutex_unlock (&self->priv->__lock_destroyed);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		{
			GstElement* _tmp9_;
			g_static_rec_mutex_lock (&self->priv->__lock_pipeline);
			if (self->priv->pipeline != NULL) {
				GstBus* _tmp8_ = NULL;
				GstBus* bus;
				g_debug ("ChannelFactory.vala:434: Stopping pipeline");
				_tmp8_ = gst_element_get_bus (self->priv->pipeline);
				bus = _tmp8_;
				gst_bus_remove_signal_watch (bus);
				gst_element_set_state (self->priv->pipeline, GST_STATE_NULL);
				_gst_object_unref0 (bus);
			}
			_tmp9_ = NULL;
			_gst_object_unref0 (self->priv->pipeline);
			self->priv->pipeline = _tmp9_;
			__finally24:
			g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
			if (_inner_error_ != NULL) {
				g_static_rec_mutex_unlock (&self->priv->__lock_destroyed);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		{
			g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
			gee_abstract_map_clear ((GeeAbstractMap*) self->priv->elements_map);
			__finally25:
			g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
			if (_inner_error_ != NULL) {
				g_static_rec_mutex_unlock (&self->priv->__lock_destroyed);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		gee_abstract_collection_clear ((GeeAbstractCollection*) self->priv->_active_channels);
		__finally22:
		g_static_rec_mutex_unlock (&self->priv->__lock_destroyed);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void dvb_player_thread_destroy (DVBPlayerThread* self, gboolean forced) {
	DVB_PLAYER_THREAD_GET_CLASS (self)->destroy (self, forced);
}


static gboolean dvb_player_thread_add_element (DVBPlayerThread* self, GstElement* elem) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* elem_name;
	GstElement* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (elem != NULL, FALSE);
	_tmp0_ = gst_object_get_name ((GstObject*) elem);
	elem_name = _tmp0_;
	_tmp1_ = _gst_object_ref0 (elem);
	_tmp2_ = gst_bin_add (GST_BIN (self->priv->pipeline), _tmp1_);
	if (!_tmp2_) {
		g_critical ("ChannelFactory.vala:451: Could not add element %s", elem_name);
		result = FALSE;
		_g_free0 (elem_name);
		_gst_object_unref0 (elem);
		return result;
	}
	g_debug ("ChannelFactory.vala:454: Element %s (%p) added to pipeline", elem_name, elem);
	result = TRUE;
	_g_free0 (elem_name);
	_gst_object_unref0 (elem);
	return result;
}


/**
         * Link program_%d pad with tee
         */
static void dvb_player_thread_on_dvbbasebin_pad_added (DVBPlayerThread* self, GstElement* elem, GstPad* pad) {
	gchar* _tmp0_ = NULL;
	gchar* pad_name;
	gboolean _tmp1_;
	guint sid = 0U;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (elem != NULL);
	g_return_if_fail (pad != NULL);
	_tmp0_ = gst_object_get_name ((GstObject*) pad);
	pad_name = _tmp0_;
	g_debug ("ChannelFactory.vala:463: Pad %s added", pad_name);
	_tmp1_ = g_str_has_prefix (pad_name, "program_");
	if (!_tmp1_) {
		_g_free0 (pad_name);
		return;
	}
	sscanf (pad_name, "program_%u", &sid);
	g_debug ("ChannelFactory.vala:471: SID is '%u'", sid);
	{
		gboolean _tmp2_;
		g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
		_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->elements_map, GUINT_TO_POINTER (sid));
		if (_tmp2_) {
			gpointer _tmp3_ = NULL;
			DVBPlayerThreadChannelElements* _tmp4_;
			GstElement* _tmp5_;
			GstElement* _tmp6_;
			GstElement* sink;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			GstPad* _tmp11_ = NULL;
			GstPad* sinkpad;
			GstPadLinkReturn _tmp12_;
			GstPadLinkReturn rc;
			_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->elements_map, GUINT_TO_POINTER (sid));
			_tmp4_ = (DVBPlayerThreadChannelElements*) _tmp3_;
			_tmp5_ = _gst_object_ref0 (_tmp4_->tee);
			sink = (_tmp6_ = _tmp5_, _dvb_player_thread_channel_elements_unref0 (_tmp4_), _tmp6_);
			if (sink == NULL) {
				g_critical ("ChannelFactory.vala:477: Could not find sink for SID %u", sid);
				_gst_object_unref0 (sink);
				g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
				_g_free0 (pad_name);
				return;
			}
			_tmp7_ = gst_object_get_name ((GstObject*) elem);
			_tmp8_ = _tmp7_;
			_tmp9_ = gst_object_get_name ((GstObject*) sink);
			_tmp10_ = _tmp9_;
			g_debug ("ChannelFactory.vala:481: Linking elements %s and %s", _tmp8_, _tmp10_);
			_g_free0 (_tmp10_);
			_g_free0 (_tmp8_);
			_tmp11_ = gst_element_get_static_pad (sink, "sink");
			sinkpad = _tmp11_;
			_tmp12_ = gst_pad_link (pad, sinkpad);
			rc = _tmp12_;
			if (rc != GST_PAD_LINK_OK) {
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_;
				_tmp13_ = gst_object_get_name ((GstObject*) pad);
				_tmp14_ = _tmp13_;
				_tmp15_ = gst_object_get_name ((GstObject*) sinkpad);
				_tmp16_ = _tmp15_;
				g_critical ("ChannelFactory.vala:486: Could not link pads %s and %s", _tmp14_, _tmp16_);
				_g_free0 (_tmp16_);
				_g_free0 (_tmp14_);
			} else {
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_;
				_tmp17_ = gst_object_get_name ((GstObject*) pad);
				_tmp18_ = _tmp17_;
				_tmp19_ = gst_object_get_name ((GstObject*) sinkpad);
				_tmp20_ = _tmp19_;
				g_debug ("ChannelFactory.vala:489: Src pad %s linked with sink pad %s", _tmp18_, _tmp20_);
				_g_free0 (_tmp20_);
				_g_free0 (_tmp18_);
			}
			_gst_object_unref0 (sinkpad);
			_gst_object_unref0 (sink);
		}
		__finally26:
		g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
		if (_inner_error_ != NULL) {
			_g_free0 (pad_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (pad_name);
}


/**
         * Forward EIT structure
         */
static gpointer _gst_structure_copy0 (gpointer self) {
	return self ? gst_structure_copy (self) : NULL;
}


static void dvb_player_thread_bus_watch_func (DVBPlayerThread* self, GstBus* bus, GstMessage* message) {
	const GstStructure* _tmp0_ = NULL;
	GstStructure* _tmp1_;
	GstStructure* structure;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bus != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = gst_message_get_structure (message);
	_tmp1_ = _gst_structure_copy0 (_tmp0_);
	structure = _tmp1_;
	switch (message->type) {
		case GST_MESSAGE_ELEMENT:
		{
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_;
			gchar* structure_name;
			_tmp2_ = gst_structure_get_name (structure);
			_tmp3_ = g_strdup (_tmp2_);
			structure_name = _tmp3_;
			if (g_strcmp0 (structure_name, "eit") == 0) {
				if (self->priv->epgscanner != NULL) {
					dvb_epg_scanner_on_eit_structure (self->priv->epgscanner, structure);
				}
				g_signal_emit_by_name (self, "eit-structure", structure);
			}
			_g_free0 (structure_name);
			break;
		}
		case GST_MESSAGE_WARNING:
		{
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			_tmp4_ = gst_structure_to_string (structure);
			_tmp5_ = _tmp4_;
			g_warning ("ChannelFactory.vala:511: %s", _tmp5_);
			_g_free0 (_tmp5_);
			break;
		}
		case GST_MESSAGE_ERROR:
		{
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			_tmp6_ = gst_structure_to_string (structure);
			_tmp7_ = _tmp6_;
			g_critical ("ChannelFactory.vala:514: %s", _tmp7_);
			_g_free0 (_tmp7_);
			break;
		}
		default:
		{
			break;
		}
	}
	_gst_structure_free0 (structure);
}


GeeHashSet* dvb_player_thread_get_active_channels (DVBPlayerThread* self) {
	GeeHashSet* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_active_channels;
	return result;
}


static void dvb_player_thread_set_active_channels (DVBPlayerThread* self, GeeHashSet* value) {
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_active_channels);
	self->priv->_active_channels = _tmp1_;
	g_object_notify ((GObject *) self, "active-channels");
}


DVBDevice* dvb_player_thread_get_device (DVBPlayerThread* self) {
	DVBDevice* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_device;
	return result;
}


static void dvb_player_thread_set_device (DVBPlayerThread* self, DVBDevice* value) {
	DVBDevice* _tmp0_;
	DVBDevice* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_device);
	self->priv->_device = _tmp1_;
	g_object_notify ((GObject *) self, "device");
}


gboolean dvb_player_thread_get_forced (DVBPlayerThread* self) {
	gboolean result;
	gboolean val;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	val = FALSE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_elements_map);
		{
			GeeCollection* _tmp0_ = NULL;
			GeeCollection* _tmp1_;
			GeeIterator* _tmp2_ = NULL;
			GeeIterator* _tmp3_;
			GeeIterator* _celem_it;
			_tmp0_ = gee_map_get_values ((GeeMap*) self->priv->elements_map);
			_tmp1_ = _tmp0_;
			_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
			_celem_it = (_tmp3_ = _tmp2_, _g_object_unref0 (_tmp1_), _tmp3_);
			while (TRUE) {
				gboolean _tmp4_;
				gpointer _tmp5_ = NULL;
				DVBPlayerThreadChannelElements* celem;
				_tmp4_ = gee_iterator_next (_celem_it);
				if (!_tmp4_) {
					break;
				}
				_tmp5_ = gee_iterator_get (_celem_it);
				celem = (DVBPlayerThreadChannelElements*) _tmp5_;
				if (celem->forced) {
					val = TRUE;
					_dvb_player_thread_channel_elements_unref0 (celem);
					break;
				}
				_dvb_player_thread_channel_elements_unref0 (celem);
			}
			_g_object_unref0 (_celem_it);
		}
		__finally27:
		g_static_rec_mutex_unlock (&self->priv->__lock_elements_map);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = val;
	return result;
}


static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__BOXED callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), data2);
}


static GObject * dvb_player_thread_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBPlayerThread * self;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_;
	GeeHashSet* _tmp2_ = NULL;
	GeeHashSet* _tmp3_;
	parent_class = G_OBJECT_CLASS (dvb_player_thread_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_PLAYER_THREAD (obj);
	_tmp0_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS, (GBoxedCopyFunc) dvb_player_thread_channel_elements_ref, dvb_player_thread_channel_elements_unref, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->elements_map);
	self->priv->elements_map = _tmp1_;
	_tmp2_ = gee_hash_set_new (DVB_TYPE_CHANNEL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_tmp3_ = _tmp2_;
	dvb_player_thread_set_active_channels (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	self->priv->destroyed = FALSE;
	return obj;
}


static DVBPlayerThreadChannelElements* dvb_player_thread_channel_elements_construct (GType object_type) {
	DVBPlayerThreadChannelElements* self = NULL;
	self = (DVBPlayerThreadChannelElements*) g_type_create_instance (object_type);
	return self;
}


static DVBPlayerThreadChannelElements* dvb_player_thread_channel_elements_new (void) {
	return dvb_player_thread_channel_elements_construct (DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS);
}


static void dvb_player_thread_value_channel_elements_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void dvb_player_thread_value_channel_elements_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		dvb_player_thread_channel_elements_unref (value->data[0].v_pointer);
	}
}


static void dvb_player_thread_value_channel_elements_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = dvb_player_thread_channel_elements_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer dvb_player_thread_value_channel_elements_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* dvb_player_thread_value_channel_elements_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		DVBPlayerThreadChannelElements* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = dvb_player_thread_channel_elements_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* dvb_player_thread_value_channel_elements_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DVBPlayerThreadChannelElements** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = dvb_player_thread_channel_elements_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* dvb_player_thread_param_spec_channel_elements (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	DVBPlayerThreadParamSpecChannelElements* spec;
	g_return_val_if_fail (g_type_is_a (object_type, DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer dvb_player_thread_value_get_channel_elements (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS), NULL);
	return value->data[0].v_pointer;
}


static void dvb_player_thread_value_set_channel_elements (GValue* value, gpointer v_object) {
	DVBPlayerThreadChannelElements* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		dvb_player_thread_channel_elements_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dvb_player_thread_channel_elements_unref (old);
	}
}


static void dvb_player_thread_value_take_channel_elements (GValue* value, gpointer v_object) {
	DVBPlayerThreadChannelElements* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dvb_player_thread_channel_elements_unref (old);
	}
}


static void dvb_player_thread_channel_elements_class_init (DVBPlayerThreadChannelElementsClass * klass) {
	dvb_player_thread_channel_elements_parent_class = g_type_class_peek_parent (klass);
	DVB_PLAYER_THREAD_CHANNEL_ELEMENTS_CLASS (klass)->finalize = dvb_player_thread_channel_elements_finalize;
}


static void dvb_player_thread_channel_elements_instance_init (DVBPlayerThreadChannelElements * self) {
	self->ref_count = 1;
}


static void dvb_player_thread_channel_elements_finalize (DVBPlayerThreadChannelElements* obj) {
	DVBPlayerThreadChannelElements * self;
	self = DVB_PLAYER_THREAD_CHANNEL_ELEMENTS (obj);
	_g_object_unref0 (self->sinks);
	_gst_object_unref0 (self->tee);
	(self->notify_func_target_destroy_notify == NULL) ? NULL : (self->notify_func_target_destroy_notify (self->notify_func_target), NULL);
	self->notify_func = NULL;
	self->notify_func_target = NULL;
	self->notify_func_target_destroy_notify = NULL;
}


static GType dvb_player_thread_channel_elements_get_type (void) {
	static volatile gsize dvb_player_thread_channel_elements_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_player_thread_channel_elements_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { dvb_player_thread_value_channel_elements_init, dvb_player_thread_value_channel_elements_free_value, dvb_player_thread_value_channel_elements_copy_value, dvb_player_thread_value_channel_elements_peek_pointer, "p", dvb_player_thread_value_channel_elements_collect_value, "p", dvb_player_thread_value_channel_elements_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DVBPlayerThreadChannelElementsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_player_thread_channel_elements_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBPlayerThreadChannelElements), 0, (GInstanceInitFunc) dvb_player_thread_channel_elements_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType dvb_player_thread_channel_elements_type_id;
		dvb_player_thread_channel_elements_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DVBPlayerThreadChannelElements", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&dvb_player_thread_channel_elements_type_id__volatile, dvb_player_thread_channel_elements_type_id);
	}
	return dvb_player_thread_channel_elements_type_id__volatile;
}


static gpointer dvb_player_thread_channel_elements_ref (gpointer instance) {
	DVBPlayerThreadChannelElements* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void dvb_player_thread_channel_elements_unref (gpointer instance) {
	DVBPlayerThreadChannelElements* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DVB_PLAYER_THREAD_CHANNEL_ELEMENTS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void dvb_player_thread_class_init (DVBPlayerThreadClass * klass) {
	dvb_player_thread_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBPlayerThreadPrivate));
	DVB_PLAYER_THREAD_CLASS (klass)->destroy = dvb_player_thread_real_destroy;
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_player_thread_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_player_thread_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_player_thread_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_player_thread_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_PLAYER_THREAD_ACTIVE_CHANNELS, g_param_spec_object ("active-channels", "active-channels", "active-channels", GEE_TYPE_HASH_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_PLAYER_THREAD_DEVICE, g_param_spec_object ("device", "device", "device", DVB_TYPE_DEVICE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_PLAYER_THREAD_FORCED, g_param_spec_boolean ("forced", "forced", "forced", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/** 
	         * Emitted when we came across EIT table
	         */
	g_signal_new ("eit_structure", DVB_TYPE_PLAYER_THREAD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, GST_TYPE_STRUCTURE);
}


static void dvb_player_thread_instance_init (DVBPlayerThread * self) {
	self->priv = DVB_PLAYER_THREAD_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_pipeline);
	g_static_rec_mutex_init (&self->priv->__lock_elements_map);
	g_static_rec_mutex_init (&self->priv->__lock_destroyed);
}


static void dvb_player_thread_finalize (GObject* obj) {
	DVBPlayerThread * self;
	self = DVB_PLAYER_THREAD (obj);
	_g_object_unref0 (self->priv->_active_channels);
	_g_object_unref0 (self->priv->_device);
	g_static_rec_mutex_free (&self->priv->__lock_pipeline);
	_gst_object_unref0 (self->priv->pipeline);
	g_static_rec_mutex_free (&self->priv->__lock_elements_map);
	_g_object_unref0 (self->priv->elements_map);
	_g_object_unref0 (self->priv->epgscanner);
	_gst_object_unref0 (self->priv->dvbbasebin);
	g_static_rec_mutex_free (&self->priv->__lock_destroyed);
	G_OBJECT_CLASS (dvb_player_thread_parent_class)->finalize (obj);
}


/**
     * This class handles watching channels one physical device.
     * 
     * It's possible to watch multiple channels at the same time
     * if they are all on the same transport stream.
     *
     * The class is able to reuse channels that are already watched
     * and forward EPG data to #EPGScanner.
     */
GType dvb_player_thread_get_type (void) {
	static volatile gsize dvb_player_thread_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_player_thread_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBPlayerThreadClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_player_thread_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBPlayerThread), 0, (GInstanceInitFunc) dvb_player_thread_instance_init, NULL };
		GType dvb_player_thread_type_id;
		dvb_player_thread_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBPlayerThread", &g_define_type_info, 0);
		g_once_init_leave (&dvb_player_thread_type_id__volatile, dvb_player_thread_type_id);
	}
	return dvb_player_thread_type_id__volatile;
}


static void _vala_dvb_player_thread_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBPlayerThread * self;
	self = DVB_PLAYER_THREAD (object);
	switch (property_id) {
		case DVB_PLAYER_THREAD_ACTIVE_CHANNELS:
		g_value_set_object (value, dvb_player_thread_get_active_channels (self));
		break;
		case DVB_PLAYER_THREAD_DEVICE:
		g_value_set_object (value, dvb_player_thread_get_device (self));
		break;
		case DVB_PLAYER_THREAD_FORCED:
		g_value_set_boolean (value, dvb_player_thread_get_forced (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_player_thread_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBPlayerThread * self;
	self = DVB_PLAYER_THREAD (object);
	switch (property_id) {
		case DVB_PLAYER_THREAD_ACTIVE_CHANNELS:
		dvb_player_thread_set_active_channels (self, g_value_get_object (value));
		break;
		case DVB_PLAYER_THREAD_DEVICE:
		dvb_player_thread_set_device (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


DVBChannelFactory* dvb_channel_factory_construct (GType object_type, DVBDeviceGroup* devgroup) {
	DVBChannelFactory * self = NULL;
	GeeHashSet* _tmp0_ = NULL;
	GeeHashSet* _tmp1_;
	g_return_val_if_fail (devgroup != NULL, NULL);
	self = (DVBChannelFactory*) g_object_new (object_type, "device-group", devgroup, NULL);
	_tmp0_ = gee_hash_set_new (DVB_TYPE_PLAYER_THREAD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->active_players);
	self->priv->active_players = _tmp1_;
	return self;
}


DVBChannelFactory* dvb_channel_factory_new (DVBDeviceGroup* devgroup) {
	return dvb_channel_factory_construct (DVB_TYPE_CHANNEL_FACTORY, devgroup);
}


/**
         * Stop all currently active players
         */
void dvb_channel_factory_destroy (DVBChannelFactory* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_active_players);
		{
			GeeIterator* _tmp0_ = NULL;
			GeeIterator* _active_player_it;
			_tmp0_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->active_players);
			_active_player_it = _tmp0_;
			while (TRUE) {
				gboolean _tmp1_;
				gpointer _tmp2_ = NULL;
				DVBPlayerThread* active_player;
				_tmp1_ = gee_iterator_next (_active_player_it);
				if (!_tmp1_) {
					break;
				}
				_tmp2_ = gee_iterator_get (_active_player_it);
				active_player = (DVBPlayerThread*) _tmp2_;
				dvb_player_thread_destroy (active_player, FALSE);
				_g_object_unref0 (active_player);
			}
			_g_object_unref0 (_active_player_it);
		}
		gee_abstract_collection_clear ((GeeAbstractCollection*) self->priv->active_players);
		__finally28:
		g_static_rec_mutex_unlock (&self->priv->__lock_active_players);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
         * @channel: channel to watch
         * @sink_element: The element the src pad should be linked with
         * @force: Whether to stop a player when there's currently no free device
         * @notify_func: The given function is called when watching the channel
         *   is aborted because a recording on a different transport streams is
         *   about to start
         * @returns: The #PlayerThread used to watch @channel
         *
         * Watch @channel and use @sink_element as sink element
         */
static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


DVBPlayerThread* dvb_channel_factory_watch_channel (DVBChannelFactory* self, DVBChannel* channel, GstElement* sink_element, gboolean force, DVBForcedStopNotify notify_func, void* notify_func_target) {
	DVBPlayerThread* result = NULL;
	const gchar* _tmp0_ = NULL;
	guint _tmp1_;
	gboolean create_new;
	DVBPlayerThread* player;
	DVBDevice* free_device;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	GstElement* _tmp25_;
	GstElement* _tmp26_ = NULL;
	GstElement* _tmp27_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (channel != NULL, NULL);
	g_return_val_if_fail (sink_element != NULL, NULL);
	_tmp0_ = dvb_channel_get_Name (channel);
	_tmp1_ = dvb_channel_get_Sid (channel);
	g_debug ("ChannelFactory.vala:563: Watching channel %s (%u)", _tmp0_, _tmp1_);
	create_new = TRUE;
	player = NULL;
	free_device = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_active_players);
		{
			GeeIterator* _tmp2_ = NULL;
			GeeIterator* _active_player_it;
			_tmp2_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->active_players);
			_active_player_it = _tmp2_;
			while (TRUE) {
				gboolean _tmp3_;
				gpointer _tmp4_ = NULL;
				DVBPlayerThread* active_player;
				_tmp3_ = gee_iterator_next (_active_player_it);
				if (!_tmp3_) {
					break;
				}
				_tmp4_ = gee_iterator_get (_active_player_it);
				active_player = (DVBPlayerThread*) _tmp4_;
				{
					GeeHashSet* _tmp5_ = NULL;
					GeeIterator* _tmp6_ = NULL;
					GeeIterator* _other_channel_it;
					_tmp5_ = dvb_player_thread_get_active_channels (active_player);
					_tmp6_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp5_);
					_other_channel_it = _tmp6_;
					while (TRUE) {
						gboolean _tmp7_;
						gpointer _tmp8_ = NULL;
						DVBChannel* other_channel;
						gboolean _tmp9_;
						_tmp7_ = gee_iterator_next (_other_channel_it);
						if (!_tmp7_) {
							break;
						}
						_tmp8_ = gee_iterator_get (_other_channel_it);
						other_channel = (DVBChannel*) _tmp8_;
						_tmp9_ = dvb_channel_on_same_transport_stream (channel, other_channel);
						if (_tmp9_) {
							DVBPlayerThread* _tmp10_;
							DVBPlayerThread* _tmp11_;
							create_new = FALSE;
							_tmp10_ = _g_object_ref0 (active_player);
							_tmp11_ = _tmp10_;
							_g_object_unref0 (player);
							player = _tmp11_;
							_g_object_unref0 (other_channel);
							break;
						}
						_g_object_unref0 (other_channel);
					}
					_g_object_unref0 (_other_channel_it);
				}
				_g_object_unref0 (active_player);
			}
			_g_object_unref0 (_active_player_it);
		}
		__finally29:
		g_static_rec_mutex_unlock (&self->priv->__lock_active_players);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (free_device);
			_g_object_unref0 (player);
			_gst_object_unref0 (sink_element);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp12_ = bool_to_string (create_new);
	_tmp13_ = _tmp12_;
	g_debug ("ChannelFactory.vala:580: Creating new PlayerThread: %s", _tmp13_);
	_g_free0 (_tmp13_);
	if (create_new) {
		DVBDevice* _tmp14_ = NULL;
		DVBDevice* _tmp15_;
		gboolean _tmp16_ = FALSE;
		DVBPlayerThread* _tmp23_ = NULL;
		DVBPlayerThread* _tmp24_;
		dvb_device_group_stop_epg_scanner (self->priv->_device_group);
		_tmp14_ = dvb_device_group_get_next_free_device (self->priv->_device_group);
		_tmp15_ = _tmp14_;
		_g_object_unref0 (free_device);
		free_device = _tmp15_;
		if (free_device == NULL) {
			_tmp16_ = force;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			DVBDevice* _tmp21_ = NULL;
			DVBDevice* _tmp22_;
			{
				g_static_rec_mutex_lock (&self->priv->__lock_active_players);
				{
					GeeIterator* _tmp17_ = NULL;
					GeeIterator* _active_player_it;
					_tmp17_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->active_players);
					_active_player_it = _tmp17_;
					while (TRUE) {
						gboolean _tmp18_;
						gpointer _tmp19_ = NULL;
						DVBPlayerThread* active_player;
						gboolean _tmp20_;
						_tmp18_ = gee_iterator_next (_active_player_it);
						if (!_tmp18_) {
							break;
						}
						_tmp19_ = gee_iterator_get (_active_player_it);
						active_player = (DVBPlayerThread*) _tmp19_;
						_tmp20_ = dvb_player_thread_get_forced (active_player);
						if (!_tmp20_) {
							dvb_player_thread_destroy (active_player, TRUE);
							_g_object_unref0 (active_player);
							break;
						} else {
							g_critical ("ChannelFactory.vala:594: No active players that are not forced");
						}
						_g_object_unref0 (active_player);
					}
					_g_object_unref0 (_active_player_it);
				}
				__finally30:
				g_static_rec_mutex_unlock (&self->priv->__lock_active_players);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (free_device);
					_g_object_unref0 (player);
					_gst_object_unref0 (sink_element);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp21_ = dvb_device_group_get_next_free_device (self->priv->_device_group);
			_tmp22_ = _tmp21_;
			_g_object_unref0 (free_device);
			free_device = _tmp22_;
		}
		if (free_device == NULL) {
			g_message ("ChannelFactory.vala:601: All devices are busy");
			result = NULL;
			_g_object_unref0 (free_device);
			_g_object_unref0 (player);
			_gst_object_unref0 (sink_element);
			return result;
		}
		_tmp23_ = dvb_channel_factory_create_player (self, free_device);
		_tmp24_ = _tmp23_;
		_g_object_unref0 (player);
		player = _tmp24_;
	}
	_tmp25_ = _gst_object_ref0 (sink_element);
	_tmp26_ = dvb_player_thread_get_element (player, channel, _tmp25_, force, notify_func, notify_func_target);
	_tmp27_ = _tmp26_;
	_gst_object_unref0 (_tmp27_);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_active_players);
		gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->active_players, player);
		__finally31:
		g_static_rec_mutex_unlock (&self->priv->__lock_active_players);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (free_device);
			_g_object_unref0 (player);
			_gst_object_unref0 (sink_element);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = player;
	_g_object_unref0 (free_device);
	_gst_object_unref0 (sink_element);
	return result;
}


/**
         * @returns: TRUE on success
         *
         * Stop watching @channel
         */
gboolean dvb_channel_factory_stop_channel (DVBChannelFactory* self, DVBChannel* channel, GstElement* sink) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	guint _tmp1_;
	gboolean success;
	DVBPlayerThread* player;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (channel != NULL, FALSE);
	g_return_val_if_fail (sink != NULL, FALSE);
	_tmp0_ = dvb_channel_get_Name (channel);
	_tmp1_ = dvb_channel_get_Sid (channel);
	g_debug ("ChannelFactory.vala:622: Stopping channel %s (%u)", _tmp0_, _tmp1_);
	success = FALSE;
	player = NULL;
	{
		gboolean _tmp10_ = FALSE;
		gint _tmp13_;
		g_static_rec_mutex_lock (&self->priv->__lock_active_players);
		{
			GeeIterator* _tmp2_ = NULL;
			GeeIterator* _active_player_it;
			_tmp2_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->active_players);
			_active_player_it = _tmp2_;
			while (TRUE) {
				gboolean _tmp3_;
				gpointer _tmp4_ = NULL;
				DVBPlayerThread* active_player;
				GeeHashSet* _tmp5_ = NULL;
				gboolean _tmp6_;
				_tmp3_ = gee_iterator_next (_active_player_it);
				if (!_tmp3_) {
					break;
				}
				_tmp4_ = gee_iterator_get (_active_player_it);
				active_player = (DVBPlayerThread*) _tmp4_;
				_tmp5_ = dvb_player_thread_get_active_channels (active_player);
				_tmp6_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp5_, channel);
				if (_tmp6_) {
					gboolean _tmp7_;
					DVBPlayerThread* _tmp8_;
					DVBPlayerThread* _tmp9_;
					_tmp7_ = dvb_player_thread_remove_channel (active_player, channel, sink);
					success = _tmp7_;
					_tmp8_ = _g_object_ref0 (active_player);
					_tmp9_ = _tmp8_;
					_g_object_unref0 (player);
					player = _tmp9_;
					_g_object_unref0 (active_player);
					break;
				}
				_g_object_unref0 (active_player);
			}
			_g_object_unref0 (_active_player_it);
		}
		if (success) {
			GeeHashSet* _tmp11_ = NULL;
			gint _tmp12_;
			_tmp11_ = dvb_player_thread_get_active_channels (player);
			_tmp12_ = gee_collection_get_size ((GeeCollection*) _tmp11_);
			_tmp10_ = _tmp12_ == 0;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->active_players, player);
		}
		_tmp13_ = gee_collection_get_size ((GeeCollection*) self->priv->active_players);
		if (_tmp13_ == 0) {
			dvb_device_group_start_epg_scanner (self->priv->_device_group);
		}
		__finally32:
		g_static_rec_mutex_unlock (&self->priv->__lock_active_players);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (player);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = success;
	_g_object_unref0 (player);
	return result;
}


/**
         * @returns: a new #PlayerThread instance for @device
         */
static DVBPlayerThread* dvb_channel_factory_real_create_player (DVBChannelFactory* self, DVBDevice* device) {
	DVBPlayerThread* result = NULL;
	DVBEPGScanner* _tmp0_ = NULL;
	DVBPlayerThread* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (device != NULL, NULL);
	_tmp0_ = dvb_device_group_get_epgscanner (self->priv->_device_group);
	_tmp1_ = dvb_player_thread_new (device, _tmp0_);
	result = _tmp1_;
	return result;
}


DVBPlayerThread* dvb_channel_factory_create_player (DVBChannelFactory* self, DVBDevice* device) {
	return DVB_CHANNEL_FACTORY_GET_CLASS (self)->create_player (self, device);
}


DVBDeviceGroup* dvb_channel_factory_get_device_group (DVBChannelFactory* self) {
	DVBDeviceGroup* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_device_group;
	return result;
}


static void dvb_channel_factory_set_device_group (DVBChannelFactory* self, DVBDeviceGroup* value) {
	g_return_if_fail (self != NULL);
	self->priv->_device_group = value;
	g_object_notify ((GObject *) self, "device-group");
}


static void dvb_channel_factory_class_init (DVBChannelFactoryClass * klass) {
	dvb_channel_factory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBChannelFactoryPrivate));
	DVB_CHANNEL_FACTORY_CLASS (klass)->create_player = dvb_channel_factory_real_create_player;
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_channel_factory_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_channel_factory_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_channel_factory_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_FACTORY_DEVICE_GROUP, g_param_spec_object ("device-group", "device-group", "device-group", DVB_TYPE_DEVICE_GROUP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void dvb_channel_factory_instance_init (DVBChannelFactory * self) {
	self->priv = DVB_CHANNEL_FACTORY_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_active_players);
}


static void dvb_channel_factory_finalize (GObject* obj) {
	DVBChannelFactory * self;
	self = DVB_CHANNEL_FACTORY (obj);
	g_static_rec_mutex_free (&self->priv->__lock_active_players);
	_g_object_unref0 (self->priv->active_players);
	G_OBJECT_CLASS (dvb_channel_factory_parent_class)->finalize (obj);
}


/**
     * This class handles watching channels for a single #DeviceGroup
     */
GType dvb_channel_factory_get_type (void) {
	static volatile gsize dvb_channel_factory_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_channel_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBChannelFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_channel_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBChannelFactory), 0, (GInstanceInitFunc) dvb_channel_factory_instance_init, NULL };
		GType dvb_channel_factory_type_id;
		dvb_channel_factory_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBChannelFactory", &g_define_type_info, 0);
		g_once_init_leave (&dvb_channel_factory_type_id__volatile, dvb_channel_factory_type_id);
	}
	return dvb_channel_factory_type_id__volatile;
}


static void _vala_dvb_channel_factory_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBChannelFactory * self;
	self = DVB_CHANNEL_FACTORY (object);
	switch (property_id) {
		case DVB_CHANNEL_FACTORY_DEVICE_GROUP:
		g_value_set_object (value, dvb_channel_factory_get_device_group (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_channel_factory_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBChannelFactory * self;
	self = DVB_CHANNEL_FACTORY (object);
	switch (property_id) {
		case DVB_CHANNEL_FACTORY_DEVICE_GROUP:
		dvb_channel_factory_set_device_group (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



