#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))

#include <src/ChannelList.h>
#include <gee/map.h>
#include "src/ChannelListReader.h"

typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};



struct _DVBChannelListPrivate {
	GFile* _channels_file;
	guint _group_id;
	GStaticRecMutex __lock_channels;
};

#define DVB_CHANNEL_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_CHANNEL_LIST, DVBChannelListPrivate))
enum  {
	DVB_CHANNEL_LIST_DUMMY_PROPERTY,
	DVB_CHANNEL_LIST_CHANNELS_FILE,
	DVB_CHANNEL_LIST_SIZE,
	DVB_CHANNEL_LIST_GROUP_ID
};
static GType dvb_channel_list_real_get_element_type (GeeIterable* base);
static GeeIterator* dvb_channel_list_real_iterator (GeeIterable* base);
static guint* dvb_channel_list_real_GetChannels (DVBIDBusChannelList* base, int* result_length1);
static guint* dvb_channel_list_real_GetRadioChannels (DVBIDBusChannelList* base, int* result_length1);
static guint* dvb_channel_list_real_GetTVChannels (DVBIDBusChannelList* base, int* result_length1);
static char* dvb_channel_list_real_GetChannelName (DVBIDBusChannelList* base, guint channel_id);
static char* dvb_channel_list_real_GetChannelNetwork (DVBIDBusChannelList* base, guint channel_id);
static gboolean dvb_channel_list_real_IsRadioChannel (DVBIDBusChannelList* base, guint channel_id);
static char* dvb_channel_list_real_GetChannelURL (DVBIDBusChannelList* base, guint channel_id);
static void dvb_channel_list_set_channels_file (DVBChannelList* self, GFile* value);
static GObject * dvb_channel_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer dvb_channel_list_parent_class = NULL;
void _dvb_channel_list_dbus_unregister (DBusConnection* connection, void* user_data);
static DBusMessage* _dbus_dvb_channel_list_introspect (DVBChannelList* self, DBusConnection* connection, DBusMessage* message);
static GeeIterableIface* dvb_channel_list_gee_iterable_parent_iface = NULL;
static DVBIDBusChannelListIface* dvb_channel_list_dvb_id_bus_channel_list_parent_iface = NULL;
static void dvb_channel_list_finalize (GObject* obj);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);

static const DBusObjectPathVTable _dvb_channel_list_dbus_path_vtable = {_dvb_channel_list_dbus_unregister, dvb_channel_list_dbus_message};
static const _DBusObjectVTable _dvb_channel_list_dbus_vtable = {dvb_channel_list_dbus_register_object};


DVBChannelList* dvb_channel_list_construct (GType object_type, GFile* channels) {
	GParameter * __params;
	GParameter * __params_it;
	DVBChannelList * self;
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "channels-file";
	g_value_init (&__params_it->value, G_TYPE_FILE);
	g_value_set_object (&__params_it->value, channels);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DVBChannelList* dvb_channel_list_new (GFile* channels) {
	return dvb_channel_list_construct (DVB_TYPE_CHANNEL_LIST, channels);
}


DVBChannel* dvb_channel_list_get (DVBChannelList* self, guint sid) {
	DVBChannel* val;
	g_return_val_if_fail (self != NULL, NULL);
	val = NULL;
	g_static_rec_mutex_lock (&self->priv->__lock_channels);
	{
		if (gee_map_contains ((GeeMap*) self->channels, GUINT_TO_POINTER (sid))) {
			DVBChannel* _tmp0;
			_tmp0 = NULL;
			val = (_tmp0 = (DVBChannel*) gee_map_get ((GeeMap*) self->channels, GUINT_TO_POINTER (sid)), (val == NULL) ? NULL : (val = (g_object_unref (val), NULL)), _tmp0);
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_channels);
	return val;
}


void dvb_channel_list_add (DVBChannelList* self, DVBChannel* channel) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	g_static_rec_mutex_lock (&self->priv->__lock_channels);
	{
		gee_map_set ((GeeMap*) self->channels, GUINT_TO_POINTER (dvb_channel_get_Sid (channel)), channel);
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_channels);
}


void dvb_channel_list_remove (DVBChannelList* self, guint sid) {
	g_return_if_fail (self != NULL);
	g_static_rec_mutex_lock (&self->priv->__lock_channels);
	{
		gee_map_remove ((GeeMap*) self->channels, GUINT_TO_POINTER (sid));
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_channels);
}


gboolean dvb_channel_list_contains (DVBChannelList* self, guint sid) {
	gboolean val;
	g_return_val_if_fail (self != NULL, FALSE);
	val = FALSE;
	g_static_rec_mutex_lock (&self->priv->__lock_channels);
	{
		val = gee_map_contains ((GeeMap*) self->channels, GUINT_TO_POINTER (sid));
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_channels);
	return val;
}


void dvb_channel_list_clear (DVBChannelList* self) {
	g_return_if_fail (self != NULL);
	g_static_rec_mutex_lock (&self->priv->__lock_channels);
	{
		gee_map_clear ((GeeMap*) self->channels);
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_channels);
}


static GType dvb_channel_list_real_get_element_type (GeeIterable* base) {
	DVBChannelList * self;
	self = (DVBChannelList*) base;
	return DVB_TYPE_CHANNEL;
}


static GeeIterator* dvb_channel_list_real_iterator (GeeIterable* base) {
	DVBChannelList * self;
	GeeCollection* _tmp0;
	GeeIterator* _tmp1;
	self = (DVBChannelList*) base;
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = gee_map_get_values ((GeeMap*) self->channels))), (_tmp0 == NULL) ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)), _tmp1);
}


DVBChannelList* dvb_channel_list_restore_from_file (GFile* channelsfile, DVBAdapterType type, GError** error) {
	GError * inner_error;
	DVBChannelListReader* reader;
	DVBChannelList* _tmp0;
	DVBChannelList* _tmp1;
	g_return_val_if_fail (channelsfile != NULL, NULL);
	inner_error = NULL;
	/* FIXME make thread-safe*/
	reader = dvb_channel_list_reader_new (channelsfile, type);
	_tmp0 = dvb_channel_list_reader_read (reader, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		(reader == NULL) ? NULL : (reader = (g_object_unref (reader), NULL));
		return NULL;
	}
	_tmp1 = NULL;
	return (_tmp1 = _tmp0, (reader == NULL) ? NULL : (reader = (g_object_unref (reader), NULL)), _tmp1);
}


/**
         * @returns: List of channel IDs aka SIDs
         */
static guint* dvb_channel_list_real_GetChannels (DVBIDBusChannelList* base, int* result_length1) {
	DVBChannelList * self;
	guint* _tmp1;
	gint ids_size;
	gint ids_length1;
	gint _tmp0;
	guint* ids;
	gint i;
	guint* _tmp4;
	self = (DVBChannelList*) base;
	_tmp1 = NULL;
	ids = (_tmp1 = g_new0 (guint, _tmp0 = dvb_channel_list_get_size (self)), ids_length1 = _tmp0, ids_size = ids_length1, _tmp1);
	i = 0;
	g_static_rec_mutex_lock (&self->priv->__lock_channels);
	{
		{
			GeeSet* _tmp2;
			GeeIterator* _tmp3;
			GeeIterator* _id_it;
			_tmp2 = NULL;
			_tmp3 = NULL;
			_id_it = (_tmp3 = gee_iterable_iterator ((GeeIterable*) (_tmp2 = gee_map_get_keys ((GeeMap*) self->channels))), (_tmp2 == NULL) ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)), _tmp3);
			while (gee_iterator_next (_id_it)) {
				guint id;
				id = GPOINTER_TO_UINT (gee_iterator_get (_id_it));
				ids[i] = id;
				i++;
			}
			(_id_it == NULL) ? NULL : (_id_it = (g_object_unref (_id_it), NULL));
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_channels);
	_tmp4 = NULL;
	return (_tmp4 = ids, *result_length1 = ids_length1, _tmp4);
}


/**
         * @returns: List of channel IDs aka SIDs of radio channels
         */
static guint* dvb_channel_list_real_GetRadioChannels (DVBIDBusChannelList* base, int* result_length1) {
	DVBChannelList * self;
	GSList* radio_channels;
	guint* _tmp3;
	gint ids_size;
	gint ids_length1;
	gint _tmp2;
	guint* ids;
	guint* _tmp4;
	guint* _tmp5;
	self = (DVBChannelList*) base;
	radio_channels = NULL;
	g_static_rec_mutex_lock (&self->priv->__lock_channels);
	{
		{
			GeeSet* _tmp0;
			GeeIterator* _tmp1;
			GeeIterator* _id_it;
			_tmp0 = NULL;
			_tmp1 = NULL;
			_id_it = (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = gee_map_get_keys ((GeeMap*) self->channels))), (_tmp0 == NULL) ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)), _tmp1);
			while (gee_iterator_next (_id_it)) {
				guint id;
				DVBChannel* chan;
				id = GPOINTER_TO_UINT (gee_iterator_get (_id_it));
				chan = (DVBChannel*) gee_map_get ((GeeMap*) self->channels, GUINT_TO_POINTER (id));
				if (dvb_channel_get_VideoPID (chan) == 0) {
					radio_channels = g_slist_prepend (radio_channels, GUINT_TO_POINTER (id));
				}
				(chan == NULL) ? NULL : (chan = (g_object_unref (chan), NULL));
			}
			(_id_it == NULL) ? NULL : (_id_it = (g_object_unref (_id_it), NULL));
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_channels);
	radio_channels = g_slist_reverse (radio_channels);
	_tmp3 = NULL;
	ids = (_tmp3 = g_new0 (guint, _tmp2 = g_slist_length (radio_channels)), ids_length1 = _tmp2, ids_size = ids_length1, _tmp3);
	{
		gint i;
		i = 0;
		for (; i < g_slist_length (radio_channels); i++) {
			ids[i] = GPOINTER_TO_UINT (g_slist_nth_data (radio_channels, (guint) i));
		}
	}
	_tmp4 = NULL;
	_tmp5 = NULL;
	return (_tmp5 = (_tmp4 = ids, *result_length1 = ids_length1, _tmp4), (radio_channels == NULL) ? NULL : (radio_channels = (g_slist_free (radio_channels), NULL)), _tmp5);
}


/**
         * @returns: List of channel IDs aka SIDs of TV channels
         */
static guint* dvb_channel_list_real_GetTVChannels (DVBIDBusChannelList* base, int* result_length1) {
	DVBChannelList * self;
	GSList* video_channels;
	guint* _tmp3;
	gint ids_size;
	gint ids_length1;
	gint _tmp2;
	guint* ids;
	guint* _tmp4;
	guint* _tmp5;
	self = (DVBChannelList*) base;
	video_channels = NULL;
	g_static_rec_mutex_lock (&self->priv->__lock_channels);
	{
		{
			GeeSet* _tmp0;
			GeeIterator* _tmp1;
			GeeIterator* _id_it;
			_tmp0 = NULL;
			_tmp1 = NULL;
			_id_it = (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = gee_map_get_keys ((GeeMap*) self->channels))), (_tmp0 == NULL) ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)), _tmp1);
			while (gee_iterator_next (_id_it)) {
				guint id;
				DVBChannel* chan;
				id = GPOINTER_TO_UINT (gee_iterator_get (_id_it));
				chan = (DVBChannel*) gee_map_get ((GeeMap*) self->channels, GUINT_TO_POINTER (id));
				if (dvb_channel_get_VideoPID (chan) != 0) {
					video_channels = g_slist_prepend (video_channels, GUINT_TO_POINTER (id));
				}
				(chan == NULL) ? NULL : (chan = (g_object_unref (chan), NULL));
			}
			(_id_it == NULL) ? NULL : (_id_it = (g_object_unref (_id_it), NULL));
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_channels);
	video_channels = g_slist_reverse (video_channels);
	_tmp3 = NULL;
	ids = (_tmp3 = g_new0 (guint, _tmp2 = g_slist_length (video_channels)), ids_length1 = _tmp2, ids_size = ids_length1, _tmp3);
	{
		gint i;
		i = 0;
		for (; i < g_slist_length (video_channels); i++) {
			ids[i] = GPOINTER_TO_UINT (g_slist_nth_data (video_channels, (guint) i));
		}
	}
	_tmp4 = NULL;
	_tmp5 = NULL;
	return (_tmp5 = (_tmp4 = ids, *result_length1 = ids_length1, _tmp4), (video_channels == NULL) ? NULL : (video_channels = (g_slist_free (video_channels), NULL)), _tmp5);
}


/**
         * @channel_id: ID of channel
         * @returns: Name of channel if channel with id exists
         * otherwise an empty string
         */
static char* dvb_channel_list_real_GetChannelName (DVBIDBusChannelList* base, guint channel_id) {
	DVBChannelList * self;
	char* val;
	self = (DVBChannelList*) base;
	val = g_strdup ("");
	g_static_rec_mutex_lock (&self->priv->__lock_channels);
	{
		if (gee_map_contains ((GeeMap*) self->channels, GUINT_TO_POINTER (channel_id))) {
			const char* _tmp1;
			DVBChannel* _tmp0;
			char* _tmp2;
			char* name;
			_tmp1 = NULL;
			_tmp0 = NULL;
			_tmp2 = NULL;
			name = (_tmp2 = (_tmp1 = dvb_channel_get_Name (_tmp0 = (DVBChannel*) gee_map_get ((GeeMap*) self->channels, GUINT_TO_POINTER (channel_id))), (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), (_tmp0 == NULL) ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)), _tmp2);
			if (name != NULL) {
				char* _tmp4;
				const char* _tmp3;
				_tmp4 = NULL;
				_tmp3 = NULL;
				val = (_tmp4 = (_tmp3 = name, (_tmp3 == NULL) ? NULL : g_strdup (_tmp3)), val = (g_free (val), NULL), _tmp4);
			}
			name = (g_free (name), NULL);
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_channels);
	return val;
}


/**
         * @channel_id: ID of channel
         * @returns: Name of network the channel belongs to
         * if the channel with id exists, otherwise an empty
         * string
         */
static char* dvb_channel_list_real_GetChannelNetwork (DVBIDBusChannelList* base, guint channel_id) {
	DVBChannelList * self;
	char* val;
	self = (DVBChannelList*) base;
	val = g_strdup ("");
	g_static_rec_mutex_lock (&self->priv->__lock_channels);
	{
		if (gee_map_contains ((GeeMap*) self->channels, GUINT_TO_POINTER (channel_id))) {
			const char* _tmp1;
			DVBChannel* _tmp0;
			char* _tmp2;
			char* network;
			_tmp1 = NULL;
			_tmp0 = NULL;
			_tmp2 = NULL;
			network = (_tmp2 = (_tmp1 = dvb_channel_get_Network (_tmp0 = (DVBChannel*) gee_map_get ((GeeMap*) self->channels, GUINT_TO_POINTER (channel_id))), (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), (_tmp0 == NULL) ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)), _tmp2);
			if (network != NULL) {
				char* _tmp4;
				const char* _tmp3;
				_tmp4 = NULL;
				_tmp3 = NULL;
				val = (_tmp4 = (_tmp3 = network, (_tmp3 == NULL) ? NULL : g_strdup (_tmp3)), val = (g_free (val), NULL), _tmp4);
			}
			network = (g_free (network), NULL);
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_channels);
	return val;
}


/**
         * @channel_id: ID of channel
         * @returns: Whether the channel is a radio channel or not
         */
static gboolean dvb_channel_list_real_IsRadioChannel (DVBIDBusChannelList* base, guint channel_id) {
	DVBChannelList * self;
	gboolean val;
	self = (DVBChannelList*) base;
	val = FALSE;
	g_static_rec_mutex_lock (&self->priv->__lock_channels);
	{
		if (gee_map_contains ((GeeMap*) self->channels, GUINT_TO_POINTER (channel_id))) {
			DVBChannel* _tmp0;
			_tmp0 = NULL;
			val = (dvb_channel_get_VideoPID (_tmp0 = (DVBChannel*) gee_map_get ((GeeMap*) self->channels, GUINT_TO_POINTER (channel_id))) == 0);
			(_tmp0 == NULL) ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL));
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_channels);
	return val;
}


/**
         * @channel_id: ID of channel
         * @returns: URL to watch the channel
         */
static char* dvb_channel_list_real_GetChannelURL (DVBIDBusChannelList* base, guint channel_id) {
	DVBChannelList * self;
	char* url;
	self = (DVBChannelList*) base;
	url = g_strdup ("");
	g_static_rec_mutex_lock (&self->priv->__lock_channels);
	{
		if (gee_map_contains ((GeeMap*) self->channels, GUINT_TO_POINTER (channel_id))) {
			DVBChannel* channel;
			char* _tmp0;
			channel = (DVBChannel*) gee_map_get ((GeeMap*) self->channels, GUINT_TO_POINTER (channel_id));
			_tmp0 = NULL;
			url = (_tmp0 = g_strdup_printf ("rtsp://localhost:1554/%u/%u", self->priv->_group_id, dvb_channel_get_Sid (channel)), url = (g_free (url), NULL), _tmp0);
			(channel == NULL) ? NULL : (channel = (g_object_unref (channel), NULL));
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_channels);
	return url;
}


GFile* dvb_channel_list_get_channels_file (DVBChannelList* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_channels_file;
}


static void dvb_channel_list_set_channels_file (DVBChannelList* self, GFile* value) {
	GFile* _tmp2;
	GFile* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_channels_file = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_channels_file == NULL) ? NULL : (self->priv->_channels_file = (g_object_unref (self->priv->_channels_file), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "channels-file");
}


gint dvb_channel_list_get_size (DVBChannelList* self) {
	g_return_val_if_fail (self != NULL, 0);
	return gee_map_get_size ((GeeMap*) self->channels);
}


guint dvb_channel_list_get_group_id (DVBChannelList* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return self->priv->_group_id;
}


void dvb_channel_list_set_group_id (DVBChannelList* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_group_id = value;
	g_object_notify ((GObject *) self, "group-id");
}


static GObject * dvb_channel_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	DVBChannelListClass * klass;
	GObjectClass * parent_class;
	DVBChannelList * self;
	klass = DVB_CHANNEL_LIST_CLASS (g_type_class_peek (DVB_TYPE_CHANNEL_LIST));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_CHANNEL_LIST (obj);
	{
		GeeHashMap* _tmp0;
		_tmp0 = NULL;
		self->channels = (_tmp0 = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_TYPE_CHANNEL, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal), (self->channels == NULL) ? NULL : (self->channels = (g_object_unref (self->channels), NULL)), _tmp0);
	}
	return obj;
}


static void dvb_channel_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBChannelList * self;
	gpointer boxed;
	self = DVB_CHANNEL_LIST (object);
	switch (property_id) {
		case DVB_CHANNEL_LIST_CHANNELS_FILE:
		g_value_set_object (value, dvb_channel_list_get_channels_file (self));
		break;
		case DVB_CHANNEL_LIST_SIZE:
		g_value_set_int (value, dvb_channel_list_get_size (self));
		break;
		case DVB_CHANNEL_LIST_GROUP_ID:
		g_value_set_uint (value, dvb_channel_list_get_group_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_channel_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBChannelList * self;
	self = DVB_CHANNEL_LIST (object);
	switch (property_id) {
		case DVB_CHANNEL_LIST_CHANNELS_FILE:
		dvb_channel_list_set_channels_file (self, g_value_get_object (value));
		break;
		case DVB_CHANNEL_LIST_GROUP_ID:
		dvb_channel_list_set_group_id (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


void _dvb_channel_list_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_dvb_channel_list_introspect (DVBChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.ChannelList\">\n  <method name=\"GetChannels\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetRadioChannels\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetTVChannels\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelName\">\n    <arg name=\"channel_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelNetwork\">\n    <arg name=\"channel_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"IsRadioChannel\">\n    <arg name=\"channel_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelURL\">\n    <arg name=\"channel_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <signal name=\"Changed\">\n    <arg name=\"channel_id\" type=\"u\"/>\n    <arg name=\"type\" type=\"u\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


DBusHandlerResult dvb_channel_list_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_dvb_channel_list_introspect (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else if (dvb_id_bus_channel_list_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dvb_channel_list_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_channel_list_dbus_path_vtable, object);
	}
	dvb_id_bus_channel_list_dbus_register_object (connection, path, object);
}


static void dvb_channel_list_class_init (DVBChannelListClass * klass) {
	dvb_channel_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBChannelListPrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_channel_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_channel_list_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_channel_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_channel_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_LIST_CHANNELS_FILE, g_param_spec_object ("channels-file", "channels-file", "channels-file", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_LIST_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_LIST_GROUP_ID, g_param_spec_uint ("group-id", "group-id", "group-id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_type_set_qdata (DVB_TYPE_CHANNEL_LIST, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_channel_list_dbus_vtable));
}


static void dvb_channel_list_gee_iterable_interface_init (GeeIterableIface * iface) {
	dvb_channel_list_gee_iterable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_element_type = dvb_channel_list_real_get_element_type;
	iface->iterator = dvb_channel_list_real_iterator;
}


static void dvb_channel_list_dvb_id_bus_channel_list_interface_init (DVBIDBusChannelListIface * iface) {
	dvb_channel_list_dvb_id_bus_channel_list_parent_iface = g_type_interface_peek_parent (iface);
	iface->GetChannels = dvb_channel_list_real_GetChannels;
	iface->GetRadioChannels = dvb_channel_list_real_GetRadioChannels;
	iface->GetTVChannels = dvb_channel_list_real_GetTVChannels;
	iface->GetChannelName = dvb_channel_list_real_GetChannelName;
	iface->GetChannelNetwork = dvb_channel_list_real_GetChannelNetwork;
	iface->IsRadioChannel = dvb_channel_list_real_IsRadioChannel;
	iface->GetChannelURL = dvb_channel_list_real_GetChannelURL;
}


static void dvb_channel_list_instance_init (DVBChannelList * self) {
	self->priv = DVB_CHANNEL_LIST_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_channels);
}


static void dvb_channel_list_finalize (GObject* obj) {
	DVBChannelList * self;
	self = DVB_CHANNEL_LIST (obj);
	(self->priv->_channels_file == NULL) ? NULL : (self->priv->_channels_file = (g_object_unref (self->priv->_channels_file), NULL));
	g_static_rec_mutex_free (&self->priv->__lock_channels);
	(self->channels == NULL) ? NULL : (self->channels = (g_object_unref (self->channels), NULL));
	G_OBJECT_CLASS (dvb_channel_list_parent_class)->finalize (obj);
}


GType dvb_channel_list_get_type (void) {
	static GType dvb_channel_list_type_id = 0;
	if (dvb_channel_list_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBChannelListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_channel_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBChannelList), 0, (GInstanceInitFunc) dvb_channel_list_instance_init, NULL };
		static const GInterfaceInfo gee_iterable_info = { (GInterfaceInitFunc) dvb_channel_list_gee_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo dvb_id_bus_channel_list_info = { (GInterfaceInitFunc) dvb_channel_list_dvb_id_bus_channel_list_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		dvb_channel_list_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBChannelList", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_channel_list_type_id, GEE_TYPE_ITERABLE, &gee_iterable_info);
		g_type_add_interface_static (dvb_channel_list_type_id, DVB_TYPE_ID_BUS_CHANNEL_LIST, &dvb_id_bus_channel_list_info);
	}
	return dvb_channel_list_type_id;
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}




