
#ifndef __SRC_IDBUSRECORDINGSSTORE_H__
#define __SRC_IDBUSRECORDINGSSTORE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>

G_BEGIN_DECLS


#define DVB_TYPE_ID_BUS_RECORDINGS_STORE (dvb_id_bus_recordings_store_get_type ())
#define DVB_ID_BUS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_RECORDINGS_STORE, DVBIDBusRecordingsStore))
#define DVB_IS_ID_BUS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_RECORDINGS_STORE))
#define DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_RECORDINGS_STORE, DVBIDBusRecordingsStoreIface))

typedef struct _DVBIDBusRecordingsStore DVBIDBusRecordingsStore;
typedef struct _DVBIDBusRecordingsStoreIface DVBIDBusRecordingsStoreIface;

struct _DVBIDBusRecordingsStoreIface {
	GTypeInterface parent_iface;
	guint32* (*GetRecordings) (DVBIDBusRecordingsStore* self, int* result_length1);
	char* (*GetLocation) (DVBIDBusRecordingsStore* self, guint32 rec_id);
	char* (*GetName) (DVBIDBusRecordingsStore* self, guint32 rec_id);
	char* (*GetDescription) (DVBIDBusRecordingsStore* self, guint32 rec_id);
	guint* (*GetStartTime) (DVBIDBusRecordingsStore* self, guint32 rec_id, int* result_length1);
	gint64 (*GetStartTimestamp) (DVBIDBusRecordingsStore* self, guint32 rec_id);
	gint64 (*GetLength) (DVBIDBusRecordingsStore* self, guint32 rec_id);
	gboolean (*Delete) (DVBIDBusRecordingsStore* self, guint32 rec_id);
};


guint32* dvb_id_bus_recordings_store_GetRecordings (DVBIDBusRecordingsStore* self, int* result_length1);
char* dvb_id_bus_recordings_store_GetLocation (DVBIDBusRecordingsStore* self, guint32 rec_id);
char* dvb_id_bus_recordings_store_GetName (DVBIDBusRecordingsStore* self, guint32 rec_id);
char* dvb_id_bus_recordings_store_GetDescription (DVBIDBusRecordingsStore* self, guint32 rec_id);
guint* dvb_id_bus_recordings_store_GetStartTime (DVBIDBusRecordingsStore* self, guint32 rec_id, int* result_length1);
gint64 dvb_id_bus_recordings_store_GetStartTimestamp (DVBIDBusRecordingsStore* self, guint32 rec_id);
gint64 dvb_id_bus_recordings_store_GetLength (DVBIDBusRecordingsStore* self, guint32 rec_id);
gboolean dvb_id_bus_recordings_store_Delete (DVBIDBusRecordingsStore* self, guint32 rec_id);
void dvb_id_bus_recordings_store_dbus_register_object (DBusConnection* connection, const char* path, void* object);
DBusHandlerResult dvb_id_bus_recordings_store_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
GType dvb_id_bus_recordings_store_get_type (void);
DVBIDBusRecordingsStore* dvb_id_bus_recordings_store_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);


G_END_DECLS

#endif
