
#include <src/Terrestrial/TerrestrialScanner.h>
#include <gio/gio.h>
#include "src/Utils.h"
#include "src/MpegTsEnums.h"
#include "src/Terrestrial/TerrestrialChannel.h"

typedef DBusGProxy DVBIDBusTerrestrialScannerDBusProxy;
typedef DBusGProxyClass DVBIDBusTerrestrialScannerDBusProxyClass;
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};



void _dvb_id_bus_terrestrial_scanner_dbus_unregister (DBusConnection* connection, void* user_data);
static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_introspect (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_property_get_all (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_Run (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_Destroy (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_WriteChannelsToFile (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_AddScanningData (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_AddScanningDataFromFile (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_dvb_id_bus_terrestrial_scanner_frequency_scanned (GObject* _sender, guint frequency, guint freq_left, DBusConnection* _connection);
static void _dbus_dvb_id_bus_terrestrial_scanner_finished (GObject* _sender, DBusConnection* _connection);
static void _dbus_dvb_id_bus_terrestrial_scanner_channel_added (GObject* _sender, guint frequency, guint sid, const char* name, const char* network, const char* type, gboolean scrambled, DBusConnection* _connection);
static void _dbus_handle_dvb_id_bus_terrestrial_scanner_frequency_scanned (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_dvb_id_bus_terrestrial_scanner_finished (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_dvb_id_bus_terrestrial_scanner_channel_added (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult dvb_id_bus_terrestrial_scanner_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
static void dvb_id_bus_terrestrial_scanner_dbus_proxy_Run (DVBIDBusTerrestrialScanner* self);
static void dvb_id_bus_terrestrial_scanner_dbus_proxy_Destroy (DVBIDBusTerrestrialScanner* self);
static gboolean dvb_id_bus_terrestrial_scanner_dbus_proxy_WriteChannelsToFile (DVBIDBusTerrestrialScanner* self, const char* path);
static void dvb_id_bus_terrestrial_scanner_dbus_proxy_AddScanningData (DVBIDBusTerrestrialScanner* self, guint frequency, guint hierarchy, guint bandwidth, const char* transmode, const char* code_rate_hp, const char* code_rate_lp, const char* constellation, guint guard);
static gboolean dvb_id_bus_terrestrial_scanner_dbus_proxy_AddScanningDataFromFile (DVBIDBusTerrestrialScanner* self, const char* path);
static void dvb_id_bus_terrestrial_scanner_dbus_proxy_interface_init (DVBIDBusTerrestrialScannerIface* iface);
enum  {
	DVB_TERRESTRIAL_SCANNER_DUMMY_PROPERTY
};
static void dvb_terrestrial_scanner_real_AddScanningData (DVBIDBusTerrestrialScanner* base, guint frequency, guint hierarchy, guint bandwidth, const char* transmode, const char* code_rate_hp, const char* code_rate_lp, const char* constellation, guint guard);
static gboolean dvb_terrestrial_scanner_real_AddScanningDataFromFile (DVBIDBusTerrestrialScanner* base, const char* path);
static void dvb_terrestrial_scanner_real_prepare (DVBScanner* base);
static DVBScannedItem* dvb_terrestrial_scanner_real_get_scanned_item (DVBScanner* base, const GstStructure* structure);
static DVBChannel* dvb_terrestrial_scanner_real_get_new_channel (DVBScanner* base);
static void dvb_terrestrial_scanner_real_add_values_from_structure_to_channel (DVBScanner* base, const GstStructure* delivery, DVBChannel* channel);
static gpointer dvb_terrestrial_scanner_parent_class = NULL;
void _dvb_terrestrial_scanner_dbus_unregister (DBusConnection* connection, void* user_data);
static DBusMessage* _dbus_dvb_terrestrial_scanner_introspect (DVBTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message);
static DVBIDBusTerrestrialScannerIface* dvb_terrestrial_scanner_dvb_id_bus_terrestrial_scanner_parent_iface = NULL;
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);

static const DBusObjectPathVTable _dvb_id_bus_terrestrial_scanner_dbus_path_vtable = {_dvb_id_bus_terrestrial_scanner_dbus_unregister, dvb_id_bus_terrestrial_scanner_dbus_message};
static const _DBusObjectVTable _dvb_id_bus_terrestrial_scanner_dbus_vtable = {dvb_id_bus_terrestrial_scanner_dbus_register_object};
static const DBusObjectPathVTable _dvb_terrestrial_scanner_dbus_path_vtable = {_dvb_terrestrial_scanner_dbus_unregister, dvb_terrestrial_scanner_dbus_message};
static const _DBusObjectVTable _dvb_terrestrial_scanner_dbus_vtable = {dvb_terrestrial_scanner_dbus_register_object};

static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

void dvb_id_bus_terrestrial_scanner_Run (DVBIDBusTerrestrialScanner* self) {
	DVB_ID_BUS_TERRESTRIAL_SCANNER_GET_INTERFACE (self)->Run (self);
}


void dvb_id_bus_terrestrial_scanner_Destroy (DVBIDBusTerrestrialScanner* self) {
	DVB_ID_BUS_TERRESTRIAL_SCANNER_GET_INTERFACE (self)->Destroy (self);
}


gboolean dvb_id_bus_terrestrial_scanner_WriteChannelsToFile (DVBIDBusTerrestrialScanner* self, const char* path) {
	return DVB_ID_BUS_TERRESTRIAL_SCANNER_GET_INTERFACE (self)->WriteChannelsToFile (self, path);
}


void dvb_id_bus_terrestrial_scanner_AddScanningData (DVBIDBusTerrestrialScanner* self, guint frequency, guint hierarchy, guint bandwidth, const char* transmode, const char* code_rate_hp, const char* code_rate_lp, const char* constellation, guint guard) {
	DVB_ID_BUS_TERRESTRIAL_SCANNER_GET_INTERFACE (self)->AddScanningData (self, frequency, hierarchy, bandwidth, transmode, code_rate_hp, code_rate_lp, constellation, guard);
}


/* 0-3
 0, 6, 7, 8
 "2k", "8k"
 "1/2", "2/3", "3/4", ..., "8/9"
 QPSK, QAM16, QAM64
 4, 8, 16, 32
*
         * @path: Path to file containing scanning data
         * @returns: TRUE when the file has been parsed successfully
         *
         * Parses initial tuning data from a file as provided by dvb-apps
         */
gboolean dvb_id_bus_terrestrial_scanner_AddScanningDataFromFile (DVBIDBusTerrestrialScanner* self, const char* path) {
	return DVB_ID_BUS_TERRESTRIAL_SCANNER_GET_INTERFACE (self)->AddScanningDataFromFile (self, path);
}


void _dvb_id_bus_terrestrial_scanner_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_introspect (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.Scanner.Terrestrial\">\n  <method name=\"Run\">\n  </method>\n  <method name=\"Destroy\">\n  </method>\n  <method name=\"WriteChannelsToFile\">\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"AddScanningData\">\n    <arg name=\"frequency\" type=\"u\" direction=\"in\"/>\n    <arg name=\"hierarchy\" type=\"u\" direction=\"in\"/>\n    <arg name=\"bandwidth\" type=\"u\" direction=\"in\"/>\n    <arg name=\"transmode\" type=\"s\" direction=\"in\"/>\n    <arg name=\"code_rate_hp\" type=\"s\" direction=\"in\"/>\n    <arg name=\"code_rate_lp\" type=\"s\" direction=\"in\"/>\n    <arg name=\"constellation\" type=\"s\" direction=\"in\"/>\n    <arg name=\"guard\" type=\"u\" direction=\"in\"/>\n  </method>\n  <method name=\"AddScanningDataFromFile\">\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <signal name=\"FrequencyScanned\">\n    <arg name=\"frequency\" type=\"u\"/>\n    <arg name=\"freq_left\" type=\"u\"/>\n  </signal>\n  <signal name=\"Finished\">\n  </signal>\n  <signal name=\"ChannelAdded\">\n    <arg name=\"frequency\" type=\"u\"/>\n    <arg name=\"sid\" type=\"u\"/>\n    <arg name=\"name\" type=\"s\"/>\n    <arg name=\"network\" type=\"s\"/>\n    <arg name=\"type\" type=\"s\"/>\n    <arg name=\"scrambled\" type=\"b\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_property_get_all (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0);
	if (strcmp (interface_name, "org.gnome.DVB.Scanner.Terrestrial") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		return NULL;
	}
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_Run (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	dvb_id_bus_terrestrial_scanner_Run (self);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_Destroy (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	dvb_id_bus_terrestrial_scanner_Destroy (self);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_WriteChannelsToFile (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	const char* path;
	const char* _tmp1;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp2;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	path = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp1);
	dbus_message_iter_next (&iter);
	path = g_strdup (_tmp1);
	result = dvb_id_bus_terrestrial_scanner_WriteChannelsToFile (self, path);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp2 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp2);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_AddScanningData (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint frequency;
	dbus_uint32_t _tmp3;
	guint hierarchy;
	dbus_uint32_t _tmp4;
	guint bandwidth;
	dbus_uint32_t _tmp5;
	const char* transmode;
	const char* _tmp6;
	const char* code_rate_hp;
	const char* _tmp7;
	const char* code_rate_lp;
	const char* _tmp8;
	const char* constellation;
	const char* _tmp9;
	guint guard;
	dbus_uint32_t _tmp10;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "uuussssu")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	frequency = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp3);
	dbus_message_iter_next (&iter);
	frequency = _tmp3;
	hierarchy = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp4);
	dbus_message_iter_next (&iter);
	hierarchy = _tmp4;
	bandwidth = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp5);
	dbus_message_iter_next (&iter);
	bandwidth = _tmp5;
	transmode = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp6);
	dbus_message_iter_next (&iter);
	transmode = g_strdup (_tmp6);
	code_rate_hp = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp7);
	dbus_message_iter_next (&iter);
	code_rate_hp = g_strdup (_tmp7);
	code_rate_lp = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp8);
	dbus_message_iter_next (&iter);
	code_rate_lp = g_strdup (_tmp8);
	constellation = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp9);
	dbus_message_iter_next (&iter);
	constellation = g_strdup (_tmp9);
	guard = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp10);
	dbus_message_iter_next (&iter);
	guard = _tmp10;
	dvb_id_bus_terrestrial_scanner_AddScanningData (self, frequency, hierarchy, bandwidth, transmode, code_rate_hp, code_rate_lp, constellation, guard);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_terrestrial_scanner_AddScanningDataFromFile (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	const char* path;
	const char* _tmp11;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp12;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	path = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp11);
	dbus_message_iter_next (&iter);
	path = g_strdup (_tmp11);
	result = dvb_id_bus_terrestrial_scanner_AddScanningDataFromFile (self, path);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp12 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp12);
	return reply;
}


DBusHandlerResult dvb_id_bus_terrestrial_scanner_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_dvb_id_bus_terrestrial_scanner_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		reply = _dbus_dvb_id_bus_terrestrial_scanner_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Terrestrial", "Run")) {
		reply = _dbus_dvb_id_bus_terrestrial_scanner_Run (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Terrestrial", "Destroy")) {
		reply = _dbus_dvb_id_bus_terrestrial_scanner_Destroy (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Terrestrial", "WriteChannelsToFile")) {
		reply = _dbus_dvb_id_bus_terrestrial_scanner_WriteChannelsToFile (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Terrestrial", "AddScanningData")) {
		reply = _dbus_dvb_id_bus_terrestrial_scanner_AddScanningData (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Terrestrial", "AddScanningDataFromFile")) {
		reply = _dbus_dvb_id_bus_terrestrial_scanner_AddScanningDataFromFile (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_dvb_id_bus_terrestrial_scanner_frequency_scanned (GObject* _sender, guint frequency, guint freq_left, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp13;
	dbus_uint32_t _tmp14;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.Scanner.Terrestrial", "FrequencyScanned");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp13 = frequency;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp13);
	_tmp14 = freq_left;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp14);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_dvb_id_bus_terrestrial_scanner_finished (GObject* _sender, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.Scanner.Terrestrial", "Finished");
	dbus_message_iter_init_append (_message, &_iter);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_dvb_id_bus_terrestrial_scanner_channel_added (GObject* _sender, guint frequency, guint sid, const char* name, const char* network, const char* type, gboolean scrambled, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp15;
	dbus_uint32_t _tmp16;
	const char* _tmp17;
	const char* _tmp18;
	const char* _tmp19;
	dbus_bool_t _tmp20;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.Scanner.Terrestrial", "ChannelAdded");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp15 = frequency;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp15);
	_tmp16 = sid;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp16);
	_tmp17 = name;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp17);
	_tmp18 = network;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp18);
	_tmp19 = type;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp19);
	_tmp20 = scrambled;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_BOOLEAN, &_tmp20);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void dvb_id_bus_terrestrial_scanner_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_id_bus_terrestrial_scanner_dbus_path_vtable, object);
	}
	g_signal_connect (object, "frequency-scanned", (GCallback) _dbus_dvb_id_bus_terrestrial_scanner_frequency_scanned, connection);
	g_signal_connect (object, "finished", (GCallback) _dbus_dvb_id_bus_terrestrial_scanner_finished, connection);
	g_signal_connect (object, "channel-added", (GCallback) _dbus_dvb_id_bus_terrestrial_scanner_channel_added, connection);
}


static void dvb_id_bus_terrestrial_scanner_base_init (DVBIDBusTerrestrialScannerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("frequency_scanned", DVB_TYPE_ID_BUS_TERRESTRIAL_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
		g_signal_new ("finished", DVB_TYPE_ID_BUS_TERRESTRIAL_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		g_signal_new ("channel_added", DVB_TYPE_ID_BUS_TERRESTRIAL_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN, G_TYPE_NONE, 6, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN);
		g_type_set_qdata (DVB_TYPE_ID_BUS_TERRESTRIAL_SCANNER, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_id_bus_terrestrial_scanner_dbus_vtable));
	}
}


GType dvb_id_bus_terrestrial_scanner_get_type (void) {
	static GType dvb_id_bus_terrestrial_scanner_type_id = 0;
	if (dvb_id_bus_terrestrial_scanner_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusTerrestrialScannerIface), (GBaseInitFunc) dvb_id_bus_terrestrial_scanner_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_id_bus_terrestrial_scanner_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusTerrestrialScanner", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_terrestrial_scanner_type_id, G_TYPE_OBJECT);
	}
	return dvb_id_bus_terrestrial_scanner_type_id;
}


G_DEFINE_TYPE_EXTENDED (DVBIDBusTerrestrialScannerDBusProxy, dvb_id_bus_terrestrial_scanner_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (DVB_TYPE_ID_BUS_TERRESTRIAL_SCANNER, dvb_id_bus_terrestrial_scanner_dbus_proxy_interface_init));
DVBIDBusTerrestrialScanner* dvb_id_bus_terrestrial_scanner_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	DVBIDBusTerrestrialScanner* self;
	char* filter;
	self = g_object_new (dvb_id_bus_terrestrial_scanner_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.DVB.Scanner.Terrestrial", NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), dvb_id_bus_terrestrial_scanner_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	g_free (filter);
	return self;
}


static void _dbus_handle_dvb_id_bus_terrestrial_scanner_frequency_scanned (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	guint frequency;
	dbus_uint32_t _tmp21;
	guint freq_left;
	dbus_uint32_t _tmp22;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "uu")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	frequency = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp21);
	dbus_message_iter_next (&iter);
	frequency = _tmp21;
	freq_left = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp22);
	dbus_message_iter_next (&iter);
	freq_left = _tmp22;
	g_signal_emit_by_name (self, "frequency-scanned", frequency, freq_left);
}


static void _dbus_handle_dvb_id_bus_terrestrial_scanner_finished (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	g_signal_emit_by_name (self, "finished");
}


static void _dbus_handle_dvb_id_bus_terrestrial_scanner_channel_added (DVBIDBusTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	guint frequency;
	dbus_uint32_t _tmp23;
	guint sid;
	dbus_uint32_t _tmp24;
	const char* name;
	const char* _tmp25;
	const char* network;
	const char* _tmp26;
	const char* type;
	const char* _tmp27;
	gboolean scrambled;
	dbus_bool_t _tmp28;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "uusssb")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	frequency = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp23);
	dbus_message_iter_next (&iter);
	frequency = _tmp23;
	sid = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp24);
	dbus_message_iter_next (&iter);
	sid = _tmp24;
	name = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp25);
	dbus_message_iter_next (&iter);
	name = g_strdup (_tmp25);
	network = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp26);
	dbus_message_iter_next (&iter);
	network = g_strdup (_tmp26);
	type = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp27);
	dbus_message_iter_next (&iter);
	type = g_strdup (_tmp27);
	scrambled = FALSE;
	dbus_message_iter_get_basic (&iter, &_tmp28);
	dbus_message_iter_next (&iter);
	scrambled = _tmp28;
	g_signal_emit_by_name (self, "channel-added", frequency, sid, name, network, type, scrambled);
}


DBusHandlerResult dvb_id_bus_terrestrial_scanner_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_is_signal (message, "org.gnome.DVB.Scanner.Terrestrial", "FrequencyScanned")) {
		_dbus_handle_dvb_id_bus_terrestrial_scanner_frequency_scanned (user_data, connection, message);
	} else if (dbus_message_is_signal (message, "org.gnome.DVB.Scanner.Terrestrial", "Finished")) {
		_dbus_handle_dvb_id_bus_terrestrial_scanner_finished (user_data, connection, message);
	} else if (dbus_message_is_signal (message, "org.gnome.DVB.Scanner.Terrestrial", "ChannelAdded")) {
		_dbus_handle_dvb_id_bus_terrestrial_scanner_channel_added (user_data, connection, message);
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void dvb_id_bus_terrestrial_scanner_dbus_proxy_class_init (DVBIDBusTerrestrialScannerDBusProxyClass* klass) {
}


static void dvb_id_bus_terrestrial_scanner_dbus_proxy_init (DVBIDBusTerrestrialScannerDBusProxy* self) {
}


static void dvb_id_bus_terrestrial_scanner_dbus_proxy_Run (DVBIDBusTerrestrialScanner* self) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Terrestrial", "Run");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void dvb_id_bus_terrestrial_scanner_dbus_proxy_Destroy (DVBIDBusTerrestrialScanner* self) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Terrestrial", "Destroy");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static gboolean dvb_id_bus_terrestrial_scanner_dbus_proxy_WriteChannelsToFile (DVBIDBusTerrestrialScanner* self, const char* path) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp29;
	gboolean _result;
	dbus_bool_t _tmp30;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Terrestrial", "WriteChannelsToFile");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp29 = path;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp29);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp30);
	dbus_message_iter_next (&_iter);
	_result = _tmp30;
	dbus_message_unref (_reply);
	return _result;
}


static void dvb_id_bus_terrestrial_scanner_dbus_proxy_AddScanningData (DVBIDBusTerrestrialScanner* self, guint frequency, guint hierarchy, guint bandwidth, const char* transmode, const char* code_rate_hp, const char* code_rate_lp, const char* constellation, guint guard) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp31;
	dbus_uint32_t _tmp32;
	dbus_uint32_t _tmp33;
	const char* _tmp34;
	const char* _tmp35;
	const char* _tmp36;
	const char* _tmp37;
	dbus_uint32_t _tmp38;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Terrestrial", "AddScanningData");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp31 = frequency;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp31);
	_tmp32 = hierarchy;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp32);
	_tmp33 = bandwidth;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp33);
	_tmp34 = transmode;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp34);
	_tmp35 = code_rate_hp;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp35);
	_tmp36 = code_rate_lp;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp36);
	_tmp37 = constellation;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp37);
	_tmp38 = guard;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp38);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static gboolean dvb_id_bus_terrestrial_scanner_dbus_proxy_AddScanningDataFromFile (DVBIDBusTerrestrialScanner* self, const char* path) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp39;
	gboolean _result;
	dbus_bool_t _tmp40;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Terrestrial", "AddScanningDataFromFile");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp39 = path;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp39);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp40);
	dbus_message_iter_next (&_iter);
	_result = _tmp40;
	dbus_message_unref (_reply);
	return _result;
}


static void dvb_id_bus_terrestrial_scanner_dbus_proxy_interface_init (DVBIDBusTerrestrialScannerIface* iface) {
	iface->Run = dvb_id_bus_terrestrial_scanner_dbus_proxy_Run;
	iface->Destroy = dvb_id_bus_terrestrial_scanner_dbus_proxy_Destroy;
	iface->WriteChannelsToFile = dvb_id_bus_terrestrial_scanner_dbus_proxy_WriteChannelsToFile;
	iface->AddScanningData = dvb_id_bus_terrestrial_scanner_dbus_proxy_AddScanningData;
	iface->AddScanningDataFromFile = dvb_id_bus_terrestrial_scanner_dbus_proxy_AddScanningDataFromFile;
}


DVBTerrestrialScanner* dvb_terrestrial_scanner_construct (GType object_type, DVBDevice* device) {
	GParameter * __params;
	GParameter * __params_it;
	DVBTerrestrialScanner * self;
	g_return_val_if_fail (device != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "Device";
	g_value_init (&__params_it->value, DVB_TYPE_DEVICE);
	g_value_set_object (&__params_it->value, device);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DVBTerrestrialScanner* dvb_terrestrial_scanner_new (DVBDevice* device) {
	return dvb_terrestrial_scanner_construct (DVB_TYPE_TERRESTRIAL_SCANNER, device);
}


/**
          * See enums in MpegTsEnums
          */
static void dvb_terrestrial_scanner_real_AddScanningData (DVBIDBusTerrestrialScanner* base, guint frequency, guint hierarchy, guint bandwidth, const char* transmode, const char* code_rate_hp, const char* code_rate_lp, const char* constellation, guint guard) {
	DVBTerrestrialScanner * self;
	GstStructure* tuning_params;
	GstStructure* _tmp0;
	self = (DVBTerrestrialScanner*) base;
	g_return_if_fail (transmode != NULL);
	g_return_if_fail (code_rate_hp != NULL);
	g_return_if_fail (code_rate_lp != NULL);
	g_return_if_fail (constellation != NULL);
	tuning_params = gst_structure_new ("tuning_params", "frequency", G_TYPE_UINT, frequency, "hierarchy", G_TYPE_UINT, hierarchy, "bandwidth", G_TYPE_UINT, bandwidth, "transmission-mode", G_TYPE_STRING, transmode, "code-rate-hp", G_TYPE_STRING, code_rate_hp, "code-rate-lp", G_TYPE_STRING, code_rate_lp, "constellation", G_TYPE_STRING, constellation, "guard-interval", G_TYPE_UINT, guard, NULL);
	_tmp0 = NULL;
	dvb_scanner_add_structure_to_scan (DVB_SCANNER (self), (_tmp0 = tuning_params, tuning_params = NULL, _tmp0));
	(tuning_params == NULL) ? NULL : (tuning_params = (gst_structure_free (tuning_params), NULL));
}


static gboolean dvb_terrestrial_scanner_real_AddScanningDataFromFile (DVBIDBusTerrestrialScanner* base, const char* path) {
	DVBTerrestrialScanner * self;
	GError * inner_error;
	GFile* datafile;
	char* contents;
	gboolean _tmp18;
	self = (DVBTerrestrialScanner*) base;
	g_return_val_if_fail (path != NULL, FALSE);
	inner_error = NULL;
	datafile = g_file_new_for_path (path);
	g_debug ("TerrestrialScanner.vala:64: Reading scanning data from %s", path);
	contents = NULL;
	{
		char* _tmp0;
		char* _tmp1;
		_tmp0 = dvb_utils_read_file_contents (datafile, &inner_error);
		if (inner_error != NULL) {
			goto __catch2_g_error;
			goto __finally2;
		}
		_tmp1 = NULL;
		contents = (_tmp1 = _tmp0, contents = (g_free (contents), NULL), _tmp1);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_critical ("TerrestrialScanner.vala:70: Could not read %s: %s", e->message, path);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally2:
	if (inner_error != NULL) {
		(datafile == NULL) ? NULL : (datafile = (g_object_unref (datafile), NULL));
		contents = (g_free (contents), NULL);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return FALSE;
	}
	if (contents == NULL) {
		gboolean _tmp2;
		return (_tmp2 = FALSE, (datafile == NULL) ? NULL : (datafile = (g_object_unref (datafile), NULL)), contents = (g_free (contents), NULL), _tmp2);
	}
	/* line looks like:
	 T freq bw fec_hi fec_lo mod transmission-mode guard-interval hierarchy*/
	{
		char** _tmp3;
		char** line_collection;
		int line_collection_length1;
		int line_it;
		_tmp3 = NULL;
		line_collection = _tmp3 = g_strsplit (contents, "\n", 0);
		line_collection_length1 = _vala_array_length (_tmp3);
		for (line_it = 0; line_it < _vala_array_length (_tmp3); line_it = line_it + 1) {
			const char* _tmp17;
			char* line;
			_tmp17 = NULL;
			line = (_tmp17 = line_collection[line_it], (_tmp17 == NULL) ? NULL : g_strdup (_tmp17));
			{
				char** _tmp4;
				gint cols_size;
				gint cols_length1;
				char** cols;
				gint cols_length;
				guint freq;
				guint hierarchy;
				const char* _tmp7;
				gint _tmp6_length1;
				char** _tmp6;
				char** _tmp5;
				char* _tmp8;
				char* bandwidth_str;
				guint bandwidth;
				const char* _tmp9;
				char* transmode;
				const char* _tmp10;
				char* code_rate_hp;
				const char* _tmp11;
				char* code_rate_lp;
				const char* _tmp12;
				char* constellation;
				const char* _tmp15;
				gint _tmp14_length1;
				char** _tmp14;
				char** _tmp13;
				char* _tmp16;
				char* guard_str;
				guint guard;
				if (g_str_has_prefix (line, "#")) {
					line = (g_free (line), NULL);
					continue;
				}
				_tmp4 = NULL;
				cols = (_tmp4 = g_regex_split_simple ("\\s+", line, 0, 0), cols_length1 = -1, cols_size = cols_length1, _tmp4);
				cols_length = 0;
				while (cols[cols_length] != NULL) {
					cols_length++;
				}
				cols_length++;
				if (cols_length < 9) {
					line = (g_free (line), NULL);
					cols = (_vala_array_free (cols, cols_length1, (GDestroyNotify) g_free), NULL);
					continue;
				}
				freq = (guint) atoi (cols[1]);
				hierarchy = (guint) 0;
				if (_vala_strcmp0 (cols[8], "1") == 0) {
					hierarchy = (guint) 1;
				} else {
					if (_vala_strcmp0 (cols[8], "2") == 0) {
						hierarchy = (guint) 2;
					} else {
						if (_vala_strcmp0 (cols[8], "4") == 0) {
							hierarchy = (guint) 3;
						}
					}
				}
				_tmp7 = NULL;
				_tmp6 = NULL;
				_tmp5 = NULL;
				_tmp8 = NULL;
				bandwidth_str = (_tmp8 = (_tmp7 = (_tmp6 = _tmp5 = g_strsplit (cols[2], "MHz", 0), _tmp6_length1 = _vala_array_length (_tmp5), _tmp6)[0], (_tmp7 == NULL) ? NULL : g_strdup (_tmp7)), _tmp6 = (_vala_array_free (_tmp6, _tmp6_length1, (GDestroyNotify) g_free), NULL), _tmp8);
				bandwidth = (guint) atoi (bandwidth_str);
				_tmp9 = NULL;
				transmode = (_tmp9 = cols[6], (_tmp9 == NULL) ? NULL : g_strdup (_tmp9));
				_tmp10 = NULL;
				code_rate_hp = (_tmp10 = cols[3], (_tmp10 == NULL) ? NULL : g_strdup (_tmp10));
				_tmp11 = NULL;
				code_rate_lp = (_tmp11 = cols[4], (_tmp11 == NULL) ? NULL : g_strdup (_tmp11));
				_tmp12 = NULL;
				constellation = (_tmp12 = cols[5], (_tmp12 == NULL) ? NULL : g_strdup (_tmp12));
				_tmp15 = NULL;
				_tmp14 = NULL;
				_tmp13 = NULL;
				_tmp16 = NULL;
				guard_str = (_tmp16 = (_tmp15 = (_tmp14 = _tmp13 = g_strsplit (cols[7], "/", 0), _tmp14_length1 = _vala_array_length (_tmp13), _tmp14)[1], (_tmp15 == NULL) ? NULL : g_strdup (_tmp15)), _tmp14 = (_vala_array_free (_tmp14, _tmp14_length1, (GDestroyNotify) g_free), NULL), _tmp16);
				guard = (guint) atoi (guard_str);
				dvb_id_bus_terrestrial_scanner_AddScanningData ((DVBIDBusTerrestrialScanner*) self, freq, hierarchy, bandwidth, transmode, code_rate_hp, code_rate_lp, constellation, guard);
				line = (g_free (line), NULL);
				cols = (_vala_array_free (cols, cols_length1, (GDestroyNotify) g_free), NULL);
				bandwidth_str = (g_free (bandwidth_str), NULL);
				transmode = (g_free (transmode), NULL);
				code_rate_hp = (g_free (code_rate_hp), NULL);
				code_rate_lp = (g_free (code_rate_lp), NULL);
				constellation = (g_free (constellation), NULL);
				guard_str = (g_free (guard_str), NULL);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	return (_tmp18 = TRUE, (datafile == NULL) ? NULL : (datafile = (g_object_unref (datafile), NULL)), contents = (g_free (contents), NULL), _tmp18);
}


static void dvb_terrestrial_scanner_real_prepare (DVBScanner* base) {
	DVBTerrestrialScanner * self;
	GstElement* dvbsrc;
	guint bandwidth;
	guint hierarchy;
	const char* _tmp0;
	char* constellation;
	guint guard;
	const char* _tmp1;
	char* transmode;
	self = (DVBTerrestrialScanner*) base;
	g_debug ("TerrestrialScanner.vala:121: Setting up pipeline for DVB-T scan");
	dvbsrc = gst_bin_get_by_name ((GST_BIN (DVB_SCANNER (self)->pipeline)), "dvbsrc");
	dvb_scanner_set_uint_property (dvbsrc, DVB_SCANNER (self)->current_tuning_params, "frequency");
	bandwidth = 0U;
	gst_structure_get_uint (((DVBScanner*) self)->current_tuning_params, "bandwidth", &bandwidth);
	g_object_set ((GObject*) dvbsrc, "bandwidth", dvb_get_bandwidth_val (bandwidth), NULL);
	hierarchy = 0U;
	gst_structure_get_uint (((DVBScanner*) self)->current_tuning_params, "hierarchy", &hierarchy);
	g_object_set ((GObject*) dvbsrc, "hierarchy", dvb_get_hierarchy_val (hierarchy), NULL);
	_tmp0 = NULL;
	constellation = (_tmp0 = gst_structure_get_string (((DVBScanner*) self)->current_tuning_params, "constellation"), (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
	g_object_set ((GObject*) dvbsrc, "modulation", dvb_get_modulation_val (constellation), NULL);
	g_object_set ((GObject*) dvbsrc, "code-rate-hp", dvb_get_code_rate_val (gst_structure_get_string (((DVBScanner*) self)->current_tuning_params, "code-rate-hp")), NULL);
	g_object_set ((GObject*) dvbsrc, "code-rate-lp", dvb_get_code_rate_val (gst_structure_get_string (((DVBScanner*) self)->current_tuning_params, "code-rate-lp")), NULL);
	guard = 0U;
	gst_structure_get_uint (((DVBScanner*) self)->current_tuning_params, "guard-interval", &guard);
	g_object_set ((GObject*) dvbsrc, "guard", dvb_get_guard_interval_val (guard), NULL);
	_tmp1 = NULL;
	transmode = (_tmp1 = gst_structure_get_string (((DVBScanner*) self)->current_tuning_params, "transmission-mode"), (_tmp1 == NULL) ? NULL : g_strdup (_tmp1));
	g_object_set ((GObject*) dvbsrc, "trans-mode", dvb_get_transmission_mode_val (transmode), NULL);
	(dvbsrc == NULL) ? NULL : (dvbsrc = (gst_object_unref (dvbsrc), NULL));
	constellation = (g_free (constellation), NULL);
	transmode = (g_free (transmode), NULL);
}


static DVBScannedItem* dvb_terrestrial_scanner_real_get_scanned_item (DVBScanner* base, const GstStructure* structure) {
	DVBTerrestrialScanner * self;
	guint freq;
	self = (DVBTerrestrialScanner*) base;
	g_return_val_if_fail (structure != NULL, NULL);
	freq = 0U;
	gst_structure_get_uint (structure, "frequency", &freq);
	return dvb_scanned_item_new (freq);
}


static DVBChannel* dvb_terrestrial_scanner_real_get_new_channel (DVBScanner* base) {
	DVBTerrestrialScanner * self;
	self = (DVBTerrestrialScanner*) base;
	return (DVBChannel*) dvb_terrestrial_channel_new ();
}


static void dvb_terrestrial_scanner_real_add_values_from_structure_to_channel (DVBScanner* base, const GstStructure* delivery, DVBChannel* channel) {
	DVBTerrestrialScanner * self;
	DVBTerrestrialChannel* _tmp0;
	DVBTerrestrialChannel* tc;
	guint freq;
	guint bandwidth;
	guint hierarchy;
	const char* _tmp1;
	char* constellation;
	guint guard;
	const char* _tmp2;
	char* transmode;
	self = (DVBTerrestrialScanner*) base;
	g_return_if_fail (delivery != NULL);
	g_return_if_fail (channel != NULL);
	if (!(DVB_IS_TERRESTRIAL_CHANNEL (channel))) {
		return;
	}
	_tmp0 = NULL;
	tc = (_tmp0 = DVB_TERRESTRIAL_CHANNEL (channel), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	/* structure doesn't contain information about inversion
	 set it to auto*/
	dvb_terrestrial_channel_set_Inversion (tc, DVB_DVB_SRC_INVERSION_INVERSION_AUTO);
	freq = 0U;
	gst_structure_get_uint (delivery, "frequency", &freq);
	dvb_channel_set_Frequency ((DVBChannel*) tc, freq);
	bandwidth = 0U;
	gst_structure_get_uint (delivery, "bandwidth", &bandwidth);
	dvb_terrestrial_channel_set_Bandwidth (tc, dvb_get_bandwidth_val (bandwidth));
	hierarchy = 0U;
	gst_structure_get_uint (delivery, "hierarchy", &hierarchy);
	dvb_terrestrial_channel_set_Hierarchy (tc, dvb_get_hierarchy_val (hierarchy));
	_tmp1 = NULL;
	constellation = (_tmp1 = gst_structure_get_string (delivery, "constellation"), (_tmp1 == NULL) ? NULL : g_strdup (_tmp1));
	dvb_terrestrial_channel_set_Constellation (tc, dvb_get_modulation_val (constellation));
	dvb_terrestrial_channel_set_CodeRateHP (tc, dvb_get_code_rate_val (gst_structure_get_string (delivery, "code-rate-hp")));
	dvb_terrestrial_channel_set_CodeRateLP (tc, dvb_get_code_rate_val (gst_structure_get_string (delivery, "code-rate-lp")));
	guard = 0U;
	gst_structure_get_uint (delivery, "guard-interval", &guard);
	dvb_terrestrial_channel_set_GuardInterval (tc, dvb_get_guard_interval_val (guard));
	_tmp2 = NULL;
	transmode = (_tmp2 = gst_structure_get_string (delivery, "transmission-mode"), (_tmp2 == NULL) ? NULL : g_strdup (_tmp2));
	dvb_terrestrial_channel_set_TransmissionMode (tc, dvb_get_transmission_mode_val (transmode));
	(tc == NULL) ? NULL : (tc = (g_object_unref (tc), NULL));
	constellation = (g_free (constellation), NULL);
	transmode = (g_free (transmode), NULL);
}


void _dvb_terrestrial_scanner_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_dvb_terrestrial_scanner_introspect (DVBTerrestrialScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.Scanner.Terrestrial\">\n  <method name=\"Run\">\n  </method>\n  <method name=\"Destroy\">\n  </method>\n  <method name=\"WriteChannelsToFile\">\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"AddScanningData\">\n    <arg name=\"frequency\" type=\"u\" direction=\"in\"/>\n    <arg name=\"hierarchy\" type=\"u\" direction=\"in\"/>\n    <arg name=\"bandwidth\" type=\"u\" direction=\"in\"/>\n    <arg name=\"transmode\" type=\"s\" direction=\"in\"/>\n    <arg name=\"code_rate_hp\" type=\"s\" direction=\"in\"/>\n    <arg name=\"code_rate_lp\" type=\"s\" direction=\"in\"/>\n    <arg name=\"constellation\" type=\"s\" direction=\"in\"/>\n    <arg name=\"guard\" type=\"u\" direction=\"in\"/>\n  </method>\n  <method name=\"AddScanningDataFromFile\">\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <signal name=\"FrequencyScanned\">\n    <arg name=\"frequency\" type=\"u\"/>\n    <arg name=\"freq_left\" type=\"u\"/>\n  </signal>\n  <signal name=\"Finished\">\n  </signal>\n  <signal name=\"ChannelAdded\">\n    <arg name=\"frequency\" type=\"u\"/>\n    <arg name=\"sid\" type=\"u\"/>\n    <arg name=\"name\" type=\"s\"/>\n    <arg name=\"network\" type=\"s\"/>\n    <arg name=\"type\" type=\"s\"/>\n    <arg name=\"scrambled\" type=\"b\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


DBusHandlerResult dvb_terrestrial_scanner_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_dvb_terrestrial_scanner_introspect (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else if (dvb_id_bus_terrestrial_scanner_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dvb_terrestrial_scanner_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_terrestrial_scanner_dbus_path_vtable, object);
	}
	dvb_id_bus_terrestrial_scanner_dbus_register_object (connection, path, object);
}


static void dvb_terrestrial_scanner_class_init (DVBTerrestrialScannerClass * klass) {
	dvb_terrestrial_scanner_parent_class = g_type_class_peek_parent (klass);
	DVB_SCANNER_CLASS (klass)->prepare = dvb_terrestrial_scanner_real_prepare;
	DVB_SCANNER_CLASS (klass)->get_scanned_item = dvb_terrestrial_scanner_real_get_scanned_item;
	DVB_SCANNER_CLASS (klass)->get_new_channel = dvb_terrestrial_scanner_real_get_new_channel;
	DVB_SCANNER_CLASS (klass)->add_values_from_structure_to_channel = dvb_terrestrial_scanner_real_add_values_from_structure_to_channel;
	g_type_set_qdata (DVB_TYPE_TERRESTRIAL_SCANNER, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_terrestrial_scanner_dbus_vtable));
}


static void dvb_terrestrial_scanner_dvb_id_bus_terrestrial_scanner_interface_init (DVBIDBusTerrestrialScannerIface * iface) {
	dvb_terrestrial_scanner_dvb_id_bus_terrestrial_scanner_parent_iface = g_type_interface_peek_parent (iface);
	iface->AddScanningData = dvb_terrestrial_scanner_real_AddScanningData;
	iface->AddScanningDataFromFile = dvb_terrestrial_scanner_real_AddScanningDataFromFile;
	iface->Run = dvb_scanner_Run;
	iface->Destroy = dvb_scanner_Destroy;
	iface->WriteChannelsToFile = dvb_scanner_WriteChannelsToFile;
}


static void dvb_terrestrial_scanner_instance_init (DVBTerrestrialScanner * self) {
}


GType dvb_terrestrial_scanner_get_type (void) {
	static GType dvb_terrestrial_scanner_type_id = 0;
	if (dvb_terrestrial_scanner_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBTerrestrialScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_terrestrial_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBTerrestrialScanner), 0, (GInstanceInitFunc) dvb_terrestrial_scanner_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_terrestrial_scanner_info = { (GInterfaceInitFunc) dvb_terrestrial_scanner_dvb_id_bus_terrestrial_scanner_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		dvb_terrestrial_scanner_type_id = g_type_register_static (DVB_TYPE_SCANNER, "DVBTerrestrialScanner", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_terrestrial_scanner_type_id, DVB_TYPE_ID_BUS_TERRESTRIAL_SCANNER, &dvb_id_bus_terrestrial_scanner_info);
	}
	return dvb_terrestrial_scanner_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}



static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN) (gpointer data1, guint arg_1, guint arg_2, const char* arg_3, const char* arg_4, const char* arg_5, gboolean arg_6, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 7);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_string (param_values + 3), g_value_get_string (param_values + 4), g_value_get_string (param_values + 5), g_value_get_boolean (param_values + 6), data2);
}



