
#include <src/Utils.h>




static void _g_slist_free_g_object_unref (GSList* self);



const char* dvb_utils_get_nick_from_enum (GType enumtype, gint val) {
	GEnumClass* eclass;
	GEnumValue* eval;
	eclass = (GEnumClass*) g_type_class_ref (enumtype);
	eval = g_enum_get_value (eclass, val);
	if (eval == NULL) {
		char* _tmp0;
		g_critical ("Utils.vala:12: Enum has no value %d", val);
		_tmp0 = NULL;
		return (_tmp0 = NULL, (eclass == NULL) ? NULL : (eclass = (g_type_class_unref (eclass), NULL)), _tmp0);
	} else {
		char* _tmp1;
		_tmp1 = NULL;
		return (_tmp1 = eval->value_nick, (eclass == NULL) ? NULL : (eclass = (g_type_class_unref (eclass), NULL)), _tmp1);
	}
	(eclass == NULL) ? NULL : (eclass = (g_type_class_unref (eclass), NULL));
}


gboolean dvb_utils_get_value_by_name_from_enum (GType enumtype, const char* name, gint* evalue) {
	GEnumClass* enumclass;
	GEnumValue* eval;
	g_return_val_if_fail (name != NULL, FALSE);
	enumclass = (GEnumClass*) g_type_class_ref (enumtype);
	eval = g_enum_get_value_by_name (enumclass, name);
	if (eval == NULL) {
		gboolean _tmp0;
		g_critical ("Utils.vala:24: Enum has no member named %s", name);
		return (_tmp0 = FALSE, (enumclass == NULL) ? NULL : (enumclass = (g_type_class_unref (enumclass), NULL)), _tmp0);
	} else {
		gboolean _tmp1;
		(*evalue) = eval->value;
		return (_tmp1 = TRUE, (enumclass == NULL) ? NULL : (enumclass = (g_type_class_unref (enumclass), NULL)), _tmp1);
	}
	(enumclass == NULL) ? NULL : (enumclass = (g_type_class_unref (enumclass), NULL));
}


const char* dvb_utils_get_name_by_value_from_enum (GType enumtype, gint val) {
	GEnumClass* enumclass;
	GEnumValue* eval;
	enumclass = (GEnumClass*) g_type_class_ref (enumtype);
	eval = g_enum_get_value (enumclass, val);
	if (eval == NULL) {
		char* _tmp0;
		g_critical ("Utils.vala:37: Enum has no value %d", val);
		_tmp0 = NULL;
		return (_tmp0 = NULL, (enumclass == NULL) ? NULL : (enumclass = (g_type_class_unref (enumclass), NULL)), _tmp0);
	} else {
		char* _tmp1;
		_tmp1 = NULL;
		return (_tmp1 = eval->value_name, (enumclass == NULL) ? NULL : (enumclass = (g_type_class_unref (enumclass), NULL)), _tmp1);
	}
	(enumclass == NULL) ? NULL : (enumclass = (g_type_class_unref (enumclass), NULL));
}


static void _g_slist_free_g_object_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) g_object_unref, NULL);
	g_slist_free (self);
}


void dvb_utils_mkdirs (GFile* directory, GError** error) {
	GError * inner_error;
	GSList* create_dirs;
	GFile* _tmp0;
	GFile* current_dir;
	g_return_if_fail (directory != NULL);
	inner_error = NULL;
	create_dirs = NULL;
	_tmp0 = NULL;
	current_dir = (_tmp0 = directory, (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	while (current_dir != NULL) {
		GFile* _tmp1;
		GFile* _tmp2;
		if (g_file_query_exists (current_dir, NULL)) {
			break;
		}
		_tmp1 = NULL;
		create_dirs = g_slist_prepend (create_dirs, (_tmp1 = current_dir, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)));
		_tmp2 = NULL;
		current_dir = (_tmp2 = g_file_get_parent (current_dir), (current_dir == NULL) ? NULL : (current_dir = (g_object_unref (current_dir), NULL)), _tmp2);
	}
	{
		GSList* dir_collection;
		GSList* dir_it;
		dir_collection = create_dirs;
		for (dir_it = dir_collection; dir_it != NULL; dir_it = dir_it->next) {
			GFile* _tmp4;
			GFile* dir;
			_tmp4 = NULL;
			dir = (_tmp4 = (GFile*) dir_it->data, (_tmp4 == NULL) ? NULL : g_object_ref (_tmp4));
			{
				char* _tmp3;
				_tmp3 = NULL;
				g_debug ("Utils.vala:55: Creating %s", _tmp3 = g_file_get_path (dir));
				_tmp3 = (g_free (_tmp3), NULL);
				g_file_make_directory (dir, NULL, &inner_error);
				if (inner_error != NULL) {
					g_propagate_error (error, inner_error);
					(dir == NULL) ? NULL : (dir = (g_object_unref (dir), NULL));
					(create_dirs == NULL) ? NULL : (create_dirs = (_g_slist_free_g_object_unref (create_dirs), NULL));
					(current_dir == NULL) ? NULL : (current_dir = (g_object_unref (current_dir), NULL));
					return;
				}
				(dir == NULL) ? NULL : (dir = (g_object_unref (dir), NULL));
			}
		}
	}
	(create_dirs == NULL) ? NULL : (create_dirs = (_g_slist_free_g_object_unref (create_dirs), NULL));
	(current_dir == NULL) ? NULL : (current_dir = (g_object_unref (current_dir), NULL));
}


char* dvb_utils_remove_nonalphanums (const char* text) {
	GError * inner_error;
	GRegex* regex;
	char* new_text;
	char* _tmp7;
	g_return_val_if_fail (text != NULL, NULL);
	inner_error = NULL;
	regex = NULL;
	{
		GRegex* _tmp0;
		_tmp0 = NULL;
		regex = (_tmp0 = g_regex_new ("\\W", 0, 0, &inner_error), (regex == NULL) ? NULL : (regex = (g_regex_unref (regex), NULL)), _tmp0);
		if (inner_error != NULL) {
			if (inner_error->domain == G_REGEX_ERROR) {
				goto __catch28_g_regex_error;
			}
			goto __finally28;
		}
	}
	goto __finally28;
	__catch28_g_regex_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			const char* _tmp1;
			char* _tmp2;
			g_error ("Utils.vala:65: RegexError: %s", e->message);
			_tmp1 = NULL;
			_tmp2 = NULL;
			return (_tmp2 = (_tmp1 = text, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), (regex == NULL) ? NULL : (regex = (g_regex_unref (regex), NULL)), _tmp2);
		}
	}
	__finally28:
	if (inner_error != NULL) {
		(regex == NULL) ? NULL : (regex = (g_regex_unref (regex), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return NULL;
	}
	new_text = NULL;
	{
		char* _tmp3;
		char* _tmp4;
		_tmp3 = g_regex_replace_literal (regex, text, strlen (text), 0, "_", 0, &inner_error);
		if (inner_error != NULL) {
			if (inner_error->domain == G_REGEX_ERROR) {
				goto __catch29_g_regex_error;
			}
			goto __finally29;
		}
		_tmp4 = NULL;
		new_text = (_tmp4 = _tmp3, new_text = (g_free (new_text), NULL), _tmp4);
	}
	goto __finally29;
	__catch29_g_regex_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			const char* _tmp5;
			char* _tmp6;
			g_error ("Utils.vala:73: RegexError: %s", e->message);
			_tmp5 = NULL;
			_tmp6 = NULL;
			return (_tmp6 = (_tmp5 = text, (_tmp5 == NULL) ? NULL : g_strdup (_tmp5)), (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), (regex == NULL) ? NULL : (regex = (g_regex_unref (regex), NULL)), new_text = (g_free (new_text), NULL), _tmp6);
		}
	}
	__finally29:
	if (inner_error != NULL) {
		(regex == NULL) ? NULL : (regex = (g_regex_unref (regex), NULL));
		new_text = (g_free (new_text), NULL);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return NULL;
	}
	_tmp7 = NULL;
	return (_tmp7 = new_text, (regex == NULL) ? NULL : (regex = (g_regex_unref (regex), NULL)), _tmp7);
}


/**
     * @returns: Difference in seconds
     */
gint64 dvb_utils_difftime (const struct tm* t1, const struct tm* t2) {
	gint64 ts1;
	gint64 ts2;
	gint64 diff;
	ts1 = (gint64) mktime (&(*t1));
	ts2 = (gint64) mktime (&(*t2));
	diff = ts1 - ts2;
	if (diff < 0) {
		return (-1) * diff;
	} else {
		return diff;
	}
}


/**
     * Creates Time of local time
     */
struct tm dvb_utils_create_time (gint year, gint month, gint day, gint hour, gint minute, gint second) {
	gboolean _tmp0;
	gboolean _tmp1;
	gboolean _tmp2;
	gboolean _tmp3;
	gboolean _tmp4;
	time_t _tmp7 = {0};
	time_t _tmp5 = {0};
	struct tm _tmp6 = {0};
	struct tm t;
	_tmp0 = FALSE;
	_tmp1 = FALSE;
	_tmp2 = FALSE;
	_tmp3 = FALSE;
	_tmp4 = FALSE;
	if (year >= 1900) {
		_tmp4 = month >= 1;
	} else {
		_tmp4 = FALSE;
	}
	if (_tmp4) {
		_tmp3 = day >= 1;
	} else {
		_tmp3 = FALSE;
	}
	if (_tmp3) {
		_tmp2 = hour >= 0;
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		_tmp1 = minute >= 0;
	} else {
		_tmp1 = FALSE;
	}
	if (_tmp1) {
		_tmp0 = second >= 0;
	} else {
		_tmp0 = FALSE;
	}
	g_assert (_tmp0);
	/* Create Time with some initial value, otherwise time is wrong*/
	t = (localtime_r ((_tmp7 = (time (&_tmp5), _tmp5), &_tmp7), &_tmp6), _tmp6);
	t.tm_year = year - 1900;
	t.tm_mon = month - 1;
	t.tm_mday = day;
	t.tm_hour = hour;
	t.tm_min = minute;
	t.tm_sec = second;
	return t;
}


/**
     * Creates Time of UTC time
     */
struct tm dvb_utils_create_utc_time (gint year, gint month, gint day, gint hour, gint minute, gint second) {
	gboolean _tmp0;
	gboolean _tmp1;
	gboolean _tmp2;
	gboolean _tmp3;
	gboolean _tmp4;
	time_t _tmp7 = {0};
	time_t _tmp5 = {0};
	struct tm _tmp6 = {0};
	struct tm t;
	_tmp0 = FALSE;
	_tmp1 = FALSE;
	_tmp2 = FALSE;
	_tmp3 = FALSE;
	_tmp4 = FALSE;
	if (year >= 1900) {
		_tmp4 = month >= 1;
	} else {
		_tmp4 = FALSE;
	}
	if (_tmp4) {
		_tmp3 = day >= 1;
	} else {
		_tmp3 = FALSE;
	}
	if (_tmp3) {
		_tmp2 = hour >= 0;
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		_tmp1 = minute >= 0;
	} else {
		_tmp1 = FALSE;
	}
	if (_tmp1) {
		_tmp0 = second >= 0;
	} else {
		_tmp0 = FALSE;
	}
	g_assert (_tmp0);
	/* Create Time with some initial value, otherwise time is wrong*/
	t = (gmtime_r ((_tmp7 = (time (&_tmp5), _tmp5), &_tmp7), &_tmp6), _tmp6);
	t.tm_year = year - 1900;
	t.tm_mon = month - 1;
	t.tm_mday = day;
	t.tm_hour = hour;
	t.tm_min = minute;
	t.tm_sec = second;
	t.tm_isdst = -1;
	/* undefined*/
	return t;
}


/* TODO throw error*/
char* dvb_utils_read_file_contents (GFile* file, GError** error) {
	GError * inner_error;
	char* attrs;
	GFileInfo* info;
	GFileInputStream* stream;
	GString* sb;
	gchar* _tmp10;
	gint buffer_size;
	gint buffer_length1;
	gchar* buffer;
	glong bytes_read;
	const char* _tmp12;
	char* _tmp13;
	g_return_val_if_fail (file != NULL, NULL);
	inner_error = NULL;
	attrs = g_strdup_printf ("%s,%s", G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_ATTRIBUTE_ACCESS_CAN_READ);
	info = NULL;
	{
		GFileInfo* _tmp0;
		GFileInfo* _tmp1;
		_tmp0 = g_file_query_info (file, attrs, 0, NULL, &inner_error);
		if (inner_error != NULL) {
			goto __catch30_g_error;
			goto __finally30;
		}
		_tmp1 = NULL;
		info = (_tmp1 = _tmp0, (info == NULL) ? NULL : (info = (g_object_unref (info), NULL)), _tmp1);
	}
	goto __finally30;
	__catch30_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			char* _tmp2;
			g_critical ("Utils.vala:147: Could not retrieve attributes: %s", e->message);
			_tmp2 = NULL;
			return (_tmp2 = NULL, (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), attrs = (g_free (attrs), NULL), (info == NULL) ? NULL : (info = (g_object_unref (info), NULL)), _tmp2);
		}
	}
	__finally30:
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		attrs = (g_free (attrs), NULL);
		(info == NULL) ? NULL : (info = (g_object_unref (info), NULL));
		return NULL;
	}
	if (g_file_info_get_file_type (info) != G_FILE_TYPE_REGULAR) {
		char* _tmp3;
		char* _tmp4;
		_tmp3 = NULL;
		g_critical ("Utils.vala:152: %s is not a regular file", _tmp3 = g_file_get_path (file));
		_tmp3 = (g_free (_tmp3), NULL);
		_tmp4 = NULL;
		return (_tmp4 = NULL, attrs = (g_free (attrs), NULL), (info == NULL) ? NULL : (info = (g_object_unref (info), NULL)), _tmp4);
	}
	if (!g_file_info_get_attribute_boolean (info, G_FILE_ATTRIBUTE_ACCESS_CAN_READ)) {
		char* _tmp5;
		char* _tmp6;
		_tmp5 = NULL;
		g_critical ("Utils.vala:157: Cannot read %s", _tmp5 = g_file_get_path (file));
		_tmp5 = (g_free (_tmp5), NULL);
		_tmp6 = NULL;
		return (_tmp6 = NULL, attrs = (g_free (attrs), NULL), (info == NULL) ? NULL : (info = (g_object_unref (info), NULL)), _tmp6);
	}
	stream = NULL;
	{
		GFileInputStream* _tmp7;
		GFileInputStream* _tmp8;
		_tmp7 = g_file_read (file, NULL, &inner_error);
		if (inner_error != NULL) {
			if (inner_error->domain == G_IO_ERROR) {
				goto __catch31_g_io_error;
			}
			goto __finally31;
		}
		_tmp8 = NULL;
		stream = (_tmp8 = _tmp7, (stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL)), _tmp8);
	}
	goto __finally31;
	__catch31_g_io_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			char* _tmp9;
			g_critical ("Utils.vala:165: Could not read file: %s", e->message);
			_tmp9 = NULL;
			return (_tmp9 = NULL, (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), attrs = (g_free (attrs), NULL), (info == NULL) ? NULL : (info = (g_object_unref (info), NULL)), (stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL)), _tmp9);
		}
	}
	__finally31:
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		attrs = (g_free (attrs), NULL);
		(info == NULL) ? NULL : (info = (g_object_unref (info), NULL));
		(stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL));
		return NULL;
	}
	sb = g_string_new ("");
	_tmp10 = NULL;
	buffer = (_tmp10 = g_new0 (gchar, DVB_UTILS_BUFFER_SIZE), buffer_length1 = DVB_UTILS_BUFFER_SIZE, buffer_size = buffer_length1, _tmp10);
	bytes_read = 0L;
	while (TRUE) {
		gssize _tmp11;
		_tmp11 = g_input_stream_read ((GInputStream*) stream, buffer, (gsize) DVB_UTILS_BUFFER_SIZE, NULL, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			attrs = (g_free (attrs), NULL);
			(info == NULL) ? NULL : (info = (g_object_unref (info), NULL));
			(stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL));
			(sb == NULL) ? NULL : (sb = (g_string_free (sb, TRUE), NULL));
			buffer = (g_free (buffer), NULL);
			return NULL;
		}
		if (!((bytes_read = (glong) _tmp11) > 0)) {
			break;
		}
		{
			gint i;
			i = 0;
			for (; i < bytes_read; i++) {
				g_string_append_c (sb, buffer[i]);
			}
		}
	}
	g_input_stream_close ((GInputStream*) stream, NULL, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		attrs = (g_free (attrs), NULL);
		(info == NULL) ? NULL : (info = (g_object_unref (info), NULL));
		(stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL));
		(sb == NULL) ? NULL : (sb = (g_string_free (sb, TRUE), NULL));
		buffer = (g_free (buffer), NULL);
		return NULL;
	}
	_tmp12 = NULL;
	_tmp13 = NULL;
	return (_tmp13 = (_tmp12 = sb->str, (_tmp12 == NULL) ? NULL : g_strdup (_tmp12)), attrs = (g_free (attrs), NULL), (info == NULL) ? NULL : (info = (g_object_unref (info), NULL)), (stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL)), (sb == NULL) ? NULL : (sb = (g_string_free (sb, TRUE), NULL)), buffer = (g_free (buffer), NULL), _tmp13);
}


void dvb_utils_delete_dir_recursively (GFile* dir, GError** error) {
	GError * inner_error;
	char* attrs;
	GFileEnumerator* files;
	GFileEnumerator* _tmp0;
	GFileEnumerator* _tmp1;
	GFileInfo* childinfo;
	char* _tmp5;
	g_return_if_fail (dir != NULL);
	inner_error = NULL;
	attrs = g_strdup_printf ("%s,%s", G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_ATTRIBUTE_STANDARD_NAME);
	files = NULL;
	_tmp0 = g_file_enumerate_children (dir, attrs, 0, NULL, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		attrs = (g_free (attrs), NULL);
		(files == NULL) ? NULL : (files = (g_object_unref (files), NULL));
		return;
	}
	_tmp1 = NULL;
	files = (_tmp1 = _tmp0, (files == NULL) ? NULL : (files = (g_object_unref (files), NULL)), _tmp1);
	if (files == NULL) {
		attrs = (g_free (attrs), NULL);
		(files == NULL) ? NULL : (files = (g_object_unref (files), NULL));
		return;
	}
	childinfo = NULL;
	while (TRUE) {
		GFileInfo* _tmp2;
		GFileInfo* _tmp3;
		guint32 type;
		GFile* child;
		_tmp2 = g_file_enumerator_next_file (files, NULL, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			attrs = (g_free (attrs), NULL);
			(files == NULL) ? NULL : (files = (g_object_unref (files), NULL));
			(childinfo == NULL) ? NULL : (childinfo = (g_object_unref (childinfo), NULL));
			return;
		}
		_tmp3 = NULL;
		if (!((childinfo = (_tmp3 = _tmp2, (childinfo == NULL) ? NULL : (childinfo = (g_object_unref (childinfo), NULL)), _tmp3)) != NULL)) {
			break;
		}
		type = g_file_info_get_attribute_uint32 (childinfo, G_FILE_ATTRIBUTE_STANDARD_TYPE);
		child = g_file_get_child (dir, g_file_info_get_name (childinfo));
		switch (type) {
			case G_FILE_TYPE_DIRECTORY:
			{
				dvb_utils_delete_dir_recursively (child, &inner_error);
				if (inner_error != NULL) {
					g_propagate_error (error, inner_error);
					(child == NULL) ? NULL : (child = (g_object_unref (child), NULL));
					attrs = (g_free (attrs), NULL);
					(files == NULL) ? NULL : (files = (g_object_unref (files), NULL));
					(childinfo == NULL) ? NULL : (childinfo = (g_object_unref (childinfo), NULL));
					return;
				}
				break;
			}
			case G_FILE_TYPE_REGULAR:
			{
				char* _tmp4;
				_tmp4 = NULL;
				g_debug ("Utils.vala:204: Deleting file %s", _tmp4 = g_file_get_path (child));
				_tmp4 = (g_free (_tmp4), NULL);
				g_file_delete (child, NULL, &inner_error);
				if (inner_error != NULL) {
					g_propagate_error (error, inner_error);
					(child == NULL) ? NULL : (child = (g_object_unref (child), NULL));
					attrs = (g_free (attrs), NULL);
					(files == NULL) ? NULL : (files = (g_object_unref (files), NULL));
					(childinfo == NULL) ? NULL : (childinfo = (g_object_unref (childinfo), NULL));
					return;
				}
				break;
			}
		}
		(child == NULL) ? NULL : (child = (g_object_unref (child), NULL));
	}
	_tmp5 = NULL;
	g_debug ("Utils.vala:210: Deleting directory %s", _tmp5 = g_file_get_path (dir));
	_tmp5 = (g_free (_tmp5), NULL);
	g_file_delete (dir, NULL, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		attrs = (g_free (attrs), NULL);
		(files == NULL) ? NULL : (files = (g_object_unref (files), NULL));
		(childinfo == NULL) ? NULL : (childinfo = (g_object_unref (childinfo), NULL));
		return;
	}
	attrs = (g_free (attrs), NULL);
	(files == NULL) ? NULL : (files = (g_object_unref (files), NULL));
	(childinfo == NULL) ? NULL : (childinfo = (g_object_unref (childinfo), NULL));
}




