/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __SRC_CHANNELLIST_H__
#define __SRC_CHANNELLIST_H__

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "src/IDBusChannelList.h"
#include "src/Device.h"
#include "src/Channel.h"
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>

G_BEGIN_DECLS


#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelListPrivate DVBChannelListPrivate;

struct _DVBChannelList {
	GObject parent_instance;
	DVBChannelListPrivate * priv;
	GeeHashMap* channels;
};

struct _DVBChannelListClass {
	GObjectClass parent_class;
};


DVBChannelList* dvb_channel_list_construct (GType object_type, GFile* channels);
DVBChannelList* dvb_channel_list_new (GFile* channels);
DVBChannel* dvb_channel_list_get_channel (DVBChannelList* self, guint sid);
void dvb_channel_list_add (DVBChannelList* self, DVBChannel* channel);
void dvb_channel_list_remove (DVBChannelList* self, guint sid);
gboolean dvb_channel_list_contains (DVBChannelList* self, guint sid);
void dvb_channel_list_clear (DVBChannelList* self);
DVBChannelList* dvb_channel_list_restore_from_file (GFile* channelsfile, DVBAdapterType type, guint group_id, GError** error);
GFile* dvb_channel_list_get_channels_file (DVBChannelList* self);
gint dvb_channel_list_get_size (DVBChannelList* self);
void dvb_channel_list_dbus_register_object (DBusConnection* connection, const char* path, void* object);
DBusHandlerResult dvb_channel_list_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
GType dvb_channel_list_get_type (void);


G_END_DECLS

#endif
