/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __SRC_CONFIGSTORE_H__
#define __SRC_CONFIGSTORE_H__

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include "src/DeviceGroup.h"
#include "src/Device.h"

G_BEGIN_DECLS


#define DVB_TYPE_CONFIG_STORE (dvb_config_store_get_type ())
#define DVB_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CONFIG_STORE, DVBConfigStore))
#define DVB_IS_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CONFIG_STORE))
#define DVB_CONFIG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_CONFIG_STORE, DVBConfigStoreIface))

typedef struct _DVBConfigStore DVBConfigStore;
typedef struct _DVBConfigStoreIface DVBConfigStoreIface;

struct _DVBConfigStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_device_groups) (DVBConfigStore* self);
	gboolean (*add_device_group) (DVBConfigStore* self, DVBDeviceGroup* dev_group);
	gboolean (*remove_device_group) (DVBConfigStore* self, DVBDeviceGroup* devgroup);
	gboolean (*add_device_to_group) (DVBConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup);
	gboolean (*remove_device_from_group) (DVBConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup);
};


GeeList* dvb_config_store_get_all_device_groups (DVBConfigStore* self);
gboolean dvb_config_store_add_device_group (DVBConfigStore* self, DVBDeviceGroup* dev_group);
gboolean dvb_config_store_remove_device_group (DVBConfigStore* self, DVBDeviceGroup* devgroup);
gboolean dvb_config_store_add_device_to_group (DVBConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup);
gboolean dvb_config_store_remove_device_from_group (DVBConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup);
GType dvb_config_store_get_type (void);


G_END_DECLS

#endif
