/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <src/Factory.h>
#include "src/SqliteEPGStore.h"




static DVBSqliteConfigTimersStore* dvb_factory_store = NULL;
static GStaticRecMutex dvb_factory_store_mutex = {0};
static DVBEPGStore* dvb_factory_epgstore = NULL;
static GStaticRecMutex dvb_factory_epgstore_mutex = {0};
static DVBSettings* dvb_factory_settings = NULL;
static GStaticRecMutex dvb_factory_settings_mutex = {0};
static void dvb_factory_instance_init (DVBFactory * self);



DVBTimersStore* dvb_factory_get_timers_store (void) {
	g_static_rec_mutex_lock (&dvb_factory_store_mutex);
	if (dvb_factory_store == NULL) {
		DVBSqliteConfigTimersStore* _tmp0;
		_tmp0 = NULL;
		dvb_factory_store = (_tmp0 = dvb_sqlite_config_timers_store_new (), (dvb_factory_store == NULL) ? NULL : (dvb_factory_store = (g_object_unref (dvb_factory_store), NULL)), _tmp0);
	}
	g_static_rec_mutex_unlock (&dvb_factory_store_mutex);
	return (DVBTimersStore*) dvb_factory_store;
}


DVBConfigStore* dvb_factory_get_config_store (void) {
	g_static_rec_mutex_lock (&dvb_factory_store_mutex);
	if (dvb_factory_store == NULL) {
		DVBSqliteConfigTimersStore* _tmp0;
		_tmp0 = NULL;
		dvb_factory_store = (_tmp0 = dvb_sqlite_config_timers_store_new (), (dvb_factory_store == NULL) ? NULL : (dvb_factory_store = (g_object_unref (dvb_factory_store), NULL)), _tmp0);
	}
	g_static_rec_mutex_unlock (&dvb_factory_store_mutex);
	return (DVBConfigStore*) dvb_factory_store;
}


DVBEPGStore* dvb_factory_get_epg_store (void) {
	g_static_rec_mutex_lock (&dvb_factory_epgstore_mutex);
	if (dvb_factory_epgstore == NULL) {
		DVBEPGStore* _tmp0;
		_tmp0 = NULL;
		dvb_factory_epgstore = (_tmp0 = (DVBEPGStore*) dvb_sqlite_epg_store_new (), (dvb_factory_epgstore == NULL) ? NULL : (dvb_factory_epgstore = (g_object_unref (dvb_factory_epgstore), NULL)), _tmp0);
	}
	g_static_rec_mutex_unlock (&dvb_factory_epgstore_mutex);
	return dvb_factory_epgstore;
}


DVBSettings* dvb_factory_get_settings (void) {
	g_static_rec_mutex_lock (&dvb_factory_settings_mutex);
	if (dvb_factory_settings == NULL) {
		DVBSettings* _tmp0;
		_tmp0 = NULL;
		dvb_factory_settings = (_tmp0 = dvb_settings_new (), (dvb_factory_settings == NULL) ? NULL : (dvb_factory_settings = (g_object_unref (dvb_factory_settings), NULL)), _tmp0);
		dvb_settings_load (dvb_factory_settings);
	}
	g_static_rec_mutex_unlock (&dvb_factory_settings_mutex);
	return dvb_factory_settings;
}


void dvb_factory_shutdown (void) {
	DVBSqliteConfigTimersStore* _tmp0;
	DVBEPGStore* _tmp1;
	DVBSettings* _tmp2;
	g_static_rec_mutex_lock (&dvb_factory_store_mutex);
	_tmp0 = NULL;
	dvb_factory_store = (_tmp0 = NULL, (dvb_factory_store == NULL) ? NULL : (dvb_factory_store = (g_object_unref (dvb_factory_store), NULL)), _tmp0);
	g_static_rec_mutex_unlock (&dvb_factory_store_mutex);
	g_static_rec_mutex_lock (&dvb_factory_epgstore_mutex);
	_tmp1 = NULL;
	dvb_factory_epgstore = (_tmp1 = NULL, (dvb_factory_epgstore == NULL) ? NULL : (dvb_factory_epgstore = (g_object_unref (dvb_factory_epgstore), NULL)), _tmp1);
	g_static_rec_mutex_unlock (&dvb_factory_epgstore_mutex);
	g_static_rec_mutex_lock (&dvb_factory_settings_mutex);
	if (dvb_factory_settings != NULL) {
		dvb_settings_save (dvb_factory_settings);
	}
	_tmp2 = NULL;
	dvb_factory_settings = (_tmp2 = NULL, (dvb_factory_settings == NULL) ? NULL : (dvb_factory_settings = (g_object_unref (dvb_factory_settings), NULL)), _tmp2);
	g_static_rec_mutex_unlock (&dvb_factory_settings_mutex);
}


DVBFactory* dvb_factory_new (void) {
	DVBFactory* self;
	self = g_slice_new0 (DVBFactory);
	dvb_factory_instance_init (self);
	return self;
}


static void dvb_factory_instance_init (DVBFactory * self) {
}


void dvb_factory_free (DVBFactory* self) {
	g_slice_free (DVBFactory, self);
}




