/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __SRC_IDBUSSCHEDULE_H__
#define __SRC_IDBUSSCHEDULE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>

G_BEGIN_DECLS


#define DVB_TYPE_ID_BUS_SCHEDULE (dvb_id_bus_schedule_get_type ())
#define DVB_ID_BUS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_SCHEDULE, DVBIDBusSchedule))
#define DVB_IS_ID_BUS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_SCHEDULE))
#define DVB_ID_BUS_SCHEDULE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_SCHEDULE, DVBIDBusScheduleIface))

typedef struct _DVBIDBusSchedule DVBIDBusSchedule;
typedef struct _DVBIDBusScheduleIface DVBIDBusScheduleIface;

struct _DVBIDBusScheduleIface {
	GTypeInterface parent_iface;
	guint32* (*GetAllEvents) (DVBIDBusSchedule* self, int* result_length1);
	guint32 (*NowPlaying) (DVBIDBusSchedule* self);
	guint32 (*Next) (DVBIDBusSchedule* self, guint32 event_id);
	char* (*GetName) (DVBIDBusSchedule* self, guint32 event_id);
	char* (*GetShortDescription) (DVBIDBusSchedule* self, guint32 event_id);
	char* (*GetExtendedDescription) (DVBIDBusSchedule* self, guint32 event_id);
	guint (*GetDuration) (DVBIDBusSchedule* self, guint32 event_id);
	guint* (*GetLocalStartTime) (DVBIDBusSchedule* self, guint32 event_id, int* result_length1);
	gboolean (*IsRunning) (DVBIDBusSchedule* self, guint32 event_id);
	gboolean (*IsScrambled) (DVBIDBusSchedule* self, guint32 event_id);
};


guint32* dvb_id_bus_schedule_GetAllEvents (DVBIDBusSchedule* self, int* result_length1);
guint32 dvb_id_bus_schedule_NowPlaying (DVBIDBusSchedule* self);
guint32 dvb_id_bus_schedule_Next (DVBIDBusSchedule* self, guint32 event_id);
char* dvb_id_bus_schedule_GetName (DVBIDBusSchedule* self, guint32 event_id);
char* dvb_id_bus_schedule_GetShortDescription (DVBIDBusSchedule* self, guint32 event_id);
char* dvb_id_bus_schedule_GetExtendedDescription (DVBIDBusSchedule* self, guint32 event_id);
guint dvb_id_bus_schedule_GetDuration (DVBIDBusSchedule* self, guint32 event_id);
guint* dvb_id_bus_schedule_GetLocalStartTime (DVBIDBusSchedule* self, guint32 event_id, int* result_length1);
gboolean dvb_id_bus_schedule_IsRunning (DVBIDBusSchedule* self, guint32 event_id);
gboolean dvb_id_bus_schedule_IsScrambled (DVBIDBusSchedule* self, guint32 event_id);
void dvb_id_bus_schedule_dbus_register_object (DBusConnection* connection, const char* path, void* object);
DBusHandlerResult dvb_id_bus_schedule_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
GType dvb_id_bus_schedule_get_type (void);
DVBIDBusSchedule* dvb_id_bus_schedule_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);


G_END_DECLS

#endif
