/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __SRC_MANAGER_H__
#define __SRC_MANAGER_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "src/IDBusManager.h"
#include "src/DeviceGroup.h"
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>

G_BEGIN_DECLS


#define DVB_TYPE_MANAGER (dvb_manager_get_type ())
#define DVB_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_MANAGER, DVBManager))
#define DVB_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_MANAGER, DVBManagerClass))
#define DVB_IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_MANAGER))
#define DVB_IS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_MANAGER))
#define DVB_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_MANAGER, DVBManagerClass))

typedef struct _DVBManager DVBManager;
typedef struct _DVBManagerClass DVBManagerClass;
typedef struct _DVBManagerPrivate DVBManagerPrivate;

struct _DVBManager {
	GObject parent_instance;
	DVBManagerPrivate * priv;
};

struct _DVBManagerClass {
	GObjectClass parent_class;
};


DVBManager* dvb_manager_get_instance (void);
void dvb_manager_shutdown (void);
gboolean dvb_manager_add_device_group (DVBManager* self, DVBDeviceGroup* devgroup);
DVBDeviceGroup* dvb_manager_get_device_group_if_exists (DVBManager* self, guint group_id);
DVBManager* dvb_manager_construct (GType object_type);
DVBManager* dvb_manager_new (void);
void dvb_manager_dbus_register_object (DBusConnection* connection, const char* path, void* object);
DBusHandlerResult dvb_manager_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
GType dvb_manager_get_type (void);


G_END_DECLS

#endif
