/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>


#define DVB_TYPE_CHANNEL_INFO (dvb_channel_info_get_type ())
typedef struct _DVBChannelInfo DVBChannelInfo;

#define DVB_TYPE_ID_BUS_CHANNEL_LIST (dvb_id_bus_channel_list_get_type ())
#define DVB_ID_BUS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_CHANNEL_LIST, DVBIDBusChannelList))
#define DVB_IS_ID_BUS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_CHANNEL_LIST))
#define DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_CHANNEL_LIST, DVBIDBusChannelListIface))

typedef struct _DVBIDBusChannelList DVBIDBusChannelList;
typedef struct _DVBIDBusChannelListIface DVBIDBusChannelListIface;
typedef struct _DVBIDBusChannelListDBusProxy DVBIDBusChannelListDBusProxy;
typedef DBusGProxyClass DVBIDBusChannelListDBusProxyClass;
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _DVBChannelInfo {
	guint id;
	char* name;
};

struct _DVBIDBusChannelListIface {
	GTypeInterface parent_iface;
	guint* (*GetChannels) (DVBIDBusChannelList* self, int* result_length1);
	guint* (*GetRadioChannels) (DVBIDBusChannelList* self, int* result_length1);
	guint* (*GetTVChannels) (DVBIDBusChannelList* self, int* result_length1);
	char* (*GetChannelName) (DVBIDBusChannelList* self, guint channel_id);
	char* (*GetChannelNetwork) (DVBIDBusChannelList* self, guint channel_id);
	gboolean (*IsRadioChannel) (DVBIDBusChannelList* self, guint channel_id);
	char* (*GetChannelURL) (DVBIDBusChannelList* self, guint channel_id);
	DVBChannelInfo* (*GetChannelInfos) (DVBIDBusChannelList* self, int* result_length1);
};

struct _DVBIDBusChannelListDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};



GType dvb_channel_info_get_type (void);
DVBChannelInfo* dvb_channel_info_dup (const DVBChannelInfo* self);
void dvb_channel_info_free (DVBChannelInfo* self);
void dvb_channel_info_copy (const DVBChannelInfo* self, DVBChannelInfo* dest);
void dvb_channel_info_destroy (DVBChannelInfo* self);
GType dvb_id_bus_channel_list_get_type (void);
guint* dvb_id_bus_channel_list_GetChannels (DVBIDBusChannelList* self, int* result_length1);
guint* dvb_id_bus_channel_list_GetRadioChannels (DVBIDBusChannelList* self, int* result_length1);
guint* dvb_id_bus_channel_list_GetTVChannels (DVBIDBusChannelList* self, int* result_length1);
char* dvb_id_bus_channel_list_GetChannelName (DVBIDBusChannelList* self, guint channel_id);
char* dvb_id_bus_channel_list_GetChannelNetwork (DVBIDBusChannelList* self, guint channel_id);
gboolean dvb_id_bus_channel_list_IsRadioChannel (DVBIDBusChannelList* self, guint channel_id);
char* dvb_id_bus_channel_list_GetChannelURL (DVBIDBusChannelList* self, guint channel_id);
DVBChannelInfo* dvb_id_bus_channel_list_GetChannelInfos (DVBIDBusChannelList* self, int* result_length1);
void dvb_id_bus_channel_list_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dvb_id_bus_channel_list_dbus_unregister (DBusConnection* connection, void* user_data);
DBusHandlerResult dvb_id_bus_channel_list_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusMessage* _dbus_dvb_id_bus_channel_list_introspect (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_channel_list_property_get_all (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_channel_list_GetChannels (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_channel_list_GetRadioChannels (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_channel_list_GetTVChannels (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_channel_list_GetChannelName (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_channel_list_GetChannelNetwork (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_channel_list_IsRadioChannel (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_channel_list_GetChannelURL (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static void _vala_DVBChannelInfo_array_free (DVBChannelInfo* array, gint array_length);
static DBusMessage* _dbus_dvb_id_bus_channel_list_GetChannelInfos (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_dvb_id_bus_channel_list_changed (GObject* _sender, guint channel_id, guint type, DBusConnection* _connection);
GType dvb_id_bus_channel_list_dbus_proxy_get_type (void);
DVBIDBusChannelList* dvb_id_bus_channel_list_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
static void _dbus_handle_dvb_id_bus_channel_list_changed (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult dvb_id_bus_channel_list_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	DVB_ID_BUS_CHANNEL_LIST_DBUS_PROXY_DUMMY_PROPERTY
};
static guint* dvb_id_bus_channel_list_dbus_proxy_GetChannels (DVBIDBusChannelList* self, int* result_length1);
static guint* dvb_id_bus_channel_list_dbus_proxy_GetRadioChannels (DVBIDBusChannelList* self, int* result_length1);
static guint* dvb_id_bus_channel_list_dbus_proxy_GetTVChannels (DVBIDBusChannelList* self, int* result_length1);
static char* dvb_id_bus_channel_list_dbus_proxy_GetChannelName (DVBIDBusChannelList* self, guint channel_id);
static char* dvb_id_bus_channel_list_dbus_proxy_GetChannelNetwork (DVBIDBusChannelList* self, guint channel_id);
static gboolean dvb_id_bus_channel_list_dbus_proxy_IsRadioChannel (DVBIDBusChannelList* self, guint channel_id);
static char* dvb_id_bus_channel_list_dbus_proxy_GetChannelURL (DVBIDBusChannelList* self, guint channel_id);
static DVBChannelInfo* dvb_id_bus_channel_list_dbus_proxy_GetChannelInfos (DVBIDBusChannelList* self, int* result_length1);
static void dvb_id_bus_channel_list_dbus_proxy_interface_init (DVBIDBusChannelListIface* iface);
static void dvb_id_bus_channel_list_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dvb_id_bus_channel_list_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);

static const DBusObjectPathVTable _dvb_id_bus_channel_list_dbus_path_vtable = {_dvb_id_bus_channel_list_dbus_unregister, dvb_id_bus_channel_list_dbus_message};
static const _DBusObjectVTable _dvb_id_bus_channel_list_dbus_vtable = {dvb_id_bus_channel_list_dbus_register_object};

static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

void dvb_channel_info_copy (const DVBChannelInfo* self, DVBChannelInfo* dest) {
	const char* _tmp0_;
	_tmp0_ = NULL;
	dest->id = self->id;
	dest->name = (_tmp0_ = self->name, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_));
}


void dvb_channel_info_destroy (DVBChannelInfo* self) {
	self->name = (g_free (self->name), NULL);
}


DVBChannelInfo* dvb_channel_info_dup (const DVBChannelInfo* self) {
	DVBChannelInfo* dup;
	dup = g_new0 (DVBChannelInfo, 1);
	dvb_channel_info_copy (self, dup);
	return dup;
}


void dvb_channel_info_free (DVBChannelInfo* self) {
	dvb_channel_info_destroy (self);
	g_free (self);
}


GType dvb_channel_info_get_type (void) {
	static GType dvb_channel_info_type_id = 0;
	if (dvb_channel_info_type_id == 0) {
		dvb_channel_info_type_id = g_boxed_type_register_static ("DVBChannelInfo", (GBoxedCopyFunc) dvb_channel_info_dup, (GBoxedFreeFunc) dvb_channel_info_free);
	}
	return dvb_channel_info_type_id;
}


/**
         * @returns: List of channel IDs aka SIDs of all channels
         */
guint* dvb_id_bus_channel_list_GetChannels (DVBIDBusChannelList* self, int* result_length1) {
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetChannels (self, result_length1);
}


/**
         * @returns: List of channel IDs aka SIDs of radio channels
         */
guint* dvb_id_bus_channel_list_GetRadioChannels (DVBIDBusChannelList* self, int* result_length1) {
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetRadioChannels (self, result_length1);
}


/**
         * @returns: List of channel IDs aka SIDs of TV channels
         */
guint* dvb_id_bus_channel_list_GetTVChannels (DVBIDBusChannelList* self, int* result_length1) {
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetTVChannels (self, result_length1);
}


/**
         * @channel_id: ID of channel
         * @returns: Name of channel if channel with id exists
         * otherwise an empty string
         */
char* dvb_id_bus_channel_list_GetChannelName (DVBIDBusChannelList* self, guint channel_id) {
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetChannelName (self, channel_id);
}


/**
         * @channel_id: ID of channel
         * @returns: Name of network the channel belongs to
         * if the channel with id exists, otherwise an empty
         * string
         */
char* dvb_id_bus_channel_list_GetChannelNetwork (DVBIDBusChannelList* self, guint channel_id) {
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetChannelNetwork (self, channel_id);
}


/**
         * @channel_id: ID of channel
         * @returns: Whether the channel is a radio channel or not
         */
gboolean dvb_id_bus_channel_list_IsRadioChannel (DVBIDBusChannelList* self, guint channel_id) {
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->IsRadioChannel (self, channel_id);
}


/**
         * @channel_id: ID of channel
         * @returns: URL to watch the channel
         */
char* dvb_id_bus_channel_list_GetChannelURL (DVBIDBusChannelList* self, guint channel_id) {
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetChannelURL (self, channel_id);
}


DVBChannelInfo* dvb_id_bus_channel_list_GetChannelInfos (DVBIDBusChannelList* self, int* result_length1) {
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetChannelInfos (self, result_length1);
}


void _dvb_id_bus_channel_list_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_introspect (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.ChannelList\">\n  <method name=\"GetChannels\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetRadioChannels\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetTVChannels\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelName\">\n    <arg name=\"channel_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelNetwork\">\n    <arg name=\"channel_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"IsRadioChannel\">\n    <arg name=\"channel_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelURL\">\n    <arg name=\"channel_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelInfos\">\n    <arg name=\"result\" type=\"a(us)\" direction=\"out\"/>\n  </method>\n  <signal name=\"Changed\">\n    <arg name=\"channel_id\" type=\"u\"/>\n    <arg name=\"type\" type=\"u\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_property_get_all (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp1_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp1_);
	if (strcmp (interface_name, "org.gnome.DVB.ChannelList") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_GetChannels (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	int result_length1;
	guint* result;
	DBusMessage* reply;
	guint* _tmp2_;
	DBusMessageIter _tmp3_;
	int _tmp4_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = dvb_id_bus_channel_list_GetChannels (self, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp2_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp3_);
	for (_tmp4_ = 0; _tmp4_ < result_length1; _tmp4_++) {
		dbus_uint32_t _tmp5_;
		_tmp5_ = *_tmp2_;
		dbus_message_iter_append_basic (&_tmp3_, DBUS_TYPE_UINT32, &_tmp5_);
		_tmp2_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp3_);
	result = (g_free (result), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_GetRadioChannels (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	int result_length1;
	guint* result;
	DBusMessage* reply;
	guint* _tmp6_;
	DBusMessageIter _tmp7_;
	int _tmp8_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = dvb_id_bus_channel_list_GetRadioChannels (self, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp6_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp7_);
	for (_tmp8_ = 0; _tmp8_ < result_length1; _tmp8_++) {
		dbus_uint32_t _tmp9_;
		_tmp9_ = *_tmp6_;
		dbus_message_iter_append_basic (&_tmp7_, DBUS_TYPE_UINT32, &_tmp9_);
		_tmp6_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp7_);
	result = (g_free (result), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_GetTVChannels (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	int result_length1;
	guint* result;
	DBusMessage* reply;
	guint* _tmp10_;
	DBusMessageIter _tmp11_;
	int _tmp12_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = dvb_id_bus_channel_list_GetTVChannels (self, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp10_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp11_);
	for (_tmp12_ = 0; _tmp12_ < result_length1; _tmp12_++) {
		dbus_uint32_t _tmp13_;
		_tmp13_ = *_tmp10_;
		dbus_message_iter_append_basic (&_tmp11_, DBUS_TYPE_UINT32, &_tmp13_);
		_tmp10_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp11_);
	result = (g_free (result), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_GetChannelName (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint channel_id;
	dbus_uint32_t _tmp14_;
	char* result;
	DBusMessage* reply;
	const char* _tmp15_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	channel_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp14_);
	dbus_message_iter_next (&iter);
	channel_id = _tmp14_;
	result = dvb_id_bus_channel_list_GetChannelName (self, channel_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp15_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp15_);
	result = (g_free (result), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_GetChannelNetwork (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint channel_id;
	dbus_uint32_t _tmp16_;
	char* result;
	DBusMessage* reply;
	const char* _tmp17_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	channel_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp16_);
	dbus_message_iter_next (&iter);
	channel_id = _tmp16_;
	result = dvb_id_bus_channel_list_GetChannelNetwork (self, channel_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp17_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp17_);
	result = (g_free (result), NULL);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_IsRadioChannel (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint channel_id;
	dbus_uint32_t _tmp18_;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp19_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	channel_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp18_);
	dbus_message_iter_next (&iter);
	channel_id = _tmp18_;
	result = dvb_id_bus_channel_list_IsRadioChannel (self, channel_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp19_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp19_);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_GetChannelURL (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint channel_id;
	dbus_uint32_t _tmp20_;
	char* result;
	DBusMessage* reply;
	const char* _tmp21_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	channel_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp20_);
	dbus_message_iter_next (&iter);
	channel_id = _tmp20_;
	result = dvb_id_bus_channel_list_GetChannelURL (self, channel_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp21_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp21_);
	result = (g_free (result), NULL);
	return reply;
}


static void _vala_DVBChannelInfo_array_free (DVBChannelInfo* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			dvb_channel_info_destroy (&array[i]);
		}
	}
	g_free (array);
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_GetChannelInfos (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	int result_length1;
	DVBChannelInfo* result;
	DBusMessage* reply;
	DVBChannelInfo* _tmp22_;
	DBusMessageIter _tmp23_;
	int _tmp24_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = dvb_id_bus_channel_list_GetChannelInfos (self, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp22_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "(us)", &_tmp23_);
	for (_tmp24_ = 0; _tmp24_ < result_length1; _tmp24_++) {
		DBusMessageIter _tmp25_;
		dbus_uint32_t _tmp26_;
		const char* _tmp27_;
		dbus_message_iter_open_container (&_tmp23_, DBUS_TYPE_STRUCT, NULL, &_tmp25_);
		_tmp26_ = (*_tmp22_).id;
		dbus_message_iter_append_basic (&_tmp25_, DBUS_TYPE_UINT32, &_tmp26_);
		_tmp27_ = (*_tmp22_).name;
		dbus_message_iter_append_basic (&_tmp25_, DBUS_TYPE_STRING, &_tmp27_);
		dbus_message_iter_close_container (&_tmp23_, &_tmp25_);
		_tmp22_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp23_);
	result = (_vala_DVBChannelInfo_array_free (result,  result_length1), NULL);
	return reply;
}


DBusHandlerResult dvb_id_bus_channel_list_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_dvb_id_bus_channel_list_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		reply = _dbus_dvb_id_bus_channel_list_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.ChannelList", "GetChannels")) {
		reply = _dbus_dvb_id_bus_channel_list_GetChannels (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.ChannelList", "GetRadioChannels")) {
		reply = _dbus_dvb_id_bus_channel_list_GetRadioChannels (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.ChannelList", "GetTVChannels")) {
		reply = _dbus_dvb_id_bus_channel_list_GetTVChannels (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.ChannelList", "GetChannelName")) {
		reply = _dbus_dvb_id_bus_channel_list_GetChannelName (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.ChannelList", "GetChannelNetwork")) {
		reply = _dbus_dvb_id_bus_channel_list_GetChannelNetwork (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.ChannelList", "IsRadioChannel")) {
		reply = _dbus_dvb_id_bus_channel_list_IsRadioChannel (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.ChannelList", "GetChannelURL")) {
		reply = _dbus_dvb_id_bus_channel_list_GetChannelURL (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.ChannelList", "GetChannelInfos")) {
		reply = _dbus_dvb_id_bus_channel_list_GetChannelInfos (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_dvb_id_bus_channel_list_changed (GObject* _sender, guint channel_id, guint type, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp28_;
	dbus_uint32_t _tmp29_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.ChannelList", "Changed");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp28_ = channel_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp28_);
	_tmp29_ = type;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp29_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void dvb_id_bus_channel_list_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_id_bus_channel_list_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "changed", (GCallback) _dbus_dvb_id_bus_channel_list_changed, connection);
}


static void dvb_id_bus_channel_list_base_init (DVBIDBusChannelListIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("changed", DVB_TYPE_ID_BUS_CHANNEL_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
		g_type_set_qdata (DVB_TYPE_ID_BUS_CHANNEL_LIST, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_id_bus_channel_list_dbus_vtable));
	}
}


GType dvb_id_bus_channel_list_get_type (void) {
	static GType dvb_id_bus_channel_list_type_id = 0;
	if (dvb_id_bus_channel_list_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusChannelListIface), (GBaseInitFunc) dvb_id_bus_channel_list_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_id_bus_channel_list_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusChannelList", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_channel_list_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (dvb_id_bus_channel_list_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &dvb_id_bus_channel_list_dbus_proxy_get_type);
	}
	return dvb_id_bus_channel_list_type_id;
}


G_DEFINE_TYPE_EXTENDED (DVBIDBusChannelListDBusProxy, dvb_id_bus_channel_list_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (DVB_TYPE_ID_BUS_CHANNEL_LIST, dvb_id_bus_channel_list_dbus_proxy_interface_init));
DVBIDBusChannelList* dvb_id_bus_channel_list_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	DVBIDBusChannelList* self;
	self = g_object_new (dvb_id_bus_channel_list_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.DVB.ChannelList", NULL);
	return self;
}


static GObject* dvb_id_bus_channel_list_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (dvb_id_bus_channel_list_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), dvb_id_bus_channel_list_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_dvb_id_bus_channel_list_changed (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	guint channel_id;
	dbus_uint32_t _tmp30_;
	guint type;
	dbus_uint32_t _tmp31_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "uu")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	channel_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp30_);
	dbus_message_iter_next (&iter);
	channel_id = _tmp30_;
	type = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp31_);
	dbus_message_iter_next (&iter);
	type = _tmp31_;
	g_signal_emit_by_name (self, "changed", channel_id, type);
}


DBusHandlerResult dvb_id_bus_channel_list_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.gnome.DVB.ChannelList", "Changed")) {
			_dbus_handle_dvb_id_bus_channel_list_changed (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void dvb_id_bus_channel_list_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((DVBIDBusChannelListDBusProxy*) self)->disposed) {
		return;
	}
	((DVBIDBusChannelListDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), dvb_id_bus_channel_list_dbus_proxy_filter, self);
	G_OBJECT_CLASS (dvb_id_bus_channel_list_dbus_proxy_parent_class)->dispose (self);
}


static void dvb_id_bus_channel_list_dbus_proxy_class_init (DVBIDBusChannelListDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = dvb_id_bus_channel_list_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = dvb_id_bus_channel_list_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = dvb_id_bus_channel_list_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_id_bus_channel_list_dbus_proxy_set_property;
}


static void dvb_id_bus_channel_list_dbus_proxy_init (DVBIDBusChannelListDBusProxy* self) {
}


static guint* dvb_id_bus_channel_list_dbus_proxy_GetChannels (DVBIDBusChannelList* self, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	guint* _result;
	int _result_length1;
	guint* _tmp32_;
	int _tmp32__length;
	int _tmp32__size;
	int _tmp32__length1;
	DBusMessageIter _tmp33_;
	if (((DVBIDBusChannelListDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.ChannelList", "GetChannels");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp32_ = g_new (guint, 5);
	_tmp32__length = 0;
	_tmp32__size = 4;
	_tmp32__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp33_);
	for (; dbus_message_iter_get_arg_type (&_tmp33_); _tmp32__length1++) {
		dbus_uint32_t _tmp34_;
		if (_tmp32__size == _tmp32__length) {
			_tmp32__size = 2 * _tmp32__size;
			_tmp32_ = g_renew (guint, _tmp32_, _tmp32__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp33_, &_tmp34_);
		dbus_message_iter_next (&_tmp33_);
		_tmp32_[_tmp32__length++] = _tmp34_;
	}
	_result_length1 = _tmp32__length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp32_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static guint* dvb_id_bus_channel_list_dbus_proxy_GetRadioChannels (DVBIDBusChannelList* self, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	guint* _result;
	int _result_length1;
	guint* _tmp35_;
	int _tmp35__length;
	int _tmp35__size;
	int _tmp35__length1;
	DBusMessageIter _tmp36_;
	if (((DVBIDBusChannelListDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.ChannelList", "GetRadioChannels");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp35_ = g_new (guint, 5);
	_tmp35__length = 0;
	_tmp35__size = 4;
	_tmp35__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp36_);
	for (; dbus_message_iter_get_arg_type (&_tmp36_); _tmp35__length1++) {
		dbus_uint32_t _tmp37_;
		if (_tmp35__size == _tmp35__length) {
			_tmp35__size = 2 * _tmp35__size;
			_tmp35_ = g_renew (guint, _tmp35_, _tmp35__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp36_, &_tmp37_);
		dbus_message_iter_next (&_tmp36_);
		_tmp35_[_tmp35__length++] = _tmp37_;
	}
	_result_length1 = _tmp35__length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp35_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static guint* dvb_id_bus_channel_list_dbus_proxy_GetTVChannels (DVBIDBusChannelList* self, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	guint* _result;
	int _result_length1;
	guint* _tmp38_;
	int _tmp38__length;
	int _tmp38__size;
	int _tmp38__length1;
	DBusMessageIter _tmp39_;
	if (((DVBIDBusChannelListDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.ChannelList", "GetTVChannels");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp38_ = g_new (guint, 5);
	_tmp38__length = 0;
	_tmp38__size = 4;
	_tmp38__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp39_);
	for (; dbus_message_iter_get_arg_type (&_tmp39_); _tmp38__length1++) {
		dbus_uint32_t _tmp40_;
		if (_tmp38__size == _tmp38__length) {
			_tmp38__size = 2 * _tmp38__size;
			_tmp38_ = g_renew (guint, _tmp38_, _tmp38__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp39_, &_tmp40_);
		dbus_message_iter_next (&_tmp39_);
		_tmp38_[_tmp38__length++] = _tmp40_;
	}
	_result_length1 = _tmp38__length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp38_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_channel_list_dbus_proxy_GetChannelName (DVBIDBusChannelList* self, guint channel_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp41_;
	char* _result;
	const char* _tmp42_;
	if (((DVBIDBusChannelListDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.ChannelList", "GetChannelName");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp41_ = channel_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp41_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp42_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp42_);
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_channel_list_dbus_proxy_GetChannelNetwork (DVBIDBusChannelList* self, guint channel_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp43_;
	char* _result;
	const char* _tmp44_;
	if (((DVBIDBusChannelListDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.ChannelList", "GetChannelNetwork");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp43_ = channel_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp43_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp44_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp44_);
	dbus_message_unref (_reply);
	return _result;
}


static gboolean dvb_id_bus_channel_list_dbus_proxy_IsRadioChannel (DVBIDBusChannelList* self, guint channel_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp45_;
	gboolean _result;
	dbus_bool_t _tmp46_;
	if (((DVBIDBusChannelListDBusProxy*) self)->disposed) {
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.ChannelList", "IsRadioChannel");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp45_ = channel_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp45_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp46_);
	dbus_message_iter_next (&_iter);
	_result = _tmp46_;
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_channel_list_dbus_proxy_GetChannelURL (DVBIDBusChannelList* self, guint channel_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp47_;
	char* _result;
	const char* _tmp48_;
	if (((DVBIDBusChannelListDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.ChannelList", "GetChannelURL");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp47_ = channel_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp47_);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp48_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp48_);
	dbus_message_unref (_reply);
	return _result;
}


static DVBChannelInfo* dvb_id_bus_channel_list_dbus_proxy_GetChannelInfos (DVBIDBusChannelList* self, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	DVBChannelInfo* _result;
	int _result_length1;
	DVBChannelInfo* _tmp49_;
	int _tmp49__length;
	int _tmp49__size;
	int _tmp49__length1;
	DBusMessageIter _tmp50_;
	if (((DVBIDBusChannelListDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.ChannelList", "GetChannelInfos");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp49_ = g_new (DVBChannelInfo, 5);
	_tmp49__length = 0;
	_tmp49__size = 4;
	_tmp49__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp50_);
	for (; dbus_message_iter_get_arg_type (&_tmp50_); _tmp49__length1++) {
		DVBChannelInfo _tmp51_;
		DBusMessageIter _tmp52_;
		dbus_uint32_t _tmp53_;
		const char* _tmp54_;
		if (_tmp49__size == _tmp49__length) {
			_tmp49__size = 2 * _tmp49__size;
			_tmp49_ = g_renew (DVBChannelInfo, _tmp49_, _tmp49__size + 1);
		}
		dbus_message_iter_recurse (&_tmp50_, &_tmp52_);
		dbus_message_iter_get_basic (&_tmp52_, &_tmp53_);
		dbus_message_iter_next (&_tmp52_);
		_tmp51_.id = _tmp53_;
		dbus_message_iter_get_basic (&_tmp52_, &_tmp54_);
		dbus_message_iter_next (&_tmp52_);
		_tmp51_.name = g_strdup (_tmp54_);
		dbus_message_iter_next (&_tmp50_);
		_tmp49_[_tmp49__length++] = _tmp51_;
	}
	_result_length1 = _tmp49__length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp49_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static void dvb_id_bus_channel_list_dbus_proxy_interface_init (DVBIDBusChannelListIface* iface) {
	iface->GetChannels = dvb_id_bus_channel_list_dbus_proxy_GetChannels;
	iface->GetRadioChannels = dvb_id_bus_channel_list_dbus_proxy_GetRadioChannels;
	iface->GetTVChannels = dvb_id_bus_channel_list_dbus_proxy_GetTVChannels;
	iface->GetChannelName = dvb_id_bus_channel_list_dbus_proxy_GetChannelName;
	iface->GetChannelNetwork = dvb_id_bus_channel_list_dbus_proxy_GetChannelNetwork;
	iface->IsRadioChannel = dvb_id_bus_channel_list_dbus_proxy_IsRadioChannel;
	iface->GetChannelURL = dvb_id_bus_channel_list_dbus_proxy_GetChannelURL;
	iface->GetChannelInfos = dvb_id_bus_channel_list_dbus_proxy_GetChannelInfos;
}


static void dvb_id_bus_channel_list_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void dvb_id_bus_channel_list_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}



static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}



