/* Main.c generated by valac 0.12.0, the Vala compiler
 * generated from Main.vala, do not modify */

/*
 * Copyright (C) 2008-2011 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <gee.h>
#include <stdarg.h>
#include <stdio.h>
#include <signal.h>


#define DVB_TYPE_MANAGER (dvb_manager_get_type ())
#define DVB_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_MANAGER, DVBManager))
#define DVB_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_MANAGER, DVBManagerClass))
#define DVB_IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_MANAGER))
#define DVB_IS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_MANAGER))
#define DVB_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_MANAGER, DVBManagerClass))

typedef struct _DVBManager DVBManager;
typedef struct _DVBManagerClass DVBManagerClass;

#define DVB_TYPE_RECORDINGS_STORE (dvb_recordings_store_get_type ())
#define DVB_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStore))
#define DVB_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))
#define DVB_IS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDINGS_STORE))
#define DVB_IS_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDINGS_STORE))
#define DVB_RECORDINGS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))

typedef struct _DVBRecordingsStore DVBRecordingsStore;
typedef struct _DVBRecordingsStoreClass DVBRecordingsStoreClass;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_TYPE_ID_BUS_MANAGER (dvb_id_bus_manager_get_type ())
#define DVB_ID_BUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_MANAGER, DVBIDBusManager))
#define DVB_IS_ID_BUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_MANAGER))
#define DVB_ID_BUS_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_MANAGER, DVBIDBusManagerIface))

typedef struct _DVBIDBusManager DVBIDBusManager;
typedef struct _DVBIDBusManagerIface DVBIDBusManagerIface;

#define DVB_TYPE_ID_BUS_MANAGER_PROXY (dvb_id_bus_manager_proxy_get_type ())

#define DVB_TYPE_CHANNEL_GROUP_INFO (dvb_channel_group_info_get_type ())
typedef struct _DVBChannelGroupInfo DVBChannelGroupInfo;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DVB_TYPE_ID_BUS_RECORDINGS_STORE (dvb_id_bus_recordings_store_get_type ())
#define DVB_ID_BUS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_RECORDINGS_STORE, DVBIDBusRecordingsStore))
#define DVB_IS_ID_BUS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_RECORDINGS_STORE))
#define DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_RECORDINGS_STORE, DVBIDBusRecordingsStoreIface))

typedef struct _DVBIDBusRecordingsStore DVBIDBusRecordingsStore;
typedef struct _DVBIDBusRecordingsStoreIface DVBIDBusRecordingsStoreIface;

#define DVB_TYPE_ID_BUS_RECORDINGS_STORE_PROXY (dvb_id_bus_recordings_store_proxy_get_type ())

#define DVB_TYPE_RECORDING_INFO (dvb_recording_info_get_type ())
typedef struct _DVBRecordingInfo DVBRecordingInfo;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))

#define DVB_DATABASE_TYPE_CONFIG_STORE (dvb_database_config_store_get_type ())
#define DVB_DATABASE_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_CONFIG_STORE, DVBdatabaseConfigStore))
#define DVB_DATABASE_IS_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_CONFIG_STORE))
#define DVB_DATABASE_CONFIG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_CONFIG_STORE, DVBdatabaseConfigStoreIface))

typedef struct _DVBdatabaseConfigStore DVBdatabaseConfigStore;
typedef struct _DVBdatabaseConfigStoreIface DVBdatabaseConfigStoreIface;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;

#define DVB_TYPE_CHANNEL_GROUP (dvb_channel_group_get_type ())
#define DVB_CHANNEL_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroup))
#define DVB_CHANNEL_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroupClass))
#define DVB_IS_CHANNEL_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_GROUP))
#define DVB_IS_CHANNEL_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_GROUP))
#define DVB_CHANNEL_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroupClass))

typedef struct _DVBChannelGroup DVBChannelGroup;
typedef struct _DVBChannelGroupClass DVBChannelGroupClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DVB_TYPE_SETTINGS (dvb_settings_get_type ())
#define DVB_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SETTINGS, DVBSettings))
#define DVB_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SETTINGS, DVBSettingsClass))
#define DVB_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SETTINGS))
#define DVB_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SETTINGS))
#define DVB_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SETTINGS, DVBSettingsClass))

typedef struct _DVBSettings DVBSettings;
typedef struct _DVBSettingsClass DVBSettingsClass;

#define DVB_LOGGING_TYPE_FILE_HANDLER (dvb_logging_file_handler_get_type ())
#define DVB_LOGGING_FILE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_FILE_HANDLER, DVBLoggingFileHandler))
#define DVB_LOGGING_FILE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_FILE_HANDLER, DVBLoggingFileHandlerClass))
#define DVB_LOGGING_IS_FILE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_FILE_HANDLER))
#define DVB_LOGGING_IS_FILE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_FILE_HANDLER))
#define DVB_LOGGING_FILE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_FILE_HANDLER, DVBLoggingFileHandlerClass))

typedef struct _DVBLoggingFileHandler DVBLoggingFileHandler;
typedef struct _DVBLoggingFileHandlerClass DVBLoggingFileHandlerClass;

#define DVB_LOGGING_TYPE_HANDLER (dvb_logging_handler_get_type ())
#define DVB_LOGGING_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_HANDLER, DVBLoggingHandler))
#define DVB_LOGGING_IS_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_HANDLER))
#define DVB_LOGGING_HANDLER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_LOGGING_TYPE_HANDLER, DVBLoggingHandlerIface))

typedef struct _DVBLoggingHandler DVBLoggingHandler;
typedef struct _DVBLoggingHandlerIface DVBLoggingHandlerIface;

#define DVB_LOGGING_TYPE_LOG_LEVEL (dvb_logging_log_level_get_type ())

#define DVB_LOGGING_TYPE_FORMATTER (dvb_logging_formatter_get_type ())
#define DVB_LOGGING_FORMATTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_FORMATTER, DVBLoggingFormatter))
#define DVB_LOGGING_IS_FORMATTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_FORMATTER))
#define DVB_LOGGING_FORMATTER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_LOGGING_TYPE_FORMATTER, DVBLoggingFormatterIface))

typedef struct _DVBLoggingFormatter DVBLoggingFormatter;
typedef struct _DVBLoggingFormatterIface DVBLoggingFormatterIface;

#define DVB_LOGGING_TYPE_CONSOLE_HANDLER (dvb_logging_console_handler_get_type ())
#define DVB_LOGGING_CONSOLE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_CONSOLE_HANDLER, DVBLoggingConsoleHandler))
#define DVB_LOGGING_CONSOLE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_CONSOLE_HANDLER, DVBLoggingConsoleHandlerClass))
#define DVB_LOGGING_IS_CONSOLE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_CONSOLE_HANDLER))
#define DVB_LOGGING_IS_CONSOLE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_CONSOLE_HANDLER))
#define DVB_LOGGING_CONSOLE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_CONSOLE_HANDLER, DVBLoggingConsoleHandlerClass))

typedef struct _DVBLoggingConsoleHandler DVBLoggingConsoleHandler;
typedef struct _DVBLoggingConsoleHandlerClass DVBLoggingConsoleHandlerClass;

#define DVB_LOGGING_TYPE_DEFAULT_FORMATTER (dvb_logging_default_formatter_get_type ())
#define DVB_LOGGING_DEFAULT_FORMATTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_DEFAULT_FORMATTER, DVBLoggingDefaultFormatter))
#define DVB_LOGGING_DEFAULT_FORMATTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_DEFAULT_FORMATTER, DVBLoggingDefaultFormatterClass))
#define DVB_LOGGING_IS_DEFAULT_FORMATTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_DEFAULT_FORMATTER))
#define DVB_LOGGING_IS_DEFAULT_FORMATTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_DEFAULT_FORMATTER))
#define DVB_LOGGING_DEFAULT_FORMATTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_DEFAULT_FORMATTER, DVBLoggingDefaultFormatterClass))

typedef struct _DVBLoggingDefaultFormatter DVBLoggingDefaultFormatter;
typedef struct _DVBLoggingDefaultFormatterClass DVBLoggingDefaultFormatterClass;

#define DVB_LOGGING_TYPE_COLOR_FORMATTER (dvb_logging_color_formatter_get_type ())
#define DVB_LOGGING_COLOR_FORMATTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_COLOR_FORMATTER, DVBLoggingColorFormatter))
#define DVB_LOGGING_COLOR_FORMATTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_COLOR_FORMATTER, DVBLoggingColorFormatterClass))
#define DVB_LOGGING_IS_COLOR_FORMATTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_COLOR_FORMATTER))
#define DVB_LOGGING_IS_COLOR_FORMATTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_COLOR_FORMATTER))
#define DVB_LOGGING_COLOR_FORMATTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_COLOR_FORMATTER, DVBLoggingColorFormatterClass))

typedef struct _DVBLoggingColorFormatter DVBLoggingColorFormatter;
typedef struct _DVBLoggingColorFormatterClass DVBLoggingColorFormatterClass;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

struct _DVBChannelGroupInfo {
	gint id;
	gchar* name;
};

struct _DVBIDBusManagerIface {
	GTypeInterface parent_iface;
	gboolean (*GetScannerForDevice) (DVBIDBusManager* self, guint adapter, guint frontend, char** opath, gchar** dbusiface, GError** error);
	char** (*GetRegisteredDeviceGroups) (DVBIDBusManager* self, int* result_length1, GError** error);
	gboolean (*GetDeviceGroup) (DVBIDBusManager* self, guint group_id, char** opath, GError** error);
	gboolean (*AddDeviceToNewGroup) (DVBIDBusManager* self, guint adapter, guint frontend, const gchar* channels_conf, const gchar* recordings_dir, const gchar* name, GError** error);
	gboolean (*GetNameOfRegisteredDevice) (DVBIDBusManager* self, guint adapter, guint frontend, gchar** name, GError** error);
	gint (*GetDeviceGroupSize) (DVBIDBusManager* self, GError** error);
	DVBChannelGroupInfo* (*GetChannelGroups) (DVBIDBusManager* self, int* result_length1, GError** error);
	gboolean (*AddChannelGroup) (DVBIDBusManager* self, const gchar* name, gint* channel_group_id, GError** error);
	gboolean (*RemoveChannelGroup) (DVBIDBusManager* self, gint channel_group_id, GError** error);
	GHashTable** (*GetDevices) (DVBIDBusManager* self, int* result_length1, GError** error);
};

struct _DVBRecordingInfo {
	guint32 id;
	gchar* name;
	gchar* description;
	gint64 length;
	gint64 start_timestamp;
	gchar* channel;
	gchar* location;
};

struct _DVBIDBusRecordingsStoreIface {
	GTypeInterface parent_iface;
	guint32* (*GetRecordings) (DVBIDBusRecordingsStore* self, int* result_length1, GError** error);
	gboolean (*GetLocation) (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** location, GError** error);
	gboolean (*GetName) (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** name, GError** error);
	gboolean (*GetDescription) (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** description, GError** error);
	gboolean (*GetStartTime) (DVBIDBusRecordingsStore* self, guint32 rec_id, guint** start_time, int* start_time_length1, GError** error);
	gboolean (*GetStartTimestamp) (DVBIDBusRecordingsStore* self, guint32 rec_id, gint64* timestamp, GError** error);
	gboolean (*GetLength) (DVBIDBusRecordingsStore* self, guint32 rec_id, gint64* length, GError** error);
	gboolean (*Delete) (DVBIDBusRecordingsStore* self, guint32 rec_id, GError** error);
	gboolean (*GetChannelName) (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** name, GError** error);
	gboolean (*GetAllInformations) (DVBIDBusRecordingsStore* self, guint32 rec_id, DVBRecordingInfo* infos, GError** error);
};

typedef enum  {
	DVB_DATABASE_SQL_ERROR_ERROR,
	DVB_DATABASE_SQL_ERROR_INTERNAL,
	DVB_DATABASE_SQL_ERROR_PERM,
	DVB_DATABASE_SQL_ERROR_ABORT,
	DVB_DATABASE_SQL_ERROR_BUSY,
	DVB_DATABASE_SQL_ERROR_LOCKED,
	DVB_DATABASE_SQL_ERROR_NOMEM,
	DVB_DATABASE_SQL_ERROR_READONLY,
	DVB_DATABASE_SQL_ERROR_INTERRUPT,
	DVB_DATABASE_SQL_ERROR_IOERR,
	DVB_DATABASE_SQL_ERROR_CORRUPT,
	DVB_DATABASE_SQL_ERROR_NOTFOUND,
	DVB_DATABASE_SQL_ERROR_FULL,
	DVB_DATABASE_SQL_ERROR_CANTOPEN,
	DVB_DATABASE_SQL_ERROR_PROTOCOL,
	DVB_DATABASE_SQL_ERROR_EMPTY,
	DVB_DATABASE_SQL_ERROR_SCHEMA,
	DVB_DATABASE_SQL_ERROR_TOOBIG,
	DVB_DATABASE_SQL_ERROR_CONSTRAINT,
	DVB_DATABASE_SQL_ERROR_MISMATCH,
	DVB_DATABASE_SQL_ERROR_MISUSE,
	DVB_DATABASE_SQL_ERROR_NOLFS,
	DVB_DATABASE_SQL_ERROR_AUTH,
	DVB_DATABASE_SQL_ERROR_FORMAT,
	DVB_DATABASE_SQL_ERROR_RANGE,
	DVB_DATABASE_SQL_ERROR_NOTADB
} DVBdatabaseSqlError;
#define DVB_DATABASE_SQL_ERROR dvb_database_sql_error_quark ()
struct _DVBdatabaseConfigStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_device_groups) (DVBdatabaseConfigStore* self, GError** error);
	gboolean (*add_device_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* dev_group, GError** error);
	gboolean (*remove_device_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*add_device_to_group) (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*remove_device_from_group) (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*update_from_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*get_parent_group) (DVBdatabaseConfigStore* self, guint adapter, guint frontend, guint* group_id, GError** error);
	gboolean (*add_channel_group) (DVBdatabaseConfigStore* self, const gchar* name, gint* channel_group_id, GError** error);
	gboolean (*remove_channel_group) (DVBdatabaseConfigStore* self, gint group_id, GError** error);
	GeeList* (*get_channel_groups) (DVBdatabaseConfigStore* self, GError** error);
	GeeList* (*get_channels_of_group) (DVBdatabaseConfigStore* self, guint dev_group_id, gint channel_group_id, GError** error);
	gboolean (*add_channel_to_group) (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
	gboolean (*remove_channel_from_group) (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
};

typedef enum  {
	DVB_LOGGING_LOG_LEVEL_LOG,
	DVB_LOGGING_LOG_LEVEL_DEBUG,
	DVB_LOGGING_LOG_LEVEL_INFO,
	DVB_LOGGING_LOG_LEVEL_WARNING,
	DVB_LOGGING_LOG_LEVEL_ERROR
} DVBLoggingLogLevel;

struct _DVBLoggingFormatterIface {
	GTypeInterface parent_iface;
	gchar* (*format) (DVBLoggingFormatter* self, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format);
};

struct _DVBLoggingHandlerIface {
	GTypeInterface parent_iface;
	void (*publish) (DVBLoggingHandler* self, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format, va_list args);
	void (*close) (DVBLoggingHandler* self);
	DVBLoggingFormatter* (*get_formatter) (DVBLoggingHandler* self);
	void (*set_formatter) (DVBLoggingHandler* self, DVBLoggingFormatter* value);
	DVBLoggingLogLevel (*get_threshold) (DVBLoggingHandler* self);
	void (*set_threshold) (DVBLoggingHandler* self, DVBLoggingLogLevel value);
};


extern DVBManager* main_manager;
DVBManager* main_manager = NULL;
extern DVBRecordingsStore* main_recstore;
DVBRecordingsStore* main_recstore = NULL;
extern gboolean main_has_debug;
gboolean main_has_debug = FALSE;
extern gboolean main_has_version;
gboolean main_has_version = FALSE;
extern gboolean main_disable_epg_scanner;
gboolean main_disable_epg_scanner = FALSE;
extern gboolean main_disable_mediaserver;
gboolean main_disable_mediaserver = FALSE;
extern GMainLoop* main_mainloop;
GMainLoop* main_mainloop = NULL;
extern DVBLoggingLogger* main_log;
DVBLoggingLogger* main_log = NULL;
extern GDBusConnection* main_conn;
GDBusConnection* main_conn = NULL;

GType dvb_manager_get_type (void) G_GNUC_CONST;
GType dvb_recordings_store_get_type (void) G_GNUC_CONST;
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
void main_start_manager (void);
DVBManager* dvb_manager_get_instance (void);
void dvb_utils_dbus_own_name (const gchar* service_name, GBusAcquiredCallback cb, void* cb_target);
#define DVB_CONSTANTS_DBUS_SERVICE "org.gnome.DVB"
void main_on_bus_acquired (GDBusConnection* _conn);
static void _main_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
void dvb_utils_dbus_register_object (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GDBusConnection* conn, const gchar* object_path, gconstpointer obj);
#define DVB_CONSTANTS_DBUS_MANAGER_PATH "/org/gnome/DVB/Manager"
GType dvb_id_bus_manager_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_manager_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_channel_group_info_get_type (void) G_GNUC_CONST;
DVBChannelGroupInfo* dvb_channel_group_info_dup (const DVBChannelGroupInfo* self);
void dvb_channel_group_info_free (DVBChannelGroupInfo* self);
void dvb_channel_group_info_copy (const DVBChannelGroupInfo* self, DVBChannelGroupInfo* dest);
void dvb_channel_group_info_destroy (DVBChannelGroupInfo* self);
GType dvb_id_bus_manager_get_type (void) G_GNUC_CONST;
void main_start_recordings_store (void);
void main_restore_device_groups (void);
void dvb_logging_logger_info (DVBLoggingLogger* self, const gchar* format, ...);
DVBRecordingsStore* dvb_recordings_store_get_instance (void);
#define DVB_CONSTANTS_DBUS_RECORDINGS_STORE_PATH "/org/gnome/DVB/RecordingsStore"
GType dvb_id_bus_recordings_store_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_recordings_store_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_recording_info_get_type (void) G_GNUC_CONST;
DVBRecordingInfo* dvb_recording_info_dup (const DVBRecordingInfo* self);
void dvb_recording_info_free (DVBRecordingInfo* self);
void dvb_recording_info_copy (const DVBRecordingInfo* self, DVBRecordingInfo* dest);
void dvb_recording_info_destroy (DVBRecordingInfo* self);
GType dvb_id_bus_recordings_store_get_type (void) G_GNUC_CONST;
void main_on_exit (gint signum);
void dvb_rtsp_server_shutdown (void);
void dvb_manager_shutdown (void);
void dvb_factory_shutdown (void);
void dvb_recordings_store_shutdown (void);
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
void dvb_logging_log_manager_cleanup (DVBLoggingLogManager* self);
gboolean main_get_disable_epg_scanner (void);
gboolean main_check_feature_version (const gchar* name, guint major, guint minor, guint micro);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
gboolean main_check_requirements (void);
GType dvb_device_group_get_type (void) G_GNUC_CONST;
GQuark dvb_database_sql_error_quark (void);
GType dvb_device_get_type (void) G_GNUC_CONST;
GType dvb_channel_group_get_type (void) G_GNUC_CONST;
GType dvb_channel_get_type (void) G_GNUC_CONST;
GType dvb_database_config_store_get_type (void) G_GNUC_CONST;
DVBdatabaseConfigStore* dvb_factory_get_config_store (void);
GeeList* dvb_database_config_store_get_all_device_groups (DVBdatabaseConfigStore* self, GError** error);
void dvb_manager_restore_device_group_and_timers (DVBManager* self, DVBDeviceGroup* device_group);
guint dvb_device_group_get_Id (DVBDeviceGroup* self);
void main_restore_fake_devices (guint max_group_id);
GType dvb_settings_get_type (void) G_GNUC_CONST;
DVBSettings* dvb_factory_get_settings (void);
GeeList* dvb_settings_get_fake_devices (DVBSettings* self);
DVBDeviceGroup* dvb_device_group_new (guint id, DVBDevice* reference_device, gboolean with_epg_scanner);
DVBDeviceGroup* dvb_device_group_construct (GType object_type, guint id, DVBDevice* reference_device, gboolean with_epg_scanner);
void dvb_device_group_set_Name (DVBDeviceGroup* self, const gchar* value);
gboolean dvb_device_group_add (DVBDeviceGroup* self, DVBDevice* device);
gboolean dvb_manager_restore_device_group (DVBManager* self, DVBDeviceGroup* device_group, gboolean store);
void main_configure_logging (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
DVBLoggingFileHandler* dvb_logging_file_handler_new (const gchar* file_pattern, GError** error);
DVBLoggingFileHandler* dvb_logging_file_handler_construct (GType object_type, const gchar* file_pattern, GError** error);
GType dvb_logging_file_handler_get_type (void) G_GNUC_CONST;
void dvb_logging_file_handler_set_limit (DVBLoggingFileHandler* self, gint value);
gint dvb_logging_file_handler_get_limit (DVBLoggingFileHandler* self);
GType dvb_logging_log_level_get_type (void) G_GNUC_CONST;
GType dvb_logging_formatter_get_type (void) G_GNUC_CONST;
GType dvb_logging_handler_get_type (void) G_GNUC_CONST;
void dvb_logging_handler_set_threshold (DVBLoggingHandler* self, DVBLoggingLogLevel value);
void dvb_logging_logger_addHandler (DVBLoggingLogger* self, DVBLoggingHandler* handler);
DVBLoggingConsoleHandler* dvb_logging_console_handler_new (void);
DVBLoggingConsoleHandler* dvb_logging_console_handler_construct (GType object_type);
GType dvb_logging_console_handler_get_type (void) G_GNUC_CONST;
DVBLoggingColorFormatter* dvb_logging_color_formatter_new (void);
DVBLoggingColorFormatter* dvb_logging_color_formatter_construct (GType object_type);
GType dvb_logging_default_formatter_get_type (void) G_GNUC_CONST;
GType dvb_logging_color_formatter_get_type (void) G_GNUC_CONST;
void dvb_logging_handler_set_formatter (DVBLoggingHandler* self, DVBLoggingFormatter* value);
gint main_main (gchar** args, int args_length1);
static void _main_on_exit_cutils_signal_signal_handler (gint signum);
void dvb_rtsp_server_start (GAsyncReadyCallback _callback_, gpointer _user_data_);
void dvb_rtsp_server_start_finish (GAsyncResult* _res_);
void dvb_media_server2_start_rygel_services (GAsyncReadyCallback _callback_, gpointer _user_data_);
void dvb_media_server2_start_rygel_services_finish (GAsyncResult* _res_);

const GOptionEntry MAIN_options[5] = {{"debug", 'd', 0, G_OPTION_ARG_NONE, &main_has_debug, "Display debug statements on stdout", NULL}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &main_has_version, "Display version number", NULL}, {"disable-epg-scanner", (gchar) 0, 0, G_OPTION_ARG_NONE, &main_disable_epg_scanner, "Disable scanning for EPG data", NULL}, {"disable-mediaserver2", (gchar) 0, 0, G_OPTION_ARG_NONE, &main_disable_mediaserver, "Disable exporting devices and channels according to Rygel's MediaServe" \
"r2 specification", NULL}, {NULL}};

static void _main_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	main_on_bus_acquired (connection);
}


void main_start_manager (void) {
	DVBManager* _tmp0_ = NULL;
	_tmp0_ = dvb_manager_get_instance ();
	main_manager = _tmp0_;
	dvb_utils_dbus_own_name (DVB_CONSTANTS_DBUS_SERVICE, _main_on_bus_acquired_gbus_acquired_callback, NULL);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void main_on_bus_acquired (GDBusConnection* _conn) {
	GDBusConnection* _tmp0_;
	g_return_if_fail (_conn != NULL);
	dvb_utils_dbus_register_object (DVB_TYPE_ID_BUS_MANAGER, (GBoxedCopyFunc) g_object_ref, g_object_unref, _conn, DVB_CONSTANTS_DBUS_MANAGER_PATH, (DVBIDBusManager*) main_manager);
	_tmp0_ = _g_object_ref0 (_conn);
	_g_object_unref0 (main_conn);
	main_conn = _tmp0_;
	main_start_recordings_store ();
	main_restore_device_groups ();
}


void main_start_recordings_store (void) {
	DVBRecordingsStore* _tmp0_ = NULL;
	DVBRecordingsStore* _tmp1_;
	dvb_logging_logger_info (main_log, "Main.vala:63: Creating new RecordingsStore D-Bus service");
	_tmp0_ = dvb_recordings_store_get_instance ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (main_recstore);
	main_recstore = _tmp1_;
	dvb_utils_dbus_register_object (DVB_TYPE_ID_BUS_RECORDINGS_STORE, (GBoxedCopyFunc) g_object_ref, g_object_unref, main_conn, DVB_CONSTANTS_DBUS_RECORDINGS_STORE_PATH, (DVBIDBusRecordingsStore*) main_recstore);
}


void main_on_exit (gint signum) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	dvb_logging_logger_info (main_log, "Main.vala:71: Exiting");
	dvb_rtsp_server_shutdown ();
	dvb_manager_shutdown ();
	dvb_factory_shutdown ();
	dvb_recordings_store_shutdown ();
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	dvb_logging_log_manager_cleanup (_tmp0_);
	_g_object_unref0 (main_recstore);
	main_recstore = NULL;
	main_manager = NULL;
	g_main_loop_quit (main_mainloop);
}


gboolean main_get_disable_epg_scanner (void) {
	gboolean result = FALSE;
	result = main_disable_epg_scanner;
	return result;
}


static gpointer _gst_object_ref0 (gpointer self) {
	return self ? gst_object_ref (self) : NULL;
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


gboolean main_check_feature_version (const gchar* name, guint major, guint minor, guint micro) {
	gboolean result = FALSE;
	GstRegistry* _tmp0_ = NULL;
	GstRegistry* _tmp1_;
	GstRegistry* reg;
	GstPluginFeature* _tmp2_ = NULL;
	GstPluginFeature* feature;
	gboolean ret = FALSE;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = gst_registry_get_default ();
	_tmp1_ = _gst_object_ref0 (_tmp0_);
	reg = _tmp1_;
	_tmp2_ = gst_registry_lookup_feature (reg, name);
	feature = _tmp2_;
	if (feature == NULL) {
		ret = FALSE;
	} else {
		gboolean _tmp3_;
		_tmp3_ = gst_plugin_feature_check_version (feature, major, minor, micro);
		ret = _tmp3_;
	}
	_tmp4_ = bool_to_string (ret);
	_tmp5_ = _tmp4_;
	dvb_logging_logger_debug (main_log, "Main.vala:98: Has %s >= %u.%u.%u: %s", name, major, minor, micro, _tmp5_);
	_g_free0 (_tmp5_);
	result = ret;
	_gst_object_unref0 (feature);
	_gst_object_unref0 (reg);
	return result;
}


gboolean main_check_requirements (void) {
	gboolean result = FALSE;
	gboolean val = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	_tmp0_ = main_check_feature_version ("dvbsrc", (guint) 0, (guint) 10, (guint) 13);
	val = _tmp0_;
	if (!val) {
		result = FALSE;
		return result;
	}
	_tmp1_ = main_check_feature_version ("dvbbasebin", (guint) 0, (guint) 10, (guint) 13);
	val = _tmp1_;
	if (!val) {
		result = FALSE;
		return result;
	}
	_tmp2_ = main_check_feature_version ("mpegtsparse", (guint) 0, (guint) 10, (guint) 13);
	val = _tmp2_;
	if (!val) {
		result = FALSE;
		return result;
	}
	_tmp3_ = main_check_feature_version ("rtpmp2tpay", (guint) 0, (guint) 10, (guint) 14);
	val = _tmp3_;
	result = val;
	return result;
}


void main_restore_device_groups (void) {
	DVBdatabaseConfigStore* _tmp0_ = NULL;
	DVBdatabaseConfigStore* config_store;
	GeeList* device_groups = NULL;
	GeeList* _tmp1_ = NULL;
	GeeList* _tmp2_;
	guint max_group_id;
	gint _tmp3_;
	GError * _inner_error_ = NULL;
	_tmp0_ = dvb_factory_get_config_store ();
	config_store = _tmp0_;
	_tmp1_ = dvb_database_config_store_get_all_device_groups (config_store, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			goto __catch77_dvb_database_sql_error;
		}
		_g_object_unref0 (device_groups);
		_g_object_unref0 (config_store);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (device_groups);
	device_groups = _tmp2_;
	goto __finally77;
	__catch77_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("Main.vala:124: %s", e->message);
		_g_error_free0 (e);
		_g_object_unref0 (device_groups);
		_g_object_unref0 (config_store);
		return;
	}
	__finally77:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (device_groups);
		_g_object_unref0 (config_store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	max_group_id = (guint) 0;
	_tmp3_ = gee_collection_get_size ((GeeCollection*) device_groups);
	dvb_logging_logger_info (main_log, "Main.vala:129: Restoring %d device groups", _tmp3_);
	{
		GeeList* _tmp4_;
		GeeList* _device_group_list;
		gint _tmp5_;
		gint _device_group_size;
		gint _device_group_index;
		_tmp4_ = _g_object_ref0 (device_groups);
		_device_group_list = _tmp4_;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _device_group_list);
		_device_group_size = _tmp5_;
		_device_group_index = -1;
		while (TRUE) {
			gpointer _tmp6_ = NULL;
			DVBDeviceGroup* device_group;
			guint _tmp7_;
			_device_group_index = _device_group_index + 1;
			if (!(_device_group_index < _device_group_size)) {
				break;
			}
			_tmp6_ = gee_list_get (_device_group_list, _device_group_index);
			device_group = (DVBDeviceGroup*) _tmp6_;
			dvb_manager_restore_device_group_and_timers (main_manager, device_group);
			_tmp7_ = dvb_device_group_get_Id (device_group);
			if (_tmp7_ > max_group_id) {
				guint _tmp8_;
				_tmp8_ = dvb_device_group_get_Id (device_group);
				max_group_id = _tmp8_;
			}
			_g_object_unref0 (device_group);
		}
		_g_object_unref0 (_device_group_list);
	}
	main_restore_fake_devices (max_group_id);
	_g_object_unref0 (device_groups);
	_g_object_unref0 (config_store);
}


void main_restore_fake_devices (guint max_group_id) {
	DVBSettings* _tmp0_ = NULL;
	DVBSettings* settings;
	GeeList* _tmp1_ = NULL;
	GeeList* devices;
	gint _tmp2_;
	_tmp0_ = dvb_factory_get_settings ();
	settings = _tmp0_;
	_tmp1_ = dvb_settings_get_fake_devices (settings);
	devices = _tmp1_;
	_tmp2_ = gee_collection_get_size ((GeeCollection*) devices);
	if (_tmp2_ > 0) {
		gpointer _tmp3_ = NULL;
		DVBDevice* ref_dev;
		DVBDeviceGroup* _tmp4_ = NULL;
		DVBDeviceGroup* group;
		_tmp3_ = gee_list_get (devices, 0);
		ref_dev = (DVBDevice*) _tmp3_;
		_tmp4_ = dvb_device_group_new (max_group_id + 1, ref_dev, FALSE);
		group = _tmp4_;
		dvb_device_group_set_Name (group, "Fake Devices");
		{
			gint i;
			i = 1;
			{
				gboolean _tmp5_;
				_tmp5_ = TRUE;
				while (TRUE) {
					gint _tmp6_;
					gpointer _tmp7_ = NULL;
					DVBDevice* _tmp8_;
					if (!_tmp5_) {
						i++;
					}
					_tmp5_ = FALSE;
					_tmp6_ = gee_collection_get_size ((GeeCollection*) devices);
					if (!(i < _tmp6_)) {
						break;
					}
					_tmp7_ = gee_list_get (devices, i);
					_tmp8_ = (DVBDevice*) _tmp7_;
					dvb_device_group_add (group, _tmp8_);
					_g_object_unref0 (_tmp8_);
				}
			}
		}
		dvb_manager_restore_device_group (main_manager, group, FALSE);
		_g_object_unref0 (group);
		_g_object_unref0 (ref_dev);
	}
	_g_object_unref0 (devices);
	_g_object_unref0 (settings);
}


void main_configure_logging (void) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogManager* _tmp1_;
	DVBLoggingLogManager* manager;
	DVBLoggingLogger* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* cache_dir;
	GFile* _tmp5_ = NULL;
	GFile* our_cache;
	GFile* _tmp6_ = NULL;
	GFile* log_file;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	DVBLoggingFileHandler* _tmp9_ = NULL;
	DVBLoggingFileHandler* _tmp10_;
	DVBLoggingFileHandler* fhandler;
	DVBLoggingConsoleHandler* _tmp12_ = NULL;
	DVBLoggingConsoleHandler* chandler;
	DVBLoggingColorFormatter* _tmp13_ = NULL;
	DVBLoggingColorFormatter* _tmp14_;
	GError * _inner_error_ = NULL;
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	manager = _tmp1_;
	_tmp2_ = dvb_logging_log_manager_getDefaultLogger (manager);
	_g_object_unref0 (main_log);
	main_log = _tmp2_;
	_tmp3_ = g_get_user_cache_dir ();
	_tmp4_ = g_file_new_for_path (_tmp3_);
	cache_dir = _tmp4_;
	_tmp5_ = g_file_get_child (cache_dir, "gnome-dvb-daemon");
	our_cache = _tmp5_;
	_tmp6_ = g_file_get_child (our_cache, "debug%d.log");
	log_file = _tmp6_;
	_tmp7_ = g_file_get_path (log_file);
	_tmp8_ = _tmp7_;
	_tmp9_ = dvb_logging_file_handler_new (_tmp8_, &_inner_error_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	fhandler = _tmp10_;
	if (_inner_error_ != NULL) {
		goto __catch78_g_error;
	}
	dvb_logging_file_handler_set_limit (fhandler, 1024 * 1024);
	if (main_has_debug) {
		gint _tmp11_;
		_tmp11_ = dvb_logging_file_handler_get_limit (fhandler);
		dvb_logging_file_handler_set_limit (fhandler, _tmp11_ * 5);
	} else {
		dvb_logging_handler_set_threshold ((DVBLoggingHandler*) fhandler, DVB_LOGGING_LOG_LEVEL_WARNING);
	}
	dvb_logging_logger_addHandler (main_log, (DVBLoggingHandler*) fhandler);
	_g_object_unref0 (fhandler);
	goto __finally78;
	__catch78_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "*** Failed creating DVB.Logging.FileHandler: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally78:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (log_file);
		_g_object_unref0 (our_cache);
		_g_object_unref0 (cache_dir);
		_g_object_unref0 (manager);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp12_ = dvb_logging_console_handler_new ();
	chandler = _tmp12_;
	_tmp13_ = dvb_logging_color_formatter_new ();
	_tmp14_ = _tmp13_;
	dvb_logging_handler_set_formatter ((DVBLoggingHandler*) chandler, (DVBLoggingFormatter*) _tmp14_);
	_g_object_unref0 (_tmp14_);
	if (!main_has_debug) {
		dvb_logging_handler_set_threshold ((DVBLoggingHandler*) chandler, DVB_LOGGING_LOG_LEVEL_ERROR);
	}
	dvb_logging_logger_addHandler (main_log, (DVBLoggingHandler*) chandler);
	_g_object_unref0 (chandler);
	_g_object_unref0 (log_file);
	_g_object_unref0 (our_cache);
	_g_object_unref0 (cache_dir);
	_g_object_unref0 (manager);
}


static void _main_on_exit_cutils_signal_signal_handler (gint signum) {
	main_on_exit (signum);
}


gint main_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* _tmp0_ = NULL;
	GOptionContext* context;
	GOptionGroup* _tmp1_ = NULL;
	GMainLoop* _tmp2_ = NULL;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	g_setenv ("TZ", "/etc/localtime", FALSE);
	signal (SIGINT, _main_on_exit_cutils_signal_signal_handler);
	signal (SIGTERM, _main_on_exit_cutils_signal_signal_handler);
	_tmp0_ = g_option_context_new ("- record and watch TV shows using one or more DVB adapters");
	context = _tmp0_;
	g_option_context_add_main_entries (context, MAIN_options, NULL);
	_tmp1_ = gst_init_get_option_group ();
	g_option_context_add_group (context, _tmp1_);
	g_option_context_parse (context, &args_length1, &args, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_OPTION_ERROR) {
			goto __catch79_g_option_error;
		}
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	goto __finally79;
	__catch79_g_option_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "%s\n", e->message);
		fprintf (stderr, "Run '%s --help' to see a full list of available command line options.\n", args[0]);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally79:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (main_has_version) {
		fprintf (stdout, "%s", PACKAGE_NAME);
		fprintf (stdout, " %s\n", PACKAGE_VERSION);
		result = 0;
		_g_option_context_free0 (context);
		return result;
	}
	_tmp2_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (main_mainloop);
	main_mainloop = _tmp2_;
	gst_init (&args_length1, &args);
	main_configure_logging ();
	_tmp3_ = main_check_requirements ();
	if (!_tmp3_) {
		fprintf (stderr, "You don't have all of the necessary requirements to run %s.\n", PACKAGE_NAME);
		fprintf (stderr, "Start the daemon with the --debug flag for more details.\n");
		result = -1;
		_g_option_context_free0 (context);
		return result;
	}
	main_start_manager ();
	dvb_rtsp_server_start (NULL, NULL);
	if (!main_disable_mediaserver) {
		dvb_media_server2_start_rygel_services (NULL, NULL);
	}
	g_main_loop_run (main_mainloop);
	result = 0;
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return main_main (argv, argc);
}



