# Infrared Remote Control Properties for GNOME
# Copyright (C) 2008 Fluendo Embedded S.L. (www.fluendo.com)
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
'''
File upload services.
'''

from cookielib                                         import CookieJar
from gnome_lirc_properties.upload.MultipartPostHandler import MultipartPostHandler
from urllib2                                           import HTTPCookieProcessor, build_opener

class HttpUploader:
    '''
    Used to upload files to a web service.
    This currently uploads to MediaWiki sites, but that is just an example.
    '''

    def __init__(self, upload_url, login_url = None, login_user = None, login_password = None):
        self.__upload_url = upload_url
        self.__login_url = login_url
        self.__login_user = login_user
        self.__login_password = login_password
        self.__logged_in = False

        # This maintains state (cookies) so that the login post can accept cookies,
        # and so that the upload post can provide the cookies received in the login post.
        self.__cookies = CookieJar()

    def _login(self):
        '''
        Exercise login procedure to get required session cookies.
        '''

        if (None == self.__login_url or
            None == self.__login_user or
            None == self.__login_password):
            return

        # Parameters for mediawiki login:
        params = {
            'wpName'     : self.__login_user,
            'wpPassword' : self.__login_password,
        }

        # We use a custom OpenerDirector, instead of just using urllib2.openurl(),
        # so we can specify handlers to use our cookies store, and multipart posts.
        opener = build_opener(HTTPCookieProcessor(self.__cookies), MultipartPostHandler)

        # Using params makes this a POST instead of a GET:
        opener.open(self.__login_url, params)

        # TODO: Catch exceptions.
        # TODO: Some error checking, though this probably requires screen scraping.

    def post_file(self, filepath, name):
        '''
        Uploads a certain file to some MediaWiki.
        '''

        # Log in first, if necessary:
        if not self.__logged_in:
            self._login()

        # Parameters for mediawiki upload:
        # The name should start with a capital letter, and have no spaces,
        # else MediaWiki will ask for confirmation of an automatic name change.
        params = {
            'wpUploadFile'        : open(filepath, 'rb'),
            'wpSourceType'        : 'file',
            'wpDestFile'          : name,
            'wpUploadDescription' : name,
        }

        # We use a custom OpenerDirector, instead of just using urllib2.openurl(),
        # so we can specify handlers to use our cookies store, and multipart posts.
        opener = build_opener(HTTPCookieProcessor(self.__cookies), MultipartPostHandler)

        # Using params makes this a POST instead of a GET:
        response = opener.open(self.__upload_url, params)
        print response.read()

        # TODO: Catch exceptions.
        # TODO: Some error checking, though this probably requires screen scraping.
