/* 
* gok-spy.h 
* 
* utility for getting accessible application UI info 
* 
* Copyright 2002 Sun Microsystems, Inc.,
* Copyright 2002 University Of Toronto 
* 
* This library is free software; you can redistribute it and/or 
* modify it under the terms of the GNU Library General Public 
* License as published by the Free Software Foundation; either 
* version 2 of the License, or (at your option) any later version. 
* 
* This library is distributed in the hope that it will be useful, 
* but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
* Library General Public License for more details. 
* 
* You should have received a copy of the GNU Library General Public 
* License along with this library; if not, write to the 
* Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
* Boston, MA 02111-1307, USA. 
*/ 
 

#ifndef __GOKSPY_H__ 
#define __GOKSPY_H__ 
 
#include "gok-spy-priv.h" 
 
#ifdef __cplusplus 
extern "C" { 
#endif /* __cplusplus */ 

/*G_LOCK_DEFINE_STATIC(gok_spy_mutex);*/
#define GOKSPY_ROLE_APPLICATION -1
#define GOKSPY_ROLE_EDITABLETEXT -2

typedef enum {
	GOK_SPY_SEARCH_ROLE,
	GOK_SPY_SEARCH_MENU,
	GOK_SPY_SEARCH_UI,
	GOK_SPY_SEARCH_EDITABLE_TEXT,
	GOK_SPY_SEARCH_APPLICATIONS,
	GOK_SPY_SEARCH_ALL
} GokSpySearchType;

void gok_spy_open(void);        /* call this first (user must call SPI_init first) */
void gok_spy_close(void);       /* call this when shutting down */ 
 
// listener support 
void gok_spy_register_appchangelistener(AppChangeListener* callback); 
void gok_spy_deregister_appchangelistener(AppChangeListener* callback); 
 
void gok_spy_register_windowchangelistener(AppChangeListener* callback); 
void gok_spy_deregister_windowchangelistener(AppChangeListener* callback); 

void gok_spy_register_mousebuttonlistener(MouseButtonListener* callback); 
void gok_spy_deregister_mousebuttonlistener(MouseButtonListener* callback); 

gulong gok_spy_get_modmask (void);

/* gboolean gok_spy_is_desktop(Accessible* pAccessible); */
/* gboolean gok_spy_accessible_is_desktopChild(Accessible* accessible);*/
/* AccessibleNode* gok_spy_get_applications( void ); */
AccessibleNode* gok_spy_get_list( Accessible* paccessible, GokSpySearchType type, AccessibleRole role ); 
AccessibleNode* gok_spy_get_ui_list( Accessible* paccessible); 
AccessibleNode* gok_spy_refresh( AccessibleNode* plist); 
void gok_spy_free( AccessibleNode* plist ); /* call this to free up an uneeded list's memory */ 

Accessible* gok_spy_get_accessibleWithEditableText(void);

gboolean gok_spy_has_child (Accessible* accessible, GokSpySearchType type, AccessibleRole role); 

void gok_spy_check_queues(void);
gboolean gok_spy_check_window(AccessibleRole role);
void gok_spy_add_idle_handler (void);
void gok_spy_remove_idle_handler (void);

/* for debugging: */
void gok_spy_accessible_ref(Accessible* accessible);
void gok_spy_accessible_implicit_ref(Accessible* accessible);
void gok_spy_accessible_unref(Accessible* accessible);
 
 
#ifdef __cplusplus 
} 
#endif /* __cplusplus */ 
 
#endif // #ifndef __GOKSPY_H__
