
extern "C"
{
#include <glib-object.h>
#include <gdk/gdkenumtypes.h>
}

#include <gdkmm/colormap.h>
#include <gdkmm/private/colormap_p.h>

// -*- c++ -*-
/* $Id: colormap.ccg,v 1.4 2001/12/19 07:31:16 kenelson Exp $ */

/*
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdk/gdkcolor.h>

namespace Gdk
{

Colormap::Colormap(const Glib::RefPtr<Visual>& visual, bool allocate)
: Glib::Object( G_OBJECT( gdk_colormap_new(visual->gobj(), (gboolean)allocate) ) )
  {}

} /* namespace Gdk */


namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gdk::Colormap> wrap(GdkColormap* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Gdk::Colormap>( dynamic_cast<Gdk::Colormap*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gdk
{


/* The *_Class implementation: */

GType Colormap_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gdk_colormap_get_type(), "gdkmm__Colormap", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Colormap_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* Colormap_Class::wrap_new(GObject* o)
{
  return new Colormap((GdkColormap*)(o));
}


/* The implementation: */

GdkColormap* Colormap::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<Colormap> Colormap::wrap_specific_type(GdkColormap* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<Colormap> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    Colormap* pCppObject = dynamic_cast<Colormap*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<Colormap>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<Colormap>( new Colormap(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

Colormap::Colormap(GdkColormap* castitem)
: Glib::Object((GObject*)(castitem))
{}

Colormap::~Colormap()
{
}

Colormap::CppClassType Colormap::colormap_class_; //Initialize static member.

GType Colormap::get_type()
{
  return colormap_class_.get_type();
}

GType Colormap::get_base_type()
{
  return gdk_colormap_get_type();
}

Glib::RefPtr<Colormap> Colormap::create(const Glib::RefPtr<Visual>& visual, bool allocate)
{
  return Glib::RefPtr<Colormap>( new Colormap(visual, allocate) );
}
int Colormap::alloc_colors(GdkColor* colors, int ncolors, bool writeable, bool best_match, gboolean* success)
{
  return gdk_colormap_alloc_colors(gobj(), colors, ncolors, static_cast<int>(writeable), static_cast<int>(best_match), success);
}

bool Colormap::alloc_color(Color& color, bool writeable, bool best_match)
{
  return gdk_colormap_alloc_color(gobj(), (color).gobj(), static_cast<int>(writeable), static_cast<int>(best_match));
}

void Colormap::free_colors(GdkColor* colors, int ncolors)
{
  gdk_colormap_free_colors(gobj(), colors, ncolors);
}

void Colormap::query_color(gulong pixel, Color& result)
{
  gdk_colormap_query_color(gobj(), pixel, (result).gobj());
}

Glib::RefPtr<Visual> Colormap::get_visual()
{
  Glib::RefPtr<Visual> retvalue = Gdk::Visual::wrap_specific_type(gdk_colormap_get_visual(gobj()));
  if(!(retvalue.is_null()))
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}


} // namespace Gdk

