
extern "C"
{
#include <glib-object.h>
#include <gdk/gdkenumtypes.h>
}

#include <gdkmm/drawable.h>
#include <gdkmm/private/drawable_p.h>

#include <gdk/gdkenumtypes.h>
// -*- c++ -*-
/* $Id: drawable.ccg,v 1.1 2001/10/12 01:00:53 murrayc Exp $ */

/*
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdk/gdkdrawable.h>

namespace Gdk
{


}


namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gdk::RgbDither>::value_type()
{
  return gdk_rgb_dither_get_type();
}


namespace Glib
{

Glib::RefPtr<Gdk::Drawable> wrap(GdkDrawable* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Gdk::Drawable>( dynamic_cast<Gdk::Drawable*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gdk
{


/* The *_Class implementation: */

GType Drawable_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gdk_drawable_get_type(), "gdkmm__Drawable", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Drawable_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* Drawable_Class::wrap_new(GObject* o)
{
  return new Drawable((GdkDrawable*)(o));
}


/* The implementation: */

GdkDrawable* Drawable::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<Drawable> Drawable::wrap_specific_type(GdkDrawable* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<Drawable> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    Drawable* pCppObject = dynamic_cast<Drawable*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<Drawable>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<Drawable>( new Drawable(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

Drawable::Drawable(GdkDrawable* castitem)
: Glib::Object((GObject*)(castitem))
{}

Drawable::~Drawable()
{
}

Drawable::CppClassType Drawable::drawable_class_; //Initialize static member.

GType Drawable::get_type()
{
  return drawable_class_.get_type();
}

GType Drawable::get_base_type()
{
  return gdk_drawable_get_type();
}

Drawable::Drawable()
: Glib::Object((GObject*)(g_object_new(get_type(), (char*)0)))
{}

Glib::RefPtr<Drawable> Drawable::create()
{
  return Glib::RefPtr<Drawable>( new Drawable() );
}
void Drawable::get_size(int& width, int& height)
{
  gdk_drawable_get_size(gobj(), &width, &height);
}

void Drawable::set_colormap(const Glib::RefPtr<Colormap>& colormap)
{
  gdk_drawable_set_colormap(gobj(), Glib::unwrap(colormap));
}

Glib::RefPtr<Colormap> Drawable::get_colormap()
{
  Glib::RefPtr<Colormap> retvalue = Glib::wrap(gdk_drawable_get_colormap(gobj()));
  if(!(retvalue.is_null()))
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<Visual> Drawable::get_visual()
{
  Glib::RefPtr<Visual> retvalue = Gdk::Visual::wrap_specific_type(gdk_drawable_get_visual(gobj()));
  if(!(retvalue.is_null()))
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

int Drawable::get_depth()
{
  return gdk_drawable_get_depth(gobj());
}

void Drawable::draw_point(const Glib::RefPtr<GC>& gc, int x, int y)
{
  gdk_draw_point(gobj(), Glib::unwrap(gc), x, y);
}

void Drawable::draw_line(const Glib::RefPtr<GC>& gc, int x1, int y1, int x2, int y2)
{
  gdk_draw_line(gobj(), Glib::unwrap(gc), x1, y1, x2, y2);
}

void Drawable::draw_rectangle(const Glib::RefPtr<GC>& gc, int filled, int x, int y, int width, int height)
{
  gdk_draw_rectangle(gobj(), Glib::unwrap(gc), filled, x, y, width, height);
}

void Drawable::draw_arc(const Glib::RefPtr<GC>& gc, int filled, int x, int y, int width, int height, int angle1, int angle2)
{
  gdk_draw_arc(gobj(), Glib::unwrap(gc), filled, x, y, width, height, angle1, angle2);
}

void Drawable::draw_polygon(const Glib::RefPtr<GC>& gc, int filled, GdkPoint* points, int npoints)
{
  gdk_draw_polygon(gobj(), Glib::unwrap(gc), filled, points, npoints);
}

void Drawable::draw_drawable(const Glib::RefPtr<GC>& gc, const Glib::RefPtr<Drawable>& src, int xsrc, int ysrc, int xdest, int ydest, int width, int height)
{
  gdk_draw_drawable(gobj(), Glib::unwrap(gc), Glib::unwrap(src), xsrc, ysrc, xdest, ydest, width, height);
}

void Drawable::draw_image(const Glib::RefPtr<GC>& gc, const Glib::RefPtr<Image>& image, int xsrc, int ysrc, int xdest, int ydest, int width, int height)
{
  gdk_draw_image(gobj(), Glib::unwrap(gc), Glib::unwrap(image), xsrc, ysrc, xdest, ydest, width, height);
}

void Drawable::draw_points(const Glib::RefPtr<GC>& gc, GdkPoint* points, int npoints)
{
  gdk_draw_points(gobj(), Glib::unwrap(gc), points, npoints);
}

void Drawable::draw_segments(const Glib::RefPtr<GC>& gc, GdkSegment* segs, int nsegs)
{
  gdk_draw_segments(gobj(), Glib::unwrap(gc), segs, nsegs);
}

void Drawable::draw_lines(const Glib::RefPtr<GC>& gc, GdkPoint* points, int npoints)
{
  gdk_draw_lines(gobj(), Glib::unwrap(gc), points, npoints);
}

void Drawable::draw_glyphs(const Glib::RefPtr<GC>& gc, PangoFont* font, int x, int y, PangoGlyphString * glyphs)
{
  gdk_draw_glyphs(gobj(), Glib::unwrap(gc), font, x, y, glyphs);
}

void Drawable::draw_layout_line(const Glib::RefPtr<GC>& gc, int x, int y, PangoLayoutLine* line)
{
  gdk_draw_layout_line(gobj(), Glib::unwrap(gc), x, y, line);
}

void Drawable::draw_layout(const Glib::RefPtr<GC>& gc, int x, int y, PangoLayout* layout)
{
  gdk_draw_layout(gobj(), Glib::unwrap(gc), x, y, layout);
}

void Drawable::draw_layout_line_with_colors(const Glib::RefPtr<GC>& gc, int x, int y, PangoLayoutLine * line, const Color& foreground, const Color& background)
{
  gdk_draw_layout_line_with_colors(gobj(), Glib::unwrap(gc), x, y, line, const_cast<GdkColor*>(foreground.gobj()), const_cast<GdkColor*>(background.gobj()));
}

void Drawable::draw_layout_with_colors(const Glib::RefPtr<GC>& gc, int x, int y, PangoLayout* layout, const Color& foreground, const Color& background)
{
  gdk_draw_layout_with_colors(gobj(), Glib::unwrap(gc), x, y, layout, const_cast<GdkColor*>(foreground.gobj()), const_cast<GdkColor*>(background.gobj()));
}

Glib::RefPtr<Image> Drawable::get_image(int x, int y, int width, int height)
{
  Glib::RefPtr<Image> retvalue = Glib::wrap(gdk_drawable_get_image(gobj(), x, y, width, height));
  if(!(retvalue.is_null()))
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Region Drawable::get_clip_region()
{
  return Region(gdk_drawable_get_clip_region(gobj()));
}

Region Drawable::get_visible_region()
{
  return Region(gdk_drawable_get_visible_region(gobj()));
}

void Drawable::draw_rgb_image(const Glib::RefPtr<Gdk::GC>& gc, int x, int y, int width, int height, RgbDither dith, const guchar* rgb_buf, int rowstride)
{
  gdk_draw_rgb_image(gobj(), Glib::unwrap(gc), x, y, width, height, ((GdkRgbDither)(dith)), const_cast<guchar*>(rgb_buf), rowstride);
}

void Drawable::draw_rgb_image_dithalign(const Glib::RefPtr<Gdk::GC>& gc, int x, int y, int width, int height, RgbDither dith, const guchar* rgb_buf, int rowstride, int xdith, int ydith)
{
  gdk_draw_rgb_image_dithalign(gobj(), Glib::unwrap(gc), x, y, width, height, ((GdkRgbDither)(dith)), const_cast<guchar*>(rgb_buf), rowstride, xdith, ydith);
}

void Drawable::draw_rgb_32_image(const Glib::RefPtr<Gdk::GC>& gc, int x, int y, int width, int height, RgbDither dith, const guchar* rgb_buf, int rowstride)
{
  gdk_draw_rgb_32_image(gobj(), Glib::unwrap(gc), x, y, width, height, ((GdkRgbDither)(dith)), const_cast<guchar*>(rgb_buf), rowstride);
}

void Drawable::draw_rgb_32_image_dithalign(const Glib::RefPtr<Gdk::GC>& gc, int x, int y, int width, int height, RgbDither dith, const guchar* rgb_buf, int rowstride, int xdith, int ydith)
{
  gdk_draw_rgb_32_image_dithalign(gobj(), Glib::unwrap(gc), x, y, width, height, ((GdkRgbDither)(dith)), const_cast<guchar*>(rgb_buf), rowstride, xdith, ydith);
}

void Drawable::draw_gray_image(const Glib::RefPtr<Gdk::GC>& gc, int x, int y, int width, int height, RgbDither dith, const guchar* rgb_buf, int rowstride)
{
  gdk_draw_gray_image(gobj(), Glib::unwrap(gc), x, y, width, height, ((GdkRgbDither)(dith)), const_cast<guchar*>(rgb_buf), rowstride);
}

void Drawable::draw_indexed_image(const Glib::RefPtr<Gdk::GC>& gc, int x, int y, int width, int height, RgbDither dith, const guchar* rgb_buf, int rowstride, GdkRgbCmap& cmap)
{
  gdk_draw_indexed_image(gobj(), Glib::unwrap(gc), x, y, width, height, ((GdkRgbDither)(dith)), const_cast<guchar*>(rgb_buf), rowstride, &cmap);
}


} // namespace Gdk

