
#include <gtkmm/celleditable.h>
#include <gtkmm/private/celleditable_p.h>

// -*- c++ -*-
/* $Id: celleditable.ccg,v 1.1 2001/11/07 15:18:49 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkeditable.h>


namespace
{

const Glib::SignalProxyInfo CellEditable_signal_editing_done_info =
{
  "editing_done",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


const Glib::SignalProxyInfo CellEditable_signal_remove_widget_info =
{
  "remove_widget",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};

} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gtk::CellEditable> wrap(GtkCellEditable* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Gtk::CellEditable>( dynamic_cast<Gtk::CellEditable*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gtk
{


/* The *_Class implementation: */

GType CellEditable_Class::get_type()
{
  if (!gtype_) //Create the GType if necessary.
    {
      //Make sure that the parent type has been created:
      CppClassParent::CppObjectType::get_type();

      //Get the size of the base C class:
      GType gtype_base = gtk_cell_editable_get_type();
      gtype_ = gtype_base; //We can not derive from another interface.
/*
      GTypeQuery typeQueryBase = {0 ,};
      g_type_query(gtype_base, &typeQueryBase);

      //Create a derived C type.
      //These init funcs will, in turn, call the init functions in the base C type.
      GTypeInfo info =
        {
          typeQueryBase.class_size, // class_size
          (GBaseInitFunc) 0, // base_init *
          (GBaseFinalizeFunc) 0, // base_finalize
          (GClassInitFunc) class_init_function, // class_init
          0, // class_finalize
          0, // class_data
          typeQueryBase.instance_size, // instance_size
          0, // n_preallocs
          (GInstanceInitFunc) object_init_function // instance_init
        };

      gtype_ = g_type_register_static(gtype_base, "gtkmm__CellEditable", &info, GTypeFlags(0));
*/
    }
  return gtype_;
}

void CellEditable_Class::iface_init_function(BaseClassType* iface)
{
  CppClassParent::iface_init_function((GTypeInterface*)iface);
  BaseClassType* klass = iface; //Allows us to reuse generated code from GObject wrappers.
   klass->start_editing = &start_editing_vfunc_callback;
   klass->editing_done = &editing_done_callback;
  klass->remove_widget = &remove_widget_callback;
}

void CellEditable_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((GTypeInterface*)klass);
}

void CellEditable_Class::object_init_function(BaseObjectType* object)
{
}

void CellEditable_Class::start_editing_vfunc_callback(GtkCellEditable* self, GdkEvent* event)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->start_editing_vfunc(event);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->start_editing)
      (*base->start_editing)(self, event);
  }
}


void CellEditable_Class::editing_done_callback(GtkCellEditable* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_editing_done();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->editing_done)
      (*base->editing_done)(self);
  }
}

void CellEditable_Class::remove_widget_callback(GtkCellEditable* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_remove_widget();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->remove_widget)
      (*base->remove_widget)(self);
  }
}


Glib::ObjectBase* CellEditable_Class::wrap_new(GObject* o)
{
  return new CellEditable((GtkCellEditable*)(o));
}


/* The implementation: */

CellEditable::CellEditable(GtkCellEditable* castitem)
: Glib::Interface((GObject*)(castitem))
{}

CellEditable::~CellEditable()
{
}

/*
GtkCellEditable* CellEditable::gobj_copy()
{
  reference();
  return gobj();
}
*/

Glib::RefPtr<CellEditable> CellEditable::wrap_specific_type(GtkCellEditable* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<CellEditable> refPtr;
  //Check for an existing wrapper:
  CellEditable* pCppObject = dynamic_cast<CellEditable*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
  if(pCppObject)
  {
    //Return the existing wrapper:
    refPtr = Glib::RefPtr<CellEditable>(pCppObject);
  }
  else
  {
    //Create a new wrapper:
    refPtr = Glib::RefPtr<CellEditable>( new CellEditable(gobject) );
  }

  if(take_copy)
    refPtr->reference();

  return refPtr;
}

CellEditable::CellEditable()
{
}


void CellEditable::add_interface(GType gtype_implementer) //static
{
  static const GInterfaceInfo iface_info =
  {
	  (GInterfaceInitFunc)CppClassType::iface_init_function,
	  NULL,
	  NULL
  };

  g_type_add_interface_static(
    gtype_implementer,
    get_type(), //interface_type: whose direct parent type must be G_TYPE_INTERFACE
    &iface_info
  );
}

CellEditable::CppClassType CellEditable::celleditable_class_; //Initialize static member.

GType CellEditable::get_type()
{
  return celleditable_class_.get_type();
}

GType CellEditable::get_base_type()
{
  return gtk_cell_editable_get_type();
}

void CellEditable::editing_done()
{
  gtk_cell_editable_editing_done(gobj());
}

void CellEditable::remove_widget()
{
  gtk_cell_editable_remove_widget(gobj());
}


Glib::SignalProxy0<void> CellEditable::signal_editing_done()
{
  return Glib::SignalProxy0<void>(this, &CellEditable_signal_editing_done_info);
}

Glib::SignalProxy0<void> CellEditable::signal_remove_widget()
{
  return Glib::SignalProxy0<void>(this, &CellEditable_signal_remove_widget_info);
}


void Gtk::CellEditable::on_editing_done()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->editing_done)
    (*base->editing_done)(gobj());
}

void Gtk::CellEditable::on_remove_widget()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->remove_widget)
    (*base->remove_widget)(gobj());
}


void Gtk::CellEditable::start_editing_vfunc(GdkEvent* event)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->start_editing)
    (*base->start_editing)(gobj(),event);
}

void Gtk::CellEditable::start_editing(GdkEvent* event)
{
  start_editing_vfunc(event);
 }

;

} // namespace Gtk

