// -*- c++ -*-
#ifndef _GTKMM_CLIPBOARD_H
#define _GTKMM_CLIPBOARD_H

/* $Id: clipboard.h,v 1.3 2002/03/07 23:33:12 murrayc Exp $ */

/* stockid.h
 *
 * clipboard (C) 2001 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <gtk/gtkclipboard.h>

namespace Gtk
{

class Clipboard
{
public:
  explicit Clipboard(GdkAtom selection = GDK_NONE);
  explicit Clipboard(GtkClipboard* gobject);
  Clipboard(const Clipboard& src);
  virtual ~Clipboard();

  Clipboard& operator=(const Clipboard& src);

  bool operator==(const Clipboard& src) const;

  //TODO: Document arg names.
  typedef SigC::Slot2<void, GtkSelectionData*, guint> SlotGet;
  typedef SigC::Slot0<void> SlotClear;
  bool set(const GtkTargetEntry* targets, guint n_targets, SlotGet slot_get, SlotClear slot_clear);

  Glib::RefPtr<Glib::Object> get_owner();
  void clear();
  void set_text(const Glib::ustring& text);

   //TODO: Document arg names.
  typedef SigC::Slot1<void, GtkSelectionData*> SlotReceived;
  void request_contents(GdkAtom target, SlotReceived slot);

   //TODO: Document arg names.
  typedef SigC::Slot1<void, const Glib::ustring&> SlotTextReceived;
  void request_text(SlotTextReceived slot);

  GtkSelectionData* wait_for_contents(GdkAtom target);
  Glib::ustring wait_for_text();
  bool wait_is_text_available();

  GtkClipboard* gobj();
  const GtkClipboard* gobj() const;

protected:
  GtkClipboard* gobject_;
};

} /* namespace Gtk */


#endif /* _GTKMM_CLIPBOARD_H */

