
#include <gtkmm/misc.h>
#include <gtkmm/private/misc_p.h>

// -*- c++ -*-
/* $Id: misc.ccg,v 1.2 2001/05/10 22:47:54 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkmisc.h>

namespace Gtk
{

}


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::Misc* wrap(GtkMisc* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Misc *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Misc_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_misc_get_type(), "gtkmm__Misc", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Misc_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* Misc_Class::wrap_new(GObject* o)
{
  return manage(new Misc((GtkMisc*)(o)));
}


/* The implementation: */

Misc::Misc(GtkMisc* castitem)
: Gtk::Widget((GtkWidget*)(castitem))
{}

Misc::~Misc()
{
  destroy_();
}

Misc::CppClassType Misc::misc_class_; //Initialize static member.

GType Misc::get_type()
{
  return misc_class_.get_type();
}

GType Misc::get_base_type()
{
  return gtk_misc_get_type();
}

Misc::Misc()
: Gtk::Widget((GtkWidget*)(g_object_new(get_type(), (char*)0)))
{}

void Misc::set_alignment(float xalign, float yalign)
{
  gtk_misc_set_alignment(gobj(), xalign, yalign);
}

void Misc::get_alignment(float& xalign, float& yalign)
{
  gtk_misc_get_alignment(gobj(), &(xalign), &(yalign));
}

void Misc::set_padding(int xpad, int ypad)
{
  gtk_misc_set_padding(gobj(), xpad, ypad);
}

void Misc::get_padding(int& xpad, int& ypad)
{
  gtk_misc_get_padding(gobj(), &xpad, &ypad);
}


Glib::PropertyProxy<float> Misc::property_xalign()
{
  return Glib::PropertyProxy<float>(this, "xalign");
}

Glib::PropertyProxy<float> Misc::property_yalign()
{
  return Glib::PropertyProxy<float>(this, "yalign");
}

Glib::PropertyProxy<int> Misc::property_xpad()
{
  return Glib::PropertyProxy<int>(this, "xpad");
}

Glib::PropertyProxy<int> Misc::property_ypad()
{
  return Glib::PropertyProxy<int>(this, "ypad");
}


} // namespace Gtk

