// -*- c++ -*-
/* $Id: stock.cc,v 1.7 2002/04/02 13:24:46 daniel Exp $ */

/* stockid.h
 *
 * Copyright (C) 2001 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/stock.h>
#include <gtkmm/stockitem.h>


namespace Gtk
{

namespace Stock
{

const BuiltinStockID DIALOG_INFO      = { "gtk-dialog-info" };
const BuiltinStockID DIALOG_WARNING   = { "gtk-dialog-warning" };
const BuiltinStockID DIALOG_ERROR     = { "gtk-dialog-error" };
const BuiltinStockID DIALOG_QUESTION  = { "gtk-dialog-question" };
const BuiltinStockID DND              = { "gtk-dnd" };
const BuiltinStockID DND_MULTIPLE     = { "gtk-dnd-multiple" };
const BuiltinStockID ADD              = { "gtk-add" };
const BuiltinStockID APPLY            = { "gtk-apply" };
const BuiltinStockID BOLD             = { "gtk-bold" };
const BuiltinStockID CANCEL           = { "gtk-cancel" };
const BuiltinStockID CDROM            = { "gtk-cdrom" };
const BuiltinStockID CLEAR            = { "gtk-clear" };
const BuiltinStockID CLOSE            = { "gtk-close" };
const BuiltinStockID CONVERT          = { "gtk-convert" };
const BuiltinStockID COPY             = { "gtk-copy" };
const BuiltinStockID CUT              = { "gtk-cut" };
const BuiltinStockID DELETE           = { "gtk-delete" };
const BuiltinStockID EXECUTE          = { "gtk-execute" };
const BuiltinStockID FIND             = { "gtk-find" };
const BuiltinStockID FIND_AND_REPLACE = { "gtk-find-and-replace" };
const BuiltinStockID FLOPPY           = { "gtk-floppy" };
const BuiltinStockID GOTO_BOTTOM      = { "gtk-goto-bottom" };
const BuiltinStockID GOTO_FIRST       = { "gtk-goto-first" };
const BuiltinStockID GOTO_LAST        = { "gtk-goto-last" };
const BuiltinStockID GOTO_TOP         = { "gtk-goto-top" };
const BuiltinStockID GO_BACK          = { "gtk-go-back" };
const BuiltinStockID GO_DOWN          = { "gtk-go-down" };
const BuiltinStockID GO_FORWARD       = { "gtk-go-forward" };
const BuiltinStockID GO_UP            = { "gtk-go-up" };
const BuiltinStockID HELP             = { "gtk-help" };
const BuiltinStockID HOME             = { "gtk-home" };
const BuiltinStockID INDEX            = { "gtk-index" };
const BuiltinStockID ITALIC           = { "gtk-italic" };
const BuiltinStockID JUMP_TO          = { "gtk-jump-to" };
const BuiltinStockID JUSTIFY_CENTER   = { "gtk-justify-center" };
const BuiltinStockID JUSTIFY_FILL     = { "gtk-justify-fill" };
const BuiltinStockID JUSTIFY_LEFT     = { "gtk-justify-left" };
const BuiltinStockID JUSTIFY_RIGHT    = { "gtk-justify-right" };
const BuiltinStockID MISSING_IMAGE    = { "gtk-missing-image" };
const BuiltinStockID NEW              = { "gtk-new" };
const BuiltinStockID NO               = { "gtk-no" };
const BuiltinStockID OK               = { "gtk-ok" };
const BuiltinStockID OPEN             = { "gtk-open" };
const BuiltinStockID PASTE            = { "gtk-paste" };
const BuiltinStockID PREFERENCES      = { "gtk-preferences" };
const BuiltinStockID PRINT            = { "gtk-print" };
const BuiltinStockID PRINT_PREVIEW    = { "gtk-print-preview" };
const BuiltinStockID PROPERTIES       = { "gtk-properties" };
const BuiltinStockID QUIT             = { "gtk-quit" };
const BuiltinStockID REDO             = { "gtk-redo" };
const BuiltinStockID REFRESH          = { "gtk-refresh" };
const BuiltinStockID REMOVE           = { "gtk-remove" };
const BuiltinStockID REVERT_TO_SAVED  = { "gtk-revert-to-saved" };
const BuiltinStockID SAVE             = { "gtk-save" };
const BuiltinStockID SAVE_AS          = { "gtk-save-as" };
const BuiltinStockID SELECT_COLOR     = { "gtk-select-color" };
const BuiltinStockID SELECT_FONT      = { "gtk-select-font" };
const BuiltinStockID SORT_ASCENDING   = { "gtk-sort-ascending" };
const BuiltinStockID SORT_DESCENDING  = { "gtk-sort-descending" };
const BuiltinStockID SPELL_CHECK      = { "gtk-spell-check" };
const BuiltinStockID STOP             = { "gtk-stop" };
const BuiltinStockID STRIKETHROUGH    = { "gtk-strikethrough" };
const BuiltinStockID UNDELETE         = { "gtk-undelete" };
const BuiltinStockID UNDERLINE        = { "gtk-underline" };
const BuiltinStockID UNDO             = { "gtk-undo" };
const BuiltinStockID YES              = { "gtk-yes" };
const BuiltinStockID ZOOM_100         = { "gtk-zoom-100" };
const BuiltinStockID ZOOM_FIT         = { "gtk-zoom-fit" };
const BuiltinStockID ZOOM_IN          = { "gtk-zoom-in" };
const BuiltinStockID ZOOM_OUT         = { "gtk-zoom-out" };


bool lookup(const Glib::ustring& stock_id, StockItem& item)
{
  GtkStockItem gitem = {0, };
  gboolean result = gtk_stock_lookup(stock_id.c_str(), &gitem);
  item = StockItem(&gitem, true); //true = take_copy.
  return (result != FALSE);
}

Glib::SListHandle<Glib::ustring> get_list_ids()
{
  return Glib::SListHandle<Glib::ustring>(gtk_stock_list_ids(), Glib::OWNERSHIP_DEEP);
}

} // namespace Stock

} // namespace Gtk

