// -*- c++ -*-
/* $Id: stockid.cc,v 1.2 2002/04/02 13:24:46 daniel Exp $ */

/* stockid.cc
 *
 * Copyright (C) 1998-1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/stockid.h>
#include <gtkmm/stock.h>


namespace Gtk
{

StockID::StockID(const Stock::BuiltinStockID& id)
:
  id_ (id.id)
{}

StockID::StockID(const Glib::ustring& id)
:
  id_ (id)
{}

StockID::StockID(const StockID& src)
:
  id_ (src.id_)
{}

StockID::~StockID()
{
}

StockID& StockID::operator=(const StockID& src)
{
  id_ = src.id_;
  return *this;
}

bool StockID::operator==(const StockID& src) const
{
  return id_ == src.id_;
}

Glib::ustring StockID::get_string() const
{
  return id_;
}

} /* namespace Gtk */

