// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TEXTVIEW_H
#define _GTKMM_TEXTVIEW_H

#include <glibmm.h>

/* $Id: textview.hg,v 1.18 2002/04/02 13:25:19 daniel Exp $ */


/* textview.h
 *
 * Copyright(C) 2001 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/container.h>
#include <gtkmm/textbuffer.h>
#include <gtkmm/textmark.h>
#include <gtkmm/menu.h>
#include <gtkmm/adjustment.h>
#include <gtk/gtktextview.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkTextView GtkTextView;
typedef struct _GtkTextViewClass GtkTextViewClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{ class TextView_Class; } // namespace Gtk
namespace Gtk
{


/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 */
enum TextWindowType
{
  TEXT_WINDOW_PRIVATE,
  TEXT_WINDOW_WIDGET,
  TEXT_WINDOW_TEXT,
  TEXT_WINDOW_LEFT,
  TEXT_WINDOW_RIGHT,
  TEXT_WINDOW_TOP,
  TEXT_WINDOW_BOTTOM
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::TextWindowType> : public Glib::Value_Enum<Gtk::TextWindowType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/** @ingroup Widgets
 * @ingroup Containers
 */

class TextView : public Container
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TextView CppObjectType;
  typedef TextView_Class CppClassType;
  typedef GtkTextView BaseObjectType;
  typedef GtkTextViewClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~TextView();

private:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  friend class CppClassType;
  static CppClassType textview_class_;

  TextView(const TextView&);
  TextView& operator=(const TextView&); // not implemented

protected:
  explicit TextView(GtkTextView* castitem);
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type() G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */
  GtkTextView* gobj()             { return (GtkTextView*)(gobject_); }
  const GtkTextView* gobj() const { return (GtkTextView*)(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_set_scroll_adjustments(Adjustment* hadjustment, Adjustment* vadjustment);
  virtual void on_populate_popup(Menu* menu);
  virtual void on_move_cursor(MovementStep step, int count, bool extend_selection);
  virtual void on_page_horizontally(int count, bool extend_selection);
  virtual void on_set_anchor();
  virtual void on_insert_at_cursor(const Glib::ustring& str);
  virtual void on_delete_from_cursor(DeleteType type, int count);
  virtual void on_cut_clipboard();
  virtual void on_copy_clipboard();
  virtual void on_paste_clipboard();
  virtual void on_toggle_overwrite();
  virtual void on_move_focus(DirectionType direction);


private:

public:
  TextView();
  explicit TextView(const Glib::RefPtr<TextBuffer>& buffer);
  

  /** Sets @a buffer as the buffer being displayed by @a text_view. The previous
   * buffer displayed by the text view is unreferenced, and a reference is
   * added to @a buffer. If you owned a reference to @a buffer before passing it
   * to this function, you must remove that reference yourself; Gtk::TextView
   * will not "adopt" it.
   * @param buffer A Gtk::TextBuffer.
   */
  void set_buffer(const Glib::RefPtr<TextBuffer>& buffer);
  
  /** Returns the Gtk::TextBuffer being displayed by this text view.
   * The reference count on the buffer is not incremented; the caller
   * of this function won't own a new reference.
   * @return A Gtk::TextBuffer.
   */
  Glib::RefPtr<TextBuffer> get_buffer();
  
  /** Scrolls @a text_view so that @a iter is on the screen in the position
   * indicated by @a xalign and @a yalign. An alignment of 0.0 indicates
   * left or top, 1.0 indicates right or bottom, 0.5 means center. If @a use_align
   * is <tt>false</tt>, the text scrolls the minimal distance to get the mark onscreen,
   * possibly not scrolling at all. The effective screen for purposes
   * of this function is reduced by a margin of size @a within_margin.
   * NOTE: This function uses the currently-computed height of the
   * lines in the text buffer. Note that line heights are computed
   * in an idle handler; so this function may not have the desired effect
   * if it's called before the height computations. To avoid oddness,
   * consider using scroll_to_mark() which saves a point
   * to be scrolled to after line validation.
   * @param iter A Gtk::TextIter.
   * @param within_margin Margin as a [0.0,0.5) fraction of screen size.
   * @param use_align Whether to use alignment arguments (if <tt>false</tt>, just get the mark onscreen).
   * @param xalign Horizontal alignment of mark within visible area.
   * @param yalign Vertical alignment of mark within visible area.
   * @return <tt>true</tt> if scrolling occurred.
   */
  bool scroll_to_iter(TextIter& iter, double within_margin, bool use_align,
                                                    double xalign, double yalign);
  
  /** Scrolls @a text_view so that @a mark is on the screen in the position
   * indicated by @a xalign and @a yalign. An alignment of 0.0 indicates
   * left or top, 1.0 indicates right or bottom, 0.5 means center. If @a use_align
   * is <tt>false</tt>, the text scrolls the minimal distance to get the mark onscreen,
   * possibly not scrolling at all. The effective screen for purposes
   * of this function is reduced by a margin of size @a within_margin.
   * @param mark A Gtk::TextMark.
   * @param within_margin Margin as a [0.0,0.5) fraction of screen size.
   * @param use_align Whether to use alignment arguments (if <tt>false</tt>, just get the mark onscreen).
   * @param xalign Horizontal alignment of mark within visible area.
   * @param yalign Vertical alignment of mark within visible area.
   */
  void scroll_to_mark(const Glib::RefPtr<TextMark>&mark,
                                                    double within_margin,
                                                    bool use_align,
                                                    double xalign,
                                                    double yalign);
  
  /** Scrolls @a text_view the minimum distance such that @a mark is contained
   * within the visible area of the widget.
   * @param mark A mark in the buffer for @a text_view.
   */
  void scroll_mark_onscreen(const Glib::RefPtr<TextMark>& mark);
  
  /** Moves a mark within the buffer so that it's
   * located within the currently-visible text area.
   * @param mark A Gtk::TextMark.
   * @return <tt>true</tt> if the mark moved (wasn't already onscreen).
   */
  bool move_mark_onscreen(const Glib::RefPtr<TextMark>& mark);
  
  /** Moves the cursor to the currently visible region of the
   * buffer, it it isn't there already.
   * @return TRUE if the cursor had to be moved.
   */
  bool place_cursor_onscreen();

  
  /** Fills @a visible_rect with the currently-visible
   * region of the buffer, in buffer coordinates. Convert to window coordinates
   * with buffer_to_window_coords().
   * @param visible_rect Rectangle to fill.
   */
  void get_visible_rect(Gdk::Rectangle& visible_rect);
  
  /** Toggles whether the insertion point is displayed. A buffer with no editable
   * text probably shouldn't have a visible cursor, so you may want to turn
   * the cursor off.
   * @param setting Whether to show the insertion cursor.
   */
  void set_cursor_visible(bool setting = true);
  
  /** Find out whether the cursor is being displayed.
   * @return Whether the insertion mark is visible.
   */
  bool get_cursor_visible();

  
  /** Gets a rectangle which roughly contains the character at @a iter.
   * The rectangle position is in buffer coordinates; use
   * buffer_to_window_coords() to convert these
   * coordinates to coordinates for one of the windows in the text view.
   * @param iter A Gtk::TextIter.
   * @param location Bounds of the character at @a iter.
   */
  void get_iter_location(const TextIter&  iter,
                                                    Gdk::Rectangle& location);
  
  /** Retrieves the iterator at buffer coordinates @a x and @a y. Buffer
   * coordinates are coordinates for the entire buffer, not just the
   * currently-displayed portion.  If you have coordinates from an
   * event, you have to convert those to buffer coordinates with
   * window_to_buffer_coords().
   * @param iter A Gtk::TextIter.
   * @param x X position, in buffer coordinates.
   * @param y Y position, in buffer coordinates.
   */
  void get_iter_at_location(TextIter& iter, int x, int y);
  
  /** Gets the y coordinate of the top of the line containing @a iter,
   * and the height of the line. The coordinate is a buffer coordinate;
   * convert to window coordinates with buffer_to_window_coords().
   * @param iter A Gtk::TextIter.
   * @param y Return location for a y coordinate.
   * @param height Return location for a height.
   */
  void get_line_yrange(const TextIter&  iter,
                                                   int& y, int& height);

  
  /** Gets the Gtk::TextIter at the start of the line containing
   * the coordinate @a y. @a y is in buffer coordinates, convert from
   * window coordinates with window_to_buffer_coords().
   * If non-<tt>0</tt>, @a line_top will be filled with the coordinate of the top
   * edge of the line.
   * @param target_iter A Gtk::TextIter.
   * @param y A y coordinate.
   * @param line_top Return location for top coordinate of the line.
   */
  void get_line_at_y(TextIter&  target_iter, int y, int& line_top);

  
  /** Converts coordinate (@a buffer_x, @a buffer_y) to coordinates for the window
   * @a win, and stores the result in (@a window_x, @a window_y).
   * @param win A Gtk::TextWindowType.
   * @param buffer_x Buffer x coordinate.
   * @param buffer_y Buffer y coordinate.
   * @param window_x Window x coordinate return location.
   * @param window_y Window y coordinate return location.
   */
  void buffer_to_window_coords(TextWindowType  win,
                                            int buffer_x, int buffer_y,
                                            int& window_x, int& window_y);
  
  /** Converts coordinates on the window identified by @a win to buffer
   * coordinates, storing the result in (@a buffer_x,@a buffer_y).
   * @param win A Gtk::TextWindowType.
   * @param window_x Window x coordinate.
   * @param window_y Window y coordinate.
   * @param buffer_x Buffer x coordinate return location.
   * @param buffer_y Buffer y coordinate return location.
   */
  void window_to_buffer_coords(TextWindowType  win,
                                            int window_x, int window_y,
                                            int& buffer_x, int& buffer_y);

  
  /** Retrieves the Gdk::Window corresponding to an area of the text view;
   * possible windows include the overall widget window, child windows
   * on the left, right, top, bottom, and the window that displays the
   * text buffer. Windows are <tt>0</tt> and nonexistent if their width or
   * height is 0, and are nonexistent before the widget has been
   * realized.
   * @param win Window to get.
   * @return A Gdk::Window, or <tt>0</tt>.
   */
  Glib::RefPtr<Gdk::Window> get_window(TextWindowType win);
  
  /** Usually used to find out which window an event corresponds to.
   * If you connect to an event signal on @a text_view, this function
   * should be called on <tt>event->window</tt> to
   * see which window it was.
   * @param window A window type.
   * @return The window type.
   */
  TextWindowType get_window_type(const Glib::RefPtr<Gdk::Window>& window);

  
  /** Sets the width of Gtk::TEXT_WINDOW_LEFT or Gtk::TEXT_WINDOW_RIGHT,
   * or the height of Gtk::TEXT_WINDOW_TOP or Gtk::TEXT_WINDOW_BOTTOM.
   * Automatically destroys the corresponding window if the size is set
   * to 0, and creates the window if the size is set to non-zero.  This
   * function can only be used for the "border windows," it doesn't work
   * with Gtk::TEXT_WINDOW_WIDGET, Gtk::TEXT_WINDOW_TEXT, or
   * Gtk::TEXT_WINDOW_PRIVATE.
   * @param type Window to affect.
   * @param size Width or height of the window.
   */
  void set_border_window_size(TextWindowType  type, int size);
  
  /** Gets the width of the specified border window. See
   * set_border_window_size().
   * @param type Window to return size from.
   * @return Width of window.
   */
  int get_border_window_size(TextWindowType type);

  
  /** Moves the given @a iter forward by one display (wrapped) line.  A
   * display line is different from a paragraph. Paragraphs are
   * separated by newlines or other paragraph separator characters.
   * Display lines are created by line-wrapping a paragraph.  If
   * wrapping is turned off, display lines and paragraphs will be the
   * same. Display lines are divided differently for each view, since
   * they depend on the view's width; paragraphs are the same in all
   * views, since they depend on the contents of the Gtk::TextBuffer.
   * @param iter A Gtk::TextIter.
   * @return <tt>true</tt> if @a iter was moved and is not on the end iterator.
   */
  bool forward_display_line(TextIter& iter);
  
  /** Moves the given @a iter backward by one display (wrapped) line.  A
   * display line is different from a paragraph. Paragraphs are
   * separated by newlines or other paragraph separator characters.
   * Display lines are created by line-wrapping a paragraph.  If
   * wrapping is turned off, display lines and paragraphs will be the
   * same. Display lines are divided differently for each view, since
   * they depend on the view's width; paragraphs are the same in all
   * views, since they depend on the contents of the Gtk::TextBuffer.
   * @param iter A Gtk::TextIter.
   * @return <tt>true</tt> if @a iter was moved and is not on the end iterator.
   */
  bool backward_display_line(TextIter& iter);
  
  /** Moves the given @a iter forward to the next display line end.  A
   * display line is different from a paragraph. Paragraphs are
   * separated by newlines or other paragraph separator characters.
   * Display lines are created by line-wrapping a paragraph.  If
   * wrapping is turned off, display lines and paragraphs will be the
   * same. Display lines are divided differently for each view, since
   * they depend on the view's width; paragraphs are the same in all
   * views, since they depend on the contents of the Gtk::TextBuffer.
   * @param iter A Gtk::TextIter.
   * @return <tt>true</tt> if @a iter was moved and is not on the end iterator.
   */
  bool forward_display_line_end(TextIter& iter);
  
  /** Moves the given @a iter backward to the next display line start.  A
   * display line is different from a paragraph. Paragraphs are
   * separated by newlines or other paragraph separator characters.
   * Display lines are created by line-wrapping a paragraph.  If
   * wrapping is turned off, display lines and paragraphs will be the
   * same. Display lines are divided differently for each view, since
   * they depend on the view's width; paragraphs are the same in all
   * views, since they depend on the contents of the Gtk::TextBuffer.
   * @param iter A Gtk::TextIter.
   * @return <tt>true</tt> if @a iter was moved and is not on the end iterator.
   */
  bool backward_display_line_start(TextIter& iter);
  
  /** Determines whether @a iter is at the start of a display line.
   * See forward_display_line() for an explanation of
   * display lines vs. paragraphs.
   * @param iter A Gtk::TextIter.
   * @return <tt>true</tt> if @a iter begins a wrapped line.
   */
  bool starts_display_line(const TextIter&  iter);
  
  /** Moves @a iter up or down by @a count display (wrapped) lines.
   * See forward_display_line() for an explanation of
   * display lines vs. paragraphs.
   * @param iter A Gtk::TextIter.
   * @param count Number of lines to move.
   * @return <tt>true</tt> if @a iter moved and is not on the end iterator.
   */
  bool move_visually(TextIter& iter, int count);

/* Adding child widgets */
  
  /** Adds a child widget in the text buffer, at the given @a anchor.
   * @param child A Gtk::Widget.
   * @param anchor A Gtk::TextChildAnchor in the Gtk::TextBuffer for @a text_view.
   */
  void add_child_at_anchor(Widget& child, const Glib::RefPtr<TextChildAnchor>& anchor);

  
  /** Adds a child at fixed coordinates in one of the text widget's
   * windows.  The window must have nonzero size (see
   * set_border_window_size()).  Note that the child
   * coordinates are given relative to the Gdk::Window in question, and
   * that these coordinates have no sane relationship to scrolling. When
   * placing a child in Gtk::TEXT_WINDOW_WIDGET, scrolling is
   * irrelevant, the child floats above all scrollable areas. But when
   * placing a child in one of the scrollable windows (border windows or
   * text window), you'll need to compute the child's correct position
   * in buffer coordinates any time scrolling occurs or buffer changes
   * occur, and then call move_child() to update the
   * child's position. Unfortunately there's no good way to detect that
   * scrolling has occurred, using the current API; a possible hack
   * would be to update all child positions when the scroll adjustments
   * change or the text buffer changes. See bug 64518 on
   * bugzilla.gnome.org for status of fixing this issue.
   * @param child A Gtk::Widget.
   * @param which_window Which window the child should appear in.
   * @param xpos X position of child in window coordinates.
   * @param ypos Y position of child in window coordinates.
   */
  void add_child_in_window(Widget& child, TextWindowType which_window,
                                        int xpos, int ypos);

  
  /** Updates the position of a child, as for add_child_in_window().
   * @param child Child widget already added to the text view.
   * @param xpos New X position in window coordinates.
   * @param ypos New Y position in window coordinates.
   */
  void move_child(Widget& child, int xpos,int ypos);

/* Default style settings(fallbacks if no tag affects the property) */

  
  /** Sets the line wrapping for the view.
   * @param wrap_mode A Gtk::WrapMode.
   */
  void set_wrap_mode(WrapMode wrap_mode);
  
  /** Gets the line wrapping for the view.
   * @return The line wrap setting.
   */
  WrapMode get_wrap_mode();
  
  /** Sets the default editability of the Gtk::TextView. You can override
   * this default setting with tags in the buffer, using the "editable"
   * attribute of tags.
   * @param setting Whether it's editable.
   */
  void set_editable(bool setting = true);
  
  /** Returns the default editability of the Gtk::TextView. Tags in the
   * buffer may override this setting for some ranges of text.
   * @return Whether text is editable by default.
   */
  bool get_editable();
  
  /** Sets the default number of blank pixels above paragraphs in @a text_view.
   * Tags in the buffer for @a text_view may override the defaults.
   * @param pixels_above_lines Pixels above paragraphs.
   */
  void set_pixels_above_lines(int pixels_above_lines);
  
  /** Gets the default number of pixels to put above paragraphs.
   * @return Default number of pixels above paragraphs.
   */
  int get_pixels_above_lines();
  
  /** Sets the default number of pixels of blank space
   * to put below paragraphs in @a text_view. May be overridden
   * by tags applied to @a text_view's buffer.
   * @param pixels_below_lines Pixels below paragraphs.
   */
  void set_pixels_below_lines(int pixels_below_lines);
  
  /** Gets the value set by set_pixels_below_lines().
   * @return Default number of blank pixels below paragraphs.
   */
  int get_pixels_below_lines();
  
  /** Sets the default number of pixels of blank space to leave between
   * display/wrapped lines within a paragraph. May be overridden by
   * tags in @a text_view's buffer.
   * @param pixels_inside_wrap Default number of pixels between wrapped lines.
   */
  void set_pixels_inside_wrap(int pixels_inside_wrap);
  
  /** Gets the value set by set_pixels_inside_wrap().
   * @return Default number of pixels of blank space between wrapped lines.
   */
  int get_pixels_inside_wrap();
  
  /** Sets the default justification of text in @a text_view.
   * Tags in the view's buffer may override the default.
   * @param justification Justification.
   */
  void set_justification(Justification justification);
  
  /** Gets the default justification of paragraphs in @a text_view.
   * Tags in the buffer may override the default.
   * @return Default justification.
   */
  Justification get_justification();
  
  /** Sets the default left margin for text in @a text_view.
   * Tags in the buffer may override the default.
   * @param left_margin Left margin in pixels.
   */
  void set_left_margin(int left_margin);
  
  /** Gets the default left margin size of paragraphs in the @a text_view.
   * Tags in the buffer may override the default.
   * @return Left margin in pixels.
   */
  int get_left_margin();
  
  /** Sets the default right margin for text in the text view.
   * Tags in the buffer may override the default.
   * @param right_margin Right margin in pixels.
   */
  void set_right_margin(int right_margin);
  
  /** Gets the default right margin for text in @a text_view. Tags
   * in the buffer may override the default.
   * @return Right margin in pixels.
   */
  int get_right_margin();
  
  /** Sets the default indentation for paragraphs in @a text_view.
   * Tags in the buffer may override the default.
   * @param indent Indentation in pixels.
   */
  void set_indent(int indent);
  
  /** Gets the default indentation of paragraphs in @a text_view.
   * Tags in the view's buffer may override the default.
   * The indentation may be negative.
   * @return Number of pixels of indentation.
   */
  int get_indent();
  
  /** Sets the default tab stops for paragraphs in @a text_view.
   * Tags in the buffer may override the default.
   * @param tabs Tabs as a Pango::TabArray.
   */
  void set_tabs(Pango::TabArray& tabs);
  
  /** Gets the default tabs for @a text_view. Tags in the buffer may
   * override the defaults. The returned array will be <tt>0</tt> if
   * "standard" (8-space) tabs are used. Free the return value
   * with pango_tab_array_free().
   * @return Copy of default tab array, or <tt>0</tt> if "standard" tabs are used; must be freed with pango_tab_array_free().
   */
  Pango::TabArray get_tabs();
  
  /** Obtains a copy of the default text attributes. These are the
   * attributes used for text unless a tag overrides them.
   * You'd typically pass the default attributes in to
   * gtk_text_iter_get_attributes() in order to get the
   * attributes in effect at a given text position.
   * 
   * The return value is a copy owned by the caller of this function,
   * and should be freed.
   * @return A new Gtk::TextAttributes.
   */
  TextAttributes get_default_attributes();

  
  /**
   * @par Prototype:
   * <tt>void %set_scroll_adjustments(Adjustment* hadjustment, Adjustment* vadjustment)</tt>
   */
  Glib::SignalProxy2<void,Adjustment*,Adjustment*> signal_set_scroll_adjustments();

  
  /**
   * @par Prototype:
   * <tt>void %populate_popup(Menu* menu)</tt>
   */
  Glib::SignalProxy1<void,Menu*> signal_populate_popup();


  /**
   * @par Prototype:
   * <tt>void %move_cursor(MovementStep step, int count, bool extend_selection)</tt>
   */
  Glib::SignalProxy3<void,MovementStep,int,bool> signal_move_cursor();

  
  /**
   * @par Prototype:
   * <tt>void %page_horizontally(int count, bool extend_selection)</tt>
   */
  Glib::SignalProxy2<void,int,bool> signal_page_horizontally();

  
  /**
   * @par Prototype:
   * <tt>void %set_anchor()</tt>
   */
  Glib::SignalProxy0<void> signal_set_anchor();

  
  /**
   * @par Prototype:
   * <tt>void %insert_at_cursor(const Glib::ustring& str)</tt>
   */
  Glib::SignalProxy1<void,const Glib::ustring&> signal_insert_at_cursor();

  
  /**
   * @par Prototype:
   * <tt>void %delete_from_cursor(DeleteType type, int count)</tt>
   */
  Glib::SignalProxy2<void,DeleteType,int> signal_delete_from_cursor();

  
  /**
   * @par Prototype:
   * <tt>void %cut_clipboard()</tt>
   */
  Glib::SignalProxy0<void> signal_cut_clipboard();

  
  /**
   * @par Prototype:
   * <tt>void %copy_clipboard()</tt>
   */
  Glib::SignalProxy0<void> signal_copy_clipboard();

  
  /**
   * @par Prototype:
   * <tt>void %paste_clipboard()</tt>
   */
  Glib::SignalProxy0<void> signal_paste_clipboard();

  
  /**
   * @par Prototype:
   * <tt>void %toggle_overwrite()</tt>
   */
  Glib::SignalProxy0<void> signal_toggle_overwrite();

  
  /**
   * @par Prototype:
   * <tt>void %move_focus(DirectionType direction)</tt>
   */
  Glib::SignalProxy1<void,DirectionType> signal_move_focus();


  Glib::PropertyProxy<int> property_pixels_above_lines();

  Glib::PropertyProxy<int> property_pixels_below_lines();

  Glib::PropertyProxy<int> property_pixels_inside_wrap();

  Glib::PropertyProxy<bool> property_editable();

  Glib::PropertyProxy<WrapMode> property_wrap_mode();

  Glib::PropertyProxy<Justification> property_justification();

  Glib::PropertyProxy<int> property_left_margin();

  Glib::PropertyProxy<int> property_right_margin();

  Glib::PropertyProxy<int> property_indent();

  Glib::PropertyProxy<Pango::TabArray> property_tabs();

  Glib::PropertyProxy<bool> property_cursor_visible();


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::TextView */
  Gtk::TextView* wrap(GtkTextView* object, bool take_copy = false);
}
#endif /* _GTKMM_TEXTVIEW_H */

