
#include <gtkmm/tooltips.h>
#include <gtkmm/private/tooltips_p.h>

// -*- c++ -*-
/* $Id: tooltips.ccg,v 1.6 2001/12/01 12:16:43 daniel Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkwidget.h>
#include <gtk/gtktooltips.h>
#include <gdkmm/color.h>
#include <gtkmm/widget.h>


namespace Gtk
{

void Tooltips::set_tip(Gtk::Widget& widget, const Glib::ustring& tip_text)
{
  gtk_tooltips_set_tip(gobj(), widget.gobj(), tip_text.c_str(), 0);
}

void Tooltips::remove_tip(Gtk::Widget& widget)
{
  gtk_tooltips_set_tip(gobj(), widget.gobj(), 0, 0);
}

} // namespace Gtk


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::Tooltips* wrap(GtkTooltips* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Tooltips *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Tooltips_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_tooltips_get_type(), "gtkmm__Tooltips", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Tooltips_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* Tooltips_Class::wrap_new(GObject* o)
{
  return manage(new Tooltips((GtkTooltips*)(o)));
}


/* The implementation: */

Tooltips::Tooltips(GtkTooltips* castitem)
: Gtk::Object((GtkObject*)(castitem))
{}

Tooltips::~Tooltips()
{
  destroy_();
}

Tooltips::CppClassType Tooltips::tooltips_class_; //Initialize static member.

GType Tooltips::get_type()
{
  return tooltips_class_.get_type();
}

GType Tooltips::get_base_type()
{
  return gtk_tooltips_get_type();
}

Tooltips::Tooltips()
: Gtk::Object((GtkObject*)(g_object_new(get_type(), (char*)0)))
{}

void Tooltips::enable()
{
  gtk_tooltips_enable(gobj());
}

void Tooltips::disable()
{
  gtk_tooltips_disable(gobj());
}

void Tooltips::set_tip(Widget& widget, const Glib::ustring& tip_text, const Glib::ustring& tip_private)
{
  gtk_tooltips_set_tip(gobj(), (widget).Gtk::Widget::gobj(), tip_text.c_str(), tip_private.c_str());
}

GtkTooltipsData* Tooltips::data_get(Widget& widget)
{
  return gtk_tooltips_data_get((widget).Gtk::Widget::gobj());
}

void Tooltips::force_window()
{
  gtk_tooltips_force_window(gobj());
}


} // namespace Gtk

