
#include <gtkmm/treedragsource.h>
#include <gtkmm/private/treedragsource_p.h>

// -*- c++ -*-
/* $Id: treedragsource.ccg,v 1.2 2002/03/23 11:16:16 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


namespace Gtk
{

bool TreeDragSource::row_draggable(const TreePath& path)
{
  //We wrap the C invoker because it contains code:
  return (bool)gtk_tree_drag_source_row_draggable( gobj(), const_cast<GtkTreePath*>(path.gobj()) );
}

} /* namespace Gtk */


namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gtk::TreeDragSource> wrap(GtkTreeDragSource* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Gtk::TreeDragSource>( dynamic_cast<Gtk::TreeDragSource*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gtk
{


/* The *_Class implementation: */

GType TreeDragSource_Class::get_type()
{
  if (!gtype_) //Create the GType if necessary.
    {
      //Make sure that the parent type has been created:
      CppClassParent::CppObjectType::get_type();

      //Get the size of the base C class:
      GType gtype_base = gtk_tree_drag_source_get_type();
      gtype_ = gtype_base; //We can not derive from another interface.
/*
      GTypeQuery typeQueryBase = {0 ,};
      g_type_query(gtype_base, &typeQueryBase);

      //Create a derived C type.
      //These init funcs will, in turn, call the init functions in the base C type.
      GTypeInfo info =
        {
          typeQueryBase.class_size, // class_size
          (GBaseInitFunc) 0, // base_init *
          (GBaseFinalizeFunc) 0, // base_finalize
          (GClassInitFunc) class_init_function, // class_init
          0, // class_finalize
          0, // class_data
          typeQueryBase.instance_size, // instance_size
          0, // n_preallocs
          (GInstanceInitFunc) object_init_function // instance_init
        };

      gtype_ = g_type_register_static(gtype_base, "gtkmm__TreeDragSource", &info, GTypeFlags(0));
*/
    }
  return gtype_;
}

void TreeDragSource_Class::iface_init_function(BaseClassType* iface)
{
  CppClassParent::iface_init_function((GTypeInterface*)iface);
  BaseClassType* klass = iface; //Allows us to reuse generated code from GObject wrappers.
   klass->row_draggable = &row_draggable_vfunc_callback;
  klass->drag_data_get = &drag_data_get_vfunc_callback;
  klass->drag_data_delete = &drag_data_delete_vfunc_callback;
 }

void TreeDragSource_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((GTypeInterface*)klass);
}

void TreeDragSource_Class::object_init_function(BaseObjectType* object)
{
}

gboolean TreeDragSource_Class::row_draggable_vfunc_callback(GtkTreeDragSource* self, GtkTreePath* path)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return obj->row_draggable(path);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->row_draggable)
      (*base->row_draggable)(self, path);
  }

  typedef gboolean RType;
  return RType();
}

gboolean TreeDragSource_Class::drag_data_get_vfunc_callback(GtkTreeDragSource* self, GtkTreePath* path, GtkSelectionData* selection_data)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return obj->drag_data_get_vfunc(path, selection_data);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->drag_data_get)
      (*base->drag_data_get)(self, path, selection_data);
  }

  typedef gboolean RType;
  return RType();
}

gboolean TreeDragSource_Class::drag_data_delete_vfunc_callback(GtkTreeDragSource* self, GtkTreePath* path)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return obj->drag_data_delete_vfunc(path);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->drag_data_delete)
      (*base->drag_data_delete)(self, path);
  }

  typedef gboolean RType;
  return RType();
}


Glib::ObjectBase* TreeDragSource_Class::wrap_new(GObject* o)
{
  return new TreeDragSource((GtkTreeDragSource*)(o));
}


/* The implementation: */

TreeDragSource::TreeDragSource(GtkTreeDragSource* castitem)
: Glib::Interface((GObject*)(castitem))
{}

TreeDragSource::~TreeDragSource()
{
}

/*
GtkTreeDragSource* TreeDragSource::gobj_copy()
{
  reference();
  return gobj();
}
*/

Glib::RefPtr<TreeDragSource> TreeDragSource::wrap_specific_type(GtkTreeDragSource* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<TreeDragSource> refPtr;
  //Check for an existing wrapper:
  TreeDragSource* pCppObject = dynamic_cast<TreeDragSource*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
  if(pCppObject)
  {
    //Return the existing wrapper:
    refPtr = Glib::RefPtr<TreeDragSource>(pCppObject);
  }
  else
  {
    //Create a new wrapper:
    refPtr = Glib::RefPtr<TreeDragSource>( new TreeDragSource(gobject) );
  }

  if(take_copy)
    refPtr->reference();

  return refPtr;
}

TreeDragSource::TreeDragSource()
{
}


void TreeDragSource::add_interface(GType gtype_implementer) //static
{
  static const GInterfaceInfo iface_info =
  {
	  (GInterfaceInitFunc)CppClassType::iface_init_function,
	  NULL,
	  NULL
  };

  g_type_add_interface_static(
    gtype_implementer,
    get_type(), //interface_type: whose direct parent type must be G_TYPE_INTERFACE
    &iface_info
  );
}

TreeDragSource::CppClassType TreeDragSource::treedragsource_class_; //Initialize static member.

GType TreeDragSource::get_type()
{
  return treedragsource_class_.get_type();
}

GType TreeDragSource::get_base_type()
{
  return gtk_tree_drag_source_get_type();
}


gboolean Gtk::TreeDragSource::row_draggable(GtkTreePath* path)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->row_draggable)
    return (*base->row_draggable)(gobj(),path);

  typedef gboolean RType;
  return RType();
}

gboolean Gtk::TreeDragSource::drag_data_get_vfunc(GtkTreePath* path, GtkSelectionData* selection_data)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->drag_data_get)
    return (*base->drag_data_get)(gobj(),path,selection_data);

  typedef gboolean RType;
  return RType();
}

gboolean Gtk::TreeDragSource::drag_data_delete_vfunc(GtkTreePath* path)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->drag_data_delete)
    return (*base->drag_data_delete)(gobj(),path);

  typedef gboolean RType;
  return RType();
}

bool Gtk::TreeDragSource::drag_data_get(const TreePath& path, GtkSelectionData* selection_data)
{
  return drag_data_get_vfunc(const_cast<GtkTreePath*>((path).gobj()), selection_data);
 }

bool Gtk::TreeDragSource::drag_data_delete(const TreePath& path)
{
  return drag_data_delete_vfunc(const_cast<GtkTreePath*>((path).gobj()));
 }

;

} // namespace Gtk

