dnl AC_CXX_IN_STD(IDENTIFIER, HEADER, MACRO)
dnl   tests the C++ for the presence of IDENTIFIER in namespace std.
dnl   If IDENTIFIER is _not_ in namespace std, MACRO is #defined to
dnl   'namespace std {using ::IDENTIFIER;}', otherwise empty.
dnl
dnl   This should be used in configure.in
dnl     e.g. AC_CXX_IN_STD([string],[string],GTKMM_USING_STD_STRING)
dnl
AC_DEFUN([AC_CXX_IN_STD],
[
  AC_CACHE_CHECK([if C++ environment has $1 in std],[gtkmm_cv_cxx_$1_in_std],
  [
    AC_TRY_COMPILE(
      [#include <]ifelse($2,,$1,$2)[>],
      [using std::$1;],
      [gtkmm_cv_cxx_$1_in_std="yes"],
      [gtkmm_cv_cxx_$1_in_std="no"]
    )
  ])

  gtkmm_using_macro=''
  test "x${gtkmm_cv_cxx_$1_in_std}" = "xno" && \
    gtkmm_using_macro='namespace std {using ::$1;}'

  AC_DEFINE_UNQUOTED([$3],[${gtkmm_using_macro}])
])

## GTKMM_CXX_HAS_NAMESPACE_STD()
##
## Test whether libstdc++ declares namespace std.  For safety,
## also check whether several randomly selected STL symbols
## are available in namespace std.
##
## On success, #define GTKMM_HAVE_NAMESPACE_STD to 1.
##
AC_DEFUN([GTKMM_CXX_HAS_NAMESPACE_STD],
[
  AC_CACHE_CHECK(
    [whether libstdc++ symbols are declared in namespace std],
    [gtkmm_cv_cxx_has_namespace_std],
  [
    AC_TRY_COMPILE(
    [
      #include <algorithm>
      #include <iterator>
      #include <iostream>
      #include <string>
    ],[
      using std::min;
      using std::find;
      using std::copy;
      using std::bidirectional_iterator_tag;
      using std::string;
      using std::istream;
      using std::cout;
    ],
      [gtkmm_cv_cxx_has_namespace_std="yes"],
      [gtkmm_cv_cxx_has_namespace_std="no"]
    )
  ])

  if test "x${gtkmm_cv_cxx_has_namespace_std}" = "xyes"; then
  {
    AC_DEFINE([GTKMM_HAVE_NAMESPACE_STD],[1])
  }
  fi
])

