dnl $Id: class_boxedtype.m4,v 1.12 2002/04/09 13:43:54 daniel Exp $

dnl
dnl _CLASS_BOXEDTYPE(Region, GdkRegion, gdk_region_new, gdk_region_copy, gdk_region_destroy)
dnl

define(`_CLASS_BOXEDTYPE',`dnl
_PUSH()
dnl
dnl  Define the args for later macros
define(`__CPPNAME__',`$1')
define(`__CNAME__',`$2')
define(`__BOXEDTYPE_FUNC_NEW',`$3')
define(`__BOXEDTYPE_FUNC_COPY',`$4')
define(`__BOXEDTYPE_FUNC_FREE',`$5')

define(`_CUSTOM_DEFAULT_CTOR',`dnl
_PUSH()
dnl Define this macro to be tested for later.
define(`__BOOL_CUSTOM_DEFAULT_CTOR__',`$1')
_POP()
')


_POP()
_SECTION(SECTION_CLASS2)
') dnl End of _CLASS_BOXEDTYPE.


dnl
dnl _END_CLASS_BOXEDTYPE()
dnl   denotes the end of a class
dnl
define(`_END_CLASS_BOXEDTYPE',`

_SECTION(SECTION_HEADER3)

ifdef(`__BOOL_NO_WRAP_FUNCTION__',`dnl
',`dnl else
namespace Glib
{

/** @relates __NAMESPACE__::__CPPNAME__ */
__NAMESPACE__::__CPPNAME__ wrap(__CNAME__* object, bool take_copy = false);

} // namespace Glib
')dnl endif __BOOL_NO_WRAP_FUNCTION__

_SECTION(SECTION_SRC_GENERATED)

ifdef(`__BOOL_NO_WRAP_FUNCTION__',`dnl
',`dnl else
namespace Glib
{

__NAMESPACE__::__CPPNAME__ wrap(__CNAME__* object, bool take_copy /* = false */)
{
  return __NAMESPACE__::__CPPNAME__`'(object, take_copy);
}

} // namespace Glib
')dnl endif


__NAMESPACE_BEGIN__

dnl
dnl The implementation:
dnl

// static
GType __CPPNAME__::get_type()
{
  return _GET_TYPE_FUNC(__CNAME__);
}

ifdef(`__BOOL_CUSTOM_DEFAULT_CTOR__',`dnl
',`dnl else
__CPPNAME__::__CPPNAME__`'()
:
ifelse(__BOXEDTYPE_FUNC_NEW,NONE,`dnl
  gobject_ (0) // Allows creation of invalid wrapper, e.g. for output arguments to methods.
',`dnl else
  gobject_ (__BOXEDTYPE_FUNC_NEW`'())
')dnl
{}
')dnl endif __BOOL_CUSTOM_DEFAULT_CTOR__

__CPPNAME__::__CPPNAME__`'(const __CPPNAME__& src)
:
  gobject_ ((src.gobject_) ? __BOXEDTYPE_FUNC_COPY`'(src.gobject_) : 0)
{}

__CPPNAME__::__CPPNAME__`'(__CNAME__* castitem, bool make_a_copy /* = true */)
{
  // For BoxedType wrappers, make_a_copy is true by default.  The static
  // BoxedType wrappers must always take a copy, thus make_a_copy = true
  // ensures identical behaviour if the default argument is used.

  if(make_a_copy)
  {
    if(castitem)
      gobject_ = __BOXEDTYPE_FUNC_COPY`'(castitem);
    else
      gobject_ = 0;
  }
  else
  {
    // It was given to us by a function which has already made a copy for us to keep.
    gobject_ = castitem;
  }
}

ifelse(__BOXEDTYPE_FUNC_COPY,NONE,`dnl
',`dnl else
__CPPNAME__& __CPPNAME__::operator=(const __CPPNAME__`'& src)
{
  __CNAME__ *const new_gobject = (src.gobject_) ? __BOXEDTYPE_FUNC_COPY`'(src.gobject_) : 0;

  if(gobject_)
    __BOXEDTYPE_FUNC_FREE`'(gobject_);dnl This could be a free or an unref, we do not need to know.

  gobject_ = new_gobject;

  return *this;
}
')dnl

__CPPNAME__::~__CPPNAME__`'()
{
  if(gobject_)
    __BOXEDTYPE_FUNC_FREE`'(gobject_);dnl This could be a free or an unref, we do not need to know.
}

dnl ifelse(__BOXEDTYPE_FUNC_EQUAL,NONE,`dnl
dnl ',`dnl
dnl bool __CPPNAME__`'::operator==(const __CPPNAME__`'& src)
dnl {
dnl   return __BOXEDTYPE_FUNC_EQUAL`'(gobj(), const_cast<BaseObjectType*>(src.gobj()));
dnl }
dnl ')dnl
dnl
dnl bool __CPPNAME__`'::is_null() const
dnl {
dnl   return ( gobject_ == 0);
dnl }
dnl
dnl __CPPNAME__`'::operator bool() const
dnl {
dnl   return !is_null();
dnl }
dnl
dnl __CNAME__* __CPPNAME__`'::gobj()
dnl {
dnl   return gobject_;
dnl }
dnl
dnl const __CNAME__* __CPPNAME__`'::gobj() const
dnl {
dnl   return gobject_;
dnl }

__CNAME__* __CPPNAME__::gobj_copy() const
{
  return __BOXEDTYPE_FUNC_COPY`'(gobject_);
}

_IMPORT(SECTION_CC)

__NAMESPACE_END__


dnl
dnl
dnl
dnl
_POP()
dnl
dnl
dnl The actual class, e.g. Pango::FontDescription, declaration:
dnl
_IMPORT(SECTION_CLASS1)
public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef __CPPNAME__ CppObjectType;
  typedef __CNAME__ BaseObjectType;

  static GType get_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

ifdef(`__BOOL_CUSTOM_DEFAULT_CTOR__',`dnl
',`dnl else
  __CPPNAME__`'();
')dnl

  explicit __CPPNAME__`'(__CNAME__* castitem, bool make_a_copy = true);

  __CPPNAME__`'(const __CPPNAME__& src);
  __CPPNAME__& operator=(const __CPPNAME__& src);

  ~__CPPNAME__`'();

dnl ifelse(__BOXEDTYPE_FUNC_EQUAL,NONE,`dnl
dnl ',`dnl
dnl   bool operator==(const __CPPNAME__`'& src);
dnl ')dnl
dnl
dnl   operator bool() const;
dnl   virtual bool is_null() const;

  __CNAME__*       gobj()       { return gobject_; }
  const __CNAME__* gobj() const { return gobject_; }

  // The caller is responsible for freeing it. Use when directly setting fields in structs.
  __CNAME__* gobj_copy() const;

protected:
  __CNAME__* gobject_;

private:
_IMPORT(SECTION_CLASS2)
')

