
#include <gtkmm/box.h>
#include <gtkmm/private/box_p.h>

// -*- c++ -*-
/* $Id: box.ccg,v 1.16 2002/04/02 13:25:13 daniel Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkbox.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkhbox.h>
#include <glibmm/wrap.h>

namespace Gtk
{

namespace Box_Helpers
{

Widget* Box_Helpers::Child::get_widget() const
{ 
  return Glib::wrap(gobj()->widget);
}

/**************************************************************************/


typedef Box_Helpers::BoxList::iterator box_iterator;

box_iterator BoxList::insert(box_iterator position, const Element& e)
{
  iterator i;

  if (e.pack_==PACK_START)
    gtk_box_pack_start(gparent(), (e.widget_?e.widget_->gobj():0),
                       e.expand_, e.fill_, e.padding_);
  else
    gtk_box_pack_end(gparent(), (e.widget_?e.widget_->gobj():0),
                       e.expand_, e.fill_, e.padding_);

  i = --end();

  if (position!=end())
    reorder(i,position);

  return i;
}

// Non-standard
void BoxList::reorder(box_iterator loc,box_iterator pos)
{
  int position = g_list_position(glist(), pos.node);
  gtk_box_reorder_child(gparent(), (*loc)->gobj()->widget,position);
}

} /* namespace Box_Helpers */

Box::BoxList& Box::children()
{
  children_proxy_ = BoxList(gobj());
  return children_proxy_;
}

const Box::BoxList& Box::children() const
{
  children_proxy_ = BoxList(const_cast<GtkBox*>(gobj()));
  return children_proxy_;
}

} /* namespace Gtk */


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::Box* wrap(GtkBox* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Box *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Box_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_box_get_type(), "gtkmm__Box", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Box_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* Box_Class::wrap_new(GObject* o)
{
  return manage(new Box((GtkBox*)(o)));
}


/* The implementation: */

Box::Box(GtkBox* castitem)
: Gtk::Container((GtkContainer*)(castitem))
{}

Box::~Box()
{
  destroy_();
}

Box::CppClassType Box::box_class_; //Initialize static member.

GType Box::get_type()
{
  return box_class_.get_type();
}

GType Box::get_base_type()
{
  return gtk_box_get_type();
}


namespace Box_Helpers
{

BoxList::iterator BoxList::find(const_reference w)
{
  iterator i = begin();
  for(i = begin(); i != end() && (*i != w); i++);
  return i;
}

BoxList::iterator BoxList::find(Widget& w)
{
  iterator i;
  for (i = begin(); i != end() && ((*i)->get_widget() != &w); i++);
  return i;
}

} /* namespace Box_Helpers */


namespace Box_Helpers
{

void BoxList::remove(const_reference child)
{
  g_return_if_fail(child != 0);
  gtk_container_remove(GTK_CONTAINER(gparent_),
                       (GtkWidget*)(child->get_widget()->gobj()));
}

void BoxList::remove(Widget &w)
{
  gtk_container_remove(GTK_CONTAINER(gparent_), (GtkWidget*)(w.gobj()));
}

BoxList::iterator BoxList::erase(iterator position)
{
  if ( !position.node || (position == end()) )
    return end();

  iterator next = position;
  next++;

  gtk_container_remove(GTK_CONTAINER(gparent_),
      (GtkWidget*)((*position)->get_widget()->gobj()));
  return next;
}

} /* namespace Box_Helpers */


namespace Box_Helpers
{

BoxList::BoxList()
{}

BoxList::BoxList(GtkBox* gparent)
: type_base((GObject*)gparent)
{}

BoxList::BoxList(const BoxList& src)
{
  operator=(src);
}

BoxList& BoxList::operator=(const BoxList& src)
{
  gparent_ = src.gparent_;
  return *this;
}

GList*& BoxList::glist() const
{
  return ((GtkBox*)gparent_)->children;
}

void BoxList::erase(iterator start, iterator stop)
{
  type_base::erase(start, stop);
}

GtkBox* BoxList::gparent()
{
  return (GtkBox*)type_base::gparent();
}

const GtkBox* BoxList::gparent() const
{
  return (GtkBox*)type_base::gparent();
}

BoxList::value_type BoxList::operator[](size_type l) const
{
  return type_base::operator[](l);
}

} /* namespace Box_Helpers */

Box::Box()
: Gtk::Container((GtkContainer*)(g_object_new(get_type(), (char*)0)))
{}

void Box::pack_start(Widget& child, bool expand, bool fill, guint padding)
{
  gtk_box_pack_start(gobj(), (child).Gtk::Widget::gobj(), static_cast<int>(expand), static_cast<int>(fill), padding);
}

void Box::pack_end(Widget& child, bool expand, bool fill, guint padding)
{
  gtk_box_pack_end(gobj(), (child).Gtk::Widget::gobj(), static_cast<int>(expand), static_cast<int>(fill), padding);
}

void Box::set_homogeneous(bool homogeneous)
{
  gtk_box_set_homogeneous(gobj(), static_cast<int>(homogeneous));
}

bool Box::get_homogeneous() const
{
  return gtk_box_get_homogeneous(const_cast<GtkBox*>(gobj()));
}

void Box::set_spacing(int spacing)
{
  gtk_box_set_spacing(gobj(), spacing);
}

int Box::get_spacing() const
{
  return gtk_box_get_spacing(const_cast<GtkBox*>(gobj()));
}

void Box::reorder_child(Widget& child, int pos)
{
  gtk_box_reorder_child(gobj(), (child).Gtk::Widget::gobj(), pos);
}


Glib::PropertyProxy<int> Box::property_spacing()
{
  return Glib::PropertyProxy<int>(this, "spacing");
}

Glib::PropertyProxy<bool> Box::property_homogeneous()
{
  return Glib::PropertyProxy<bool>(this, "homogeneous");
}


} // namespace Gtk


namespace Glib
{

Gtk::VBox* wrap(GtkVBox* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::VBox *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType VBox_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_vbox_get_type(), "gtkmm__VBox", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void VBox_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* VBox_Class::wrap_new(GObject* o)
{
  return manage(new VBox((GtkVBox*)(o)));
}


/* The implementation: */

VBox::VBox(GtkVBox* castitem)
: Gtk::Box((GtkBox*)(castitem))
{}

VBox::~VBox()
{
  destroy_();
}

VBox::CppClassType VBox::vbox_class_; //Initialize static member.

GType VBox::get_type()
{
  return vbox_class_.get_type();
}

GType VBox::get_base_type()
{
  return gtk_vbox_get_type();
}

VBox::VBox(bool homogeneous, int spacing)
: Gtk::Box((GtkBox*)( g_object_new(get_type(), "homogeneous", static_cast<int>(homogeneous), "spacing", spacing, (char*)0) ))
{}


} // namespace Gtk


namespace Glib
{

Gtk::HBox* wrap(GtkHBox* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::HBox *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType HBox_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_hbox_get_type(), "gtkmm__HBox", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void HBox_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* HBox_Class::wrap_new(GObject* o)
{
  return manage(new HBox((GtkHBox*)(o)));
}


/* The implementation: */

HBox::HBox(GtkHBox* castitem)
: Gtk::Box((GtkBox*)(castitem))
{}

HBox::~HBox()
{
  destroy_();
}

HBox::CppClassType HBox::hbox_class_; //Initialize static member.

GType HBox::get_type()
{
  return hbox_class_.get_type();
}

GType HBox::get_base_type()
{
  return gtk_hbox_get_type();
}

HBox::HBox(bool homogeneous, int spacing)
: Gtk::Box((GtkBox*)( g_object_new(get_type(), "homogeneous", static_cast<int>(homogeneous), "spacing", spacing, (char*)0) ))
{}


} // namespace Gtk

