
#include <gtkmm/fileselection.h>
#include <gtkmm/private/fileselection_p.h>

// -*- c++ -*-
/* $Id: fileselection.ccg,v 1.11 2002/03/09 18:10:46 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkfilesel.h>
#include <gtkmm/entry.h>
#include <gtkmm/label.h>
#include <gtkmm/box.h>
#include <gtkmm/button.h>


namespace Gtk
{

FileSelection::FileSelection()
: Gtk::Dialog(reinterpret_cast<GtkDialog*>(g_object_new(get_type(), "title", 0, 0)))
{

}

} // namespace Gtk


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::FileSelection* wrap(GtkFileSelection* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::FileSelection *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType FileSelection_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_file_selection_get_type(), "gtkmm__FileSelection", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void FileSelection_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* FileSelection_Class::wrap_new(GObject* o)
{
  return manage(new FileSelection((GtkFileSelection*)(o)));
}


/* The implementation: */

FileSelection::FileSelection(GtkFileSelection* castitem)
: Gtk::Dialog((GtkDialog*)(castitem))
{}

FileSelection::~FileSelection()
{
  destroy_();
}

FileSelection::CppClassType FileSelection::fileselection_class_; //Initialize static member.

GType FileSelection::get_type()
{
  return fileselection_class_.get_type();
}

GType FileSelection::get_base_type()
{
  return gtk_file_selection_get_type();
}

FileSelection::FileSelection(const Glib::ustring& title)
: Gtk::Dialog((GtkDialog*)( g_object_new(get_type(), "title", title.c_str(), (char*)0) ))
{}

void FileSelection::set_filename(const Glib::ustring& filename)
{
  gtk_file_selection_set_filename(gobj(), filename.c_str());
}

Glib::ustring FileSelection::get_filename() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_file_selection_get_filename(const_cast<GtkFileSelection*>(gobj())));
}

void FileSelection::complete(const Glib::ustring& pattern)
{
  gtk_file_selection_complete(gobj(), pattern.c_str());
}

void FileSelection::show_fileop_buttons()
{
  gtk_file_selection_show_fileop_buttons(gobj());
}

void FileSelection::hide_fileop_buttons()
{
  gtk_file_selection_hide_fileop_buttons(gobj());
}

void FileSelection::set_select_multiple(bool elect_multiple)
{
  gtk_file_selection_set_select_multiple(gobj(), static_cast<int>(elect_multiple));
}

bool FileSelection::get_select_multiple() const
{
  return gtk_file_selection_get_select_multiple(const_cast<GtkFileSelection*>(gobj()));
}

TreeView* FileSelection::get_dir_list()
{
  return Glib::wrap((GtkTreeView*)(gobj()->dir_list));
}

const TreeView* FileSelection::get_dir_list() const
{
  return Glib::wrap((GtkTreeView*)(gobj()->dir_list));
}

TreeView* FileSelection::get_file_list()
{
  return Glib::wrap((GtkTreeView*)(gobj()->file_list));
}

const TreeView* FileSelection::get_file_list() const
{
  return Glib::wrap((GtkTreeView*)(gobj()->file_list));
}

Entry* FileSelection::get_selection_entry()
{
  return Glib::wrap((GtkEntry*)(gobj()->selection_entry));
}

const Entry* FileSelection::get_selection_entry() const
{
  return Glib::wrap((GtkEntry*)(gobj()->selection_entry));
}

Label* FileSelection::get_selection_text()
{
  return Glib::wrap((GtkLabel*)(gobj()->selection_text));
}

const Label* FileSelection::get_selection_text() const
{
  return Glib::wrap((GtkLabel*)(gobj()->selection_text));
}

VBox* FileSelection::get_main_vbox()
{
  return Glib::wrap((GtkVBox*)(gobj()->main_vbox));
}

const VBox* FileSelection::get_main_vbox() const
{
  return Glib::wrap((GtkVBox*)(gobj()->main_vbox));
}

Button* FileSelection::get_ok_button()
{
  return Glib::wrap((GtkButton*)(gobj()->ok_button));
}

const Button* FileSelection::get_ok_button() const
{
  return Glib::wrap((GtkButton*)(gobj()->ok_button));
}

Button* FileSelection::get_cancel_button()
{
  return Glib::wrap((GtkButton*)(gobj()->cancel_button));
}

const Button* FileSelection::get_cancel_button() const
{
  return Glib::wrap((GtkButton*)(gobj()->cancel_button));
}

Button* FileSelection::get_help_button()
{
  return Glib::wrap((GtkButton*)(gobj()->help_button));
}

const Button* FileSelection::get_help_button() const
{
  return Glib::wrap((GtkButton*)(gobj()->help_button));
}

HButtonBox* FileSelection::get_button_area()
{
  return Glib::wrap((GtkHButtonBox*)(gobj()->button_area));
}

const HButtonBox* FileSelection::get_button_area() const
{
  return Glib::wrap((GtkHButtonBox*)(gobj()->button_area));
}

HBox* FileSelection::get_action_area()
{
  return Glib::wrap((GtkHBox*)(gobj()->action_area));
}

const HBox* FileSelection::get_action_area() const
{
  return Glib::wrap((GtkHBox*)(gobj()->action_area));
}


Glib::PropertyProxy<bool> FileSelection::property_show_fileops()
{
  return Glib::PropertyProxy<bool>(this, "show_fileops");
}

Glib::PropertyProxy<Glib::ustring> FileSelection::property_filename()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "filename");
}

Glib::PropertyProxy<bool> FileSelection::property_select_multiple()
{
  return Glib::PropertyProxy<bool>(this, "select_multiple");
}


} // namespace Gtk

