
#include <gtkmm/separator.h>
#include <gtkmm/private/separator_p.h>

// -*- c++ -*-
/* $Id: separator.ccg,v 1.2 2001/05/10 22:13:27 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkseparator.h>
#include <gtk/gtkhseparator.h>
#include <gtk/gtkvseparator.h>


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::Separator* wrap(GtkSeparator* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Separator *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Separator_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_separator_get_type(), "gtkmm__Separator", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Separator_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* Separator_Class::wrap_new(GObject* o)
{
  return manage(new Separator((GtkSeparator*)(o)));
}


/* The implementation: */

Separator::Separator(GtkSeparator* castitem)
: Gtk::Widget((GtkWidget*)(castitem))
{}

Separator::~Separator()
{
  destroy_();
}

Separator::CppClassType Separator::separator_class_; //Initialize static member.

GType Separator::get_type()
{
  return separator_class_.get_type();
}

GType Separator::get_base_type()
{
  return gtk_separator_get_type();
}

Separator::Separator()
: Gtk::Widget((GtkWidget*)(g_object_new(get_type(), (char*)0)))
{}


} // namespace Gtk


namespace Glib
{

Gtk::VSeparator* wrap(GtkVSeparator* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::VSeparator *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType VSeparator_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_vseparator_get_type(), "gtkmm__VSeparator", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void VSeparator_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* VSeparator_Class::wrap_new(GObject* o)
{
  return manage(new VSeparator((GtkVSeparator*)(o)));
}


/* The implementation: */

VSeparator::VSeparator(GtkVSeparator* castitem)
: Gtk::Separator((GtkSeparator*)(castitem))
{}

VSeparator::~VSeparator()
{
  destroy_();
}

VSeparator::CppClassType VSeparator::vseparator_class_; //Initialize static member.

GType VSeparator::get_type()
{
  return vseparator_class_.get_type();
}

GType VSeparator::get_base_type()
{
  return gtk_vseparator_get_type();
}

VSeparator::VSeparator()
: Gtk::Separator((GtkSeparator*)(g_object_new(get_type(), (char*)0)))
{}


} // namespace Gtk


namespace Glib
{

Gtk::HSeparator* wrap(GtkHSeparator* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::HSeparator *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType HSeparator_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_hseparator_get_type(), "gtkmm__HSeparator", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void HSeparator_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* HSeparator_Class::wrap_new(GObject* o)
{
  return manage(new HSeparator((GtkHSeparator*)(o)));
}


/* The implementation: */

HSeparator::HSeparator(GtkHSeparator* castitem)
: Gtk::Separator((GtkSeparator*)(castitem))
{}

HSeparator::~HSeparator()
{
  destroy_();
}

HSeparator::CppClassType HSeparator::hseparator_class_; //Initialize static member.

GType HSeparator::get_type()
{
  return hseparator_class_.get_type();
}

GType HSeparator::get_base_type()
{
  return gtk_hseparator_get_type();
}

HSeparator::HSeparator()
: Gtk::Separator((GtkSeparator*)(g_object_new(get_type(), (char*)0)))
{}


} // namespace Gtk

