#!/usr/bin/perl

use strict;

my @namespace_whole = (); # list of strings.
my $function_prefix = "";
my $parent_dir = ""; # e.g. gtkmm
my $path = "gtk--";
my $debug = 0;
my %objects = ();
my %exceptions = ();
my %namespaces = (); # hashmap of lists of strings.
my %basenames = ();
my %nowrap = ();

# Loop through command line arguments, setting variables:
while ($ARGV[0] =~ /^-/)
  {
   if ($ARGV[0] =~ /--namespace=(\S+)/)
   {
     push(@namespace_whole, $1);

     if($parent_dir eq "")
       { $parent_dir = lc($1) . "mm"; }
   }
   elsif ($ARGV[0] =~ /--function_prefix=(\S+)/)
   {
     $function_prefix = "$1";
   }
   elsif ($ARGV[0] =~ /--parent_dir=(\S+)/)
   {
     $parent_dir = "$1";
   }
   elsif
   (
     $ARGV[0] =~ /--debug/) {$debug = 1;
   }
   elsif ($ARGV[0] =~ /--path=(\S+)/)
   {
     $path = "$1";
   }
   else
   {
     print "Error: unknown option $ARGV[0]\n";
     exit;
   }

   shift @ARGV;
  }



while ($ARGV[0])
  {
    if ($debug) {warn "Processing file : $ARGV[0]\n";}

    open FILE, $ARGV[0] or die "Couldn't open file $ARGV[0] : $!\n";
    my $file = $ARGV[0];
    $file =~ s/.*\/([^\/]+)$/$1/;
    $file =~ s/\.hg//;
    my @tmpnamespace = @namespace_whole;
    my $cppname = "";
    my $cname = "";
    my $ccast = "";
    while (<FILE>) 
    {
      if (/CLASS_START\((\w+)\)/) #We need a new way to get the namespace.
      {
	print "generate_wrap_init: namespace found: $1\n";
	push(@tmpnamespace, $1);
      }
      elsif (/_CLASS_GOBJECT\s*\(/) #TODO: There is duplication of code here.
      {
	my $line = $_;
	while ($line !~ /\)/ && ($_ = <FILE>))
	{
		$line .= $_;
	}

	$line =~ s/^.*_CLASS_GOBJECT\s*\(//;
	$line =~ s/\s+//g;
	($cppname, $cname, $ccast) = split(/,/, $line);

	$objects{$cppname} = $cname;
	@{$namespaces{$cppname}} = ( @tmpnamespace ); #both are lists of strings
	$basenames{$cppname} = lc($ccast);
      }
      elsif (/_CLASS_GTKOBJECT\s*\(/)
      {
	my $line = $_;
	while ($line !~ /\)/ && ($_ = <FILE>))
	{
		$line .= $_;
	}

	$line =~ s/^.*_CLASS_GTKOBJECT\s*\(//;
	$line =~ s/\s+//g;
	($cppname, $cname, $ccast) = split(/,/, $line);

	#TODO: Remove this hack eventually.
	if( ($cname ne "GtkTree") && ($cname ne "GtkTreeItem") && ($cname ne "GtkText") )
	{
	  $objects{$cppname} = $cname;
	  @{$namespaces{$cppname}} = ( @tmpnamespace ); #both are lists of strings
	  $basenames{$cppname} = lc($ccast);
	}
      }
      elsif (/_CLASS_GERROR\s*\(/) #TODO: There is duplication of code here.
      {
	my $line = $_;
	while ($line !~ /\)/ && ($_ = <FILE>))
	{
		$line .= $_;
	}

	$line =~ s/^.*_CLASS_GERROR\s*\(//;
	$line =~ s/\s+//g;
	$line =~ s/\)//;
	($cppname, $cname, $ccast) = split(/,/, $line);

	$exceptions{$cppname} = $cname;
	@{$namespaces{$cppname}} = ( @tmpnamespace ); #both are lists of strings
	$basenames{$cppname} = lc($ccast);
      }
      elsif (/_NO_WRAP_FUNCTION/)
      {
	$nowrap{$cppname} = 1;
      }
    }

    shift @ARGV;
    close(FILE);
  }

# my $namespace_whole_lower = lc($namespace_whole);
print "#include <${parent_dir}/wrap_init.h>\n";
print "#include <glibmm/error.h>\n";
print "#include <glibmm/object.h>\n";

# Here we have to be subtle. The Gtk-- objects are easy, they all go
# into the Gtk namespace. But in Gnome--, some go into the Gnome
# namespace (most of them), and some into the Gtk one (because the
# corresponding widget is Gtk-prefixed, e.g. GtkTed, GtkDial, etc...

# First, the Gtk namespace

print "extern \"C\"\n";
print "{\n";
print "\n//Declarations of the *_get_type() functions:\n\n";

my $i = 0;
foreach $i (sort keys %objects)
  {
    if( $nowrap{$i} ne 1 )
    {
      print "GType $basenames{$i}_get_type(void);\n";
    }
  }

print "\n//Declarations of the *_error_quark() functions:\n\n";

my $i = 0;
foreach $i (sort keys %exceptions)
  {
    print "GQuark $basenames{$i}_quark(void);\n";
  }

print "} // extern \"C\"\n";
print "\n";

print "\n//Declarations of the *_Class::wrap_new() methods, instead of including all the private headers:\n\n";

my $i = 0;
foreach $i (sort keys %objects)
{
  if( $nowrap{$i} ne 1 )
  {
    my $namespace_declarations = "";
    my $namespace_close = "";
    foreach ( @{$namespaces{$i}} )
    {
      $namespace_declarations .= "namespace $_ { ";
      $namespace_close .= " }";
    }

    print "${namespace_declarations} class ${i}_Class { public: static Glib::ObjectBase* wrap_new(GObject*); }; ${namespace_close}\n";
  }
}

print "\n//Declarations of the *Error::throw_func() methods:\n\n";

my $i = 0;
foreach $i (sort keys %exceptions)
{
  my $namespace_declarations = "";
  my $namespace_close = "";
  foreach ( @{$namespaces{$i}} )
  {
    $namespace_declarations .= "namespace $_ { ";
    $namespace_close .= " }";
  }

  print "${namespace_declarations} class ${i} { public: static void throw_func(GError*); }; ${namespace_close}\n";
}

my $namespace_whole_declarations = "";
my $namespace_whole_close = "";
foreach( @namespace_whole )
{
  $namespace_whole_declarations .= "namespace " . $_ ." { ";
  $namespace_whole_close = "} //" . $_ . "\n" . $namespace_whole_close;
}

print "\n";
print "$namespace_whole_declarations\n";
print "\n";
print "void " .$function_prefix . "wrap_init()\n{\n";

# Generate namespace::wrap_init() body
#
#foreach $i (sort keys %objects)
#  {
#    if( $nowrap{$i} ne 1 )
#    {
#      print "  Glib::wrap_register(\"$objects{$i}\", \&$namespaces{$i}::${i}_Class::wrap_new);\n";
#    }
#  }

# Generate namespace::wrap_init() body
#
foreach $i (sort keys %exceptions)
  {
    my $namespace_prefix = "";
    foreach( @{$namespaces{$i}} )
    {
      $namespace_prefix .= $_ ."::";
    }

    print "  Glib::Error::register_domain($basenames{$i}_quark(), \& ${namespace_prefix}${i}::throw_func);\n";
  }

foreach $i (sort keys %objects)
  {
    if( $nowrap{$i} ne 1 )
    {
      my $namespace_prefix = "";
      foreach( @{$namespaces{$i}} )
      {
        $namespace_prefix .= $_ ."::";
      }

      print "  Glib::wrap_register($basenames{$i}_get_type(), \& ${namespace_prefix}${i}_Class::wrap_new);\n";
    }
  }

print "} // wrap_init()\n";
print "\n";
print $namespace_whole_close;

