
#include <gtkmm/eventbox.h>
#include <gtkmm/private/eventbox_p.h>

// -*- c++ -*-
/* $Id: eventbox.ccg,v 1.2 2001/05/10 22:13:27 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkeventbox.h>


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::EventBox* wrap(GtkEventBox* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::EventBox *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType EventBox_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_event_box_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void EventBox_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* EventBox_Class::wrap_new(GObject* o)
{
  return manage(new EventBox((GtkEventBox*)(o)));
}


/* The implementation: */

EventBox::EventBox(GtkEventBox* castitem)
: Gtk::Bin((GtkBin*)(castitem))
{}

EventBox::~EventBox()
{
  destroy_();
}

EventBox::CppClassType EventBox::eventbox_class_; //Initialize static member.

GType EventBox::get_type()
{
  return eventbox_class_.get_type();
}

GType EventBox::get_base_type()
{
  return gtk_event_box_get_type();
}

EventBox::EventBox()
: Gtk::Bin((GtkBin*)(g_object_new(get_type(), (char*)0)))
{}


} // namespace Gtk

