
#include <gtkmm/radiobutton.h>
#include <gtkmm/private/radiobutton_p.h>

// -*- c++ -*-
/* $Id: radiobutton.ccg,v 1.12 2002/01/18 22:30:41 daniel Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkradiobutton.h>

typedef Gtk::RadioButton::Group Group;
namespace Gtk
{

RadioButton::RadioButton()
: CheckButton((GtkCheckButton*)(g_object_new(get_type(), (char*)0)))
{
}

RadioButton::RadioButton(const Glib::ustring& label, bool mnemonic /* = false */)
:  CheckButton((GtkCheckButton*)(g_object_new(get_type(),
        "label", label.c_str(), "use_underline", (gboolean)mnemonic, (char*)0)))
{
}

RadioButton::RadioButton(Group& group)
:  CheckButton((GtkCheckButton*)(g_object_new(get_type(), (char*)0)))
{
  group.add(*this);
}

RadioButton::RadioButton(Group& group, const Glib::ustring& label, bool mnemonic /* = false */)
:  CheckButton((GtkCheckButton*)(g_object_new(get_type(),
        "label", label.c_str(), "use_underline", (gboolean)mnemonic, (char*)0)))
{
  group.add(*this);
}

void RadioButton::reset_group()
{
  gtk_radio_button_set_group(gobj(), 0);
}

void RadioButton_Helpers::Group::add(RadioButton& item)
{
  item.set_group(*this);
  group_ = gtk_radio_button_get_group(item.gobj());
}

} /* namespace Gtk */


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::RadioButton* wrap(GtkRadioButton* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::RadioButton *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType RadioButton_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_radio_button_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void RadioButton_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* RadioButton_Class::wrap_new(GObject* o)
{
  return manage(new RadioButton((GtkRadioButton*)(o)));
}


/* The implementation: */

RadioButton::RadioButton(GtkRadioButton* castitem)
: Gtk::CheckButton((GtkCheckButton*)(castitem))
{}

RadioButton::~RadioButton()
{
  destroy_();
}

RadioButton::CppClassType RadioButton::radiobutton_class_; //Initialize static member.

GType RadioButton::get_type()
{
  return radiobutton_class_.get_type();
}

GType RadioButton::get_base_type()
{
  return gtk_radio_button_get_type();
}

Group RadioButton::get_group()
{
  return Group(gtk_radio_button_get_group(gobj()));
}

void RadioButton::set_group(Group group)
{
  gtk_radio_button_set_group(gobj(), group.group_);
}


} // namespace Gtk

