
#include <gtkmm/ruler.h>
#include <gtkmm/private/ruler_p.h>

// -*- c++ -*-
/* $Id: ruler.ccg,v 1.5 2002/04/02 13:25:19 daniel Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkruler.h>
#include <gtk/gtkhruler.h>
#include <gtk/gtkvruler.h>
#include <cstring>


namespace Gtk
{

MetricType Ruler::get_metric() const
{
  MetricType metric = PIXELS;

  if     (strcmp(gobj()->metric->abbrev, "In") == 0) metric = INCHES;
  else if(strcmp(gobj()->metric->abbrev, "Cn") == 0) metric = CENTIMETERS;

  return metric;
}

} // namespace Gtk


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::Ruler* wrap(GtkRuler* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Ruler *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Ruler_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_ruler_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void Ruler_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->draw_ticks = &draw_ticks_vfunc_callback;
  klass->draw_pos = &draw_pos_vfunc_callback;
}


void Ruler_Class::draw_ticks_vfunc_callback(GtkRuler* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->draw_ticks_vfunc();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->draw_ticks)
      (*base->draw_ticks)(self);
  }
}

void Ruler_Class::draw_pos_vfunc_callback(GtkRuler* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->draw_pos_vfunc();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->draw_pos)
      (*base->draw_pos)(self);
  }
}


Glib::ObjectBase* Ruler_Class::wrap_new(GObject* o)
{
  return manage(new Ruler((GtkRuler*)(o)));
}


/* The implementation: */

Ruler::Ruler(GtkRuler* castitem)
: Gtk::Widget((GtkWidget*)(castitem))
{}

Ruler::~Ruler()
{
  destroy_();
}

Ruler::CppClassType Ruler::ruler_class_; //Initialize static member.

GType Ruler::get_type()
{
  return ruler_class_.get_type();
}

GType Ruler::get_base_type()
{
  return gtk_ruler_get_type();
}

Ruler::Ruler()
: Gtk::Widget((GtkWidget*)(g_object_new(get_type(), (char*)0)))
{}

void Ruler::set_metric(MetricType metric)
{
  gtk_ruler_set_metric(gobj(), ((GtkMetricType)(metric)));
}

MetricType Ruler::get_metric()
{
  return ((MetricType)(gtk_ruler_get_metric(gobj())));
}

double Ruler::get_range_lower() const
{
  return gobj()->lower;
}

double Ruler::get_range_upper() const
{
  return gobj()->upper;
}

void Ruler::set_range(double lower, double upper, double position, double max_size)
{
  gtk_ruler_set_range(gobj(), lower, upper, position, max_size);
}

void Ruler::get_range(double& lower, double& upper, double& position, double& max_size)
{
  gtk_ruler_get_range(gobj(), &(lower), &(upper), &(position), &(max_size));
}

void Ruler::draw_ticks()
{
  gtk_ruler_draw_ticks(gobj());
}

void Ruler::draw_pos()
{
  gtk_ruler_draw_pos(gobj());
}


Glib::PropertyProxy<double> Ruler::property_lower()
{
  return Glib::PropertyProxy<double>(this, "lower");
}

Glib::PropertyProxy<double> Ruler::property_upper()
{
  return Glib::PropertyProxy<double>(this, "upper");
}

Glib::PropertyProxy<double> Ruler::property_position()
{
  return Glib::PropertyProxy<double>(this, "position");
}

Glib::PropertyProxy<double> Ruler::property_max_size()
{
  return Glib::PropertyProxy<double>(this, "max_size");
}


void Gtk::Ruler::draw_ticks_vfunc()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->draw_ticks)
    (*base->draw_ticks)(gobj());
}

void Gtk::Ruler::draw_pos_vfunc()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->draw_pos)
    (*base->draw_pos)(gobj());
}


} // namespace Gtk


namespace Glib
{

Gtk::VRuler* wrap(GtkVRuler* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::VRuler *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType VRuler_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_vruler_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void VRuler_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* VRuler_Class::wrap_new(GObject* o)
{
  return manage(new VRuler((GtkVRuler*)(o)));
}


/* The implementation: */

VRuler::VRuler(GtkVRuler* castitem)
: Gtk::Ruler((GtkRuler*)(castitem))
{}

VRuler::~VRuler()
{
  destroy_();
}

VRuler::CppClassType VRuler::vruler_class_; //Initialize static member.

GType VRuler::get_type()
{
  return vruler_class_.get_type();
}

GType VRuler::get_base_type()
{
  return gtk_vruler_get_type();
}

VRuler::VRuler()
: Gtk::Ruler((GtkRuler*)(g_object_new(get_type(), (char*)0)))
{}


} // namespace Gtk


namespace Glib
{

Gtk::HRuler* wrap(GtkHRuler* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::HRuler *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType HRuler_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_hruler_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void HRuler_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* HRuler_Class::wrap_new(GObject* o)
{
  return manage(new HRuler((GtkHRuler*)(o)));
}


/* The implementation: */

HRuler::HRuler(GtkHRuler* castitem)
: Gtk::Ruler((GtkRuler*)(castitem))
{}

HRuler::~HRuler()
{
  destroy_();
}

HRuler::CppClassType HRuler::hruler_class_; //Initialize static member.

GType HRuler::get_type()
{
  return hruler_class_.get_type();
}

GType HRuler::get_base_type()
{
  return gtk_hruler_get_type();
}

HRuler::HRuler()
: Gtk::Ruler((GtkRuler*)(g_object_new(get_type(), (char*)0)))
{}


} // namespace Gtk

