// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TABLE_H
#define _GTKMM_TABLE_H

#include <glibmm.h>

/* $Id: table.hg,v 1.30 2002/04/26 01:36:26 murrayc Exp $ */


/* table.h
 * 
 * Copyright (C) 1998-1999 The gtkmm Development Team 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/helperlist.h>
#include <gtkmm/container.h>
#include <gtkmm/enums.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkTable GtkTable;
typedef struct _GtkTableClass GtkTableClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Table_Class; } // namespace Gtk
namespace Gtk
{

class Table;

namespace Table_Helpers
{
 
  
class TableList : public Glib::HelperList< Widget*, Widget, Glib::List_Iterator< Widget* > >
{
public:
  TableList();
  explicit TableList(GtkTable* gparent);
  TableList(const TableList& src);
  virtual ~TableList() {}

  TableList& operator=(const TableList& src);

  typedef Glib::HelperList< Widget*, Widget,  Glib::List_Iterator< Widget* > > type_base;

  GtkTable* gparent();
  const GtkTable* gparent() const;

  virtual GList*& glist() const;      // front of list

  virtual void erase(iterator start, iterator stop);
  virtual iterator erase(iterator);  //Implented as custom or by LIST_CONTAINER_REMOVE
  virtual void remove(const_reference); //Implented as custom or by LIST_CONTAINER_REMOVE

  value_type front() const     { return *begin(); }
  value_type back() const      { return *(--end()); }

  /// This is order n. (use at own risk)
  value_type operator[](size_type l) const;

protected:
  //Hide these because its read-only:
  iterator insert(iterator position, element_type& e);

  inline void pop_front();
  inline void pop_back();


virtual void remove(Widget& w); //Implented as custom or by LIST_CONTAINER_REMOVE

  };


} /* namespace Table_Helpers */

/** Table Packing Widget
 * Gtk::Table is one of the primary methods for construction of
 * grouped widgets.  It consists of a set of lattice points to
 * to which widgets can be attached.  There are {\i(rows+1)} lattice
 * points vertically and {\i (columns+1)} lattice points horizontally.
 * Lattice points start counting from 0.
 * Lattice points can either be specified to be {homogeneous}  meaning
 * equally spaced or not {homogeneous} meaning each cell should
 * be calculated based on the widgets contained in the row and column.
 * Homogeneous defaults to false.
 *
 * Widgets can be attached to the table by specifying the top, bottom,
 * left and right points corresponding to upper, lefthand
 * lattice point and the lower, righthand lattice point which the
 * widget should span.  Widgets can
 * either be contained in a cell or may span cells.  A number of options
 * control the resizing behavior of widgets contained in the table.
 *
 * {\b Packing options:}
 *
 * There are a number of packing objections that can be specified
 * when adding a widget.  With {\enum GTK_EXPAND}, the lattice is
 * allowed to grow to fill space.  With {\enum GTK_SHRINK}, the lattice
 * is allowed to shrink when resized.  It is also possible to specify
 * the behaviour of the widgets allocation within the table.  The
 * flag {\enum GTK_FILL} declares the widget should grow to fill lattice.
 * If this is not set any extra space is used as padding.
 * The default is {\enum GTK_FILL} and {\enum GTK_EXPAND}.
 *
 * The table size is calculated
 * based on the size of the widgets contained within and the restrictions
 * imposed by specified options.
 *
 * Padding and spacing can be used
 * in the table.  Padding is added on either side of a widget, while spacing
 * is placed between widgets.
 *
 * The other generic packing widgets are:
 * Gtk::HBox, Gtk::VBox
 *
 * @ingroup Widgets
 * @ingroup Containers
 */

class Table : public Container
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Table CppObjectType;
  typedef Table_Class CppClassType;
  typedef GtkTable BaseObjectType;
  typedef GtkTableClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Table();

private:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  friend class Table_Class;
  static CppClassType table_class_;

  Table(const Table&);
  Table& operator=(const Table&); // not implemented

protected:
  explicit Table(GtkTable* castitem);
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type() G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */
  GtkTable* gobj()             { return (GtkTable*)(gobject_); }
  const GtkTable* gobj() const { return (GtkTable*)(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

  
public:
  explicit Table(guint n_rows = 1, guint n_columns = 1, bool homogeneous = false);

  //: Binds a widget to a set of lattice points.  
  //- At minumum 
  //- specification of the lattice points is required.  
  //- Additionally, the cell options as described above and paddings 
  //- may be specified.  Default paddings are 0 pixels in both dimensions.
  
  
        void attach(Widget &child,
                    guint left_attach,
                    guint right_attach,
                    guint top_attach,
                    guint bottom_attach,
                    AttachOptions xoptions = AttachOptions(FILL|EXPAND),
                    AttachOptions yoptions = AttachOptions(FILL|EXPAND),
                    guint xpadding=0,
                    guint ypadding=0);


  //- (Gtk 1.1) This function allows for dynamic resizing of 
  //- a Table.
  
  void resize(guint rows, guint columns);


  //- This function sets the number of pixels to appear
  //- between one row of cells and the next.  {\i row} is the 
  //- lattice row counted without the edges starting from 0.  Therefore, row
  //- 0 would denote between the first and second
  //- row of cells.  {\i row} has a range from  0 and {\i (rows-2)}
  //- Default spacing is 0 pixels.
  
  void set_row_spacing(guint row, guint spacing);
  
  guint get_row_spacing(guint row) const;

  //- This function sets the number of pixels to appear
  //- between one column of cells and the next.  {\i column} is the 
  //- lattice column counted without the edges starting from 0.  Therefore, 
  //- column 0 would denote between the first and second
  //- row of cells.  {\i column} has a range from  0 and {\i (columns-2)}.
  //- Default spacing is 0 pixels.
  
  void set_col_spacing(guint column, guint spacing);
  
  guint get_col_spacing(guint column) const;

  //- This function sets the number of pixels to a appear between every
  //- row of cells.  Default is 0 pixels.
  
  void set_row_spacings(guint spacing);

  //- This function sets the number of pixels to a appear between every
  //- column of cells.  Default is 0 pixels.
  
  void set_col_spacings(guint spacing);

  void set_spacings(guint spacing);

  
  guint get_default_row_spacing();
  
  guint get_default_col_spacing();

  
  void set_homogeneous(bool homogeneous = true);
  
  bool get_homogeneous() const;

  typedef Table_Helpers::TableList TableList;

  // *****WARNING - THESE METHODS DO NOT WORK IN STABLE 
  //   CAN NOT BE FIXED BECAUSE OF BINARY COMPATIBLITY.  WILL
  //   FIX IN 1.4
  // TODO: What methods? Why? What needs to be done? murrayc.


  TableList& children();
  const TableList& children() const;

  Glib::PropertyProxy<guint> property_n_rows();

  Glib::PropertyProxy<guint> property_n_columns();

  Glib::PropertyProxy<guint> property_column_spacing();

  Glib::PropertyProxy<guint> property_row_spacing();


protected:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  mutable TableList children_proxy_;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::Table */
  Gtk::Table* wrap(GtkTable* object, bool take_copy = false);
}
#endif /* _GTKMM_TABLE_H */

