
#include <gtkmm/textattributes.h>
#include <gtkmm/private/textattributes_p.h>

// -*- c++ -*-
/* $Id: textattributes.ccg,v 1.4 2002/04/16 13:01:53 murrayc Exp $ */

/*
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtktexttag.h>


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::TextAttributes wrap(GtkTextAttributes* object, bool take_copy /* = false */)
{
  return Gtk::TextAttributes(object, take_copy);
}

} // namespace Glib


namespace Gtk
{


// static
GType TextAttributes::get_type()
{
  return gtk_text_attributes_get_type();
}

TextAttributes::TextAttributes()
:
  gobject_ (gtk_text_attributes_new())
{}

TextAttributes::TextAttributes(const TextAttributes& src)
:
  gobject_ ((src.gobject_) ? gtk_text_attributes_copy(src.gobject_) : 0)
{}

TextAttributes::TextAttributes(GtkTextAttributes* castitem, bool make_a_copy /* = true */)
{
  // For BoxedType wrappers, make_a_copy is true by default.  The static
  // BoxedType wrappers must always take a copy, thus make_a_copy = true
  // ensures identical behaviour if the default argument is used.

  if(make_a_copy)
  {
    if(castitem)
      gobject_ = gtk_text_attributes_copy(castitem);
    else
      gobject_ = 0;
  }
  else
  {
    // It was given to us by a function which has already made a copy for us to keep.
    gobject_ = castitem;
  }
}

TextAttributes& TextAttributes::operator=(const TextAttributes& src)
{
  GtkTextAttributes *const new_gobject = (src.gobject_) ? gtk_text_attributes_copy(src.gobject_) : 0;

  if(gobject_)
    gtk_text_attributes_unref(gobject_);
  gobject_ = new_gobject;

  return *this;
}

TextAttributes::~TextAttributes()
{
  if(gobject_)
    gtk_text_attributes_unref(gobject_);}


GtkTextAttributes* TextAttributes::gobj_copy() const
{
  return gtk_text_attributes_copy(gobject_);
}


} // namespace Gtk


