// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDKMM_WINDOW_H
#define _GDKMM_WINDOW_H

#include <glibmm.h>

/* $Id: window.hg,v 1.22 2002/05/09 20:31:22 murrayc Exp $ */

/* bitmap.h
 *
 * Copyright(C) 1998-1999 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not write to the Free
 * Software Foundation Inc. 675 Mass Ave Cambridge MA 02139 USA.
 */

#include <glibmm/object.h>
#include <gdkmm/bitmap.h>
//#include <gdkmm/cursor.h>
#include <gdkmm/types.h>
#include <gdk/gdkwindow.h>


namespace Gdk
{ class Window_Class; } // namespace Gdk
namespace Gdk
{


/** @addtogroup gdkmmEnums Enums and Flags */

/**
 * @ingroup gdkmmEnums
 * @par Bitwise operators:
 * <tt>%EventMask operator|(EventMask, EventMask)</tt><br>
 * <tt>%EventMask operator&(EventMask, EventMask)</tt><br>
 * <tt>%EventMask operator~(EventMask)</tt><br>
 */
enum EventMask
{
  EXPOSURE_MASK = 1 << 1,
  POINTER_MOTION_MASK = 1 << 2,
  POINTER_MOTION_HINT_MASK = 1 << 3,
  BUTTON_MOTION_MASK = 1 << 4,
  BUTTON1_MOTION_MASK = 1 << 5,
  BUTTON2_MOTION_MASK = 1 << 6,
  BUTTON3_MOTION_MASK = 1 << 7,
  BUTTON_PRESS_MASK = 1 << 8,
  BUTTON_RELEASE_MASK = 1 << 9,
  KEY_PRESS_MASK = 1 << 10,
  KEY_RELEASE_MASK = 1 << 11,
  ENTER_NOTIFY_MASK = 1 << 12,
  LEAVE_NOTIFY_MASK = 1 << 13,
  FOCUS_CHANGE_MASK = 1 << 14,
  STRUCTURE_MASK = 1 << 15,
  PROPERTY_CHANGE_MASK = 1 << 16,
  VISIBILITY_NOTIFY_MASK = 1 << 17,
  PROXIMITY_IN_MASK = 1 << 18,
  PROXIMITY_OUT_MASK = 1 << 19,
  SUBSTRUCTURE_MASK = 1 << 20,
  SCROLL_MASK = 1 << 21,
  ALL_EVENTS_MASK = 0x3FFFFE
};

/** @ingroup gdkmmEnums */
inline EventMask operator|(EventMask lhs, EventMask rhs)
  { return static_cast<EventMask>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline EventMask operator&(EventMask lhs, EventMask rhs)
  { return static_cast<EventMask>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline EventMask operator~(EventMask flags)
  { return static_cast<EventMask>(~static_cast<unsigned>(flags)); }

} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::EventMask> : public Glib::Value_Flags<Gdk::EventMask>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 * @par Bitwise operators:
 * <tt>%WindowState operator|(WindowState, WindowState)</tt><br>
 * <tt>%WindowState operator&(WindowState, WindowState)</tt><br>
 * <tt>%WindowState operator~(WindowState)</tt><br>
 */
enum WindowState
{
  WINDOW_STATE_WITHDRAWN = 1 << 0,
  WINDOW_STATE_ICONIFIED = 1 << 1,
  WINDOW_STATE_MAXIMIZED = 1 << 2,
  WINDOW_STATE_STICKY = 1 << 3
};

/** @ingroup gdkmmEnums */
inline WindowState operator|(WindowState lhs, WindowState rhs)
  { return static_cast<WindowState>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WindowState operator&(WindowState lhs, WindowState rhs)
  { return static_cast<WindowState>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WindowState operator~(WindowState flags)
  { return static_cast<WindowState>(~static_cast<unsigned>(flags)); }

} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::WindowState> : public Glib::Value_Flags<Gdk::WindowState>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 */
enum WindowType
{
  WINDOW_ROOT,
  WINDOW_TOPLEVEL,
  WINDOW_CHILD,
  WINDOW_DIALOG,
  WINDOW_TEMP,
  WINDOW_FOREIGN
};

} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::WindowType> : public Glib::Value_Enum<Gdk::WindowType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 * @par Bitwise operators:
 * <tt>%WindowAttributesType operator|(WindowAttributesType, WindowAttributesType)</tt><br>
 * <tt>%WindowAttributesType operator&(WindowAttributesType, WindowAttributesType)</tt><br>
 * <tt>%WindowAttributesType operator~(WindowAttributesType)</tt><br>
 */
enum WindowAttributesType
{
  WA_TITLE = 1 << 1,
  WA_X = 1 << 2,
  WA_Y = 1 << 3,
  WA_CURSOR = 1 << 4,
  WA_COLORMAP = 1 << 5,
  WA_VISUAL = 1 << 6,
  WA_WMCLASS = 1 << 7,
  WA_NOREDIR = 1 << 8
};

/** @ingroup gdkmmEnums */
inline WindowAttributesType operator|(WindowAttributesType lhs, WindowAttributesType rhs)
  { return static_cast<WindowAttributesType>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WindowAttributesType operator&(WindowAttributesType lhs, WindowAttributesType rhs)
  { return static_cast<WindowAttributesType>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WindowAttributesType operator~(WindowAttributesType flags)
  { return static_cast<WindowAttributesType>(~static_cast<unsigned>(flags)); }

} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::WindowAttributesType> : public Glib::Value_Flags<Gdk::WindowAttributesType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 * @par Bitwise operators:
 * <tt>%WindowHints operator|(WindowHints, WindowHints)</tt><br>
 * <tt>%WindowHints operator&(WindowHints, WindowHints)</tt><br>
 * <tt>%WindowHints operator~(WindowHints)</tt><br>
 */
enum WindowHints
{
  HINT_POS = 1 << 0,
  HINT_MIN_SIZE = 1 << 1,
  HINT_MAX_SIZE = 1 << 2,
  HINT_BASE_SIZE = 1 << 3,
  HINT_ASPECT = 1 << 4,
  HINT_RESIZE_INC = 1 << 5,
  HINT_WIN_GRAVITY = 1 << 6,
  HINT_USER_POS = 1 << 7,
  HINT_USER_SIZE = 1 << 8
};

/** @ingroup gdkmmEnums */
inline WindowHints operator|(WindowHints lhs, WindowHints rhs)
  { return static_cast<WindowHints>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WindowHints operator&(WindowHints lhs, WindowHints rhs)
  { return static_cast<WindowHints>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WindowHints operator~(WindowHints flags)
  { return static_cast<WindowHints>(~static_cast<unsigned>(flags)); }

} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::WindowHints> : public Glib::Value_Flags<Gdk::WindowHints>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 */
enum WindowTypeHint
{
  WINDOW_TYPE_HINT_NORMAL,
  WINDOW_TYPE_HINT_DIALOG,
  WINDOW_TYPE_HINT_MENU,
  WINDOW_TYPE_HINT_TOOLBAR
};

} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::WindowTypeHint> : public Glib::Value_Enum<Gdk::WindowTypeHint>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 * @par Bitwise operators:
 * <tt>%WMDecoration operator|(WMDecoration, WMDecoration)</tt><br>
 * <tt>%WMDecoration operator&(WMDecoration, WMDecoration)</tt><br>
 * <tt>%WMDecoration operator~(WMDecoration)</tt><br>
 */
enum WMDecoration
{
  DECOR_ALL = 1 << 0,
  DECOR_BORDER = 1 << 1,
  DECOR_RESIZEH = 1 << 2,
  DECOR_TITLE = 1 << 3,
  DECOR_MENU = 1 << 4,
  DECOR_MINIMIZE = 1 << 5,
  DECOR_MAXIMIZE = 1 << 6
};

/** @ingroup gdkmmEnums */
inline WMDecoration operator|(WMDecoration lhs, WMDecoration rhs)
  { return static_cast<WMDecoration>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WMDecoration operator&(WMDecoration lhs, WMDecoration rhs)
  { return static_cast<WMDecoration>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WMDecoration operator~(WMDecoration flags)
  { return static_cast<WMDecoration>(~static_cast<unsigned>(flags)); }

} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::WMDecoration> : public Glib::Value_Flags<Gdk::WMDecoration>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 * @par Bitwise operators:
 * <tt>%WMFunction operator|(WMFunction, WMFunction)</tt><br>
 * <tt>%WMFunction operator&(WMFunction, WMFunction)</tt><br>
 * <tt>%WMFunction operator~(WMFunction)</tt><br>
 */
enum WMFunction
{
  FUNC_ALL = 1 << 0,
  FUNC_RESIZE = 1 << 1,
  FUNC_MOVE = 1 << 2,
  FUNC_MINIMIZE = 1 << 3,
  FUNC_MAXIMIZE = 1 << 4,
  FUNC_CLOSE = 1 << 5
};

/** @ingroup gdkmmEnums */
inline WMFunction operator|(WMFunction lhs, WMFunction rhs)
  { return static_cast<WMFunction>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WMFunction operator&(WMFunction lhs, WMFunction rhs)
  { return static_cast<WMFunction>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WMFunction operator~(WMFunction flags)
  { return static_cast<WMFunction>(~static_cast<unsigned>(flags)); }

} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::WMFunction> : public Glib::Value_Flags<Gdk::WMFunction>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 */
enum WindowEdge
{
  WINDOW_EDGE_NORTH_WEST,
  WINDOW_EDGE_NORTH,
  WINDOW_EDGE_NORTH_EAST,
  WINDOW_EDGE_WEST,
  WINDOW_EDGE_EAST,
  WINDOW_EDGE_SOUTH_WEST,
  WINDOW_EDGE_SOUTH,
  WINDOW_EDGE_SOUTH_EAST
};

} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::WindowEdge> : public Glib::Value_Enum<Gdk::WindowEdge>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 */
enum Gravity
{
  GRAVITY_NORTH_WEST = 1,
  GRAVITY_NORTH,
  GRAVITY_NORTH_EAST,
  GRAVITY_WEST,
  GRAVITY_CENTER,
  GRAVITY_EAST,
  GRAVITY_SOUTH_WEST,
  GRAVITY_SOUTH,
  GRAVITY_SOUTH_EAST,
  GRAVITY_STATIC
};

} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::Gravity> : public Glib::Value_Enum<Gdk::Gravity>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{


class Cursor;


class Window : public Gdk::Drawable
{
  // GdkWindow is a typedef to GdkDrawable, but it's actually a GdkWindowObject.
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Window          CppObjectType;
  typedef Window_Class    CppClassType;
  typedef GdkWindow           BaseObjectType;
  typedef GdkWindowObjectClass      BaseClassType;

private:
  friend class Window_Class;
  static CppClassType window_class_;

  Window(const Window&);
  Window& operator=(const Window&); // not implemented

protected:
  explicit Window(GdkWindow* castitem);
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Window();

  static Glib::RefPtr<Window> wrap_specific_type(GdkWindow* gobject, bool take_copy = false); //Re-uses the existing wrapper, if it exists.

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type() G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */
  GdkWindow* gobj()             { return (GdkWindow*)(gobject_); }
  const GdkWindow* gobj() const { return (GdkWindow*)(gobject_); }

  GdkWindow* gobj_copy();


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

  
protected:
  Window(const Glib::RefPtr<Window>& parent, GdkWindowAttr* attributes, int attributes_mask);

public:
  
  static Glib::RefPtr<Window> create(const Glib::RefPtr<Window>& parent, GdkWindowAttr * attributes, int attributes_mask);


  WindowType get_window_type() const;
  
  void show();
  
  void hide();
  
  void withdraw();
  
  void show_unraised();
  
  void move(int x, int y);
  
  void resize(int width, int height);
  
  void move_resize(int x, int y, int width, int height);
  
  void reparent(const Glib::RefPtr<Window>& new_parent, int x, int y);
  
  void clear();
  
  void clear_area(int x, int y, int width, int height);
  
  void clear_area_e(int x, int y, int width, int height);
  
  void raise();
  
  void lower();
  
  void focus(guint32 imestamp);
  
  void set_user_data(gpointer user_data);
  
  void set_override_redirect(bool override_redirect = true);
  
  void add_filter(GdkFilterFunc function, gpointer data);
  
  void remove_filter(GdkFilterFunc function, gpointer data);
  
  void scroll(int dx, int dy);
  
  void shape_combine_mask(const Glib::RefPtr<Bitmap>& mask, int	x, int y);
  
  void shape_combine_region(GdkRegion* shape_region, int offset_x, int offset_y);
  
  void set_child_shapes();
  
  void merge_child_shapes();
  
  bool is_visible();
  
  bool is_viewable();
  
  WindowState get_state();
  
  bool set_static_gravities(bool use_static = true);
  
  void set_type_hint(WindowTypeHint hint);
  
  void set_modal_hint(bool modal = true);
  
  void set_geometry_hints(GdkGeometry* geometry, WindowHints geom_mask);
  
  static void set_sm_client_id(const Glib::ustring& sm_client_id);
  
  void begin_paint_rect(Rectangle&rectangle);
  
  void begin_paint_region(GdkRegion* region);
  
  void end_paint();
  
  void set_title(const Glib::ustring& title);
  
  void set_role(const Glib::ustring& role);
  
  void set_transient_for(const Glib::RefPtr<Window>& parent);
  
  void set_background(const Color& color);
  
  void set_back_pixmap(const Glib::RefPtr<Pixmap>&pixmap, bool parent_relative);
  
  void set_cursor(const Cursor& cursor);
  
  void get_user_data(gpointer* data);
  
  void get_geometry(int& x, int& y, int& width, int& height, int& depth);
  
  void get_position(int& x, int& y);
  
  int get_origin(int& x, int& y);
  //_WRAP_METHOD(bool get_deskrelative_origin(int& x, int& y), gdk_window_get_deskrelative_origin)
  
  void get_root_origin(int& x, int& y);
  
  void get_frame_extents(Rectangle& rect);
  
  Glib::RefPtr<Window> get_pointer(int& x, int& y, ModifierType& mask);
  
  Glib::RefPtr<Window> get_parent();
  
  Glib::RefPtr<Window> get_toplevel();
  
  GList* get_children();
  
  GList* peek_children();
  
  EventMask get_events();
  
  void set_events(EventMask event_mask);
  
  void set_icon_list(GList* pixbufs);
  
  void set_icon(const Glib::RefPtr<Window>&icon_window, const Glib::RefPtr<Pixmap>& pixmap, const Glib::RefPtr<Bitmap>& mask);
  
  void set_icon_name(const Glib::ustring& name);
  
  void set_group(const Glib::RefPtr<Window>& leader);
  
  void set_decorations(WMDecoration decorations);
  
  bool get_decorations(WMDecoration& decorations);
  
  void set_functions(WMFunction functions);
  
  static GList* get_toplevels();
  
  void iconify();
  
  void deiconify();
  
  void stick();
  
  void unstick();
  
  void maximize();
  
  void unmaximize();
  
  void register_dnd();
  
  void begin_resize_drag(WindowEdge  edge, int button, int root_x, int root_y, guint32 imestamp);
  
  void begin_move_drag(int button, int root_x, int root_y, guint32 imestamp);
  
  void invalidate_rect(const Rectangle& rect, bool invalidate_children);
  
  void invalidate_region(GdkRegion* region, bool invalidate_children);
  
  GdkRegion* get_update_area();
  
  void freeze_updates();
  
  void thaw_updates();
  
  static void process_all_updates();
  
  void process_updates(bool update_children);
  
  static void set_debug_updates(bool setting);
  
  static void constrain_size(const Geometry& geometry, guint flags, int width, int height, int& new_width, int& new_height);
  
  void get_internal_paint_info(GdkDrawable **real_drawable, int* x_offset, int* y_offset);


};

} /* namespace Gdk */


#endif /* _GDKMM_WINDOW_H */

