// -*- c++ -*-

/* $Id: class.cc,v 1.7 2002/04/27 22:09:32 daniel Exp $ */

/* Copyright (C) 1998-2001 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/class.h>
#include <glibmm/ustring.h>


namespace Glib
{

void Class::register_derived_type(GType base_type, GClassInitFunc class_init_func)
{
  if(gtype_)
    return; // already initialized

  GTypeQuery base_query = { 0, };
  g_type_query(base_type, &base_query);

  const GTypeInfo derived_info =
  {
    base_query.class_size,
    0, // base_init
    0, // base_finalize
    class_init_func,
    0, // class_finalize
    0, // class_data
    base_query.instance_size,
    0, // n_preallocs
    0, // instance_init
    0, // value_table
  };

  Glib::ustring derived_name = "gtkmm__";
  derived_name += base_query.type_name;

  gtype_ = g_type_register_static(base_type, derived_name.c_str(), &derived_info, GTypeFlags(0));
}

} // namespace Glib

