
#include <gtkmm/sizegroup.h>
#include <gtkmm/private/sizegroup_p.h>

#include <gtk/gtktypebuiltins.h>
// -*- c++ -*-
/* $Id: sizegroup.ccg,v 1.5 2002/04/16 13:01:52 murrayc Exp $ */

/* 
 *
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtksizegroup.h>

namespace Gtk
{

SizeGroup::SizeGroup(SizeGroupMode mode)
: Glib::Object((GObject*)( g_object_new( get_type() , "mode", mode, 0 ) ))
{
}

} /* namespace Gtk */


namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gtk::SizeGroupMode>::value_type()
{
  return gtk_size_group_mode_get_type();
}


namespace Glib
{

Glib::RefPtr<Gtk::SizeGroup> wrap(GtkSizeGroup* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Gtk::SizeGroup>( dynamic_cast<Gtk::SizeGroup*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gtk
{


/* The *_Class implementation: */

GType SizeGroup_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_size_group_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void SizeGroup_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* SizeGroup_Class::wrap_new(GObject* o)
{
  return new SizeGroup((GtkSizeGroup*)(o));
}


/* The implementation: */

GtkSizeGroup* SizeGroup::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<SizeGroup> SizeGroup::wrap_specific_type(GtkSizeGroup* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<SizeGroup> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    SizeGroup* pCppObject = dynamic_cast<SizeGroup*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<SizeGroup>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<SizeGroup>( new SizeGroup(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

SizeGroup::SizeGroup(GtkSizeGroup* castitem)
: Glib::Object((GObject*)(castitem))
{}

SizeGroup::~SizeGroup()
{
}

SizeGroup::CppClassType SizeGroup::sizegroup_class_; //Initialize static member.

GType SizeGroup::get_type()
{
  return sizegroup_class_.get_type();
}

GType SizeGroup::get_base_type()
{
  return gtk_size_group_get_type();
}

Glib::RefPtr<SizeGroup> SizeGroup::create(SizeGroupMode mode)
{
  return Glib::RefPtr<SizeGroup>( new SizeGroup(mode) );
}
void SizeGroup::set_mode(SizeGroupMode mode)
{
  gtk_size_group_set_mode(gobj(), ((GtkSizeGroupMode)(mode)));
}

SizeGroupMode SizeGroup::get_mode() const
{
  return ((SizeGroupMode)(gtk_size_group_get_mode(const_cast<GtkSizeGroup*>(gobj()))));
}

void SizeGroup::add_widget(Widget& widget)
{
  gtk_size_group_add_widget(gobj(), (widget).Gtk::Widget::gobj());
}

void SizeGroup::remove_widget(Widget& widget)
{
  gtk_size_group_remove_widget(gobj(), (widget).Gtk::Widget::gobj());
}


Glib::PropertyProxy<SizeGroupMode> SizeGroup::property_mode()
{
  return Glib::PropertyProxy<SizeGroupMode>(this, "mode");
}


} // namespace Gtk

