
#include <gtkmm/viewport.h>
#include <gtkmm/private/viewport_p.h>

// -*- c++ -*-
/* $Id: viewport.ccg,v 1.6 2001/10/25 11:17:19 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/viewport.h>
#include <gtkmm/adjustment.h>
#include <gtk/gtkviewport.h>


namespace
{


void Viewport_signal_set_scroll_adjustments_callback(GtkViewport*, GtkAdjustment* p0,GtkAdjustment* p1,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot2<void,Gtk::Adjustment*,Gtk::Adjustment*> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (Glib::wrap(p0)
,Glib::wrap(p1)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo Viewport_signal_set_scroll_adjustments_info =
{
  "set_scroll_adjustments",
  (GCallback) &Viewport_signal_set_scroll_adjustments_callback,
  (GCallback) &Viewport_signal_set_scroll_adjustments_callback
};

} // anonymous namespace


namespace Glib
{

Gtk::Viewport* wrap(GtkViewport* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Viewport *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Viewport_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_viewport_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void Viewport_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->set_scroll_adjustments = &set_scroll_adjustments_callback;
}


void Viewport_Class::set_scroll_adjustments_callback(GtkViewport* self, GtkAdjustment* p0, GtkAdjustment* p1)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_set_scroll_adjustments(Glib::wrap(p0)
, Glib::wrap(p1)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->set_scroll_adjustments)
      (*base->set_scroll_adjustments)(self, p0, p1);
  }
}


Glib::ObjectBase* Viewport_Class::wrap_new(GObject* o)
{
  return manage(new Viewport((GtkViewport*)(o)));
}


/* The implementation: */

Viewport::Viewport(GtkViewport* castitem)
: Gtk::Bin((GtkBin*)(castitem))
{}

Viewport::~Viewport()
{
  destroy_();
}

Viewport::CppClassType Viewport::viewport_class_; //Initialize static member.

GType Viewport::get_type()
{
  return viewport_class_.get_type();
}

GType Viewport::get_base_type()
{
  return gtk_viewport_get_type();
}

Viewport::Viewport(Adjustment& hadjustment, Adjustment& vadjustment)
: Gtk::Bin((GtkBin*)( g_object_new(get_type(), "hadjustment", (hadjustment).gobj(), "vadjustment", (vadjustment).gobj(), (char*)0) ))
{}

Gtk::Adjustment* Viewport::get_hadjustment()
{
  return Glib::wrap(gtk_viewport_get_hadjustment(gobj()));
}

const Gtk::Adjustment* Viewport::get_hadjustment() const
{
  return Glib::wrap(gtk_viewport_get_hadjustment(const_cast<GtkViewport*>(gobj())));
}

Gtk::Adjustment* Viewport::get_vadjustment()
{
  return Glib::wrap(gtk_viewport_get_vadjustment(gobj()));
}

const Gtk::Adjustment* Viewport::get_vadjustment() const
{
  return Glib::wrap(gtk_viewport_get_vadjustment(const_cast<GtkViewport*>(gobj())));
}

void Viewport::set_hadjustment(Gtk::Adjustment* adjustment)
{
  gtk_viewport_set_hadjustment(gobj(), (GtkAdjustment*)Glib::unwrap(adjustment));
}

void Viewport::set_hadjustment(Gtk::Adjustment& adjustment)
{
  gtk_viewport_set_hadjustment(gobj(), (adjustment).gobj());
}

void Viewport::set_vadjustment(Gtk::Adjustment* adjustment)
{
  gtk_viewport_set_vadjustment(gobj(), (GtkAdjustment*)Glib::unwrap(adjustment));
}

void Viewport::set_vadjustment(Gtk::Adjustment& adjustment)
{
  gtk_viewport_set_vadjustment(gobj(), (adjustment).gobj());
}

void Viewport::set_shadow_type(ShadowType type)
{
  gtk_viewport_set_shadow_type(gobj(), ((GtkShadowType)(type)));
}

ShadowType Viewport::get_shadow_type() const
{
  return ((ShadowType)(gtk_viewport_get_shadow_type(const_cast<GtkViewport*>(gobj()))));
}


Glib::SignalProxy2<void,Gtk::Adjustment*,Gtk::Adjustment*> Viewport::signal_set_scroll_adjustments()
{
  return Glib::SignalProxy2<void,Gtk::Adjustment*,Gtk::Adjustment*>(this, &Viewport_signal_set_scroll_adjustments_info);
}


Glib::PropertyProxy<Gtk::Adjustment*> Viewport::property_hadjustment()
{
  return Glib::PropertyProxy<Gtk::Adjustment*>(this, "hadjustment");
}

Glib::PropertyProxy<Gtk::Adjustment*> Viewport::property_vadjustment()
{
  return Glib::PropertyProxy<Gtk::Adjustment*>(this, "vadjustment");
}

Glib::PropertyProxy<ShadowType> Viewport::property_shadow_type()
{
  return Glib::PropertyProxy<ShadowType>(this, "shadow_type");
}


void Gtk::Viewport::on_set_scroll_adjustments(Gtk::Adjustment* hadjustment, Gtk::Adjustment* vadjustment)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->set_scroll_adjustments)
    (*base->set_scroll_adjustments)(gobj(),(GtkAdjustment*)Glib::unwrap(hadjustment),(GtkAdjustment*)Glib::unwrap(vadjustment));
}


} // namespace Gtk

