
#include <iostream>
#include <sigc++/class_slot.h>
#include <glibmm/convert.h>
#include <glibmm/exceptionhandler.h>
#include <gtkmm/main.h>
#include <gtkmm/window.h>
#include <gtkmm/button.h>
#include <gtkmm/box.h>

void global_on_clicked();

class MyButton: public Gtk::Button
{
protected:
  //Signal handler:
  virtual void on_clicked();
};

class MyException {};
class MyException2 {};
class MyException3 {};

void MyButton::on_clicked()
{
  std::cout << "The Button was clicked." << std::endl;
  throw MyException();
}

void global_on_clicked()
{
  std::cout << "The Button was clicked." << std::endl;
  throw MyException2();
}

void global_on_clicked_throw_glib_error()
{
  std::cout << "The Button was clicked." << std::endl;
  Glib::locale_from_utf8("Und tschss!"); // invalid UTF-8
}

void global_on_clicked_throw_std_exception()
{
  std::cout << "The Button was clicked." << std::endl;
  Glib::ustring str;
  str.at(3); // out of range
}

/****************************************************************/
void foo()
{
  std::cout << "exception handler 1" << std::endl;
  try {
    throw;  // rethrow exception
  }
  catch (MyException e) {
    std::cout << "caught my exception" << std::endl;
  }
  // if not handled it gets passed to next handler
}

void bar()
{
  std::cout << "exception handler 2" << std::endl;
  try {
    throw; // rethrow exception
  } 
  catch (MyException2 e) {
    std::cout << "caught my exception2" << std::endl;
  }
}
/****************************************************************/

int main (int argc, char *argv[])
{
  SigC::Connection conn_foo = Glib::add_exception_handler(SigC::slot(&foo));
  SigC::Connection conn_bar = Glib::add_exception_handler(SigC::slot(&bar));

  Gtk::Main kit(argc, argv);
  Gtk::Window window;
  Gtk::VBox* box = manage( new Gtk::VBox );

  Gtk::Button* button1 = Gtk::manage( new MyButton() );
  Gtk::Button* button2 = Gtk::manage( new Gtk::Button("From signal") );
  Gtk::Button* button3 = Gtk::manage( new Gtk::Button("Unhandled Glib::Error") );
  Gtk::Button* button4 = Gtk::manage( new Gtk::Button("Unhandled std::exception (crash!)") );
  Gtk::Button* button5 = Gtk::manage( new Gtk::Button("Disconnect handler 1") );
  Gtk::Button* button6 = Gtk::manage( new Gtk::Button("Disconnect handler 2") );

  button1->add_label("From vfunc");
  button2->signal_clicked().connect(&global_on_clicked);
  button3->signal_clicked().connect(&global_on_clicked_throw_glib_error);
  button4->signal_clicked().connect(&global_on_clicked_throw_std_exception);
  button5->signal_clicked().connect(SigC::slot_class(conn_foo, &SigC::Connection::disconnect));
  button6->signal_clicked().connect(SigC::slot_class(conn_bar, &SigC::Connection::disconnect));

  box->add(*button1);
  box->add(*button2);
  box->add(*button3);
  box->add(*button4);
  box->add(*button5);
  box->add(*button6);

  window.set_border_width(10);
  window.add(*box);
  window.show_all();

  kit.run(window);
  return 0;
}

