// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_FILESELECTION_H
#define _GTKMM_FILESELECTION_H

#include <glibmm.h>

/* $Id: fileselection.hg,v 1.25 2002/07/08 15:17:30 murrayc Exp $ */


/* fileselection.h
 * 
 * Copyright (C) 1998-1999 The gtkmm Development Team 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/dialog.h>
#include <gtkmm/button.h>
#include <gtkmm/entry.h>
#include <gtkmm/label.h>
#include <gtkmm/box.h>
#include <gtkmm/treeview.h>
#include <gtkmm/buttonbox.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkFileSelection GtkFileSelection;
typedef struct _GtkFileSelectionClass GtkFileSelectionClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class FileSelection_Class; } // namespace Gtk
namespace Gtk
{

/** Prompt the user for a file or directory name.
 *
 * Gtk::FileSelection should be used to retrieve file or directory names from
 * the user. It will create a new dialog window containing a directory list,
 * and a file list corresponding to the current working directory. The
 * filesystem can be navigated using the directory list or the drop-down
 * history menu. Alternatively, the TAB key can be used to navigate using
 * filename completion - common in text based editors such as emacs and jed.
 *
 * @ingroup Dialogs
 */

class FileSelection : public Dialog
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef FileSelection CppObjectType;
  typedef FileSelection_Class CppClassType;
  typedef GtkFileSelection BaseObjectType;
  typedef GtkFileSelectionClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~FileSelection();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class FileSelection_Class;
  static CppClassType fileselection_class_;

  // noncopyable
  FileSelection(const FileSelection&);
  FileSelection& operator=(const FileSelection&);

protected:
  explicit FileSelection(const Glib::ConstructParams& construct_params);
  explicit FileSelection(GtkFileSelection* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  GtkFileSelection*       gobj()       { return reinterpret_cast<GtkFileSelection*>(gobject_); }
  const GtkFileSelection* gobj() const { return reinterpret_cast<GtkFileSelection*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

public:

  FileSelection();
  explicit FileSelection(const Glib::ustring& title);

  
  /** Sets a default path for the file requestor. If @a filename includes a
   * directory path, then the requestor will open with that path as its
   * current working directory.
   * 
   * The encoding of @a filename is the on-disk encoding, which
   * may not be UTF-8. See Glib::filename_from_utf8().
   * 
   * 
   * @param filename A string to set as the default file name.
   */
  void set_filename(const std::string& filename);

  
  /** This function returns the selected filename in the on-disk encoding
   * (see Glib::filename_from_utf8()), which may or may not be the same as that
   * used by GTK+ (UTF-8). To convert to UTF-8, call Glib::filename_to_utf8().
   * The returned string points to a statically allocated buffer and
   * should be copied if you plan to keep it around.
   * 
   * 
   * Retrieves the currently selected filename from the file selection dialog. If no file is selected then the selected directory path is returned.
   * 
   * @return Currently-selected filename in locale's encoding
   * a string containing the selected file's full path.
   */
  std::string get_filename() const;

  
  /** 
   * Will attempt to match @a pattern to a valid filenames or subdirectories in the current directory. If a match can be made, the matched filename will appear in the text entry field of the file selection dialog.
   * If a partial match can be made, the "Files" list will contain those
   * file names which have been partially matched, and the "Directories"
   * list those directories which have been partially matched.
   * 
   * @param pattern A string of characters which may or may not match any filenames in the current directory.
   */
  void complete(const Glib::ustring& pattern);
  
  /** 
   * Shows the file operation buttons, if they have previously been hidden. The rest of the widgets in the dialog will be resized accordingly.
   * 
   */
  void show_fileop_buttons();
  
  /** 
   * Hides the file operation buttons that normally appear at the top of the dialog. Useful if you wish to create a custom file selector, based on Gtk::FileSelection.
   * 
   */
  void hide_fileop_buttons();

  
  /** Retrieves the list of file selections the user has made in the dialog box.
   * This function is intended for use when the user can select multiple files
   * in the file list. The first file in the list is equivalent to what
   * get_filename() would return.
   * 
   * The filenames are in the encoding of g_filename_from_utf8, which may or may
   * not be the same as that used by GTK+ (UTF-8). To convert to UTF-8, call
   * Glib::filename_to_utf8() on each string.
   * 
   * 
   * 
   * 
   * @return A newly-allocated <tt>0</tt>-terminated array of strings. Use
   * Glib::strfreev() to free it.
   */
  Glib::ArrayHandle<std::string> get_selections() const;

  
  /** Sets whether the user is allowed to select multiple files in the file list.
   * Use get_selections() to get the list of selected files.
   * 
   * 
   * 
   * @param select_multiple Whether or not the user is allowed to select multiple
   * files in the file list.
   */
  void set_select_multiple(bool select_multiple = true);
  
  /** Determines whether or not the user is allowed to select multiple files in
   * the file list. See set_select_multiple().
   * 
   * 
   * 
   * 
   * 
   * 
   * 
   * &lt;!-- ##### ARG GtkFileSelection:show-fileops ##### --&gt;
   * 
   * 
   * 
   * 
   * &lt;!-- ##### ARG GtkFileSelection:filename ##### --&gt;
   * 
   * 
   * 
   * 
   * &lt;!-- ##### ARG GtkFileSelection:select-multiple ##### --&gt;
   * 
   * 
   * 
   * @return <tt>true</tt> if the user is allowed to select multiple files in the
   * file list.
   */
  bool get_select_multiple() const;

  //: Accessors
  TreeView* get_dir_list();
  const TreeView* get_dir_list() const;
  TreeView* get_file_list();
  const TreeView* get_file_list() const;
  Entry* get_selection_entry();
  const Entry* get_selection_entry() const;
  Label* get_selection_text();
  const Label* get_selection_text() const;
  VBox* get_main_vbox();
  const VBox* get_main_vbox() const;
  Button* get_ok_button();
  const Button* get_ok_button() const;
  Button* get_cancel_button();
  const Button* get_cancel_button() const;
  Button* get_help_button();
  const Button* get_help_button() const;
  HButtonBox* get_button_area();
  const HButtonBox* get_button_area() const;
  HBox* get_action_area();
  const HBox* get_action_area() const;

  Glib::PropertyProxy<bool> property_show_fileops();

  Glib::PropertyProxy<std::string> property_filename();

  Glib::PropertyProxy<bool> property_select_multiple();


};

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::FileSelection */
  Gtk::FileSelection* wrap(GtkFileSelection* object, bool take_copy = false);
}
#endif /* _GTKMM_FILESELECTION_H */

