// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_HANDLEBOX_H
#define _GTKMM_HANDLEBOX_H

#include <glibmm.h>

 /* $Id: handlebox.hg,v 1.22 2002/07/08 15:17:30 murrayc Exp $ */

/* handlebox.h
 * 
 * Copyright (C) 1998-1999 The gtkmm Development Team 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/eventbox.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkHandleBox GtkHandleBox;
typedef struct _GtkHandleBoxClass GtkHandleBoxClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class HandleBox_Class; } // namespace Gtk
namespace Gtk
{

/** A widget for detachable window portions.
 *
 * The Gtk::HandleBox widget allows a portion of a window to be "torn off".
 * It displays its child and a handle that the user can drag to tear off a separate window (the float window) containing the child widget. A thin ghost is drawn in the original location of the handlebox. By dragging the separate window back to its original location, it can be reattached.
 * When reattaching, the ghost and float window must be aligned along one of the edges, the snap edge. This can be specified by the application programmer explicitely, or GTK+ will pick a reasonable default based on the handle position.
 * To make detaching and reattaching the handlebox as minimally confusing as possible to the user, it is important to set the snap edge so that the snap edge does not move when the handlebox is deattached.
 * For instance, if the handlebox is packed at the bottom of a VBox, then when the handlebox is detached, the bottom edge of the handlebox's allocation will remain fixed as the height of the handlebox shrinks, so the snap edge should be set to GTK_POS_BOTTOM.
 *
 * @ingroup Widgets
 * @ingroup Containers
 */

class HandleBox : public Bin
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef HandleBox CppObjectType;
  typedef HandleBox_Class CppClassType;
  typedef GtkHandleBox BaseObjectType;
  typedef GtkHandleBoxClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~HandleBox();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class HandleBox_Class;
  static CppClassType handlebox_class_;

  // noncopyable
  HandleBox(const HandleBox&);
  HandleBox& operator=(const HandleBox&);

protected:
  explicit HandleBox(const Glib::ConstructParams& construct_params);
  explicit HandleBox(GtkHandleBox* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  GtkHandleBox*       gobj()       { return reinterpret_cast<GtkHandleBox*>(gobject_); }
  const GtkHandleBox* gobj() const { return reinterpret_cast<GtkHandleBox*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_child_attached(Widget* child);
  virtual void on_child_detached(Widget* child);


private:

public:
  HandleBox();
  

  /** 
   * Sets the type of shadow to be drawn around the border 
   * of the handle box.
   * 
   * @param type The shadow type.
   */
  void set_shadow_type(ShadowType type);
  
  /** Gets the type of shadow drawn around the handle box. See
   * set_shadow_type().
   * 
   * 
   * 
   * 
   * @return The type of shadow currently drawn around the handle box.
   */
  ShadowType get_shadow_type() const;
  
  /** 
   * Sets the side of the handlebox where the handle is drawn.
   * 
   * @param position The side of the handlebox where the handle should be drawn.
   */
  void set_handle_position(PositionType position);
  
  /** Gets the handle position of the handle box. See
   * set_handle_position().
   * 
   * 
   * 
   * 
   * @return The current handle position.
   */
  PositionType get_handle_position() const;
  
  /** 
   * Sets the snap edge of a handlebox. The snap edge is
   * the edge of the detached child that must be aligned
   * with the corresponding edge of the "ghost" left
   * behind when the child was detached to reattach
   * the torn-off window. Usually, the snap edge should
   * be chosen so that it stays in the same place on
   * the screen when the handlebox is torn off.
   * 
   * 
   * If the snap edge is not set, then an appropriate value
   * will be guessed from the handle position. If the
   * handle position is Gtk::POS_RIGHT or Gtk::POS_LEFT,
   * then the snap edge will be Gtk::POS_TOP, otherwise
   * it will be Gtk::POS_LEFT.
   * 
   * 
   * case GTK+ will try to guess an appropriate value
   * in the future.
   * @param edge The snap edge, or -1 to unset the value; in which.
   */
  void set_snap_edge(PositionType edge);
  
  /** Gets the edge used for determining reattachment of the handle box. See
   * set_snap_edge().
   * 
   * 
   * 
   * 
   * 
   * 
   * 
   * &lt;!-- ##### SIGNAL GtkHandleBox::child-attached ##### --&gt;
   * 
   * This signal is emitted when the contents of the
   * handlebox are reattached to the main window.
   * 
   * 
   *          (this argument provides no extra information
   *           and is here only for backwards-compatibility)
   * 
   * &lt;!-- ##### SIGNAL GtkHandleBox::child-detached ##### --&gt;
   * 
   * This signal is emitted when the contents of the
   * handlebox are detached from the main window.
   * 
   * 
   *          (this argument provides no extra information
   *           and is here only for backwards-compatibility)
   * 
   * &lt;!-- ##### ARG GtkHandleBox:shadow ##### --&gt;
   * 
   * Determines the shadow type for the handlebox.
   * 
   * 
   * &lt;!-- ##### ARG GtkHandleBox:shadow-type ##### --&gt;
   * 
   * 
   * 
   * 
   * &lt;!-- ##### ARG GtkHandleBox:handle-position ##### --&gt;
   * 
   * Determines the side of the handlebox where the handle is drawn.
   * 
   * 
   * &lt;!-- ##### ARG GtkHandleBox:snap-edge ##### --&gt;
   * 
   * Determines the snap edge of a handlebox. The snap edge is
   * the edge of the detached child that must be aligned
   * with the corresponding edge of the "ghost" left
   * behind when the child was detached to reattach
   * the torn-off window. See set_snap_edge().
   * 
   * @param handlebox The object which received the signal.
   *  the object which received the signal.
   * @param widget The child widget of the handlebox.
   *  the child widget of the handlebox.
   * @return The edge used for determining reattachment, or (GtkPositionType)-1 if this
   * is determined (as per default) from the handle position.
   */
  PositionType get_snap_edge() const;

  
  /**
   * @par Prototype:
   * <tt>void %child_attached(Widget* child)</tt>
   */
  Glib::SignalProxy1<void,Widget*> signal_child_attached();

  
  /**
   * @par Prototype:
   * <tt>void %child_detached(Widget* child)</tt>
   */
  Glib::SignalProxy1<void,Widget*> signal_child_detached();


  Glib::RefPtr<Gdk::Window> get_bin_window();
  Glib::RefPtr<const Gdk::Window> get_bin_window() const;
  Glib::RefPtr<Gdk::Window> get_float_window();
  Glib::RefPtr<const Gdk::Window> get_float_window() const;

  bool is_child_detached() const;
  bool is_float_window_mapped() const;
  bool is_in_drag() const;
  bool shrinks_on_detach() const;

  //_WRAP_PROPERTY("shadow", ShadowType); //deprecated.
  Glib::PropertyProxy<ShadowType> property_shadow_type();

  Glib::PropertyProxy<PositionType> property_handle_position();

  Glib::PropertyProxy<PositionType> property_snap_edge();


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::HandleBox */
  Gtk::HandleBox* wrap(GtkHandleBox* object, bool take_copy = false);
}
#endif /* _GTKMM_HANDLEBOX_H */

