// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TREEPATH_H
#define _GTKMM_TREEPATH_H

#include <glibmm.h>

/* $Id: treepath.hg,v 1.21 2002/06/30 15:01:25 murrayc Exp $ */

/* treepath.h
 *
 * Copyright(C) 1998-1999 The gtkmm Development Team
 *
 * This library is free software, ) you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation, ) either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, ) without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library, ) if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/treemodel.h>
#include <glibmm/arrayhandle.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkTreePath GtkTreePath;
typedef struct _GtkTreePathClass GtkTreePathClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/**
 * Typdefed as Gtk::TreeModel::Path.
 * @ingroup TreeView
 */
class TreePath
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TreePath CppObjectType;
  typedef GtkTreePath BaseObjectType;

  static GType get_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  explicit TreePath(GtkTreePath* castitem, bool make_a_copy = true);

  TreePath(const TreePath& src);
  TreePath& operator=(const TreePath& src);

  ~TreePath();

  GtkTreePath*       gobj()       { return gobject_; }
  const GtkTreePath* gobj() const { return gobject_; }

  // The caller is responsible for freeing it. Use when directly setting fields in structs.
  GtkTreePath* gobj_copy() const;

protected:
  GtkTreePath* gobject_;

private:

  
public:

  
  explicit TreePath(bool root = false);
  explicit TreePath(const Glib::ustring& path);
  explicit TreePath(const TreeModel::iterator& iter);

  
  /** Generates a string representation of the path.  This string is a ':'
   * separated list of numbers.  For example, "4:10:0:3" would be an acceptable return value for this string.
   * 
   * 
   * 
   * 
   * @return A newly-allocated string.  Must be freed with Glib::free().
   */
  Glib::ustring to_string() const;

  
  /** Appends a new index to a path.  As a result, the depth of the path is
   * increased.
   * 
   * 
   * 
   * @param index The index.
   */
  void append_index(int index);
  
  /** Prepends a new index to a path.  As a result, the depth of the path is
   * increased.
   * 
   * 
   * 
   * @param index The index.
   */
  void prepend_index(int index);
  
  /** Returns the current depth of @a path.
   * 
   * 
   * 
   * 
   * @return The depth of @a path.
   */
  int get_depth() const;
  Glib::ArrayHandle<int> get_indices() const;
  
  /** Moves the @a path to point to the next node at the current depth.
   * 
   * 
   * 
   */
  void next();
  
  /** Moves the @a path to point to the previous node at the current depth, if it exists.
   * 
   * 
   * 
   * 
   * @return <tt>true</tt> if @a path has a previous node, and the move was made.
   */
  bool prev();
  
  /** Moves the @a path to point to it's parent node, if it has a parent.
   * 
   * 
   * 
   * 
   * @return <tt>true</tt> if @a path has a parent, and the move was made.
   */
  bool up();
  
  /** Moves @a path to point to the first child of the current path.
   * 
   * 
   * 
   */
  void down();

  
  /** Returns <tt>true</tt> if @a descendant is a descendant of @a path.
   * 
   * 
   * 
   * 
   * @param descendant Another Gtk::TreePath.
   * @return <tt>true</tt> if @a descendant is contained inside @a path.
   */
  bool is_ancestor(TreePath& descendant) const;
  
  /** Returns <tt>true</tt> if @a path is a descendant of @a ancestor.
   * 
   * 
   * 
   * 
   * @param ancestor Another Gtk::TreePath.
   * @return <tt>true</tt> if @a ancestor contains @a path somewhere below it.
   */
  bool is_descendant(TreePath& ancestor) const;


};

} // namespace Gtk


namespace Gtk
{

/** @relates Gtk::TreePath */
bool operator==(const TreePath& lhs, const TreePath& rhs);

/** @relates Gtk::TreePath */
bool operator!=(const TreePath& lhs, const TreePath& rhs);

/** @relates Gtk::TreePath */
bool operator<(const TreePath& lhs, const TreePath& rhs);

/** @relates Gtk::TreePath */
bool operator>(const TreePath& lhs, const TreePath& rhs);

/** @relates Gtk::TreePath */
bool operator<=(const TreePath& lhs, const TreePath& rhs);

/** @relates Gtk::TreePath */
bool operator>=(const TreePath& lhs, const TreePath& rhs);


} // namespace Gtk


namespace Glib
{

/** @relates Gtk::TreePath */
Gtk::TreePath wrap(GtkTreePath* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gtk::TreePath> : public Glib::Value_Boxed<Gtk::TreePath>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib

#endif /* _GTKMM_TREEPATH_H */

