// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDKMM_IMAGE_H
#define _GDKMM_IMAGE_H

#include <glibmm.h>

/* $Id: image.hg,v 1.17 2002/10/11 18:05:37 murrayc Exp $ */

/* bitmap.h
 *
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <gdkmm/visual.h>
#include <gdkmm/colormap.h>
#include <gdk/gdkimage.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdkImage GdkImage;
typedef struct _GdkImageClass GdkImageClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{ class Image_Class; } // namespace Gdk
namespace Gdk
{


/** @addtogroup gdkmmEnums Enums and Flags */

/**
 * @ingroup gdkmmEnums
 */
enum ImageType
{
  IMAGE_NORMAL,
  IMAGE_SHARED,
  IMAGE_FASTEST
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::ImageType> : public Glib::Value_Enum<Gdk::ImageType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{


class Image : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Image CppObjectType;
  typedef Image_Class CppClassType;
  typedef GdkImage BaseObjectType;
  typedef GdkImageClass BaseClassType;

private:
  friend class Image_Class;
  static CppClassType image_class_;

  // noncopyable
  Image(const Image&);
  Image& operator=(const Image&);

protected:
  explicit Image(const Glib::ConstructParams& construct_params);
  explicit Image(GdkImage* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Image();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  GdkImage*       gobj()       { return reinterpret_cast<GdkImage*>(gobject_); }
  const GdkImage* gobj() const { return reinterpret_cast<GdkImage*>(gobject_); }

  GdkImage* gobj_copy();

private:

  
protected:
  Image(ImageType type, const Glib::RefPtr<Visual>& visual, int	width, int height);

public:
  
  static Glib::RefPtr<Image> create(ImageType type, const Glib::RefPtr<Visual>& visual, int width, int height);


  void put_pixel(int x, int y, guint32 pixel);
  
  guint32 get_pixel(int	x, int	y) const;
  
  /** Sets the colormap for the image to the given colormap.  Normally
   * there's no need to use this function, images are created with the
   * correct colormap if you get the image from a drawable. If you
   * create the image from scratch, use the colormap of the drawable you
   * intend to render the image to.
   * @param colormap A Gdk::Colormap.
   */
  void set_colormap(const Glib::RefPtr<Colormap>& colormap);
  
  /** Retrieves the colormap for a given image, if it exists.  An image
   * will have a colormap if the drawable from which it was created has
   * a colormap, or if a colormap was set explicitely with
   * set_colormap().
   * @return Colormap for the image.
   */
  Glib::RefPtr<Colormap> get_colormap();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} /* namespace Gdk */


namespace Glib
{
  /** @relates Gdk::Image */
  Glib::RefPtr<Gdk::Image> wrap(GdkImage* object, bool take_copy = false);
}


#endif /* _GDKMM_IMAGE_H */

